var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmUpdateOptions = $("#frmUpdateOptions"),
			$frmInstall = $("#frmInstall"),
			validate = ($.fn.validate !== undefined),
			multiselect = ($.fn.multiselect !== undefined),
			tabs = ($.fn.tabs !== undefined),
			tipsy = ($.fn.tipsy !== undefined),
			$tabs = $("#tabs");
		
		if (multiselect) {
			$("#user_id").multiselect({noneSelectedText: myLabel.choose});
		}
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		if (tipsy) {
			$(".option-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
		}
		
		$(".field-int").spinner({
			min: 0
		});
		
		if ($frmUpdateOptions.length > 0 && validate) {

			$.validator.addMethod('validateHost',
			    function (value) {
					if(value == '')
					{
						return true;
					}else{
						var result = /(?:^|\b)([\w.]+\.[a-z]{2,3}(?:\:[0-9]{1,5})?(?:\/.*)?)(?:[,\s]|$)/i.test(value);
						if (result == true) {
							return true;
						}else{
							var pattern = /\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b/;
							if (!pattern.test(value)) 
							{
								return false;
							}else{
								return true;
							}
						}
					}
			    }, myLabel.validate_host
			);
			
			$frmUpdateOptions.validate({
				rules:{
					"value-string-o_smtp_host":{
						required: function(){
							if($('select[name=value-enum-o_send_email]').val() == 'mail|smtp::smtp')
							{
								return true;
							}else{
								return false;
							}
						},
						validateHost: true
					},
					"value-string-o_smtp_pass":{
						required: function(){
							if($('select[name=value-enum-o_send_email]').val() == 'mail|smtp::smtp')
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"value-int-o_smtp_port":{
						required: function(){
							if($('select[name=value-enum-o_send_email]').val() == 'mail|smtp::smtp')
							{
								return true;
							}else{
								return false;
							}
						},
						number: true,
						range: [1, 65535]
					},
					"value-string-o_smtp_user":{
						required: function(){
							if($('select[name=value-enum-o_send_email]').val() == 'mail|smtp::smtp')
							{
								return true;
							}else{
								return false;
							}
						}
					}
				},
				errorPlacement: function (error, element) {
					if(	element.attr('name') == 'value-string-o_smtp_host' || 
						element.attr('name') == 'value-string-o_smtp_pass' ||
						element.attr('name') == 'value-string-o_smtp_port' ||
						element.attr('name') == 'value-string-o_smtp_user')
					{
						error.insertAfter(element);
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		function validateURL(value){
			var expression = /[-a-zA-Z0-9@:%_\+.~#?&//=]{2,256}\.[a-z]{2,4}\b(\/[-a-zA-Z0-9@:%_\+.~#?&//=]*)?/gi;
			var regex = new RegExp(expression);
			return value.match(regex);
	    }
		if ($frmInstall.length > 0 && validate) {
			$.validator.addMethod("validateURL", function(value, element) {
			      return this.optional(element) || validateURL(value);
		    }, "");
			$frmInstall.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent().parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		
		$("#content").on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("change", "#send_notify", function (e) {
			if($(this).val() == 'Yes')
			{
				$('.sbNotification').show();
			}else{
				$('.sbNotification').hide();
			}
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
				}
			});
		});
	});
})(jQuery_1_8_2);