var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	if (window.tinyMCE !== undefined) {
		tinymce.init({
			relative_urls : false,
			selector: "textarea#body",
		    theme: "modern",
		    browser_spellcheck : true,
		    contextmenu: false,
		    width: 600,
		    relative_urls: false,
		    plugins: [
		         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
		         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
		         "save table contextmenu directionality emoticons template paste textcolor"
		    ],
		    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons",
		    image_advtab: true,
		    menubar: "file edit insert view table tools"
		});
	}
	$(function () {
		var $frmCreatePost = $("#frmCreatePost"),
			$frmUpdatePost = $("#frmUpdatePost"),
			$frmExportPosts = $("#frmExportPosts"),
			datepicker = ($.fn.datepicker !== undefined),
			chosen = ($.fn.chosen !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			dialog = ($.fn.dialog !== undefined),
			$dialogDelete = $("#dialogDeleteImage"),
			$dialogReset = $("#dialogReset"),
			tabs = ($.fn.tabs !== undefined),
			reseturl = null,
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			};
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		if (chosen) {
			$("#category_id").chosen();
			$("#author_id").chosen();
		}
		if ($frmCreatePost.length > 0 && validate) {
			$frmCreatePost.validate({
				messages:{
					"category_id": {
						required: myLabel.field_required
					},
					"title": {
						required: myLabel.field_required
					},
					"status": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ''
			});
		}
		if ($frmUpdatePost.length > 0 && validate) {
			$frmUpdatePost.validate({
				messages:{
					"category_id": {
						required: myLabel.field_required
					},
					"title": {
						required: myLabel.field_required
					},
					"status": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em", 
				ignore: ''
			});
			$(".post-rating").stars({
			    inputType: "select",
			    oneVoteOnly: true,
			    disabled: true,
			    callback: function(ui, type, value) {
			    	
			    }
			});
		}
		if ($frmExportPosts.length > 0 && validate) {
			$frmExportPosts.validate({
				rules: {
					"password": {
						required: function(){
							if($('#feed').is(':checked'))
							{
								return true;
							}else{
								return false;
							}
						}
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore"
			});
		}
		if ($("#grid").length > 0 && datagrid) {
			function formatComments(val, obj) {
				if(val == '0'){
					return val;
				}else{
					return '<a href="index.php?controller=pjAdminComments&action=pjActionIndex&post_id='+obj.id+'">'+val+'</a>';
				}
			}
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminPosts&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminPosts&action=pjActionDeletePost&id={:id}"}
				          ],
				columns: [{text: myLabel.date_published, type: "text", sortable: true, editable: false, width: 110},
				          {text: myLabel.title, type: "text", sortable: true, editable: true, width: 300},
				          {text: myLabel.comments, type: "text", sortable: true, editable: false, width: 90, renderer: formatComments},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminPosts&action=pjActionGetPost" + pjGrid.queryString,
				dataType: "json",
				fields: ['published_date', 'title', 'cnt_comments', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminPosts&action=pjActionDeletePostBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.revert_status, url: "index.php?controller=pjAdminPosts&action=pjActionStatusPost", render: true},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminPosts&action=pjActionExportPost", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminPosts&action=pjActionSavePost&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: "",
				title: "",
				blog_text: "",
				author_id: "",
				date_from: "",
				date_to: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminPosts&action=pjActionGetPost", "published_date", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminPosts&action=pjActionGetPost", "published_date", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val(),
				title: "",
				blog_text: "",
				author_id: "",
				date_from: "",
				date_to: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminPosts&action=pjActionGetPost", "published_date", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
			e.stopPropagation();
			$(".pj-form-filter-advanced").toggle();
		}).on("submit", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var obj = {},
				$this = $(this),
				arr = $this.serializeArray(),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
				obj[arr[i].name] = arr[i].value;
			}
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminPosts&action=pjActionGetPost", "published_date", "DESC", content.page, content.rowCount);
			return false;
		}).on("reset", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(".pj-button-detailed").trigger("click");
			$('#title').val('');
			$('#blog_text').val('');
			$('#author_id').val('');
			$('input[name="date_from"]').val('');
			$('input[name="date_to"]').val('');
		}).on("focusin", ".datepicker", function (e) {
			var minDate, maxDate,
				$this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
				};
			switch ($this.attr("name")) {
			case "date_from":
				if($(".datepicker[name='date_to']").val() != '')
				{
					maxDate = $(".datepicker[name='date_to']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev")
					}).datepicker("getDate");
					$(".datepicker[name='date_to']").datepicker("destroy").removeAttr("id");
					if (maxDate !== null) {
						custom.maxDate = maxDate;
					}
				}
				break;
			case "date_to":
				if($(".datepicker[name='date_from']").val() != '')
				{
					minDate = $(".datepicker[name='date_from']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev")
					}).datepicker("getDate");
					$(".datepicker[name='date_from']").datepicker("destroy").removeAttr("id");
					if (minDate !== null) {
						custom.minDate = minDate;
					}
				}
				break;
			}
			$(this).datepicker($.extend(o, custom));
			
		}).on("focusin", ".datepick", function (e) {
			var $this = $(this);
			$this.datepicker({
				firstDay: $this.attr("rel"),
				dateFormat: $this.attr("rev")
			});
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
		}).on("click", "#rating_reset", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			reseturl = $(this).attr('href');
			$dialogReset.dialog("open");
		}).on("click", ".delete-image", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$('#delete_url').text($(this).attr('href'));
			$dialogDelete.dialog("open");
		}).on("click", "#file", function (e) {
			$('#tsSubmitButton').val(myLabel.btn_export);
			$('.tsFeedContainer').hide();
			$('.tsPassowrdContainer').hide();
		}).on("click", "#feed", function (e) {
			$('.tsPassowrdContainer').show();
			$('#tsSubmitButton').val(myLabel.btn_get_url);
		}).on("focus", "#posts_feed", function (e) {
			$(this).select();
		});
		
		if ($dialogReset.length > 0 && dialog) {
			$dialogReset.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				width: 400,
				buttons: {
					"Reset": function () {
						$(this).dialog("close");
						window.location.href = reseturl;
					},
					"Cancel": function () {
						$(this).dialog("close");
					}
				}
			});
		}
		if ($dialogDelete.length > 0 && dialog) {
			$dialogDelete.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				width: 400,
				buttons: {
					"Delete": function () {
						$.ajax({
							type: "GET",
							dataType: "json",
							url: $('#delete_url').text(),
							success: function (res) {
								if(res.code == 200){
									$('#image_container').remove();
									$dialogDelete.dialog('close');
								}
							}
						});
					},
					"Cancel": function () {
						$(this).dialog("close");
					}
				}
			});
		}
	});
})(jQuery_1_8_2);