<?php
require_once dirname(__FILE__) . '/pjCalendar.component.php';
class pjACalendar extends pjCalendar
{
	protected $availability = array();
	
	protected $weekNumbers = false;
	
	protected $options = array();
		
	public function getMonthView($month, $year)
    {
        return $this->getMonthHTML($month, $year, 1);
    }
    
	public function getCalendarLink($month, $year)
	{
		return array('href' => '#', 'onclick' => '', 'class' => 'aCalendarLinkMonth');
	}
	
	public function getLegend($CalendarOptions, $locale)
	{
		$html = '
		<table class="aCalendarLegend" cellspacing="1" cellpadding="2">
			<tbody>
				<tr>
					<td class="aCalendarColor aCalendarColorAvailable">&nbsp;</td>
					<td class="aCalendarLabel">'.@$locale['legend_available'].'</td>
					<td class="aCalendarColor aCalendarColorReserved">&nbsp;</td>
					<td class="aCalendarLabel">'.@$locale['legend_booked'].'</td>
					<td class="aCalendarColor aCalendarColorPast">&nbsp;</td>
					<td class="aCalendarLabel">'.@$locale['legend_past'].'</td>
				</tr>
			</tbody>
		</table>';
		return $html;
	}
	
	public function getMonthHTML($m, $y, $showYear = 1)
    {
        $s = "";

        $a = $this->adjustDate($m, $y);
        $month = $a[0];
        $year = $a[1];
        
    	$daysInMonth = $this->getDaysInMonth($month, $year);
    	$date = getdate(mktime(12, 0, 0, $month, 1, $year));
    	
    	$first = $date["wday"];
    	$_monthNames = $this->getMonthNames();
    	$_dayNames = $this->getDayNames();
    	$monthName = $_monthNames[$month];
    	
    	$prev = $this->adjustDate($month - 1, $year);
    	$next = $this->adjustDate($month + 1, $year);
    	
    	if ($showYear == 1)
    	{
    	    $prevMonth = $this->getCalendarLink($prev[0], $prev[1]);
    	    $nextMonth = $this->getCalendarLink($next[0], $next[1]);
    	} else {
    	    $prevMonth = "";
    	    $nextMonth = "";
    	}
    	
    	$search = array('Month', 'Year');
    	$replace = array($monthName, $showYear > 0 ? $year : "");
    	$header = str_replace($search, $replace, 'Month Year');//$this->options['o_month_year_format']);
		    	
    	$prevM = ((int) $month - 1) < 1 ? 12 : (int) $month - 1;
    	$prevY = ((int) $month - 1) < 1 ? (int) $year - 1 : (int) $year;
    	
    	$nextM = ((int) $month + 1) > 12 ? 1 : (int) $month + 1;
    	$nextY = ((int) $month + 1) > 12 ? (int) $year + 1 : (int) $year;
    	
    	$cols = $this->weekNumbers ? 8 : 7;
    	
    	$s .= "<table class=\"".$this->classTable."\" cellspacing=\"0\" cellpadding=\"0\">\n";
    	$s .= "<tbody><tr>\n";
    	$s .= "<td class=\"".$this->classMonth." ".$this->classMonthPrev."\">" . (!$this->getShowPrevLink() ? "&nbsp;" : '<div class="aCalendarMonthInner"><a data-direction="prev" data-month="'.$prevM.'" data-year="'.$prevY.'" href="'.$prevMonth['href'].'" class="'.$prevMonth['class'].'">'.$this->getPrevLink().'</a></div>')  . "</td>\n";
    	$s .= "<td class=\"".$this->classMonth."\" colspan=\"".($cols == 7 ? 5 : 6)."\">$header</td>\n";
    	$s .= "<td class=\"".$this->classMonth." ".$this->classMonthNext."\">" . (!$this->getShowNextLink() ? "&nbsp;" : '<div class="aCalendarMonthInner"><a data-direction="next" data-month="'.$nextM.'" data-year="'.$nextY.'" href="'.$nextMonth['href'].'" class="'.$nextMonth['class'].'">'.$this->getNextLink().'</a></div>')  . "</td>\n";
    	$s .= "</tr>\n";
    	
    	$s .= "<tr>\n";
    	if ($this->weekNumbers)
    	{
    		$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $this->weekTitle, "\n");
    		$weekNumPattern = "<td class=\"".$this->classWeekNum."\">{WEEK_NUM}</td>";
    	}
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $_dayNames[($this->getStartDay())%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $_dayNames[($this->getStartDay()+1)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $_dayNames[($this->getStartDay()+2)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $_dayNames[($this->getStartDay()+3)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $_dayNames[($this->getStartDay()+4)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $_dayNames[($this->getStartDay()+5)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $_dayNames[($this->getStartDay()+6)%7], "\n");
    	$s .= "</tr>\n";

    	$d = $this->getStartDay() + 1 - $first;
    	while ($d > 1)
    	{
    	    $d -= 7;
    	}

        $today = getdate(time());
    	
        $rows = 0;
    	while ($d <= $daysInMonth)
    	{
    	    $s .= "<tr>\n";
    	    
    	    if ($this->weekNumbers)
    	    {
    	    	$s .= $weekNumPattern;
    	    }
    	    for ($i = 0; $i < 7; $i++)
    	    {
    	    	$scope = 0;
    	    	$timestamp = mktime(0, 0, 0, $month, $d, $year);
    	    	$isPast = false;
    	    	$class = "";
    	    	
    	    	if ($year == $today["year"] && $month == $today["mon"] && $d == $today["mday"])
    	    	{
    	    		$class = $this->classCalendar; //calendarToday
    	    		$scope = 1;
    	    	} elseif ($d < 1 || $d > $daysInMonth) {
    	    		$class = $this->classEmpty;
    	    	} elseif ($timestamp < $today[0]) {
    	    		$isPast = true;
    	    		$class = $this->classPast;
    	    		$scope = -1;
    	    	} else {
    	    		$class = $this->classCalendar;
    	    		$scope = 1;
    	    	}
    	    	
        	    if ($d > 0 && $d <= $daysInMonth && !$isPast)
        	    {
        	    	if (in_array(date("Y-m-d", $timestamp), $this->availability))
        	    	{
        	    		$class = 'aCalendarUnavailable';
        	    	}
        	    }
        	    
        	    if ($d < 1 || $d > $daysInMonth) {
        	    	$s .= '<td class="'.$class.'">';
        	    } else {
        	    	$s .= '<td class="aCalendarCell '.$class.'" data-time="'.$timestamp.'">';
        	    }
    	               
    	        if ($d > 0 && $d <= $daysInMonth)
    	        {
   	        		$s .= $d;
    	        } else {
    	            $s .= "&nbsp;";
    	        }
      	        $s .= "</td>\n";
        	    $d++;
    	    }
    	    if ($this->weekNumbers)
    	    {
    	    	$s = str_replace('{WEEK_NUM}', date("W", $timestamp), $s);
    	    }
    	    $s .= "</tr>\n";
    	    $rows++;
    	}
    	
    	if ($rows == 5)
    	{
    		if ($cols == 7)
    		{
    			$s .= "<tr>" . str_repeat('<td class="'.$this->classEmpty.'">&nbsp;</td>', $cols) . "</tr>";
    		} else {
    			$s .= '<tr><td class="aCalendarWeekNum">&nbsp;</td>' . str_repeat('<td class="'.$this->classEmpty.'">&nbsp;</td>', 7) . "</tr>";
    		}
    	}
    	
    	$s .= "</tbody></table>\n";

    	return $s;
    }
    
	public function set($key, $value)
	{
		if (in_array($key, array('weekNumbers', 'options', 'availability')))
		{
			$this->$key = $value;
		}
		return $this;
	}
}
?>