<?php
class pjCalendar
{
    protected $startDay = 0;

    protected $startMonth = 1;

    protected $dayNames = array("S", "M", "T", "W", "T", "F", "S");

    protected $monthNames = array(
    	1 => "January",
    	2 => "February",
    	3 => "March",
    	4 => "April",
    	5 => "May",
    	6 => "June",
    	7 => "July",
    	8 => "August",
    	9 => "September",
    	10 => "October",
    	11 => "November",
    	12 => "December"
    );

    protected $daysInMonth = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    
    protected $showNextLink = true;
    
    protected $showPrevLink = true;
    
    protected $weekTitle = "#";
    
    protected $prevLink = "&lt;";
    
    protected $nextLink = "&gt;";
    
    protected $classTable = "aCalendarTable";
    protected $classWeekDay = "aCalendarWeekDay";
    protected $classMonth = "aCalendarMonth";
    protected $classMonthPrev = "aCalendarMonthPrev";
    protected $classMonthNext = "aCalendarMonthNext";
    protected $classReserved = "aCalendarReserved";
    protected $classCalendar = "aCalendarDate";
    protected $classEmpty = "aCalendarEmpty";
    protected $classWeekNum = "aCalendarWeekNum";
    protected $classPast = "aCalendarPast";
	protected $classLinkDate = "aCalendarLinkDate";
    
    public function __construct()
    {
    	
    }
    
    public function setPrevLink($value)
    {
    	$this->prevLink = $value;
    	return $this;
    }
    
	public function setNextLink($value)
    {
    	$this->nextLink = $value;
    	return $this;
    }
    
	public function getPrevLink()
    {
    	return $this->prevLink;
    }
    
	public function getNextLink()
    {
    	return $this->nextLink;
    }
    
    public function setShowNextLink($value)
    {
    	if (is_bool($value))
    	{
    		$this->showNextLink = $value;
    	}
    	return $this;
    }
    
    public function getShowNextLink()
    {
    	return $this->showNextLink;
    }
    
	public function setShowPrevLink($value)
    {
    	if (is_bool($value))
    	{
    		$this->showPrevLink = $value;
    	}
    	return $this;
    }
    
    public function getShowPrevLink()
    {
    	return $this->showPrevLink;
    }

    public function getDayNames()
    {
        return $this->dayNames;
    }

    public function setDayNames($names)
    {
        $this->dayNames = $names;
        return $this;
    }

    public function getMonthNames()
    {
        return $this->monthNames;
    }

    public function setMonthNames($names)
    {
        $this->monthNames = $names;
        return $this;
    }

    public function getStartDay()
    {
        return $this->startDay;
    }

    public function setStartDay($day)
    {
        $this->startDay = $day;
        return $this;
    }

    public function getStartMonth()
    {
        return $this->startMonth;
    }

    public function setStartMonth($month)
    {
        $this->startMonth = $month;
        return $this;
    }

    public function getCalendarLink($month, $year)
    {
        return "";
    }

    public function getDateLink($day, $month, $year)
    {
        return "";
    }

    public function getCurrentMonthView()
    {
        $d = getdate(time());
        return $this->getMonthView($d["mon"], $d["year"]);
    }

    public function getMonthView($month, $year)
    {
        return $this->getMonthHTML($month, $year);
    }

    public function getDaysInMonth($month, $year)
    {
        if ($month < 1 || $month > 12)
        {
            return 0;
        }
   
        $d = $this->daysInMonth[$month - 1];
   
        if ($month == 2)
        {
            if ($year%4 == 0)
            {
                if ($year%100 == 0)
                {
                    if ($year%400 == 0)
                    {
                        $d = 29;
                    }
                } else {
                    $d = 29;
                }
            }
        }
    
        return $d;
    }

    public function getMonthHTML($m, $y, $showYear = 1)
    {
        $s = "";

        $a = $this->adjustDate($m, $y);
        $month = $a[0];
        $year = $a[1];
        
    	$daysInMonth = $this->getDaysInMonth($month, $year);
    	$date = getdate(mktime(12, 0, 0, $month, 1, $year));
    	
    	$first = $date["wday"];
    	$monthName = $this->monthNames[$month];
    	
    	$prev = $this->adjustDate($month - 1, $year);
    	$next = $this->adjustDate($month + 1, $year);
    	
    	if ($showYear == 1)
    	{
    	    $prevMonth = $this->getCalendarLink($prev[0], $prev[1]);
    	    $nextMonth = $this->getCalendarLink($next[0], $next[1]);
    	} else {
    	    $prevMonth = "";
    	    $nextMonth = "";
    	}
    	
    	$search = array('Month', 'Year');
    	$replace = array($monthName, $showYear > 0 ? $year : "");
    	$header = str_replace($search, $replace, 'Month Year');//$this->options['o_month_year_format']);
		    	
    	$prevM = ((int) $month - 1) < 1 ? 12 : (int) $month - 1;
    	$prevY = ((int) $month - 1) < 1 ? (int) $year - 1 : (int) $year;
    	
    	$nextM = ((int) $month + 1) > 12 ? 1 : (int) $month + 1;
    	$nextY = ((int) $month + 1) > 12 ? (int) $year + 1 : (int) $year;
    	
    	$cols = $this->weekNumbers ? 8 : 7;
    	
    	$s .= "<table class=\"".$this->classTable."\" cellspacing=\"0\" cellpadding=\"0\">\n";
    	$s .= "<tbody><tr>\n";
    	$s .= "<td class=\"".$this->classMonth." ".$this->classMonthPrev."\">" . (!$this->getShowPrevLink() ? "&nbsp;" : '<div class="aCalendarMonthInner"><a data-direction="prev" data-month="'.$prevM.'" data-year="'.$prevY.'" href="'.$prevMonth['href'].'" class="'.$prevMonth['class'].'">'.$this->getPrevLink().'</a></div>')  . "</td>\n";
    	$s .= "<td class=\"".$this->classMonth."\" colspan=\"".($cols == 7 ? 5 : 6)."\">$header</td>\n";
    	$s .= "<td class=\"".$this->classMonth." ".$this->classMonthNext."\">" . (!$this->getShowNextLink() ? "&nbsp;" : '<div class="aCalendarMonthInner"><a data-direction="next" data-month="'.$nextM.'" data-year="'.$nextY.'" href="'.$nextMonth['href'].'" class="'.$nextMonth['class'].'">'.$this->getNextLink().'</a></div>')  . "</td>\n";
    	$s .= "</tr>\n";
    	
    	$s .= "<tr>\n";
    	if ($this->weekNumbers)
    	{
    		$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $this->weekTitle, "\n");
    		$weekNumPattern = "<td class=\"".$this->classWeekNum."\">{WEEK_NUM}</td>";
    	}
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $this->dayNames[($this->startDay)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $this->dayNames[($this->startDay+1)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $this->dayNames[($this->startDay+2)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $this->dayNames[($this->startDay+3)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $this->dayNames[($this->startDay+4)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $this->dayNames[($this->startDay+5)%7], "\n");
    	$s .= sprintf('<td class="%s">%s</td>%s', $this->classWeekDay, $this->dayNames[($this->startDay+6)%7], "\n");
    	$s .= "</tr>\n";

    	$d = $this->startDay + 1 - $first;
    	while ($d > 1)
    	{
    	    $d -= 7;
    	}

        $today = getdate(time());
    	
        $rows = 0;
    	while ($d <= $daysInMonth)
    	{
    	    $s .= "<tr>\n";
    	    
    	    if ($this->weekNumbers)
    	    {
    	    	$s .= $weekNumPattern;
    	    }
    	    for ($i = 0; $i < 7; $i++)
    	    {
    	    	$scope = 0;
    	    	$timestamp = mktime(0, 0, 0, $month, $d, $year);
    	    	$isPast = false;
    	    	$class = "";
    	    	
    	    	if ($year == $today["year"] && $month == $today["mon"] && $d == $today["mday"])
    	    	{
    	    		$class = $this->classCalendar; //calendarToday
    	    		$scope = 1;
    	    	} elseif ($d < 1 || $d > $daysInMonth) {
    	    		$class = $this->classEmpty;
    	    	} elseif ($timestamp < $today[0]) {
    	    		$isPast = true;
    	    		$class = $this->classPast;
    	    		$scope = -1;
    	    	} else {
    	    		$class = $this->classCalendar;
    	    		$scope = 1;
    	    	}
        	    
        	    if ($d < 1 || $d > $daysInMonth) {
        	    	$s .= '<td class="'.$class.'">';
        	    } else {
        	    	$s .= '<td class="aCalendarCell '.$class.'" data-time="'.$timestamp.'">';
        	    }
    	               
    	        if ($d > 0 && $d <= $daysInMonth)
    	        {
   	        		$s .= $d;
    	        } else {
    	            $s .= "&nbsp;";
    	        }
      	        $s .= "</td>\n";
        	    $d++;
    	    }
    	    if ($this->weekNumbers)
    	    {
    	    	$s = str_replace('{WEEK_NUM}', date("W", $timestamp), $s);
    	    }
    	    $s .= "</tr>\n";
    	    $rows++;
    	}
    	
    	if ($rows == 5)
    	{
    		if ($cols == 7)
    		{
    			$s .= "<tr>" . str_repeat('<td class="'.$this->classEmpty.'">&nbsp;</td>', $cols) . "</tr>";
    		} else {
    			$s .= '<tr><td class="aCalendarWeekNum">&nbsp;</td>' . str_repeat('<td class="'.$this->classEmpty.'">&nbsp;</td>', 7) . "</tr>";
    		}
    	}
    	
    	$s .= "</tbody></table>\n";

    	return $s;
    }

    static public function adjustDate($month, $year)
    {
        $a = array();
        $a[0] = $month;
        $a[1] = $year;
        
        while ($a[0] > 12)
        {
            $a[0] -= 12;
            $a[1]++;
        }
        
        while ($a[0] <= 0)
        {
            $a[0] += 12;
            $a[1]--;
        }
        
        return $a;
    }
}
?>