<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminTime extends pjAdmin
{
	public function pjActionCheckTime()
	{
		if ($this->isXHR())
		{
			$response = array();
			$response['status'] = 'OK';
			$response['days'] = '';
			$days = array();
			$weekDays = array('monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday');
			foreach ($weekDays as $day)
			{
				if (!isset($_POST[$day . '_dayoff']))
				{
					$time_from = $_POST[$day . '_hour_from'] . ":" . $_POST[$day . '_minute_from'];
					$time_to = $_POST[$day . '_hour_to'] . ":" . $_POST[$day . '_minute_to'];
					if (strtotime($time_from) >= strtotime($time_to))
					{
						$response['status'] = 'ERR';
						$days[] = $day;
					}
				}
			}
			$response['days'] = join("|", $days);
			
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			if (isset($_POST['working_time']))
			{
				$data = array();
				$weekDays = array('monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday');
				foreach ($weekDays as $day)
				{
					if (!isset($_POST[$day . '_dayoff']))
					{
						$data[$day . '_from'] = $_POST[$day . '_hour_from'] . ":" . $_POST[$day . '_minute_from'];
						$data[$day . '_to'] = $_POST[$day . '_hour_to'] . ":" . $_POST[$day . '_minute_to'];
						if (strtotime($data[$day . '_from']) > strtotime($data[$day . '_to']))
						{
							if ($data[$day . '_from'] != '23:55')
							{
								$data[$day . '_to'] = date("H:i:s", strtotime("+5 minutes", strtotime($data[$day . '_from'])));
							} else {
								$data[$day . '_from'] = '23:50';
								$data[$day . '_to'] = '23:55';
							}
						}
						$data[$day . '_dayoff'] = "F";
					} else {
						$data[$day . '_from'] = ":NULL";
						$data[$day . '_to'] = ":NULL";
						$data[$day . '_dayoff'] = "T";
					}
				}

				pjCalendarModel::factory()
					->set('id', $this->getForeignId())
					->modify(array_merge($_POST, $data));

				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminTime&action=pjActionIndex&err=AT01");
			}
			
			$this->set('wt_arr', pjCalendarModel::factory()->find($this->getForeignId())->getData());
			
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminTime.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionCustom()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			if (isset($_POST['custom_time']))
			{
				$pjDateModel = pjDateModel::factory();
				$date = pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']);
				$pjDateModel
					->where('calendar_id', $this->getForeignId())
					->where('`date`', $date)
					->limit(1)
					->eraseAll();
				
				$data = array();
				$data['calendar_id'] = $this->getForeignId();
				$data['start_time'] = join(":", array($_POST['start_hour'], $_POST['start_minute']));
				$data['end_time'] = join(":", array($_POST['end_hour'], $_POST['end_minute']));
				$data['date'] = $date;
				
				$pjDateModel->reset()->setAttributes(array_merge($_POST, $data))->insert();
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminTime&action=pjActionCustom&err=AT02");
			}

			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminTime.js');
			$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
			
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteDate()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			if (isset($_GET['id']) && (int) $_GET['id'] > 0 && pjDateModel::factory()->set('id', $_GET['id'])->erase()->getAffectedRows() == 1)
			{
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => ''));
			}
			pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
		}
		exit;
	}
	
	public function pjActionDeleteDateBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			if (isset($_POST['record']) && !empty($_POST['record']))
			{
				pjDateModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => ''));
			}
			pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
		}
		exit;
	}
	
	public function pjActionGetDate()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			$pjDateModel = pjDateModel::factory()
				->where('t1.calendar_id', $this->getForeignId());
			
			if (isset($_GET['is_dayoff']) && strlen($_GET['is_dayoff']) > 0 && in_array($_GET['is_dayoff'], array('T', 'F')))
			{
				$pjDateModel->where('t1.is_dayoff', $_GET['is_dayoff']);
			}
				
			$column = 'date';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjDateModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = $pjDateModel
				->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();
				
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionSaveDate()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			$pjDateModel = pjDateModel::factory();
			if (!in_array($_POST['column'], $pjDateModel->getI18n()))
			{
				$pjDateModel->set('id', $_GET['id'])->modify(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjDate');
			}
		}
		exit;
	}
	
	public function pjActionUpdateCustom()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$pjDateModel = pjDateModel::factory();
			
			if (isset($_POST['custom_time']))
			{
				$arr = $pjDateModel->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminTime&action=pjActionCustom&err=AT04");
				}
				$data = array();
				$data['date'] = pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']);
				$data['start_time'] = join(":", array($_POST['start_hour'], $_POST['start_minute']));
				$data['end_time'] = join(":", array($_POST['end_hour'], $_POST['end_minute']));
				$data['is_dayoff'] = isset($_POST['is_dayoff']) ? 'T' : 'F';
				
				if (0 == $pjDateModel->reset()->where('t1.id !=', $arr['id'])->where('t1.calendar_id', $arr['calendar_id'])->where('t1.date', $data['date'])->findCount()->getData())
				{
					$err = 'AT03';
					$pjDateModel->reset()->set('id', $_POST['id'])->modify($data);
				} else {
					$err = 'AT05';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminTime&action=pjActionCustom&err=".$err);
			}
			
			if (isset($_GET['id']))
			{
				$arr = $pjDateModel->find($_GET['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminTime&action=pjActionCustom&err=AT04");
				}
				$this->set('arr', $arr);
			}
			
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminTime.js');
		} else {
			$this->set('status', 2);
		}
	}
}
?>