<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjCalendarModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'calendars';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'monday_from', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'monday_to', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'monday_dayoff', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'tuesday_from', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'tuesday_to', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'tuesday_dayoff', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'wednesday_from', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'wednesday_to', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'wednesday_dayoff', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'thursday_from', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'thursday_to', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'thursday_dayoff', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'friday_from', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'friday_to', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'friday_dayoff', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'saturday_from', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'saturday_to', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'saturday_dayoff', 'type' => 'enum', 'default' => 'F'),
		array('name' => 'sunday_from', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'sunday_to', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'sunday_dayoff', 'type' => 'enum', 'default' => 'F')
	);
	
	protected $i18n = array('title', 'description', 'confirm_subject_client', 'confirm_tokens_client', 'payment_subject_client', 'payment_tokens_client',
		'cancel_subject_client', 'cancel_tokens_client', 'cancel_subject_admin', 'cancel_tokens_admin', 
		'confirm_subject_admin', 'confirm_tokens_admin', 'payment_subject_admin', 'payment_tokens_admin', 'terms_url', 'terms_body');
	
	public static function factory($attr=array())
	{
		return new pjCalendarModel($attr);
	}
	
	public function getDaysOff($id)
	{
		$_arr = array();
		$arr = $this->reset()->find($id)->getData();
		foreach ($arr as $k => $v)
		{
			if (is_null($v) && (strpos($k, "_from") !== false || strpos($k, "_to") !== false))
			{
				list($key) = explode("_", $k);
				$_arr[$key] = 1;
			}
		}
		return $_arr;
	}
	
	public function getWorkingTime($id, $date)
	{
		$day = strtolower(date("l", strtotime($date)));
		$arr = $this->reset()->find($id)->getData();

		if (empty($arr))
		{
			return false;
		}
	
		if ($arr[$day . '_dayoff'] == 'T')
		{
			return array();
		}
		
		$wt = array();
		foreach ($arr as $k => $v)
		{
			if (strpos($k, $day . '_from') !== false && !is_null($v))
			{
				$d = getdate(strtotime($v));
				$wt['start_hour'] = $d['hours'];
				$wt['start_minutes'] = $d['minutes'];
				$wt['start_ts'] = strtotime($date . " " . $v);
				continue;
			}
		
			if (strpos($k, $day . '_to') !== false && !is_null($v))
			{
				$d = getdate(strtotime($v));
				$wt['end_hour'] = $d['hours'];
				$wt['end_minutes'] = $d['minutes'];
				$wt['end_ts'] = strtotime($date . " " . $v);
				continue;
			}
		}
		return $wt;
	}
	
	public function init()
	{
		$data = array();
		$data['monday_from']    = '08:00:00';
		$data['monday_to']      = '17:00:00';
		$data['tuesday_from']   = '08:00:00';
		$data['tuesday_to']     = '17:00:00';
		$data['wednesday_from'] = '08:00:00';
		$data['wednesday_to']   = '17:00:00';
		$data['thursday_from']  = '08:00:00';
		$data['thursday_to']    = '17:00:00';
		$data['friday_from']    = '08:00:00';
		$data['friday_to']      = '17:00:00';
		$data['saturday_from']  = '08:00:00';
		$data['saturday_to']    = '17:00:00';
		$data['sunday_from']    = '08:00:00';
		$data['sunday_to']      = '17:00:00';
		return $this->reset()->setAttributes($data)->insert()->getInsertId();
	}
}
?>