<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$pjTime = pjTime::factory();
	$backs = __('booking_backs', true);
	$forths = __('booking_forths', true);
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionIndex"><?php __('menuBookings'); ?></a></li>
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjInvoice&amp;action=pjActionInvoices"><?php __('plugin_invoice_menu_invoices'); ?></a></li>
		</ul>
	</div>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate" method="post" id="frmUpdateBooking" class="form pj-form frmBooking">
		<input type="hidden" name="booking_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('booking_tab_details'); ?></a></li>
				<li><a href="#tabs-2"><?php __('booking_tab_client'); ?></a></li>
				<?php
				if (pjObject::getPlugin('pjInvoice') !== NULL)
				{
					?><li><a href="#tabs-3"><?php __('plugin_invoice_menu_invoices'); ?></a></li><?php
				}
				?>
			</ul>
			
			<div id="tabs-1">
				<?php pjUtil::printNotice(@$titles['ABK12'], @$bodies['ABK12']); ?>
				<fieldset class="fieldset white">
					<legend><?php __('booking_general'); ?></legend>
					<div class="float_left">
						<p>
							<label class="title"><?php __('booking_created'); ?>:</label>
							<span class="left"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created'])); ?></span>
						</p>
						<p>
							<label class="title"><?php __('booking_uuid'); ?>:</label>
							<input type="text" name="uuid" id="uuid" class="pj-form-field w100 required" value="<?php echo pjSanitize::html($tpl['arr']['uuid']); ?>" data-msg-remote="<?php __('booking_uuid_duplicate', false, true); ?>" />
						</p>
						<?php
						if (!empty($tpl['arr']['dt_from']))
						{
							list($date_from, $time_from) = explode(" ", $tpl['arr']['dt_from']);
							list($hour_from, $minute_from,) = explode(":", $time_from);
						}
						if (!empty($tpl['arr']['dt_to']))
						{
							list($date_to, $time_to) = explode(" ", $tpl['arr']['dt_to']);
							list($hour_to, $minute_to,) = explode(":", $time_to);
						}
						?>
						<p>
							<label class="title"><?php __('booking_from'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
								<input type="text" name="date_from" id="date_from" class="pj-form-field w80 datepick pointer required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo !isset($date_from) ? NULL : pjUtil::formatDate($date_from, 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" />
								<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							</span>
							<span class="float_left">
							<?php
							$pjTime->reset();
							if (isset($hour_from))
							{
								$pjTime->prop('selected', $hour_from);
							}
							echo $pjTime
								->attr('name', 'hour_from')
								->attr('id', 'hour_from')
								->attr('class', 'pj-form-field')
								->hour();
							?>
							<?php
							$pjTime->reset();
							if (isset($minute_from))
							{
								$pjTime->prop('selected', $minute_from);
							}
							echo $pjTime
								->attr('name', 'minute_from')
								->attr('id', 'minute_from')
								->attr('class', 'pj-form-field')
								->prop('step', 5)
								->minute();
							?>
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_to'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
								<input type="text" name="date_to" id="date_to" class="pj-form-field w80 datepick pointer required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo !isset($date_to) ? NULL : pjUtil::formatDate($date_to, 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" />
								<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							</span>
							<span class="float_left">
							<?php
							$pjTime->reset();
							if (isset($hour_to))
							{
								$pjTime->prop('selected', $hour_to);
							}
							echo $pjTime
								->attr('name', 'hour_to')
								->attr('id', 'hour_to')
								->attr('class', 'pj-form-field')
								->hour();
							?>
							<?php
							$pjTime->reset();
							if (isset($minute_to))
							{
								$pjTime->prop('selected', $minute_to);
							}
							echo $pjTime
								->attr('name', 'minute_to')
								->attr('id', 'minute_to')
								->attr('class', 'pj-form-field')
								->prop('step', 5)
								->minute();
							?>
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_status'); ?>:</label>
							<select name="status" id="status" class="pj-form-field required">
								<option value=""><?php __('booking_choose'); ?></option>
								<?php
								foreach (__('booking_statuses', true) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['status'] == $k ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</p>
						<p>
							<label class="title200"><?php __('booking_forth'); ?>:</label>
							<span class="left padding150">
							<?php
							foreach (__('booking_forths', true) as $k => $v)
							{
								?><label><input type="radio" name="forth" value="<?php echo $k; ?>"<?php echo $tpl['arr']['forth'] == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
								<?php
							}
							?>
							</span>
						</p>
						<p>
							<label class="title200"><?php __('booking_back'); ?>:</label>
							<span class="left padding150">
							<?php
							foreach (__('booking_backs', true) as $k => $v)
							{
								?><label><input type="radio" name="back" value="<?php echo $k; ?>"<?php echo $tpl['arr']['back'] == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
								<?php
							}
							?>
							</span>
						</p>
						<br/><br/>
						<div id="boxBookingItems"></div>
					</div>
					<div class="float_right">
						<p>
							<label class="title"><?php __('booking_payment_method'); ?>:</label>
							<select name="payment_method" id="payment_method" class="pj-form-field<?php echo (int) $tpl['option_arr']['o_disable_payments'] === 1 ? NULL : ' required'; ?>">
								<option value=""><?php __('booking_choose'); ?></option>
								<?php
								foreach (__('payment_methods', true) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['payment_method'] == $k ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</p>
						<p class="erCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
							<label class="title"><?php __('booking_cc_type'); ?></label>
							<span class="inline_block">
								<select name="cc_type" class="pj-form-field w140">
									<option value="">---</option>
									<?php
									foreach (__('booking_cc_types', true) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"<?php echo $k != $tpl['arr']['cc_type'] ? NULL : ' selected="selected"'; ?>><?php echo $v; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p class="erCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
							<label class="title"><?php __('booking_cc_num'); ?></label>
							<span class="inline_block">
								<input type="text" name="cc_num" id="cc_num" class="pj-form-field w120 digits" value="<?php echo pjSanitize::html($tpl['arr']['cc_num']); ?>" />
							</span>
						</p>
						<p class="erCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
							<label class="title"><?php __('booking_cc_code'); ?></label>
							<span class="inline_block">
								<input type="text" name="cc_code" id="cc_code" class="pj-form-field w120 digits" value="<?php echo pjSanitize::html($tpl['arr']['cc_code']); ?>" />
							</span>
						</p>
						<p class="erCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
							<label class="title"><?php __('booking_cc_exp'); ?></label>
							<span class="inline_block">
								<?php
								echo pjTime::factory()
									->attr('name', 'cc_exp_month')
									->attr('id', 'cc_exp_month')
									->attr('class', 'pj-form-field')
									->prop('format', 'M')
									->prop('selected', $tpl['arr']['cc_exp_month'])
									->month();
								?>
								<?php
								echo pjTime::factory()
									->attr('name', 'cc_exp_year')
									->attr('id', 'cc_exp_year')
									->attr('class', 'pj-form-field')
									->prop('left', 0)
									->prop('right', 10)
									->prop('selected', $tpl['arr']['cc_exp_year'])
									->year();
								?>
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_price'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="price" id="price" class="pj-form-field number w80" value="<?php echo number_format(@$tpl['arr']['price'], 2, ".", ""); ?>" />
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_security'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="security" id="security" class="pj-form-field number w80" value="<?php echo number_format(@$tpl['arr']['security'], 2, ".", ""); ?>" />
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_deposit'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="deposit" id="deposit" class="pj-form-field number w80" value="<?php echo number_format(@$tpl['arr']['deposit'], 2, ".", ""); ?>" />
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_tax'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="tax" id="tax" class="pj-form-field number w80" value="<?php echo number_format(@$tpl['arr']['tax'], 2, ".", ""); ?>" />
							</span>
						</p>
						<p>
							<label class="title"><?php echo @$forths['delivery']; ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="delivery" id="delivery" class="pj-form-field number w80" value="<?php echo number_format(@$tpl['arr']['delivery'], 2, ".", ""); ?>" />
							</span>
						</p>
						<p>
							<label class="title"><?php echo @$backs['collection']; ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="collection" id="collection" class="pj-form-field number w80" value="<?php echo number_format(@$tpl['arr']['collection'], 2, ".", ""); ?>" />
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_total'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="total" id="total" class="pj-form-field number w80" value="<?php echo number_format(@$tpl['arr']['total'], 2, ".", ""); ?>" />
							</span>
						</p>
					</div>
					<br class="clear_both" /><br/>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
						<input type="button" value="<?php __('booking_add_item', false, true); ?>" class="pj-button item-add" />
						<input type="button" value="<?php __('booking_recalc', false, true); ?>" class="pj-button order-calc" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
					</p>
					<div class="p">
						<div id="dialogItemDelete" title="Delete confirmation" style="display: none">Are you sure you want to delete selected item?</div>
						<div id="dialogItemEdit" title="Edit Item" style="display: none"></div>
						<div id="dialogItemAdd" title="Add Item" style="display: none"></div>
					</div>
				</fieldset>
			</div>
			<div id="tabs-2">
				<?php pjUtil::printNotice(@$titles['ABK13'], @$bodies['ABK13']); ?>
				<fieldset class="fieldset white">
					<legend><?php __('booking_customer'); ?></legend>
					
					<div class="float_left w360">
						<p>
							<label class="title"><?php __('booking_country'); ?>:</label>
							<select name="c_country_id" id="c_country_id" class="pj-form-field w180 custom-chosen">
								<option value=""><?php __('booking_choose'); ?></option>
								<?php
								foreach ($tpl['country_arr'] as $country)
								{
									?><option value="<?php echo $country['id']; ?>"<?php echo $country['id'] == $tpl['arr']['c_country_id'] ? ' selected="selected"' : NULL; ?>><?php echo pjSanitize::html($country['name']); ?></option><?php
								}
								?>
							</select>
						</p>
						<p>
							<label class="title"><?php __('booking_state'); ?>:</label>
							<input type="text" name="c_state" id="c_state" class="pj-form-field w180" value="<?php echo pjSanitize::html($tpl['arr']['c_state']); ?>" />
						</p>
					</div>
					<div class="float_right w350">
						<p>
							<label class="title"><?php __('booking_city'); ?>:</label>
							<input type="text" name="c_city" id="c_city" class="pj-form-field w160" value="<?php echo pjSanitize::html($tpl['arr']['c_city']); ?>" />
						</p>
						<p>
							<label class="title"><?php __('booking_zip'); ?>:</label>
							<input type="text" name="c_zip" id="c_zip" class="pj-form-field w80" value="<?php echo pjSanitize::html($tpl['arr']['c_zip']); ?>" />
						</p>
					</div>
					<br class="clear_both" />
					<p>
						<label class="title"><?php __('booking_name'); ?>:</label>
						<input type="text" name="c_name" id="c_name" class="pj-form-field w300" value="<?php echo pjSanitize::html($tpl['arr']['c_name']); ?>" />
					</p>
					<p>
						<label class="title"><?php __('booking_email'); ?>:</label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
							<input type="text" name="c_email" id="c_email" class="pj-form-field email w250" value="<?php echo pjSanitize::html($tpl['arr']['c_email']); ?>" />
						</span>
					</p>
					<p>
						<label class="title"><?php __('booking_phone'); ?>:</label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
							<input type="text" name="c_phone" id="c_phone" class="pj-form-field w250" value="<?php echo pjSanitize::html($tpl['arr']['c_phone']); ?>" />
						</span>
					</p>
					<p>
						<label class="title"><?php __('booking_address_1'); ?>:</label>
						<input type="text" name="c_address_1" id="c_address_1" class="pj-form-field w500" value="<?php echo pjSanitize::html($tpl['arr']['c_address_1']); ?>" />
					</p>
					<p>
						<label class="title"><?php __('booking_address_2'); ?>:</label>
						<input type="text" name="c_address_2" id="c_address_2" class="pj-form-field w500" value="<?php echo pjSanitize::html($tpl['arr']['c_address_2']); ?>" />
					</p>
					<p>
						<label class="title"><?php __('booking_notes'); ?>:</label>
						<textarea name="c_notes" id="c_notes" class="pj-form-field w500 h100"><?php echo pjSanitize::html($tpl['arr']['c_notes']); ?></textarea>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
					</p>
				</fieldset>
				
			</div>
			<?php
			if (pjObject::getPlugin('pjInvoice') !== NULL)
			{
				?>
				<div id="tabs-3">
					<input type="button" class="pj-button btnCreateInvoice" value="<?php __('booking_create_invoice'); ?>" />
					<div id="grid_invoices" class="t10 b10"></div>
				</div>
				<?php
			}
			?>
		</div>
	</form>
	
	<?php
	if (pjObject::getPlugin('pjInvoice') !== NULL)
	{
		$map = array(
			'confirmed' => 'paid',
			'pending' => 'not_paid',
			'cancelled' => 'cancelled'
		);
		?>
		<form action="<?php echo PJ_INSTALL_URL; ?>index.php" method="get" target="_blank" style="display: inline" id="frmCreateInvoice">
			<input type="hidden" name="controller" value="pjInvoice" />
			<input type="hidden" name="action" value="pjActionCreateInvoice" />
			<input type="hidden" name="tmp" value="<?php echo md5(uniqid(rand(), true)); ?>" />
			<input type="hidden" name="uuid" value="<?php echo pjUtil::uuid(); ?>" />
			<input type="hidden" name="order_id" value="<?php echo pjSanitize::html($tpl['arr']['uuid']); ?>" />
			<input type="hidden" name="issue_date" value="<?php echo date('Y-m-d'); ?>" />
			<input type="hidden" name="due_date" value="<?php echo date('Y-m-d'); ?>" />
			<input type="hidden" name="status" value="<?php echo @$map[$tpl['arr']['status']]; ?>" />
			<input type="hidden" name="subtotal" value="<?php echo $tpl['arr']['price'] + $tpl['arr']['security']; ?>" />
			<input type="hidden" name="discount" value="0.00" />
			<input type="hidden" name="tax" value="<?php echo $tpl['arr']['tax']; ?>" />
			<input type="hidden" name="shipping" value="0.00" />
			<input type="hidden" name="total" value="<?php echo $tpl['arr']['total']; ?>" />
			<input type="hidden" name="paid_deposit" value="0.00" />
			<input type="hidden" name="amount_due" value="0.00" />
			<input type="hidden" name="currency" value="<?php echo pjSanitize::html($tpl['option_arr']['o_currency']); ?>" />
			<input type="hidden" name="notes" value="<?php echo pjSanitize::html($tpl['arr']['c_notes']); ?>" />
			<input type="hidden" name="b_billing_address" value="<?php echo pjSanitize::html($tpl['arr']['c_address_1']); ?>" />
			<input type="hidden" name="b_name" value="<?php echo pjSanitize::html($tpl['arr']['c_name']); ?>" />
			<input type="hidden" name="b_address" value="<?php echo pjSanitize::html($tpl['arr']['c_address_1']); ?>" />
			<input type="hidden" name="b_street_address" value="<?php echo pjSanitize::html($tpl['arr']['c_address_2']); ?>" />
			<input type="hidden" name="b_city" value="<?php echo pjSanitize::html($tpl['arr']['c_city']); ?>" />
			<input type="hidden" name="b_state" value="<?php echo pjSanitize::html($tpl['arr']['c_state']); ?>" />
			<input type="hidden" name="b_zip" value="<?php echo pjSanitize::html($tpl['arr']['c_zip']); ?>" />
			<input type="hidden" name="b_phone" value="<?php echo pjSanitize::html($tpl['arr']['c_phone']); ?>" />
			<input type="hidden" name="b_email" value="<?php echo pjSanitize::html($tpl['arr']['c_email']); ?>" />
			<?php
			$items = array();
			if (isset($tpl['bi_arr']) && !empty($tpl['bi_arr']))
			{
				foreach ($tpl['bi_arr'] as $i => $attr)
				{
					$items[$i] = array(
						'name' => $attr['title'],
						'description' => NULL,
						'qty' => $attr['qty'],
						'unit_price' => $attr['unit_price'],
						'amount' => number_format($attr['qty'] * $attr['unit_price'], 2, ".", "")
					);
					?>
					<input type="hidden" name="items[<?php echo $i; ?>][name]" value="<?php echo pjSanitize::html($items[$i]['name']); ?>" />
					<input type="hidden" name="items[<?php echo $i; ?>][description]" value="<?php echo pjSanitize::html($items[$i]['description']); ?>" />
					<input type="hidden" name="items[<?php echo $i; ?>][qty]" value="<?php echo $items[$i]['qty']; ?>" />
					<input type="hidden" name="items[<?php echo $i; ?>][unit_price]" value="<?php echo $items[$i]['unit_price']; ?>" />
					<input type="hidden" name="items[<?php echo $i; ?>][amount]" value="<?php echo $items[$i]['amount']; ?>" />
					<?php
				}
				?>
				<input type="hidden" name="items[<?php echo $i+1; ?>][name]" value="<?php echo pjSanitize::html(__('booking_security', true)); ?>" />
				<input type="hidden" name="items[<?php echo $i+1; ?>][description]" value="" />
				<input type="hidden" name="items[<?php echo $i+1; ?>][qty]" value="1" />
				<input type="hidden" name="items[<?php echo $i+1; ?>][unit_price]" value="<?php echo $tpl['arr']['security']; ?>" />
				<input type="hidden" name="items[<?php echo $i+1; ?>][amount]" value="<?php echo $tpl['arr']['security']; ?>" />
				
				<input type="hidden" name="items[<?php echo $i+2; ?>][name]" value="<?php echo pjSanitize::html(@$forths['delivery']); ?>" />
				<input type="hidden" name="items[<?php echo $i+2; ?>][description]" value="" />
				<input type="hidden" name="items[<?php echo $i+2; ?>][qty]" value="1" />
				<input type="hidden" name="items[<?php echo $i+2; ?>][unit_price]" value="<?php echo @$tpl['arr']['delivery']; ?>" />
				<input type="hidden" name="items[<?php echo $i+2; ?>][amount]" value="<?php echo @$tpl['arr']['delivery']; ?>" />
				
				<input type="hidden" name="items[<?php echo $i+3; ?>][name]" value="<?php echo pjSanitize::html(@$backs['collection']); ?>" />
				<input type="hidden" name="items[<?php echo $i+3; ?>][description]" value="" />
				<input type="hidden" name="items[<?php echo $i+3; ?>][qty]" value="1" />
				<input type="hidden" name="items[<?php echo $i+3; ?>][unit_price]" value="<?php echo @$tpl['arr']['collection']; ?>" />
				<input type="hidden" name="items[<?php echo $i+3; ?>][amount]" value="<?php echo @$tpl['arr']['collection']; ?>" />
				<?php
			} else {
				$items[0] = array(
					'name' => 'Booking payment',
					'description' => '',
					'qty' => 1,
					'unit_price' => $tpl['arr']['total'],
					'amount' => $tpl['arr']['total']
				);
				?>
				<input type="hidden" name="items[0][name]" value="<?php echo pjSanitize::html($items[0]['name']); ?>" />
				<input type="hidden" name="items[0][description]" value="<?php echo pjSanitize::html($items[0]['description']); ?>" />
				<input type="hidden" name="items[0][qty]" value="<?php echo $items[0]['qty']; ?>" />
				<input type="hidden" name="items[0][unit_price]" value="<?php echo $items[0]['unit_price']; ?>" />
				<input type="hidden" name="items[0][amount]" value="<?php echo $items[0]['amount']; ?>" />
				<?php
			}
			?>
		</form>
		<?php
	}
	$statuses = __('plugin_invoice_statuses', true);
	?>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	var myLabel = myLabel || {};
	myLabel.uuid = "<?php __('booking_uuid'); ?>";
	myLabel.client = "<?php __('booking_client'); ?>";
	myLabel.created = "<?php __('booking_created'); ?>";
	myLabel.status = "<?php __('booking_status'); ?>";
	myLabel.total = "<?php __('booking_total'); ?>";
	myLabel.statuses = <?php echo pjAppController::jsonEncode(__('booking_statuses', true)); ?>;
	myLabel.exported = "<?php __('lblExport'); ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('gridDeleteConfirmation'); ?>";

	myLabel.num = "<?php __('plugin_invoice_i_num'); ?>";
	myLabel.order_id = "<?php __('plugin_invoice_i_order_id'); ?>";
	myLabel.issue_date = "<?php __('plugin_invoice_i_issue_date'); ?>";
	myLabel.due_date = "<?php __('plugin_invoice_i_due_date'); ?>";
	myLabel.created = "<?php __('plugin_invoice_i_created'); ?>";
	myLabel.status = "<?php __('plugin_invoice_i_status'); ?>";
	myLabel.total = "<?php __('plugin_invoice_i_total'); ?>";
	myLabel.delete_title = "<?php __('plugin_invoice_i_delete_title'); ?>";
	myLabel.delete_body = "<?php __('plugin_invoice_i_delete_body'); ?>";
	myLabel.paid = "<?php echo $statuses['paid']; ?>";
	myLabel.not_paid = "<?php echo $statuses['not_paid']; ?>";
	myLabel.cancelled = "<?php echo $statuses['cancelled']; ?>";
	myLabel.empty_date = "<?php __('gridEmptyDate'); ?>";
	myLabel.invalid_date = "<?php __('gridInvalidDate'); ?>";
	myLabel.empty_datetime = "<?php __('gridEmptyDatetime'); ?>";
	myLabel.invalid_datetime = "<?php __('gridInvalidDatetime'); ?>";
	</script>
	<?php
}
?>