<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/optmenu.php';
	include_once dirname(__FILE__) . '/elements/submenu.php';

	pjUtil::printNotice(@$titles['AO28'], @$bodies['AO28']);
	?>
	<form id="frmTimeDefault" action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTime&amp;action=pjActionIndex" method="post" class="form">
		<input type="hidden" name="working_time" value="1" />
		<table class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%;">
			<thead>
				<tr>
					<th><?php __('time_day'); ?></th>
					<th><?php __('time_from'); ?></th>
					<th><?php __('time_to'); ?></th>
					<th><?php __('time_is'); ?></th>
				</tr>
			</thead>
			<tbody>
			<?php
			$i = 1;
			$days = __('days', true);
			$w_days = array(
				'monday' => $days[1],
				'tuesday' => $days[2],
				'wednesday' => $days[3],
				'thursday' => $days[4],
				'friday' => $days[5],
				'saturday' => $days[6],
				'sunday' => $days[0]
			);

			foreach ($w_days as $k => $day)
			{
				$step = 5;
				
				$pjTime_hf = pjTime::factory()
					->attr('name', $k . '_hour_from')
					->attr('id', $k . '_hour_from')
					->attr('class', 'pj-form-field w60');
					
				$pjTime_mf = pjTime::factory()
					->attr('name', $k . '_minute_from')
					->attr('id', $k . '_minute_from')
					->attr('class', 'pj-form-field w60')
					->prop('step', $step);
					
				$pjTime_ht = pjTime::factory()
					->attr('name', $k . '_hour_to')
					->attr('id', $k . '_hour_to')
					->attr('class', 'pj-form-field w60');
					
				$pjTime_mt = pjTime::factory()
					->attr('name', $k . '_minute_to')
					->attr('id', $k . '_minute_to')
					->attr('class', 'pj-form-field w60')
					->prop('step', $step);
					
				if (isset($tpl['wt_arr']) && count($tpl['wt_arr']) > 0)
				{
					$hour_from = substr($tpl['wt_arr'][$k.'_from'], 0, 2);
					$hour_to = substr($tpl['wt_arr'][$k.'_to'], 0, 2);
					$minute_from = substr($tpl['wt_arr'][$k.'_from'], 3, 2);
					$minute_to = substr($tpl['wt_arr'][$k.'_to'], 3, 2);
					$checked = NULL;
					//$disabled = NULL;
					if (is_null($tpl['wt_arr'][$k.'_from']) || $tpl['wt_arr'][$k.'_dayoff'] == 'T')
					{
						$pjTime_hf->attr('disabled', 'disabled');
						$pjTime_mf->attr('disabled', 'disabled');
						$pjTime_ht->attr('disabled', 'disabled');
						$pjTime_mt->attr('disabled', 'disabled');
						$checked = ' checked="checked"';
						//$disabled = ' disabled="disabled"';
					}
				} else {
					$hour_from = NULL;
					$hour_to = NULL;
					$minute_from = NULL;
					$minute_to = NULL;
					$checked = NULL;
					//$disabled = NULL;
				}
				?>
				<tr id="pjRow_<?php echo $k;?>" class="<?php echo ($i % 2 !== 0 ? 'odd' : 'even'); ?>">
					<td><?php echo $day; ?></td>
					<td>
					<?php
					echo $pjTime_hf
						->prop('selected', $hour_from)
						->hour();
					?>
					<?php
					echo $pjTime_mf
						->prop('selected', $minute_from)
						->minute();
					?>
					</td>
					<td>
					<?php
					echo $pjTime_ht
						->prop('selected', $hour_to)
						->hour();
					?>
					<?php
					echo $pjTime_mt
						->prop('selected', $minute_to)
						->minute();
					?>
					</td>
					<td><input type="checkbox" class="working_day" name="<?php echo $k; ?>_dayoff" value="T"<?php echo $checked; ?> /></td>
				</tr>
				<?php
				$i++;
			}
			?>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="4"><input type="submit" value="<?php __('btnSave'); ?>" class="pj-button"  /></td>
				</tr>
			</tfoot>
		</table>
	</form>
	<?php
}
?>