var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var tipsy = ($.fn.tipsy !== undefined),
			tabs = ($.fn.tabs !== undefined),
			validate = ($.fn.validate !== undefined),
			$tabs = $("#tabs"),
			$frmOptions = $("#frmOptions"),
			$frmTerms = $("#frmTerms");

		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		if (validate) {
			if ($frmTerms.length > 0) {
				$frmTerms.validate({
					errorPlacement: function (error, element) {
						error.insertAfter(element.parent());
					},
					onkeyup: false,
					errorClass: "err",
					wrapper: "em"
				});
			}
			if ($frmOptions.length > 0) {
				$frmOptions.validate({
					rules: {
						"value-float-o_delivery": {
							number: true,
							min: 0,
							max: 99999.99
						},
						"value-float-o_collection": {
							number: true,
							min: 0,
							max: 99999.99
						},
						"value-float-o_deposit": {
							number: true,
							min: 0,
							max: 99999.99
						},
						"value-float-o_security": {
							number: true,
							min: 0,
							max: 99999.99
						},
						"value-float-o_tax": {
							number: true,
							min: 0,
							max: 99999.99
						},
						"value-int-o_require_all_within": {
							digits: true,
							min: 0,
							max: 999
						}
						
					},
					errorPlacement: function (error, element) {
						error.insertAfter(element.parent());
					},
					onkeyup: false,
					errorClass: "err",
					wrapper: "em"
				});
			}
		}

		if (tipsy) {
			$(".listing-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
		}
		
		$(".field-int").spinner({
			min: 0
		});
		
		$("input[name='value-int-o_require_all_within']").spinner({
			min: 0,
			max: 999
		});
		
		$("#content").on("focus", ".textarea_install", function (e) {
			var $this = $(this);
			$this.select();
			$this.mouseup(function() {
				$this.unbind("mouseup");
				return false;
			});
		}).on("keyup", "#uri_page", function (e) {
			var tmpl = $("#hidden_htaccess").text(),
				index = this.value.indexOf("?");
			$("#install_htaccess").text(tmpl.replace('::URI_PAGE::', index >= 0 ? this.value.substring(0, index) : this.value));
		}).on("change", "select[name='install_locale']", function(e) {
            var locale = $("option:selected", this).val(),
            	$area = $("#install_code"),
                $clone_area = $("#clone_install_code"),
                script = $clone_area.text(),
                pattern = /&locale=(\d+)?/g;
            if (script.match(pattern) === null) {
            	$area.text(script.replace(/&action=pjActionLoadJS/g, function(match) {
                    return ['&action=pjActionLoad&locale=', locale].join("");
                }));
            } else {
                $area.text(script.replace(pattern, ''));
            }
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("change", "input[name='value-bool-o_allow_paypal']", function (e) {
			if ($(this).is(":checked")) {
				$(".boxPaypal").show();
			} else {
				$(".boxPaypal").hide();
			}
		}).on("change", "input[name='value-bool-o_allow_authorize']", function (e) {
			if ($(this).is(":checked")) {
				$(".boxAuthorize").show();
			} else {
				$(".boxAuthorize").hide();
			}
		}).on("change", "input[name='value-bool-o_allow_bank']", function (e) {
			if ($(this).is(":checked")) {
				$(".boxBank").show();
			} else {
				$(".boxBank").hide();
			}
		}).on("change", "input[name='value-bool-o_disable_payments']", function (e) {
			if ($(this).is(":checked")) {
				$(".boxDisable").show();
			} else {
				$(".boxDisable").hide();
			}
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
				}
			});
		});
	});
})(jQuery_1_8_2);