DROP TABLE IF EXISTS `fundrasing_donations`;
CREATE TABLE IF NOT EXISTS `fundrasing_donations` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `campaign_id` int(10) unsigned DEFAULT NULL,
  `status` enum('P','N') default 'N',
  `amount` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `ip` varchar(255) default NULL,
  `name` varchar(255) default NULL,
  `phone` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `cc_type` varchar(255) default NULL,
  `cc_num` varchar(255) default NULL,
  `cc_exp` varchar(255) default NULL,
  `cc_code` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `campaign_id` (`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `fundrasing_donations_payments`;
CREATE TABLE IF NOT EXISTS `fundrasing_donations_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `donation_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `donation_id` (`donation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `fundrasing_campaigns`;
CREATE TABLE IF NOT EXISTS `fundrasing_campaigns` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `terms` text DEFAULT NULL,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY  (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `fundrasing_fields`;
CREATE TABLE IF NOT EXISTS `fundrasing_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `fundrasing_multi_lang`;
CREATE TABLE IF NOT EXISTS `fundrasing_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `fundrasing_options`;
CREATE TABLE IF NOT EXISTS `fundrasing_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `fundrasing_roles`;
CREATE TABLE IF NOT EXISTS `fundrasing_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `fundrasing_users`;
CREATE TABLE IF NOT EXISTS `fundrasing_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `fundrasing_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install & Preview', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(457, 'menuCampaigns', 'backend', 'Menu / Campaigns', 'script', NULL),
(458, 'menuDonations', 'backend', 'Menu / Donations', 'script', NULL),
(459, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(460, 'menuPayments', 'backend', 'Menu / Payments', 'script', NULL),
(461, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(462, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(463, 'opt_o_allow_paypal', 'backend', 'Options / Allow donation with PayPal', 'script', NULL),
(464, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address ', 'script', NULL),
(465, 'opt_o_allow_authorize', 'backend', 'Options / Allow donation with Authorize.net', 'script', NULL),
(466, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(467, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(468, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(469, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(470, 'opt_o_allow_cash', 'backend', 'Options / Allow donations with cash', 'script', NULL),
(471, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline donation', 'script', NULL),
(472, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(473, 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
(474, 'opt_o_thankyou_page', 'backend', 'Options / Thank you page', 'script', NULL),
(475, 'opt_o_email_confirmation', 'backend', 'Options / Donation confirmation email', 'script', NULL),
(476, 'opt_o_email_confirmation_text', 'backend', 'Options / Donation confirmation email', 'script', NULL),
(477, 'opt_o_email_confirmation_subject', 'backend', 'Donation confirmation subject', 'script', NULL),
(478, 'opt_o_email_confirmation_message', 'backend', 'Donation confirmation message', 'script', NULL),
(479, 'opt_o_email_confirmation_message_text', 'backend', 'Donation confirmation message', 'script', NULL),
(480, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(481, 'lblDeadline', 'backend', 'Label / Deadline', 'script', NULL),
(482, 'lblAddCampaign', 'backend', 'Label / Add campaign', 'script', NULL),
(483, 'lblTitleTaken', 'backend', 'Label / Title was already used for another campaign.', 'script', NULL),
(484, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(485, 'lblTerms', 'backend', 'Label / Terms', 'script', NULL),
(486, 'lblAmount', 'backend', 'Label / Amount', 'script', NULL),
(487, 'infoCampaignsTitle', 'backend', 'Infobox / List of campaigns', 'script', NULL),
(489, 'infoCampaignsDesc', 'backend', 'Infobox / List of campaigns', 'script', NULL),
(490, 'infoAddCampaignTitle', 'backend', 'Label / Add new campaign', 'script', NULL),
(491, 'infoAddCampaignDesc', 'backend', 'Label / Add new campaign', 'script', NULL),
(492, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(493, 'lblUpdateCampaign', 'backend', 'Label / Update campaign', 'script', NULL),
(494, 'infoUpdateCampaignTitle', 'backend', 'Infobox / Update campaign', 'script', NULL),
(495, 'infoUpdateCampaignDesc', 'backend', 'Infobox / Update campaign', 'script', NULL),
(496, 'lblDeleteImageTitle', 'backend', 'Label / Delete image', 'script', NULL),
(497, 'lblDeleteImageConfirmation', 'backend', 'Label / Delete image', 'script', NULL),
(498, 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
(499, 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
(500, 'error_titles_ARRAY_ACP01', 'arrays', 'error_titles_ARRAY_ACP01', 'script', NULL),
(501, 'error_bodies_ARRAY_ACP01', 'arrays', 'error_bodies_ARRAY_ACP01', 'script', NULL),
(502, 'error_titles_ARRAY_ACP03', 'arrays', 'error_titles_ARRAY_ACP03', 'script', NULL),
(503, 'error_bodies_ARRAY_ACP03', 'arrays', 'error_bodies_ARRAY_ACP03', 'script', NULL),
(504, 'error_titles_ARRAY_ACP04', 'arrays', 'error_titles_ARRAY_ACP04', 'script', NULL),
(505, 'error_bodies_ARRAY_ACP04', 'arrays', 'error_bodies_ARRAY_ACP04', 'script', NULL),
(506, 'error_bodies_ARRAY_ACP08', 'arrays', 'error_bodies_ARRAY_ACP08', 'script', NULL),
(507, 'error_titles_ARRAY_ACP08', 'arrays', 'error_titles_ARRAY_ACP08', 'script', NULL),
(509, 'error_titles_ARRAY_ACP05', 'arrays', 'error_titles_ARRAY_ACP05', 'script', NULL),
(510, 'error_bodies_ARRAY_ACP05', 'arrays', 'error_bodies_ARRAY_ACP05', 'script', NULL),
(511, 'error_titles_ARRAY_ACP06', 'arrays', 'error_titles_ARRAY_ACP06', 'script', NULL),
(512, 'error_bodies_ARRAY_ACP06', 'arrays', 'error_bodies_ARRAY_ACP06', 'script', NULL),
(513, 'error_titles_ARRAY_ACP09', 'arrays', 'error_titles_ARRAY_ACP09', 'script', NULL),
(514, 'error_bodies_ARRAY_ACP09', 'arrays', 'error_bodies_ARRAY_ACP09', 'script', NULL),
(515, 'error_titles_ARRAY_ACP10', 'arrays', 'error_titles_ARRAY_ACP10', 'script', NULL),
(516, 'error_bodies_ARRAY_ACP10', 'arrays', 'error_bodies_ARRAY_ACP10', 'script', NULL),
(517, 'opt_o_admin_email_confirmation', 'backend', 'Options / New donation received email', 'script', NULL),
(518, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New donation received email', 'script', NULL),
(519, 'opt_o_admin_email_confirmation_subject', 'backend', 'Donation confirmation subject', 'script', NULL),
(520, 'opt_o_admin_email_confirmation_message', 'backend', 'Donation confirmation message', 'script', NULL),
(521, 'opt_o_admin_email_confirmation_message_text', 'backend', 'Donation confirmation message', 'script', NULL),
(522, 'infoNotificationsTitle', 'backend', 'Infobox / Notifications', 'script', NULL),
(523, 'infoNotificationsDesc', 'backend', 'Infobox / Notifications', 'script', NULL),
(524, 'lblCampaign', 'backend', 'Label / Campaign', 'script', NULL),
(526, 'lblEmail', 'backend', 'Label / Email', 'script', NULL),
(527, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(529, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(530, 'lblCCType', 'backend', 'Label / CC Type', 'script', NULL),
(531, 'lblCCNum', 'backend', 'Label / CC Number', 'script', NULL),
(532, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(533, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(534, 'lblAddDonation', 'backend', 'Label / Add donation', 'script', NULL),
(535, 'infoDonationsTitle', 'backend', 'Infobox / List of donations', 'script', NULL),
(536, 'infoDonationsDesc', 'backend', 'Infobox / List of donations', 'script', NULL),
(537, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(538, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(539, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(540, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(541, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(542, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(543, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(544, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(545, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(546, 'infoAddDonationTitle', 'backend', 'Infobox / Add new donation', 'script', NULL),
(547, 'infoAddDonationDesc', 'backend', 'Infobox / Add new donation', 'script', NULL),
(548, 'lblNoCampaigns', 'backend', 'Label / No campaigns', 'script', NULL),
(549, 'error_titles_ARRAY_AD01', 'arrays', 'error_titles_ARRAY_AD01', 'script', NULL),
(550, 'error_bodies_ARRAY_AD01', 'arrays', 'error_bodies_ARRAY_AD01', 'script', NULL),
(551, 'error_titles_ARRAY_AD03', 'arrays', 'error_titles_ARRAY_AD03', 'script', NULL),
(552, 'error_bodies_ARRAY_AD03', 'arrays', 'error_bodies_ARRAY_AD03', 'script', NULL),
(553, 'error_titles_ARRAY_AD04', 'arrays', 'error_titles_ARRAY_AD04', 'script', NULL),
(554, 'error_bodies_ARRAY_AD04', 'arrays', 'error_bodies_ARRAY_AD04', 'script', NULL),
(555, 'error_titles_ARRAY_AD08', 'arrays', 'error_titles_ARRAY_AD08', 'script', NULL),
(556, 'error_bodies_ARRAY_AD08', 'arrays', 'error_bodies_ARRAY_AD08', 'script', NULL),
(557, 'lblUpdateDonation', 'backend', 'Label / Update donation', 'script', NULL),
(558, 'infoUpdateDonationTitle', 'backend', 'Infobox / Update donation', 'script', NULL),
(559, 'infoUpdateDonationDesc', 'backend', 'Infobox / Update donation', 'script', NULL),
(560, 'lblInstallJs1_title', 'backend', 'Label / Installation', 'script', NULL),
(561, 'lblInstallJs1_body', 'backend', 'Label / Installation', 'script', NULL),
(562, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(563, 'front_read_more', 'frontend', 'Label / Read more', 'script', NULL),
(564, 'front_read_less', 'frontend', 'Label / Read less', 'script', NULL),
(565, 'front_button_donate', 'frontend', 'Button / Donate', 'script', NULL),
(566, 'front_needed', 'frontend', 'Label / needed', 'script', NULL),
(567, 'front_received', 'frontend', 'Label / received', 'script', NULL),
(568, 'front_days_left', 'frontend', 'Label / days left', 'script', NULL),
(569, 'front_day_left', 'frontend', 'Label / day left', 'script', NULL),
(570, 'front_donation', 'frontend', 'Label / donation', 'script', NULL),
(571, 'front_donations', 'frontend', 'Label / donations', 'script', NULL),
(572, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(573, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(574, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(575, 'front_amount_to_donate', 'frontend', 'Label / Amount to donate', 'script', NULL),
(576, 'front_select_payment_method', 'frontend', 'Label / Select payment method', 'script', NULL),
(577, 'front_payment_method', 'frontend', 'Label / Payment method', 'script', NULL),
(578, 'front_cctype', 'frontend', 'Label / CC type', 'script', NULL),
(579, 'front_ccnumber', 'frontend', 'Label / CC number', 'script', NULL),
(580, 'front_ccexp', 'frontend', 'Label / CC expiration', 'script', NULL),
(581, 'front_cccode', 'frontend', 'Label / CC code', 'script', NULL),
(582, 'front_terms_conditions', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(583, 'front_cancel', 'frontend', 'Label / Cancel', 'script', NULL),
(584, 'front_required_field', 'frontend', 'Label / This field is required.', 'script', NULL),
(585, 'lblDonated', 'backend', 'Label / Donated', 'script', NULL),
(586, 'lblOf', 'backend', 'Label / of', 'script', NULL),
(587, 'lblDateTime', 'backend', 'Label / Date & time', 'script', NULL),
(588, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(589, 'lblMore', 'backend', 'Label / More', 'script', NULL),
(590, 'donation_statuses_ARRAY_P', 'arrays', 'donation_statuses_ARRAY_P', 'script', NULL),
(591, 'donation_statuses_ARRAY_N', 'arrays', 'donation_statuses_ARRAY_N', 'script', NULL),
(687, 'front_campaign_not_existing', 'frontend', 'Label / Campaign does not existing anymore.', 'script', NULL),
(688, 'front_donation_could_not_saved', 'frontend', 'Label / Donation could not be saved.', 'script', NULL),
(689, 'opt_o_email_payment', 'backend', 'Options / Donation payment email', 'script', NULL),
(690, 'opt_o_email_payment_text', 'backend', 'Options / Donation payment email', 'script', NULL),
(691, 'opt_o_email_payment_subject', 'backend', 'Options / Donation payment subject', 'script', NULL),
(692, 'opt_o_email_payment_message', 'backend', 'Options / Donation payment message', 'script', NULL),
(693, 'opt_o_email_payment_message_text', 'backend', 'Options / Donation payment message', 'script', NULL),
(694, 'opt_o_admin_email_payment', 'backend', 'Options / Payment received email', 'script', NULL),
(695, 'opt_o_admin_email_payment_subject', 'backend', 'Options / Payment received', 'script', NULL),
(696, 'opt_o_admin_email_payment_message', 'backend', 'Options / Payment received message', 'script', NULL),
(698, 'opt_o_admin_email_payment_text', 'backend', 'Options / Payment received email', 'script', NULL),
(699, 'opt_o_admin_email_payment_message_text', 'backend', 'Options / Payment received message', 'script', NULL),
(700, 'front_donation_saved', 'frontend', 'Label / Donation has been saved.', 'script', NULL),
(701, 'front_message', 'frontend', 'Label / Donation is processing...', 'script', NULL),
(702, 'front_messages_ARRAY_1', 'arrays', 'front_messages_ARRAY_1', 'script', NULL),
(703, 'front_messages_ARRAY_2', 'arrays', 'front_messages_ARRAY_2', 'script', NULL),
(704, 'front_messages_ARRAY_3', 'arrays', 'front_messages_ARRAY_3', 'script', NULL),
(705, 'lblProgress', 'backend', 'Label / Progress', 'script', NULL),
(706, 'lblSingularDonation', 'backend', 'Label /donation', 'script', NULL),
(707, 'lblPluralDonation', 'backend', 'Label /donations', 'script', NULL),
(708, 'lblActiveCampaign', 'backend', 'Label / active campaign', 'script', NULL),
(709, 'lblActiveCampaigns', 'backend', 'Label / active campaigns', 'script', NULL),
(710, 'lblDonationReceived', 'backend', 'Label / donation received', 'script', NULL),
(711, 'lblDonationsReceived', 'backend', 'Label / donations received', 'script', NULL),
(712, 'lblCompletedCampaign', 'backend', 'Label / completed campaign', 'script', NULL),
(713, 'lblCompletedCampaigns', 'backend', 'Label / completed campaigns', 'script', NULL),
(714, 'lblAlmostCompleted', 'backend', 'Label / Almost completed', 'script', NULL),
(715, 'lblLatestDonations', 'backend', 'Label / Latest donations', 'script', NULL),
(716, 'lblLatestCampaigns', 'backend', 'Label / Latest campaigns', 'script', NULL),
(717, 'lblReceived', 'backend', 'Label / received', 'script', NULL),
(718, 'lblMoreNeeded', 'backend', 'Label / more needed', 'script', NULL),
(719, 'lblBy', 'backend', 'Label / by', 'script', NULL),
(720, 'lblVia', 'backend', 'Label / via', 'script', NULL),
(722, 'lblFunded', 'backend', 'Label / funded', 'script', NULL),
(723, 'lblDonations', 'backend', 'Label / donations', 'script', NULL),
(724, 'lblDonation', 'backend', 'Label / donation', 'script', NULL),
(725, 'lblCampaignsNotFound', 'backend', 'Label / Campaigns not found', 'script', NULL),
(726, 'lblDonationsNotFound', 'backend', 'Label / No donations received yet.', 'script', NULL),
(823, 'front_no_campaign_found', 'frontend', 'Label / Campaign not found.', 'script', NULL),
(824, 'front_campaign_stopped', 'frontend', 'Label / Campaign is stopped.', 'script', NULL),
(825, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(826, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(827, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(828, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(829, 'buttons_ARRAY_stop', 'arrays', 'buttons_ARRAY_stop', 'script', NULL),
(830, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(831, 'lblDeleteCampaignConfirm', 'backend', 'Label / Delete campaign confirmation', 'script', NULL),
(832, 'lblDeleteCampaignConfirm2', 'backend', 'Label / Delete campaign confirmation', 'script', NULL),
(833, 'lblDeleteCampaignConfirm3', 'backend', 'Label / Delete campaign confirmation', 'script', NULL),
(834, 'lblNoActiveCampaigns', 'backend', 'Label / No active campaigns', 'script', NULL),
(835, 'gridEmptyTitle', 'backend', 'Label / No records selected', 'script', NULL),
(836, 'gridEmptyBody', 'backend', 'Label / No records selected', 'script', NULL);

INSERT INTO `fundrasing_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', '??', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', '??', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'User with such email address exists.', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'User with such email address exists.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes have been saved.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes have been saved. ', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes have been saved.', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 256, 'pjField', 2, 'title', 'Client with such email address exists.', 'script'),
(NULL, 256, 'pjField', 3, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 360, 'pjField', 2, 'title', 'Install & Preview', 'script'),
(NULL, 360, 'pjField', 3, 'title', 'Install & Preview', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 361, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 361, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Campaigns', 'script'),
(NULL, 457, 'pjField', 2, 'title', 'Campaigns', 'script'),
(NULL, 457, 'pjField', 3, 'title', 'Campaigns', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Donations', 'script'),
(NULL, 458, 'pjField', 2, 'title', 'Donations', 'script'),
(NULL, 458, 'pjField', 3, 'title', 'Donations', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 459, 'pjField', 2, 'title', 'General', 'script'),
(NULL, 459, 'pjField', 3, 'title', 'General', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Payments', 'script'),
(NULL, 460, 'pjField', 2, 'title', 'Payments', 'script'),
(NULL, 460, 'pjField', 3, 'title', 'Payments', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 461, 'pjField', 2, 'title', 'Notifications', 'script'),
(NULL, 461, 'pjField', 3, 'title', 'Notifications', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 462, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 462, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Allow donation with PayPal', 'script'),
(NULL, 463, 'pjField', 2, 'title', 'Allow donation with PayPal', 'script'),
(NULL, 463, 'pjField', 3, 'title', 'Allow donation with PayPal', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 464, 'pjField', 2, 'title', 'PayPal business email address', 'script'),
(NULL, 464, 'pjField', 3, 'title', 'PayPal business email address', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Allow donation with Authorize.net', 'script'),
(NULL, 465, 'pjField', 2, 'title', 'Allow donation with Authorize.net', 'script'),
(NULL, 465, 'pjField', 3, 'title', 'Allow donation with Authorize.net', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 466, 'pjField', 2, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 466, 'pjField', 3, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 467, 'pjField', 2, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 467, 'pjField', 3, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 468, 'pjField', 2, 'title', 'Authorize.net time zone', 'script'),
(NULL, 468, 'pjField', 3, 'title', 'Authorize.net time zone', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 469, 'pjField', 2, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 469, 'pjField', 3, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Allow donations with cash', 'script'),
(NULL, 470, 'pjField', 2, 'title', 'Allow donations with cash', 'script'),
(NULL, 470, 'pjField', 3, 'title', 'Allow donations with cash', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Collect Credit Card details for offline donation', 'script'),
(NULL, 471, 'pjField', 2, 'title', 'Collect Credit Card details for offline donation', 'script'),
(NULL, 471, 'pjField', 3, 'title', 'Collect Credit Card details for offline donation', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 472, 'pjField', 2, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 472, 'pjField', 3, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 473, 'pjField', 2, 'title', 'Bank account', 'script'),
(NULL, 473, 'pjField', 3, 'title', 'Bank account', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Thank you page:<br/>\r\nURL for the web page where people will be redirected after donation with PayPal or Authorize.net. ', 'script'),
(NULL, 474, 'pjField', 2, 'title', 'Thank you page:<br/>\r\nURL for the web page where people will be redirected after donation with PayPal or Authorize.net. ', 'script'),
(NULL, 474, 'pjField', 3, 'title', 'Thank you page:<br/>\r\nURL for the web page where people will be redirected after donation with PayPal or Authorize.net. ', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Donation confirmation email', 'script'),
(NULL, 475, 'pjField', 2, 'title', 'Donation confirmation email', 'script'),
(NULL, 475, 'pjField', 3, 'title', 'Donation confirmation email', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Select ''Yes'' if you want people to receive confirmation email when they make a donation. Otherwise select ''No''. ', 'script'),
(NULL, 476, 'pjField', 2, 'title', 'Select ''Yes'' if you want people to receive confirmation email when they make a donation. Otherwise select ''No''. ', 'script'),
(NULL, 476, 'pjField', 3, 'title', 'Select ''Yes'' if you want people to receive confirmation email when they make a donation. Otherwise select ''No''. ', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Donation confirmation subject', 'script'),
(NULL, 477, 'pjField', 2, 'title', 'Donation confirmation subject', 'script'),
(NULL, 477, 'pjField', 3, 'title', 'Donation confirmation subject', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Donation confirmation message', 'script'),
(NULL, 478, 'pjField', 2, 'title', 'Donation confirmation message', 'script'),
(NULL, 478, 'pjField', 3, 'title', 'Donation confirmation message', 'script'),
(NULL, 479, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 479, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 479, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 480, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 480, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Deadline', 'script'),
(NULL, 481, 'pjField', 2, 'title', 'Deadline', 'script'),
(NULL, 481, 'pjField', 3, 'title', 'Deadline', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Add campaign', 'script');
INSERT INTO `fundrasing_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 482, 'pjField', 2, 'title', 'Add campaign', 'script'),
(NULL, 482, 'pjField', 3, 'title', 'Add campaign', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Title was already used for another campaign.', 'script'),
(NULL, 483, 'pjField', 2, 'title', 'Title was already used for another campaign.', 'script'),
(NULL, 483, 'pjField', 3, 'title', 'Title was already used for another campaign.', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 484, 'pjField', 2, 'title', 'Description', 'script'),
(NULL, 484, 'pjField', 3, 'title', 'Description', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 485, 'pjField', 2, 'title', 'Terms', 'script'),
(NULL, 485, 'pjField', 3, 'title', 'Terms', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 486, 'pjField', 2, 'title', 'Amount', 'script'),
(NULL, 486, 'pjField', 3, 'title', 'Amount', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'List of campaigns', 'script'),
(NULL, 487, 'pjField', 2, 'title', 'List of campaigns', 'script'),
(NULL, 487, 'pjField', 3, 'title', 'List of campaigns', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Below are all fundraising campaigns you have created using the script. To edit a campaign, click on the pencil icon at the right of the row.', 'script'),
(NULL, 489, 'pjField', 2, 'title', 'You can find below the list of campaigns. If you wan to edit or view detail information of any campaign, click on the corresponding pencil icon.', 'script'),
(NULL, 489, 'pjField', 3, 'title', 'You can find below the list of campaigns. If you wan to edit or view detail information of any campaign, click on the corresponding pencil icon.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Add new campaign', 'script'),
(NULL, 490, 'pjField', 2, 'title', 'Add new campaign', 'script'),
(NULL, 490, 'pjField', 3, 'title', 'Add new campaign', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'To add a new campaign, fill the form fields below, then click on the "Save" button.', 'script'),
(NULL, 491, 'pjField', 2, 'title', 'Please fill the form below and click on the "Save" button to add new campaign.', 'script'),
(NULL, 491, 'pjField', 3, 'title', 'Please fill the form below and click on the "Save" button to add new campaign.', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 492, 'pjField', 2, 'title', 'Image', 'script'),
(NULL, 492, 'pjField', 3, 'title', 'Image', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Edit campaign', 'script'),
(NULL, 493, 'pjField', 2, 'title', 'Update campaign', 'script'),
(NULL, 493, 'pjField', 3, 'title', 'Update campaign', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Edit campaign data', 'script'),
(NULL, 494, 'pjField', 2, 'title', 'Update campaign', 'script'),
(NULL, 494, 'pjField', 3, 'title', 'Update campaign', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'You can make any changes to the campaign, then click the "Save" button to update the campaign details.', 'script'),
(NULL, 495, 'pjField', 2, 'title', 'You can make any change on the form below and click on "Save" button update the campaign information.', 'script'),
(NULL, 495, 'pjField', 3, 'title', 'You can make any change on the form below and click on "Save" button update the campaign information.', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 496, 'pjField', 2, 'title', 'Delete image', 'script'),
(NULL, 496, 'pjField', 3, 'title', 'Delete image', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Are you sure that you want to delete the image?', 'script'),
(NULL, 497, 'pjField', 2, 'title', 'Are you sure that you want to delete the image?', 'script'),
(NULL, 497, 'pjField', 3, 'title', 'Are you sure that you want to delete the image?', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 498, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 498, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 499, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 499, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Campaign updated', 'script'),
(NULL, 500, 'pjField', 2, 'title', 'Campaign updated', 'script'),
(NULL, 500, 'pjField', 3, 'title', 'Campaign updated', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'All changes have been saved.', 'script'),
(NULL, 501, 'pjField', 2, 'title', 'All changes made to the campaign have been saved.', 'script'),
(NULL, 501, 'pjField', 3, 'title', 'All changes made to the campaign have been saved.', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Saved', 'script'),
(NULL, 502, 'pjField', 2, 'title', 'Campaign added', 'script'),
(NULL, 502, 'pjField', 3, 'title', 'Campaign added', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Your campaign has been added to the list.', 'script'),
(NULL, 503, 'pjField', 2, 'title', 'New campaign has been added into the list.', 'script'),
(NULL, 503, 'pjField', 3, 'title', 'New campaign has been added into the list.', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Campaign failed to add', 'script'),
(NULL, 504, 'pjField', 2, 'title', 'Campaign failed to add', 'script'),
(NULL, 504, 'pjField', 3, 'title', 'Campaign failed to add', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'We are sorry that new campaign could not be added successfully.', 'script'),
(NULL, 505, 'pjField', 2, 'title', 'We are sorry that new campaign could not be added successfully.', 'script'),
(NULL, 505, 'pjField', 3, 'title', 'We are sorry that new campaign could not be added successfully.', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'We are sorry that the campaign you are looking for is missing.', 'script'),
(NULL, 506, 'pjField', 2, 'title', 'We are sorry that the campaign you are looking for is missing.', 'script'),
(NULL, 506, 'pjField', 3, 'title', 'We are sorry that the campaign you are looking for is missing.', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Campaign not found', 'script'),
(NULL, 507, 'pjField', 2, 'title', 'Campaign not found', 'script'),
(NULL, 507, 'pjField', 3, 'title', 'Campaign not found', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 509, 'pjField', 2, 'title', 'Image size too large', 'script'),
(NULL, 509, 'pjField', 3, 'title', 'Image size too large', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'New campaign could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 510, 'pjField', 2, 'title', 'New campaign could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 510, 'pjField', 3, 'title', 'New campaign could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 511, 'pjField', 2, 'title', 'Image size too large', 'script'),
(NULL, 511, 'pjField', 3, 'title', 'Image size too large', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'The campaign could not be updated successfully because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 512, 'pjField', 2, 'title', 'The campaign could not be updated successfully because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 512, 'pjField', 3, 'title', 'The campaign could not be updated successfully because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 513, 'pjField', 2, 'title', 'Upload error', 'script'),
(NULL, 513, 'pjField', 3, 'title', 'Upload error', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'New campaign has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 514, 'pjField', 2, 'title', 'New campaign has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 514, 'pjField', 3, 'title', 'New campaign has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 515, 'pjField', 2, 'title', 'Upload error', 'script'),
(NULL, 515, 'pjField', 3, 'title', 'Upload error', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'The campaign has been updated, but image could not be uploaded successfully.', 'script'),
(NULL, 516, 'pjField', 2, 'title', 'The campaign has been updated, but image could not be uploaded successfully.', 'script'),
(NULL, 516, 'pjField', 3, 'title', 'The campaign has been updated, but image could not be uploaded successfully.', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'New donation received email', 'script'),
(NULL, 517, 'pjField', 2, 'title', 'New donation received email', 'script'),
(NULL, 517, 'pjField', 3, 'title', 'New donation received email', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications when a new donation has been made. Otherwise select ''No''. ', 'script'),
(NULL, 518, 'pjField', 2, 'title', 'Select ''Yes'' if you want to receive email notifications when a new donation has been made. Otherwise select ''No''. ', 'script'),
(NULL, 518, 'pjField', 3, 'title', 'Select ''Yes'' if you want to receive email notifications when a new donation has been made. Otherwise select ''No''. ', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Donation confirmation subject', 'script'),
(NULL, 519, 'pjField', 2, 'title', 'Donation confirmation subject', 'script'),
(NULL, 519, 'pjField', 3, 'title', 'Donation confirmation subject', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Donation confirmation message', 'script'),
(NULL, 520, 'pjField', 2, 'title', 'Donation confirmation message', 'script'),
(NULL, 520, 'pjField', 3, 'title', 'Donation confirmation message', 'script'),
(NULL, 521, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 521, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 521, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 522, 'pjField', 2, 'title', 'Notifications', 'script'),
(NULL, 522, 'pjField', 3, 'title', 'Notifications', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'There are four types of email notifications, sent either to the script admin or the contributors. The notifications are triggered by different events  such as donation received or payment is made. Read carefully when set up the notifications.', 'script'),
(NULL, 523, 'pjField', 2, 'title', 'You will find below 2 types of email notifications. "Donation confirmation email" is used to send confirmation to people who make donation. And the other is used to send notification to the admin.', 'script'),
(NULL, 523, 'pjField', 3, 'title', 'You will find below 2 types of email notifications. "Donation confirmation email" is used to send confirmation to people who make donation. And the other is used to send notification to the admin.', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Campaign', 'script'),
(NULL, 524, 'pjField', 2, 'title', 'Campaign', 'script'),
(NULL, 524, 'pjField', 3, 'title', 'Campaign', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 526, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 526, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 527, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 527, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 529, 'pjField', 2, 'title', 'Payment method', 'script'),
(NULL, 529, 'pjField', 3, 'title', 'Payment method', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'CC Type', 'script'),
(NULL, 530, 'pjField', 2, 'title', 'CC Type', 'script'),
(NULL, 530, 'pjField', 3, 'title', 'CC Type', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'CC Number', 'script'),
(NULL, 531, 'pjField', 2, 'title', 'CC Number', 'script'),
(NULL, 531, 'pjField', 3, 'title', 'CC Number', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 532, 'pjField', 2, 'title', 'CC expiration date', 'script'),
(NULL, 532, 'pjField', 3, 'title', 'CC expiration date', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 533, 'pjField', 2, 'title', 'CC code', 'script'),
(NULL, 533, 'pjField', 3, 'title', 'CC code', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Add donation', 'script'),
(NULL, 534, 'pjField', 2, 'title', 'Add donation', 'script'),
(NULL, 534, 'pjField', 3, 'title', 'Add donation', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Donations ', 'script'),
(NULL, 535, 'pjField', 2, 'title', 'List of donations', 'script'),
(NULL, 535, 'pjField', 3, 'title', 'List of donations', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Below is a full list of donations for all your campaigns. To view contributor''s details, click on the corresponding pencil icon. To add a donation manually, click on the the above tab "Add donation". ', 'script'),
(NULL, 536, 'pjField', 2, 'title', 'You can find below the list of donations for all campaigns. To view the details of each donation, click on the corresponding pencil icon. To add new donation, click on the the tab "Add donation".', 'script'),
(NULL, 536, 'pjField', 3, 'title', 'You can find below the list of donations for all campaigns. To view the details of each donation, click on the corresponding pencil icon. To add new donation, click on the the tab "Add donation".', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 537, 'pjField', 2, 'title', 'PayPal', 'script'),
(NULL, 537, 'pjField', 3, 'title', 'PayPal', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 538, 'pjField', 2, 'title', 'Authorize.net', 'script'),
(NULL, 538, 'pjField', 3, 'title', 'Authorize.net', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 539, 'pjField', 2, 'title', 'Cash', 'script'),
(NULL, 539, 'pjField', 3, 'title', 'Cash', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 540, 'pjField', 2, 'title', 'Bank account', 'script'),
(NULL, 540, 'pjField', 3, 'title', 'Bank account', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 541, 'pjField', 2, 'title', 'Credit card', 'script'),
(NULL, 541, 'pjField', 3, 'title', 'Credit card', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 542, 'pjField', 2, 'title', 'Visa', 'script'),
(NULL, 542, 'pjField', 3, 'title', 'Visa', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 543, 'pjField', 2, 'title', 'MasterCard', 'script'),
(NULL, 543, 'pjField', 3, 'title', 'MasterCard', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 544, 'pjField', 2, 'title', 'Maestro', 'script'),
(NULL, 544, 'pjField', 3, 'title', 'Maestro', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 545, 'pjField', 2, 'title', 'AmericanExpress', 'script'),
(NULL, 545, 'pjField', 3, 'title', 'AmericanExpress', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Add new donation', 'script'),
(NULL, 546, 'pjField', 2, 'title', 'Add new donation', 'script'),
(NULL, 546, 'pjField', 3, 'title', 'Add new donation', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'To add a new donation, fill out the form below, then click the "Save" button.', 'script'),
(NULL, 547, 'pjField', 2, 'title', 'Please fill out the form below and click "Save" button to add new donation for the selected campaign.', 'script'),
(NULL, 547, 'pjField', 3, 'title', 'Please fill out the form below and click "Save" button to add new donation for the selected campaign.', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'There are no campaigns. Click [STAG]here[ETAG] to add new campaign.', 'script'),
(NULL, 548, 'pjField', 2, 'title', 'There are no campaigns. Click [STAG]here[ETAG] to add new campaign.', 'script'),
(NULL, 548, 'pjField', 3, 'title', 'There are no campaigns. Click [STAG]here[ETAG] to add new campaign.', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Donation updated', 'script'),
(NULL, 549, 'pjField', 2, 'title', 'Donation updated', 'script'),
(NULL, 549, 'pjField', 3, 'title', 'Donation updated', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'All changes made to the donation have been saved.', 'script'),
(NULL, 550, 'pjField', 2, 'title', 'All changes made to the donation have been saved.', 'script'),
(NULL, 550, 'pjField', 3, 'title', 'All changes made to the donation have been saved.', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Saved', 'script'),
(NULL, 551, 'pjField', 2, 'title', 'Donation added', 'script'),
(NULL, 551, 'pjField', 3, 'title', 'Donation added', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'The donation has been added.', 'script'),
(NULL, 552, 'pjField', 2, 'title', 'New donation has been added into the list.', 'script'),
(NULL, 552, 'pjField', 3, 'title', 'New donation has been added into the list.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Donation failed to add', 'script'),
(NULL, 553, 'pjField', 2, 'title', 'Donation failed to add', 'script'),
(NULL, 553, 'pjField', 3, 'title', 'Donation failed to add', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'We are sorry that new donation has not been added successfully.', 'script'),
(NULL, 554, 'pjField', 2, 'title', 'We are sorry that new donation has not been added successfully.', 'script'),
(NULL, 554, 'pjField', 3, 'title', 'We are sorry that new donation has not been added successfully.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Donation not found', 'script'),
(NULL, 555, 'pjField', 2, 'title', 'Donation not found', 'script'),
(NULL, 555, 'pjField', 3, 'title', 'Donation not found', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'We are sorry that the donation you are looking for is missing.', 'script'),
(NULL, 556, 'pjField', 2, 'title', 'We are sorry that the donation you are looking for is missing.', 'script'),
(NULL, 556, 'pjField', 3, 'title', 'We are sorry that the donation you are looking for is missing.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Update donation', 'script'),
(NULL, 557, 'pjField', 2, 'title', 'Update donation', 'script'),
(NULL, 557, 'pjField', 3, 'title', 'Update donation', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Update donation', 'script'),
(NULL, 558, 'pjField', 2, 'title', 'Update donation', 'script'),
(NULL, 558, 'pjField', 3, 'title', 'Update donation', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'You can make any change on the form below and click "Save" button to update information of the selected donation.', 'script'),
(NULL, 559, 'pjField', 2, 'title', 'You can make any change on the form below and click "Save" button to update information of the selected donation.', 'script'),
(NULL, 559, 'pjField', 3, 'title', 'You can make any change on the form below and click "Save" button to update information of the selected donation.', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Installation', 'script'),
(NULL, 560, 'pjField', 2, 'title', 'Installation', 'script'),
(NULL, 560, 'pjField', 3, 'title', 'Installation', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Use the drop-down menu to select a campaign, then copy the code which appears below and paste it into your HTML page. N.B. The script should be installed on your hosting account first, otherwise this will not work.', 'script'),
(NULL, 561, 'pjField', 2, 'title', 'Copy the code below and put it on your web page. It will show the front end the donation form for the selected campaign. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
(NULL, 561, 'pjField', 3, 'title', 'Copy the code below and put it on your web page. It will show the front end the donation form for the selected campaign. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 562, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 562, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Read more', 'script'),
(NULL, 563, 'pjField', 2, 'title', 'Read more', 'script'),
(NULL, 563, 'pjField', 3, 'title', 'Read more', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Read less', 'script'),
(NULL, 564, 'pjField', 2, 'title', 'Read less', 'script'),
(NULL, 564, 'pjField', 3, 'title', 'Read less', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Donate', 'script'),
(NULL, 565, 'pjField', 2, 'title', 'Donate', 'script'),
(NULL, 565, 'pjField', 3, 'title', 'Donate', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'needed', 'script'),
(NULL, 566, 'pjField', 2, 'title', 'needed', 'script'),
(NULL, 566, 'pjField', 3, 'title', 'needed', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'received', 'script'),
(NULL, 567, 'pjField', 2, 'title', 'received', 'script'),
(NULL, 567, 'pjField', 3, 'title', 'received', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'days left', 'script'),
(NULL, 568, 'pjField', 2, 'title', 'days left', 'script'),
(NULL, 568, 'pjField', 3, 'title', 'days left', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'day left', 'script'),
(NULL, 569, 'pjField', 2, 'title', 'day left', 'script'),
(NULL, 569, 'pjField', 3, 'title', 'day left', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'donation', 'script'),
(NULL, 570, 'pjField', 2, 'title', 'donation', 'script'),
(NULL, 570, 'pjField', 3, 'title', 'donation', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'donations', 'script'),
(NULL, 571, 'pjField', 2, 'title', 'donations', 'script'),
(NULL, 571, 'pjField', 3, 'title', 'donations', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 572, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 572, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 573, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 573, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 574, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 574, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Amount to donate', 'script'),
(NULL, 575, 'pjField', 2, 'title', 'Amount to donate', 'script'),
(NULL, 575, 'pjField', 3, 'title', 'Amount to donate', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Select payment method', 'script'),
(NULL, 576, 'pjField', 2, 'title', 'Select payment method', 'script'),
(NULL, 576, 'pjField', 3, 'title', 'Select payment method', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 577, 'pjField', 2, 'title', 'Payment method', 'script'),
(NULL, 577, 'pjField', 3, 'title', 'Payment method', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 578, 'pjField', 2, 'title', 'CC type', 'script'),
(NULL, 578, 'pjField', 3, 'title', 'CC type', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 579, 'pjField', 2, 'title', 'CC number', 'script'),
(NULL, 579, 'pjField', 3, 'title', 'CC number', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 580, 'pjField', 2, 'title', 'CC expiration', 'script'),
(NULL, 580, 'pjField', 3, 'title', 'CC expiration', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 581, 'pjField', 2, 'title', 'CC code', 'script'),
(NULL, 581, 'pjField', 3, 'title', 'CC code', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'I agree with <a href="#" class="frTerms">Terms and Conditions</a>', 'script'),
(NULL, 582, 'pjField', 2, 'title', 'I agree with <a href="#" class="frTerms">Terms and Conditions</a>', 'script'),
(NULL, 582, 'pjField', 3, 'title', 'I agree with <a href="#" class="frTerms">Terms and Conditions</a>', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 583, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 583, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 584, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 584, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Donated', 'script'),
(NULL, 585, 'pjField', 2, 'title', 'Donated', 'script'),
(NULL, 585, 'pjField', 3, 'title', 'Donated', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 586, 'pjField', 2, 'title', 'of', 'script'),
(NULL, 586, 'pjField', 3, 'title', 'of', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 587, 'pjField', 2, 'title', 'Date & time', 'script'),
(NULL, 587, 'pjField', 3, 'title', 'Date & time', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 588, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 588, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'More', 'script'),
(NULL, 589, 'pjField', 2, 'title', 'More', 'script'),
(NULL, 589, 'pjField', 3, 'title', 'More', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Paid', 'script'),
(NULL, 590, 'pjField', 2, 'title', 'Paid', 'script'),
(NULL, 590, 'pjField', 3, 'title', 'Paid', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Not paid', 'script'),
(NULL, 591, 'pjField', 2, 'title', 'Not paid', 'script'),
(NULL, 591, 'pjField', 3, 'title', 'Not paid', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Campaign does not existing anymore.', 'script'),
(NULL, 687, 'pjField', 2, 'title', 'Campaign does not existing anymore.', 'script'),
(NULL, 687, 'pjField', 3, 'title', 'Campaign does not existing anymore.', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Donation could not be saved.', 'script'),
(NULL, 688, 'pjField', 2, 'title', 'Donation could not be saved.', 'script'),
(NULL, 688, 'pjField', 3, 'title', 'Donation could not be saved.', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Donation payment email', 'script'),
(NULL, 689, 'pjField', 2, 'title', 'Donation payment email', 'script'),
(NULL, 689, 'pjField', 3, 'title', 'Donation payment email', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Select ''Yes'' if you want people to receive payment email when they make payment for the donation. Otherwise select ''No''. ', 'script'),
(NULL, 690, 'pjField', 2, 'title', 'Select ''Yes'' if you want people to receive payment email when they make payment for the donation. Otherwise select ''No''. ', 'script'),
(NULL, 690, 'pjField', 3, 'title', 'Select ''Yes'' if you want people to receive payment email when they make payment for the donation. Otherwise select ''No''. ', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Donation payment subject', 'script'),
(NULL, 691, 'pjField', 2, 'title', 'Donation payment subject', 'script'),
(NULL, 691, 'pjField', 3, 'title', 'Donation payment subject', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Donation payment message', 'script'),
(NULL, 692, 'pjField', 2, 'title', 'Donation payment message', 'script'),
(NULL, 692, 'pjField', 3, 'title', 'Donation payment message', 'script'),
(NULL, 693, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 693, 'pjField', 2, 'title', '<u>Available tokens:</u>\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 693, 'pjField', 3, 'title', '<u>Available tokens:</u>\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Payment received email', 'script'),
(NULL, 694, 'pjField', 2, 'title', 'Payment received email', 'script'),
(NULL, 694, 'pjField', 3, 'title', 'Payment received email', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'Payment received', 'script'),
(NULL, 695, 'pjField', 2, 'title', 'Payment received', 'script'),
(NULL, 695, 'pjField', 3, 'title', 'Payment received', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Payment received message', 'script'),
(NULL, 696, 'pjField', 2, 'title', 'Payment received message', 'script'),
(NULL, 696, 'pjField', 3, 'title', 'Payment received message', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications when a payment for donation has been made. Otherwise select ''No''. ', 'script'),
(NULL, 698, 'pjField', 2, 'title', 'Select ''Yes'' if you want to receive email notifications when a payment for donation has been made. Otherwise select ''No''. ', 'script'),
(NULL, 698, 'pjField', 3, 'title', 'Select ''Yes'' if you want to receive email notifications when a payment for donation has been made. Otherwise select ''No''. ', 'script'),
(NULL, 699, 'pjField', 1, 'title', '<u>Available tokens</u>:\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 699, 'pjField', 2, 'title', '<u>Available tokens</u>:\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 699, 'pjField', 3, 'title', '<u>Available tokens</u>:\r\n{Campaign}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Amount}', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Donation has been saved.', 'script'),
(NULL, 700, 'pjField', 2, 'title', 'Donation has been saved.', 'script'),
(NULL, 700, 'pjField', 3, 'title', 'Donation has been saved.', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Donation is processing...', 'script'),
(NULL, 701, 'pjField', 2, 'title', 'Donation is processing...', 'script'),
(NULL, 701, 'pjField', 3, 'title', 'Donation is processing...', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'The donation was saved. Redirecting to PayPal...', 'script'),
(NULL, 702, 'pjField', 2, 'title', 'The donation was saved. Redirecting to PayPal...', 'script'),
(NULL, 702, 'pjField', 3, 'title', 'The donation was saved. Redirecting to PayPal...', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'The donation was saved. Redirecting to Authorize.net...', 'script'),
(NULL, 703, 'pjField', 2, 'title', 'The donation was saved. Redirecting to Authorize.net...', 'script'),
(NULL, 703, 'pjField', 3, 'title', 'The donation was saved. Redirecting to Authorize.net...', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'The donation was saved. Thank you!', 'script'),
(NULL, 704, 'pjField', 2, 'title', 'The donation was saved. Thank you!', 'script'),
(NULL, 704, 'pjField', 3, 'title', 'The donation was saved. Thank you!', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Progress', 'script'),
(NULL, 705, 'pjField', 2, 'title', 'Progress', 'script'),
(NULL, 705, 'pjField', 3, 'title', 'Progress', 'script'),
(NULL, 706, 'pjField', 1, 'title', '%s received with %u donation', 'script'),
(NULL, 706, 'pjField', 2, 'title', '%s received with %u donation', 'script'),
(NULL, 706, 'pjField', 3, 'title', '%s received with %u donation', 'script'),
(NULL, 707, 'pjField', 1, 'title', '%s received with %u donations', 'script'),
(NULL, 707, 'pjField', 2, 'title', '%s received with %u donations', 'script'),
(NULL, 707, 'pjField', 3, 'title', '%s received with %u donations', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'active campaign', 'script'),
(NULL, 708, 'pjField', 2, 'title', 'active campaign', 'script'),
(NULL, 708, 'pjField', 3, 'title', 'active campaign', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'active campaigns', 'script'),
(NULL, 709, 'pjField', 2, 'title', 'active campaigns', 'script'),
(NULL, 709, 'pjField', 3, 'title', 'active campaigns', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'donation received', 'script'),
(NULL, 710, 'pjField', 2, 'title', 'donation received', 'script'),
(NULL, 710, 'pjField', 3, 'title', 'donation received', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'donations received', 'script'),
(NULL, 711, 'pjField', 2, 'title', 'donations received', 'script'),
(NULL, 711, 'pjField', 3, 'title', 'donations received', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'completed campaign', 'script'),
(NULL, 712, 'pjField', 2, 'title', 'completed campaign', 'script'),
(NULL, 712, 'pjField', 3, 'title', 'completed campaign', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'completed campaigns', 'script'),
(NULL, 713, 'pjField', 2, 'title', 'completed campaigns', 'script'),
(NULL, 713, 'pjField', 3, 'title', 'completed campaigns', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'Almost completed', 'script'),
(NULL, 714, 'pjField', 2, 'title', 'Almost completed', 'script'),
(NULL, 714, 'pjField', 3, 'title', 'Almost completed', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Latest donations', 'script'),
(NULL, 715, 'pjField', 2, 'title', 'Latest donations', 'script'),
(NULL, 715, 'pjField', 3, 'title', 'Latest donations', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Latest campaigns', 'script'),
(NULL, 716, 'pjField', 2, 'title', 'Latest campaigns', 'script'),
(NULL, 716, 'pjField', 3, 'title', 'Latest campaigns', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'received', 'script'),
(NULL, 717, 'pjField', 2, 'title', 'received', 'script'),
(NULL, 717, 'pjField', 3, 'title', 'received', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'more needed', 'script'),
(NULL, 718, 'pjField', 2, 'title', 'more needed', 'script'),
(NULL, 718, 'pjField', 3, 'title', 'more needed', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 719, 'pjField', 2, 'title', 'by', 'script'),
(NULL, 719, 'pjField', 3, 'title', 'by', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'via', 'script'),
(NULL, 720, 'pjField', 2, 'title', 'via', 'script'),
(NULL, 720, 'pjField', 3, 'title', 'via', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'funded', 'script'),
(NULL, 722, 'pjField', 2, 'title', 'funded', 'script'),
(NULL, 722, 'pjField', 3, 'title', 'funded', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'donations', 'script'),
(NULL, 723, 'pjField', 2, 'title', 'donations', 'script'),
(NULL, 723, 'pjField', 3, 'title', 'donations', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'donation', 'script'),
(NULL, 724, 'pjField', 2, 'title', 'donation', 'script'),
(NULL, 724, 'pjField', 3, 'title', 'donation', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'Campaigns not found', 'script'),
(NULL, 725, 'pjField', 2, 'title', 'Campaigns not found', 'script'),
(NULL, 725, 'pjField', 3, 'title', 'Campaigns not found', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'No donations received yet.', 'script'),
(NULL, 726, 'pjField', 2, 'title', 'No donations received yet.', 'script'),
(NULL, 726, 'pjField', 3, 'title', 'No donations received yet.', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'Campaign not found.', 'script'),
(NULL, 823, 'pjField', 2, 'title', 'Campaign not found.', 'script'),
(NULL, 823, 'pjField', 3, 'title', 'Campaign not found.', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'Campaign is stopped.', 'script'),
(NULL, 824, 'pjField', 2, 'title', 'Campaign is stopped.', 'script'),
(NULL, 824, 'pjField', 3, 'title', 'Campaign is stopped.', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'Saved', 'script'),
(NULL, 825, 'pjField', 2, 'title', 'Notifications updated', 'script'),
(NULL, 825, 'pjField', 3, 'title', 'Notifications updated', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'All the changes made here have been saved.', 'script'),
(NULL, 826, 'pjField', 2, 'title', 'All the changes made to notifications have been saved.', 'script'),
(NULL, 826, 'pjField', 3, 'title', 'All the changes made to notifications have been saved.', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'Settings updated', 'script'),
(NULL, 827, 'pjField', 2, 'title', 'Donation settings updated', 'script'),
(NULL, 827, 'pjField', 3, 'title', 'Donation settings updated', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'All the changes made have been saved.', 'script'),
(NULL, 828, 'pjField', 2, 'title', 'All the changes made to donation settings have been saved.', 'script'),
(NULL, 828, 'pjField', 3, 'title', 'All the changes made to donation settings have been saved.', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'Stop campaign', 'script'),
(NULL, 829, 'pjField', 2, 'title', 'Stop campaign', 'script'),
(NULL, 829, 'pjField', 3, 'title', 'Stop campaign', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 830, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 830, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'There are %u donations made with total amount of %s. Are you sure you want to delete them too?', 'script'),
(NULL, 831, 'pjField', 2, 'title', 'There are %u donations made with total amount of %s. Are you sure you want to delete them too?', 'script'),
(NULL, 831, 'pjField', 3, 'title', 'There are %u donations made with total amount of %s. Are you sure you want to delete them too?', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'Are you sure you want to delete the selected campaign?', 'script'),
(NULL, 832, 'pjField', 2, 'title', 'Are you sure you want to delete the selected campaign?', 'script'),
(NULL, 832, 'pjField', 3, 'title', 'Are you sure you want to delete the selected campaign?', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'There is %u donation made with total amount of %s. Are you sure you want to delete it too?', 'script'),
(NULL, 833, 'pjField', 2, 'title', 'There is %u donation made with total amount of %s. Are you sure you want to delete it too?', 'script'),
(NULL, 833, 'pjField', 3, 'title', 'There is %u donation made with total amount of %s. Are you sure you want to delete it too?', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'There are no active campaigns. Click [STAG]here[ETAG] to add new campaign.', 'script'),
(NULL, 834, 'pjField', 2, 'title', 'There are no active campaigns. Click [STAG]here[ETAG] to add new campaign.', 'script'),
(NULL, 834, 'pjField', 3, 'title', 'There are no active campaigns. Click [STAG]here[ETAG] to add new campaign.', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 835, 'pjField', 2, 'title', 'No records selected', 'script'),
(NULL, 835, 'pjField', 3, 'title', 'No records selected', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 836, 'pjField', 2, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 836, 'pjField', 3, 'title', 'You need to select at least a single record.', 'script');

INSERT INTO `fundrasing_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),
(1, 'o_thankyou_page', 2, 'https://www.phpjabbers.com', NULL, 'string', 21, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, 'Thank you for your donation!', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 3, 'Dear {Name},\r\n\r\nOn behalf of our organization, I would like to thank you for your contribution of {Amount} for {Campaign}. Your financial support helps us continue in our mission.\r\nThe generous support of individuals like you makes it possible for our organization to exist and to make the world a better place to live.\r\n\r\nThank you again for your support!\r\n\r\nSincerely,\r\n', NULL, 'text', 3, 1, NULL),

(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, 'Thank you for your donation!', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 3, 'Dear {Name},\r\n\r\nOn behalf of our organization, I would like to thank you for your contribution of {Amount} for {Campaign}. Your financial support helps us continue in our mission.\r\nThe generous support of individuals like you makes it possible for our organization to exist and to make the world a better place to live.\r\n\r\nThank you again for your support!\r\n\r\nSincerely,', NULL, 'text', 6, 1, NULL),

(1, 'o_admin_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 3, 'New donation has been received', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_confirmation_message', 3, 'New donation of {Amount} has been made for {Campaign}.\r\n\r\nThe contributor''s details are as follows:\r\n{Name}\r\n{Email}', NULL, 'text', 9, 1, NULL),

(1, 'o_admin_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_admin_email_payment_subject', 3, 'New donation has been paid', NULL, 'string', 11, 1, NULL),
(1, 'o_admin_email_payment_message', 3, 'New donation of {Amount} has been paid for {Campaign}.\r\n\r\nThe contributor''s details are as follows:\r\n{Name}\r\n{Email}', NULL, 'text', 12, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `fundrasing_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');