<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminDonations extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['donation_create']))
			{
				$pjDonationModel = pjDonationModel::factory();
				
				$data = array();
				
				$data['ip'] = pjUtil::getClientIp();
				if (isset($_POST['payment_method']) && $_POST['payment_method'] == 'creditcard')
				{
					$data['cc_exp'] = $_POST['cc_exp_year'] . '-' . $_POST['cc_exp_month'];
				}
				
				$id = $pjDonationModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AD03';
					
				} else {
					$err = 'AD04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminDonations&action=pjActionIndex&err=$err");
			} else {
				$campaign_arr = pjCampaignModel::factory()->where('status', 'T')->orderBy("title ASC")->findAll()->getData();
				$this->set('campaign_arr', $campaign_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminDonations.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteDonation()
	{
		$this->setAjax(true);
		if ($this->isAdmin())
		{
			if ($this->isXHR())
			{
				$response = array();
				
				if (pjDonationModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
				
				pjAppController::jsonResponse($response);
			}
		}
		exit;
	}
	
	public function pjActionDeleteDonationBulk()
	{
		$this->setAjax(true);
		if ($this->isAdmin())
		{
			if ($this->isXHR())
			{
				if (isset($_POST['record']) && count($_POST['record']) > 0)
				{
					pjDonationModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionExportDonation()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjDonationModel::factory()
				->join("pjCampaign", "t1.campaign_id=t2.id", 'left inner')
				->select("t1.*, t2.title")
				->whereIn('t1.id', $_POST['record'])
				->findAll()
				->getData();
			$donation_statuses = __('donation_statuses', true, false) ;
			foreach($arr as $k => $v)
			{
				$v['status'] = $donation_statuses[$v['status']];
				$v['campaign_id'] = $v['title'];
				unset($v['title']);
				$arr[$k] = $v;
			}
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Donations-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetDonation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjDonationModel = pjDonationModel::factory()
				->join('pjCampaign', "t2.id=t1.campaign_id", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjDonationModel->where('t1.name LIKE', "%$q%");
				$pjDonationModel->orWhere('t1.email LIKE', "%$q%");
			}
	
			if (isset($_GET['campaign_id']) && (int) $_GET['campaign_id'] > 0)
			{
				$pjDonationModel->where('t1.campaign_id', $_GET['campaign_id']);
			}
			
			$column = 'id';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjDonationModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			
			$data = $pjDonationModel->select('t1.*, t2.title')
				->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();
			foreach($data as $k => $v)
			{
				$v['amount'] = pjUtil::formatCurrencySign($v['amount'], $this->option_arr['o_currency']);
				$v['created'] = date($this->option_arr['o_date_format'], strtotime($v['created'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['created']));
				$data[$k] = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminDonations.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveDonation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjDonationModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['donation_update']))
			{
				$pjDonationModel = pjDonationModel::factory();
				
				$arr = $pjDonationModel->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminDonations&action=pjActionIndex&err=AD08");
				}
				$data = array();
				
				if (isset($_POST['payment_method']) && $_POST['payment_method'] == 'creditcard')
				{
					$data['cc_exp'] = $_POST['cc_exp_year'] . '-' . $_POST['cc_exp_month'];
				}
				$pjDonationModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminDonations&action=pjActionIndex&err=AD01");
				
			} else {
				$arr = pjDonationModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminDonations&action=pjActionIndex&err=AD08");
				}
				$this->set('arr', $arr);

				$campaign_arr = pjCampaignModel::factory()->where('status', 'T')->orderBy("title ASC")->findAll()->getData();
				$this->set('campaign_arr', $campaign_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminDonations.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>