<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCampaigns&amp;action=pjActionIndex"><?php __('menuCampaigns'); ?></a></li>
			<?php
			if($controller->isAdmin())
			{ 
				?><li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCampaigns&amp;action=pjActionCreate"><?php __('lblAddCampaign'); ?></a></li><?php
			} 
			?>
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCampaigns&amp;action=pjActionUpdate&amp;id=<?php echo $tpl['arr']['id'];?>"><?php __('lblUpdateCampaign'); ?></a></li>
		</ul>
	</div>
	
	<?php pjUtil::printNotice(__('infoUpdateCampaignTitle', true, false), __('infoUpdateCampaignDesc', true, false)); ?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCampaigns&amp;action=pjActionUpdate" method="post" id="frmUpdateCampaign" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="campaign_update" value="1" />
		<input type="hidden" id="id" name="id" value="<?php echo $tpl['arr']['id'];?>" />
		<p>
			<label class="title"><?php __('lblProgress'); ?></label>
			<span class="inline_block">
				<label class="content"><?php $tpl['arr']['total_donations'] != 1 ? printf(__('lblPluralDonation', true), pjUtil::formatCurrencySign($tpl['arr']['total_amount'] > 0 ? $tpl['arr']['total_amount'] : 0, $tpl['option_arr']['o_currency']), $tpl['arr']['total_donations']) : printf(__('lblSingularDonation', true), pjUtil::formatCurrencySign($tpl['arr']['total_amount'], $tpl['option_arr']['o_currency']), $tpl['arr']['total_donations']); ?></label>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblTitle'); ?></label>
			<span class="inline_block">
				<input type="text" name="title" id="title" class="pj-form-field w400 required" value="<?php echo pjSanitize::clean($tpl['arr']['title']);?>"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblDescription'); ?></label>
			<span class="inline_block">
				<textarea id="description" name="description" class="pj-form-field w500 h200"><?php echo pjSanitize::clean($tpl['arr']['description']);?></textarea>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblImage'); ?></label>
			<span class="inline_block">
				<input type="file" name="image" id="image" class="pj-form-field w300"/>
			</span>
		</p>
		<?php
		if(!empty($tpl['arr']['image']))
		{
			$image_path =  $tpl['arr']['image'];
			if (file_exists(PJ_INSTALL_PATH . $image_path)) 
			{
				$image_url = PJ_INSTALL_URL . $image_path;
				?>
				<p id="image_container">
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<img src="<?php echo $image_url;?>" />
						<a class="icon-remove" href="javascript:void(0);" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCampaigns&amp;action=pjActionDeleteImage&id=<?php echo $tpl['arr']['id'];?>"></a>
					</span>
				</p>
				<?php
			}
		} 
		?>
		<p>
			<label class="title"><?php __('lblDeadline'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-after">
				<input type="text" name="deadline" id="deadline" class="pj-form-field pointer w80 required datepick" value="<?php echo pjUtil::formatDate($tpl['arr']['deadline'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
				<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblAmount'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
				<input type="text" id="amount" name="amount" class="pj-form-field number w100 required" value="<?php echo pjSanitize::clean($tpl['arr']['amount']);?>"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblTerms'); ?></label>
			<span class="inline_block">
				<textarea id="terms" name="terms" class="pj-form-field w500 h150"><?php echo pjSanitize::clean($tpl['arr']['terms']);?></textarea>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblStatus'); ?></label>
			<span class="inline_block">
				<select name="status" id="status" class="pj-form-field required">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach (__('u_statarr', true) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['status'] == $k ? ' selected="selected"' : null;?>><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
		</p>
	</form>
	
	<div id="dialogDeleteImage" title="<?php __('lblDeleteImageTitle'); ?>" style="display:none;">
		<div class="t15">
			<?php __('lblDeleteImageConfirmation'); ?>
		</div>
	</div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.title_taken = "<?php __('lblTitleTaken', false, true); ?>";
	</script>
	<?php
}
?>