var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateDonation = $("#frmCreateDonation"),
			$frmUpdateDonation = $("#frmUpdateDonation"),
			datagrid = ($.fn.datagrid !== undefined);
		
		if ($frmCreateDonation.length > 0) {
			$frmCreateDonation.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmUpdateDonation.length > 0) {
			$frmUpdateDonation.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var buttonOpts = [{type: "edit", url: "index.php?controller=pjAdminDonations&action=pjActionUpdate&id={:id}"},
					          {type: "delete", url: "index.php?controller=pjAdminDonations&action=pjActionDeleteDonation&id={:id}"}
	          ];
			var actionOpts = [
							   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminDonations&action=pjActionDeleteDonationBulk", render: true, confirmation: myLabel.delete_confirmation},
							   {text: myLabel.exported, url: "index.php?controller=pjAdminDonations&action=pjActionExportDonation", ajax: false}
							 ];
			if (pjGrid.isEditor === true) 
			{
				buttonOpts = [{type: "edit", url: "index.php?controller=pjAdminDonations&action=pjActionUpdate&id={:id}"}];
				actionOpts = [{text: myLabel.exported + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' , url: "index.php?controller=pjAdminDonations&action=pjActionExportDonation", ajax: false}];
			}
			var $grid = $("#grid").datagrid({
				buttons: buttonOpts,
				columns: [{text: myLabel.campaign, type: "text", sortable: true, editable: false, width: 130},
				          {text: myLabel.name, type: "text", sortable: true, editable: true, width: 130, editableWidth: 110},
				          {text: myLabel.date_time, type: "text", sortable: true, editable: false, width: 130},
				          {text: myLabel.amount, type: "text", sortable: true, editable: false, width: 80},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 110, editableWidth: 90,options: [
						                                                                                     {label: myLabel.paid, value: "P"}, 
						                                                                                     {label: myLabel.not_paid, value: "N"}
						                                                                                     ], applyClass: "pj-status"}
				         ],
				dataUrl: "index.php?controller=pjAdminDonations&action=pjActionGetDonation" + pjGrid.queryString,
				dataType: "json",
				fields: ['title', 'name', 'created', 'amount', 'status'],
				paginator: {
					actions: actionOpts,
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminDonations&action=pjActionSaveDonation&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminDonations&action=pjActionGetDonation", "id", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminDonations&action=pjActionGetDonation", "id", "DESC", content.page, content.rowCount);
			return false;
		}).on("change", "#payment_method", function (e) {
			switch ($("option:selected", this).val()) {
				case 'creditcard':
					$(".boxCC").show();
					break;
				default:
					$(".boxCC").hide();
			}
		}).on("keydown", "#amount", function (event) {
			if (event.shiftKey == true) {
	            event.preventDefault();
	        }
	        if ((event.keyCode >= 48 && event.keyCode <= 57) || 
	            (event.keyCode >= 96 && event.keyCode <= 105) || 
	            event.keyCode == 8 || event.keyCode == 9 || event.keyCode == 37 ||
	            event.keyCode == 39 || event.keyCode == 46 || event.keyCode == 190) {

	        } else {
	            event.preventDefault();
	        }

	        if($(this).val().indexOf('.') !== -1 && event.keyCode == 190)
	        {
	        	event.preventDefault();
	        }
		}).on("change", "#campaign_id", function (e) {
			if($(this).val() == '')
			{
				$('.frEdit').attr('target', '');
				$('.frPreview').attr('target', '');
				$('.frEdit').attr('href', 'javascript:void(0);');
				$('.frPreview').attr('href', 'javascript:void(0);');
			}else{
				$('.frEdit').attr('target', '_blank');
				$('.frPreview').attr('target', '_blank');
				$('.frEdit').attr('href', 'index.php?controller=pjAdminCampaigns&action=pjActionUpdate&id=' + $(this).val());
				$('.frPreview').attr('href', 'index.php?controller=pjAdminOptions&action=pjActionPreview&cid=' + $(this).val());
			}
		});
	});
})(jQuery_1_8_2);