BEGIN;

DROP TABLE IF EXISTS `invoicemanager_invoices`;
CREATE TABLE IF NOT EXISTS `invoicemanager_invoices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `status` enum('new','paid','cancelled') DEFAULT NULL,
  `date_issued` date DEFAULT NULL,
  `recurring` enum('weekly','monthly','quarterly','yearly') DEFAULT NULL,
  `recurring_date` date DEFAULT NULL,
  `invoice_number` varchar(250) DEFAULT NULL,
  `amount` decimal(9,2) NULL,
  `currency` varchar(11) DEFAULT NULL,
  `vat` decimal(9,2) DEFAULT NULL,
  `total` decimal(9,2) DEFAULT NULL,
  `notes` text,
  `processed_on` datetime DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `payment_fee` decimal(9,2) DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') DEFAULT NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `invoicemanager_products`;
CREATE TABLE `invoicemanager_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,	
  `invoice_id` int(11) DEFAULT NULL,
  `product_title` varchar(250) DEFAULT NULL,
  `quantity`  int(10) DEFAULT NULL,
  `price`  decimal(9,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_id` (`invoice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `invoicemanager_clients`;
CREATE TABLE IF NOT EXISTS `invoicemanager_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `position` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `vat_number` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `country_id` int(11) unsigned default NULL,
  `zip` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `notes` text,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `status` enum('T','F') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `invoicemanager_passwords`;
CREATE TABLE IF NOT EXISTS `invoicemanager_passwords` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `invoicemanager_fields`;
CREATE TABLE IF NOT EXISTS `invoicemanager_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `invoicemanager_multi_lang`;
CREATE TABLE IF NOT EXISTS `invoicemanager_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `invoicemanager_options`;
CREATE TABLE IF NOT EXISTS `invoicemanager_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `invoicemanager_roles`;
CREATE TABLE IF NOT EXISTS `invoicemanager_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `invoicemanager_users`;
CREATE TABLE IF NOT EXISTS `invoicemanager_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  `is_active` enum('T','F') NOT NULL default 'F',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `invoicemanager_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(480, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(481, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(482, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(483, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(484, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(485, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(486, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(487, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(488, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(489, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(490, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(491, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(492, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(493, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(639, 'menuClients', 'backend', 'Menu / Clients', 'script', NULL),
(640, 'menuInvoices', 'backend', 'Menu / Invoices', 'script', NULL),
(759, 'infoGeneralOptionTitle', 'backend', 'Infobox / General options', 'script', NULL),
(760, 'infoGeneralOptionDesc', 'backend', 'Infobox / General options', 'script', NULL),
(761, 'menuPayments', 'backend', 'Menu / Payments', 'script', NULL),
(762, 'infoPaymentsTitle', 'backend', 'Infobox / Payment options', 'script', NULL),
(763, 'infoPaymentsDesc', 'backend', 'Infobox / Payment options', 'script', NULL),
(764, 'opt_o_vat', 'backend', 'Options / VAT', 'script', NULL),
(765, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(766, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(767, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(768, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(769, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(770, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(771, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(772, 'opt_o_allow_cash', 'backend', 'Options / Allow cash payments', 'script', NULL),
(773, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(774, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(775, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(776, 'menuTemplates', 'backend', 'Menu / Templates', 'script', NULL),
(777, 'tabInvoiceTemplate', 'backend', 'Tab / Invoice template', 'script', NULL),
(778, 'tabEmailTemplateNew', 'backend', 'Tab / Email template - New invoice', 'script', NULL),
(779, 'tabEmailTemplatePaid', 'backend', 'Tab / Email template - Paid invoice', 'script', NULL),
(780, 'tabPrintTemplate', 'backend', 'Tab / Print template', 'script', NULL),
(781, 'infoInvoiceTemplateTitle', 'backend', 'Infobox / Invoice Template', 'script', NULL),
(782, 'infoInvoiceTemplateDesc', 'backend', 'Infobox / Invoice Template', 'script', NULL),
(784, 'infoNewInvoiceTemplateTitle', 'backend', 'Infobox / Email template for new invoice', 'script', NULL),
(785, 'infoNewInvoiceTemplateDesc', 'backend', 'Infobox / Email template for new invoice', 'script', NULL),
(786, 'infoPaidInvoiceTemplateTitle', 'backend', 'Infobox / Email template for paid invoice', 'script', NULL),
(787, 'infoPaidInvoiceTemplateDesc', 'backend', 'Infobox / Email template for paid invoice', 'script', NULL),
(788, 'infoPrintTemplateTitle', 'backend', 'Infobox / Print template', 'script', NULL),
(789, 'infoPrintTemplateDesc', 'backend', 'Infobox / Print template', 'script', NULL),
(790, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(791, 'lblNewInvoiceSubject', 'backend', 'Label / New invoice email subject', 'script', NULL),
(792, 'lblPaidInvoiceSubject', 'backend', 'Label / Paid invoice email subject', 'script', NULL),
(793, 'infoClientsTitle', 'backend', 'Infobox / List of clients', 'script', NULL),
(794, 'infoClientsDesc', 'backend', 'Infobox / List of clients', 'script', NULL),
(795, 'btnAddClient', 'backend', 'Button / + Add client', 'script', NULL),
(796, 'lblInvoices', 'backend', 'Label / Invoices', 'script', NULL),
(797, 'tabPersonalDetails', 'backend', 'Tab / Personal Details', 'script', NULL),
(798, 'tabCompanyDetails', 'backend', 'Tab / Company Details', 'script', NULL),
(799, 'tabContactDetails', 'backend', 'Tab / Contact Details', 'script', NULL),
(800, 'tabNotes', 'backend', 'Tab / Notes', 'script', NULL),
(801, 'infoAddClientTitle', 'backend', 'Infobox / Add client', 'script', NULL),
(802, 'infoAddClientDesc', 'backend', 'Infobox / Add client', 'script', NULL),
(803, 'lblClientTitle', 'backend', 'Label / Title', 'script', NULL),
(804, 'lblFirstName', 'backend', 'Label / First name', 'script', NULL),
(805, 'lblLastName', 'backend', 'Label / Last name', 'script', NULL),
(806, 'lblPosition', 'backend', 'Label / Position', 'script', NULL),
(807, 'lblCompanyName', 'backend', 'Label / Company name', 'script', NULL),
(808, 'lblVatNumber', 'backend', 'Label / VAT / TAX number', 'script', NULL),
(809, 'lblWebsite', 'backend', 'Label / Website', 'script', NULL),
(810, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(811, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(812, 'lblState', 'backend', 'Label / State', 'script', NULL),
(813, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(814, 'lblZip', 'backend', 'Label / Zip', 'script', NULL),
(816, 'lblFax', 'backend', 'Label / Fax', 'script', NULL),
(817, 'lblNotes', 'backend', 'Label / Notes', 'script', NULL),
(818, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(819, 'lblEmailInvalid', 'backend', 'Label / Email invalid.', 'script', NULL),
(820, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(821, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(822, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(823, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(824, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(825, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(826, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(827, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(828, 'infoUpdateClientTitle', 'backend', 'Infobox / Update client', 'script', NULL),
(829, 'infoUpdateClientDesc', 'backend', 'Infobox / Update client', 'script', NULL),
(830, 'lblNoAccessToFeed', 'backend', 'Label / No access to feed.', 'script', NULL),
(831, 'infoExportClientsTitle', 'backend', 'Infobox / Export clients', 'script', NULL),
(832, 'infoExportClientsDesc', 'backend', 'Infobox / Export clients', 'script', NULL),
(833, 'export_formats_ARRAY_csv', 'arrays', 'export_formats_ARRAY_csv', 'script', NULL),
(834, 'export_formats_ARRAY_xml', 'arrays', 'export_formats_ARRAY_xml', 'script', NULL),
(835, 'export_types_ARRAY_file', 'arrays', 'export_types_ARRAY_file', 'script', NULL),
(836, 'export_types_ARRAY_feed', 'arrays', 'export_types_ARRAY_feed', 'script', NULL),
(837, 'lblFormat', 'backend', 'Labe / Format', 'script', NULL),
(838, 'lblEnterPassword', 'backend', 'Label / Enter password', 'script', NULL),
(839, 'lblClientCreated', 'backend', 'Label / Client created', 'script', NULL),
(840, 'made_arr_ARRAY_1', 'arrays', 'made_arr_ARRAY_1', 'script', NULL),
(841, 'made_arr_ARRAY_2', 'arrays', 'made_arr_ARRAY_2', 'script', NULL),
(842, 'made_arr_ARRAY_3', 'arrays', 'made_arr_ARRAY_3', 'script', NULL),
(843, 'made_arr_ARRAY_4', 'arrays', 'made_arr_ARRAY_4', 'script', NULL),
(844, 'made_arr_ARRAY_5', 'arrays', 'made_arr_ARRAY_5', 'script', NULL),
(845, 'made_arr_ARRAY_6', 'arrays', 'made_arr_ARRAY_6', 'script', NULL),
(846, 'btnGetFeedURL', 'backend', 'Button / Get Feed URL', 'script', NULL),
(847, 'infoClientsFeedTitle', 'backend', 'Infobox / Clients feed URL', 'script', NULL),
(848, 'infoClientsFeedDesc', 'backend', 'Infobox / Clients feed URL', 'script', NULL),
(850, 'lblImport', 'backend', 'Label / Import', 'script', NULL),
(851, 'lblType', 'backend', 'Label / Type', 'script', NULL),
(852, 'error_bodies_ARRAY_AC10', 'arrays', 'error_bodies_ARRAY_AC10', 'script', NULL),
(853, 'error_titles_ARRAY_AC10', 'arrays', 'error_titles_ARRAY_AC10', 'script', NULL),
(854, 'error_titles_ARRAY_AC11', 'arrays', 'error_titles_ARRAY_AC11', 'script', NULL),
(855, 'error_bodies_ARRAY_AC11', 'arrays', 'error_bodies_ARRAY_AC11', 'script', NULL),
(856, 'error_titles_ARRAY_AC12', 'arrays', 'error_titles_ARRAY_AC12', 'script', NULL),
(857, 'error_bodies_ARRAY_AC12', 'arrays', 'error_bodies_ARRAY_AC12', 'script', NULL),
(858, 'error_bodies_ARRAY_AC21', 'arrays', 'error_bodies_ARRAY_AC21', 'script', NULL),
(859, 'error_titles_ARRAY_AC22', 'arrays', 'error_titles_ARRAY_AC22', 'script', NULL),
(860, 'error_bodies_ARRAY_AC22', 'arrays', 'error_bodies_ARRAY_AC22', 'script', NULL),
(861, 'error_titles_ARRAY_AC20', 'arrays', 'error_titles_ARRAY_AC20', 'script', NULL),
(862, 'error_bodies_ARRAY_AC20', 'arrays', 'error_bodies_ARRAY_AC20', 'script', NULL),
(863, 'error_titles_ARRAY_AC23', 'arrays', 'error_titles_ARRAY_AC23', 'script', NULL),
(864, 'error_bodies_ARRAY_AC23', 'arrays', 'error_bodies_ARRAY_AC23', 'script', NULL),
(865, 'error_titles_ARRAY_AC21', 'arrays', 'error_titles_ARRAY_AC21', 'script', NULL),
(866, 'import_sources_ARRAY_csv', 'arrays', 'import_sources_ARRAY_csv', 'script', NULL),
(867, 'import_sources_ARRAY_excel', 'arrays', 'import_sources_ARRAY_excel', 'script', NULL),
(868, 'lblSource', 'backend', 'Label / Source', 'script', NULL),
(869, 'lblUpdateClients', 'backend', 'Label / Update clients', 'script', NULL),
(870, 'btnImport', 'backend', 'Button / Import', 'script', NULL),
(871, 'lblCSVAllowed', 'backend', 'Label / Only csv files are allowed.', 'script', NULL),
(872, 'infoImportTitle', 'backend', 'Infobox / Import clients ', 'script', NULL),
(873, 'infoImportDesc', 'backend', 'Infobox / Import clients ', 'script', NULL),
(874, 'lblCSVFile', 'backend', 'Label / CSV file', 'script', NULL),
(875, 'invoice_status_ARRAY_new', 'arrays', 'invoice_status_ARRAY_new', 'script', NULL),
(876, 'invoice_status_ARRAY_paid', 'arrays', 'invoice_status_ARRAY_paid', 'script', NULL),
(877, 'invoice_status_ARRAY_cancelled', 'arrays', 'invoice_status_ARRAY_cancelled', 'script', NULL),
(878, 'recurring_ARRAY_weekly', 'arrays', 'recurring_ARRAY_weekly', 'script', NULL),
(879, 'recurring_ARRAY_monthly', 'arrays', 'recurring_ARRAY_monthly', 'script', NULL),
(880, 'recurring_ARRAY_quarterly', 'arrays', 'recurring_ARRAY_quarterly', 'script', NULL),
(881, 'recurring_ARRAY_yearly', 'arrays', 'recurring_ARRAY_yearly', 'script', NULL),
(882, 'infoInvoicesTitle', 'backend', 'Infobox / Invoices list', 'script', NULL),
(883, 'infoInvoicesDesc', 'backend', 'Infobox / Invoices list', 'script', NULL),
(884, 'btnAddInvoice', 'backend', 'Button / + Add invoice', 'script', NULL),
(885, 'lblAmount', 'backend', 'Label / Amount', 'script', NULL),
(886, 'lblDateIssued', 'backend', 'Label / Date issued', 'script', NULL),
(887, 'lblInvoiceNumber', 'backend', 'Label / Invoice number', 'script', NULL),
(888, 'lblClient', 'backend', 'Label / Client', 'script', NULL),
(889, 'infoAddInvoiceTitle', 'backend', 'Infobox / Add invoice', 'script', NULL),
(890, 'infoAddInvoiceDesc', 'backend', 'Infobox / Add invoice', 'script', NULL),
(891, 'lblRecurring', 'backend', 'Label / Recurring', 'script', NULL),
(892, 'lblLastFiveInvoices', 'backend', 'Label / Last 5 invoices', 'script', NULL),
(893, 'lblProduct', 'backend', 'Label / Product', 'script', NULL),
(894, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(895, 'btnAdd', 'backend', 'Button / Add +', 'script', NULL),
(896, 'btnRemove', 'backend', 'Button / Remove', 'script', NULL),
(897, 'lblVAT', 'backend', 'Label / VAT', 'script', NULL),
(898, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(899, 'lblEnterPositiveNumber', 'backend', 'Label / Please enter positive number.', 'script', NULL),
(900, 'lblInvoiceNo', 'backend', 'Label / Invoice No.', 'script', NULL),
(901, 'error_titles_ARRAY_AI01', 'arrays', 'error_titles_ARRAY_AI01', 'script', NULL),
(902, 'error_bodies_ARRAY_AI01', 'arrays', 'error_bodies_ARRAY_AI01', 'script', NULL),
(903, 'error_titles_ARRAY_AI03', 'arrays', 'error_titles_ARRAY_AI03', 'script', NULL),
(904, 'error_bodies_ARRAY_AI03', 'arrays', 'error_bodies_ARRAY_AI03', 'script', NULL),
(905, 'error_titles_ARRAY_AI04', 'arrays', 'error_titles_ARRAY_AI04', 'script', NULL),
(906, 'error_bodies_ARRAY_AI04', 'arrays', 'error_bodies_ARRAY_AI04', 'script', NULL),
(907, 'error_titles_ARRAY_AI08', 'arrays', 'error_titles_ARRAY_AI08', 'script', NULL),
(908, 'error_bodies_ARRAY_AI08', 'arrays', 'error_bodies_ARRAY_AI08', 'script', NULL),
(909, 'buttons_ARRAY_ok', 'arrays', 'buttons_ARRAY_ok', 'script', NULL),
(910, 'infoUpdateInvoiceTitle', 'backend', 'Infobox / Update invoice', 'script', NULL),
(911, 'infoUpdateInvoiceDesc', 'backend', 'Infobox / Update invoice', 'script', NULL),
(912, 'tabDetails', 'backend', 'Tab / Details', 'script', NULL),
(913, 'tabPayment', 'backend', 'Tab / Payment', 'script', NULL),
(914, 'lblDatePaid', 'backend', 'Label / Date paid', 'script', NULL),
(915, 'lblPaymentID', 'backend', 'Label / Payment ID', 'script', NULL),
(916, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(917, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(918, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(919, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(920, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(921, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(922, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(923, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(924, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(925, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(926, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(927, 'lblCCExp', 'backend', 'Label / CC expiration', 'script', NULL),
(928, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(929, 'lblPaymentFee', 'backend', 'Label / Payment fee', 'script', NULL),
(930, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(931, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(932, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(933, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(934, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(935, 'lblViewInvoice', 'backend', 'Label / View invoice', 'script', NULL),
(936, 'lblSendInvoiceEmail', 'backend', 'Label / Send invoice email', 'script', NULL),
(937, 'lblPrintInvoice', 'backend', 'Label / Print invoice', 'script', NULL),
(938, 'invoice_err_ARRAY_1', 'arrays', 'invoice_err_ARRAY_1', 'script', NULL),
(939, 'invoice_err_ARRAY_2', 'arrays', 'invoice_err_ARRAY_2', 'script', NULL),
(940, 'invoice_err_ARRAY_3', 'arrays', 'invoice_err_ARRAY_3', 'script', NULL),
(941, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(942, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(943, 'lblSendTo', 'backend', 'Label / Send to', 'script', NULL),
(944, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(1063, 'menuCompanyDetails', 'backend', 'Menu / Company details', 'script', NULL),
(1064, 'infoUpdateCompanyTitle', 'backend', 'Menu / Company Details', 'script', NULL),
(1065, 'infoUpdateCompanyDesc', 'backend', 'Menu / Company Details', 'script', NULL),
(1066, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(1067, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(1068, 'lblProducts', 'backend', 'Label / Products', 'script', NULL),
(1069, 'lblQuantity', 'backend', 'Label / Quantity', 'script', NULL),
(1070, 'btnAddProduct', 'backend', 'Button / Add product +', 'script', NULL),
(1071, 'lblTemplate', 'backend', 'Label / Template', 'script', NULL),
(1072, 'lblEdit', 'backend', 'Label / Edit', 'script', NULL),
(1073, 'lblDelete', 'backend', 'Label / Delete', 'script', NULL),
(1074, 'lblSend', 'backend', 'Label / Send', 'script', NULL),
(1075, 'lblDuplicate', 'backend', 'Label / Duplicate', 'script', NULL),
(1076, 'lblView', 'backend', 'Label / View', 'script', NULL),
(1077, 'lblDuplicateInvoice', 'backend', 'Label / Duplicate invoice', 'script', NULL),
(1078, 'lblDulicateMessage', 'backend', 'Label / A duplicated invoice has been created.', 'script', NULL),
(1079, 'lblDulicateConfirmation', 'backend', 'Label / Do you want to duplicate the selected invoice?', 'script', NULL),
(1080, 'buttons_ARRAY_duplicate', 'arrays', 'buttons_ARRAY_duplicate', 'script', NULL),
(1081, 'lblCreated', 'backend', 'Label / Created', 'script', NULL),
(1082, 'lblBy', 'backend', 'Label / by', 'script', NULL),
(1083, 'lblViewDetails', 'backend', 'Label / View details', 'script', NULL),
(1084, 'lblInvoicesCreated', 'backend', 'Label / Invoices created', 'script', NULL),
(1085, 'role_arr_ARRAY_admin', 'arrays', 'role_arr_ARRAY_admin', 'script', NULL),
(1086, 'role_arr_ARRAY_editor', 'arrays', 'role_arr_ARRAY_editor', 'script', NULL),
(1087, 'menuReports', 'backend', 'Menu / Reports', 'script', NULL),
(1088, 'infoReportsTitle', 'backend', 'Infobox / Reports', 'script', NULL),
(1089, 'infoReportsDesc', 'backend', 'Infobox / Reports', 'script', NULL),
(1090, 'lblFrom', 'backend', 'Label / From', 'script', NULL),
(1091, 'lblTo', 'backend', 'Label / To', 'script', NULL),
(1092, 'btnSubmit', 'backend', 'Button / Submit', 'script', NULL),
(1093, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(1094, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(1095, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(1096, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(1097, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(1098, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(1099, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(1100, 'lblHint', 'backend', 'Label / Hint text', 'script', NULL),
(1101, 'lblSummary', 'backend', 'Label / Summary', 'script', NULL),
(1102, 'lblInvoicesSummary', 'backend', 'Label / Invoices Summary', 'script', NULL),
(1103, 'lblProductName', 'backend', 'Label / Product name', 'script', NULL),
(1104, 'lblAddProduct', 'backend', 'Label / Add product', 'script', NULL),
(1105, 'front_payment_processing', 'frontend', 'Label / Payment is processing...', 'script', NULL),
(1106, 'payment_statuses_ARRAY_0', 'arrays', 'payment_statuses_ARRAY_0', 'script', NULL),
(1107, 'payment_statuses_ARRAY_1', 'arrays', 'payment_statuses_ARRAY_1', 'script', NULL),
(1108, 'payment_statuses_ARRAY_2', 'arrays', 'payment_statuses_ARRAY_2', 'script', NULL),
(1109, 'payment_statuses_ARRAY_3', 'arrays', 'payment_statuses_ARRAY_3', 'script', NULL),
(1110, 'payment_statuses_ARRAY_4', 'arrays', 'payment_statuses_ARRAY_4', 'script', NULL),
(1111, 'lblNextInvoice', 'backend', 'Label / Next invoice', 'script', NULL),
(1112, 'lblInvoiceNumberDuplidated', 'backend', 'Label / Invoice number is already used.', 'script', NULL),
(1113, 'tabPaymentTemplate', 'backend', 'Tab / Payment template', 'script', NULL),
(1114, 'infoPaymentTemplateTitle', 'backend', 'Infobox / Payment template', 'script', NULL),
(1115, 'infoPaymentTemplateDesc', 'backend', 'Infobox / Payment template', 'script', NULL),
(1116, 'front_thankyou_message', 'frontend', 'Label / Thank you message', 'script', NULL);

INSERT INTO `invoicemanager_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next ', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Below you can see all users who have access to the administration page. There are two types of users - Administrators and Managers. Click on "+ Add user" to add a new user.', 'script'),
(NULL, 482, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Add User', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'You can add a new Administrator who has full access to the back-end system and can add other users; or a Manager who will only be able to access the invoices.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Update User', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'You can make any change to the form below. Just click "Save" to update the user information.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Here you can set the General options for the Menu Builder.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Invoices', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Here you can make the general settings for the Invoice Manager script.', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Payments', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'Payment options', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences.', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'VAT', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Templates', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Invoice template', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Email template - New invoice', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'Email template - Paid invoice', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Print template', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Invoice Template', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'Use below template to review the invoice. You can also use available tokens to personalize them.', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'Email template for new invoice', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'Let use the below template if you want to send new invoices to your clients. You may need to use available tokens personalize them.', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'Email template for paid invoice', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'Let use the below template if you want to view or send paid invoices to your clients. You may need to use available tokens personalize them.', 'script'),
(NULL, 788, 'pjField', 1, 'title', 'Print template', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'Let use the below template to print the invoice. You can also use the available tokens to personalize them.', 'script'),
(NULL, 790, 'pjField', 1, 'title', '<div style="float: left; width: 345px;line-height: 20px;">{INVOICE_VIEW} - View invoice link\r\n{INVOICE_PRINT} - Invoice print link\r\n{INVOICE_PAY} - Invoice pay link\r\n{INVOICE_NUMBER} - Invoice number\r\n{INVOICE_STATUS} - Invoice status\r\n{INVOICE_CLIENT} - Client full name\r\n{INVOICE_DATE_ISSUED} - Date issued\r\n{INVOICE_AMOUNT} - Invoice Amount\r\n{INVOICE_DESCRIPTION} - Product / Service description\r\n{INVOICE_DATE_PAID} - Date paid\r\n{INVOICE_PAYMENT_ID} - Invoice payment ID\r\n{INVOICE_PAYMENT_FEE} - Invoice payment fee\r\n{INVOICE_PAYMENT_TYPE} - Invoice payment type\r\n{INVOICE_NOTES} - Invoice notes\r\n{INVOICE_VAT} - Invoice VAT\r\n{INVOICE_TOTAL} - Invoice Total\r\n{MY_FNAME} - My first name\r\n{MY_LNAME} - My last name\r\n{MY_FULL_NAME} - My full name\r\n{MY_POSITION} - My position\r\n{MY_COMPANY_NAME} - My Company name\r\n{MY_COMPANY_VAT} - My Company VAT/TAX number\r\n{MY_COMPANY_WEB} - My Company web site\r\n{MY_ADDRESS} - My Address\r\n{MY_CITY} - My City\r\n</div><div style="float: left; width: 350px;line-height: 20px;">{CLIENT_TITLE} - Client title\r\n{CLIENT_FNAME} - Client first name\r\n{CLIENT_LNAME} - Client last name\r\n{CLIENT_FULL_NAME} - Client full name\r\n{CLIENT_POSITION} - Client position\r\n{CLIENT_COMPANY_NAME} - Company name\r\n{CLIENT_COMPANY_VAT} - Company VAT/TAX number\r\n{CLIENT_COMPANY_WEB} - Company web site\r\n{CLIENT_ADDRESS} - Address\r\n{CLIENT_CITY} - City\r\n{CLIENT_STATE} - State/Province\r\n{CLIENT_COUNTRY} - Country\r\n{CLIENT_ZIP} - Zip / Postal code\r\n{CLIENT_PHONE} - Phone\r\n{CLIENT_FAX} - Fax\r\n{CLIENT_EMAIL} - Email\r\n{CLIENT_NOTES} - Notes\r\n{MY_STATE} - My State/Province\r\n{MY_COUNTRY} - My Country\r\n{MY_ZIP} - My Zip / Postal code\r\n{MY_PHONE} - My Phone\r\n{MY_FAX} - My Fax\r\n{MY_EMAIL} - My Email\r\n{MY_NOTES} - My Notes\r\n</div>', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'New invoice email subject', 'script'),
(NULL, 792, 'pjField', 1, 'title', 'Paid invoice email subject', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'Below you can see all clients added to the Invoice Manager. Later when you create an invoice you assign it to a client.', 'script'),
(NULL, 795, 'pjField', 1, 'title', '+ Add client', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'Invoices', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'Personal Details', 'script'),
(NULL, 798, 'pjField', 1, 'title', 'Company Details', 'script'),
(NULL, 799, 'pjField', 1, 'title', 'Contact Details', 'script'),
(NULL, 800, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 801, 'pjField', 1, 'title', 'Add Client', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'Fill in client details using the form below click "Save" button to add a new client. Under the 4 tabs you can enter detailed information about your client.', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 804, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 805, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 806, 'pjField', 1, 'title', 'Position', 'script'),
(NULL, 807, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 808, 'pjField', 1, 'title', 'VAT / TAX number', 'script'),
(NULL, 809, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 810, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 811, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 812, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 813, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 814, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 816, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 817, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 818, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 819, 'pjField', 1, 'title', 'Email invalid.', 'script'),
(NULL, 820, 'pjField', 1, 'title', 'Client updated!', 'script'),
(NULL, 821, 'pjField', 1, 'title', 'Changes made on the client have been saved.', 'script'),
(NULL, 822, 'pjField', 1, 'title', 'Client added!', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'Client has been added into the system.', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'Client not added!', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'Client could not be added. Please try again.', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'Client not found!', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'Client you are looking for is missing.', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'Update Client', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'Edit client detais using the form below. Under Invoices Summary tab you can see a summary for all invoices created for this client.', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'No access to feed.', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'Export Clients', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'You can export clients'' details in different formats. You can either download a file with clients'' details or use a link for a feed which load all the clients'' details.', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'CSV', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'XML', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'Feed', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'Format', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'Enter password', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'Client created', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'Yesterday', 'script'),
(NULL, 842, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'Last week', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 845, 'pjField', 1, 'title', 'Last month', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'Get Feed URL', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'Clients feed URL', 'script'),
(NULL, 848, 'pjField', 1, 'title', 'Use the URL below to have access to all clients. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 850, 'pjField', 1, 'title', 'Import', 'script'),
(NULL, 851, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 852, 'pjField', 1, 'title', 'Changes made on the client have been saved, but the avatar could not be uploaded. Please try again.', 'script'),
(NULL, 853, 'pjField', 1, 'title', 'Client updated!', 'script'),
(NULL, 854, 'pjField', 1, 'title', 'CSV file missing', 'script'),
(NULL, 855, 'pjField', 1, 'title', 'Importing clients could not be processed because of missing of CSV file.', 'script'),
(NULL, 856, 'pjField', 1, 'title', 'Clients updated', 'script'),
(NULL, 857, 'pjField', 1, 'title', 'Clients in CSV file have been updated.', 'script'),
(NULL, 858, 'pjField', 1, 'title', 'Importing cannot be processed because of invalid data. ', 'script'),
(NULL, 859, 'pjField', 1, 'title', 'File type error', 'script'),
(NULL, 860, 'pjField', 1, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 861, 'pjField', 1, 'title', 'Clients updated', 'script'),
(NULL, 862, 'pjField', 1, 'title', 'Clients pasted from Excel have been updated.', 'script'),
(NULL, 863, 'pjField', 1, 'title', 'Client imported', 'script'),
(NULL, 864, 'pjField', 1, 'title', 'Client list has been imported successfully.', 'script'),
(NULL, 865, 'pjField', 1, 'title', 'Clients data invalid', 'script'),
(NULL, 866, 'pjField', 1, 'title', 'upload CSV file', 'script'),
(NULL, 867, 'pjField', 1, 'title', 'copy/paste from Excel', 'script'),
(NULL, 868, 'pjField', 1, 'title', 'Source', 'script'),
(NULL, 869, 'pjField', 1, 'title', 'Update clients', 'script'),
(NULL, 870, 'pjField', 1, 'title', 'Import', 'script'),
(NULL, 871, 'pjField', 1, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 872, 'pjField', 1, 'title', 'Import Clients', 'script'),
(NULL, 873, 'pjField', 1, 'title', 'You can upload a CSV file with your clients. If you check "Update clients" then clients who are already in your list will be updated with the new data provided. Otherwise each new client will be added to the list and duplicates may be possible. Sample CSV file can be found <a href="import-sample.csv">here</a>.', 'script'),
(NULL, 874, 'pjField', 1, 'title', 'CSV file', 'script'),
(NULL, 875, 'pjField', 1, 'title', 'New', 'script'),
(NULL, 876, 'pjField', 1, 'title', 'Paid', 'script'),
(NULL, 877, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 878, 'pjField', 1, 'title', 'Weekly', 'script'),
(NULL, 879, 'pjField', 1, 'title', 'Monthly', 'script'),
(NULL, 880, 'pjField', 1, 'title', 'Quarterly', 'script'),
(NULL, 881, 'pjField', 1, 'title', 'Yearly', 'script'),
(NULL, 882, 'pjField', 1, 'title', 'Invoices', 'script'),
(NULL, 883, 'pjField', 1, 'title', 'Below you can find all created invoices. If you want to add new invoice click on the "+ Add invoice" button. You can filter invoices by their status or see today''s recurring invoices.', 'script'),
(NULL, 884, 'pjField', 1, 'title', '+ Add invoice', 'script'),
(NULL, 885, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 886, 'pjField', 1, 'title', 'Date issued', 'script'),
(NULL, 887, 'pjField', 1, 'title', 'Invoice number', 'script'),
(NULL, 888, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 889, 'pjField', 1, 'title', 'Add Invoice', 'script'),
(NULL, 890, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new invoice.', 'script'),
(NULL, 891, 'pjField', 1, 'title', 'Recurring', 'script'),
(NULL, 892, 'pjField', 1, 'title', 'See last 5 invoices', 'script'),
(NULL, 893, 'pjField', 1, 'title', 'Product', 'script'),
(NULL, 894, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 895, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 896, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 897, 'pjField', 1, 'title', 'VAT', 'script'),
(NULL, 898, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 899, 'pjField', 1, 'title', 'Please enter positive number.', 'script'),
(NULL, 900, 'pjField', 1, 'title', 'Invoice No.', 'script'),
(NULL, 901, 'pjField', 1, 'title', 'Invoice updated!', 'script'),
(NULL, 902, 'pjField', 1, 'title', 'Changes made to the invoice have been saved.', 'script'),
(NULL, 903, 'pjField', 1, 'title', 'Invoice added!', 'script'),
(NULL, 904, 'pjField', 1, 'title', 'Invoice has been added into the system.', 'script'),
(NULL, 905, 'pjField', 1, 'title', 'Invoice not added!', 'script'),
(NULL, 906, 'pjField', 1, 'title', 'Invoice could not be added. Please try again.', 'script'),
(NULL, 907, 'pjField', 1, 'title', 'Invoice not found!', 'script'),
(NULL, 908, 'pjField', 1, 'title', 'Invoice you are looking for is missing.', 'script'),
(NULL, 909, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 910, 'pjField', 1, 'title', 'Update invoice', 'script'),
(NULL, 911, 'pjField', 1, 'title', 'You can edit the invoices using the form below. Under Payment tab you can set details about payment made for the invoice.', 'script'),
(NULL, 912, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 913, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 914, 'pjField', 1, 'title', 'Date paid', 'script'),
(NULL, 915, 'pjField', 1, 'title', 'Payment ID', 'script'),
(NULL, 916, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 917, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 918, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 919, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 920, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 921, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 922, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 923, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 924, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 925, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 926, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 927, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 928, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 929, 'pjField', 1, 'title', 'Payment fee', 'script'),
(NULL, 930, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 931, 'pjField', 1, 'title', 'Payment settings updated!', 'script'),
(NULL, 932, 'pjField', 1, 'title', 'Changes made on the payment settings have been saved.', 'script'),
(NULL, 933, 'pjField', 1, 'title', 'Template settings updated!', 'script'),
(NULL, 934, 'pjField', 1, 'title', 'Changes made on the template settings have been saved.', 'script'),
(NULL, 935, 'pjField', 1, 'title', 'View invoice', 'script'),
(NULL, 936, 'pjField', 1, 'title', 'Send invoice email', 'script'),
(NULL, 937, 'pjField', 1, 'title', 'Print invoice', 'script'),
(NULL, 938, 'pjField', 1, 'title', 'Parameters are missing.', 'script'),
(NULL, 939, 'pjField', 1, 'title', 'Invoice with such ID does not exist.', 'script'),
(NULL, 940, 'pjField', 1, 'title', 'Hash value is not correct.', 'script'),
(NULL, 941, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 942, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 943, 'pjField', 1, 'title', 'Send to', 'script'),
(NULL, 944, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 1063, 'pjField', 1, 'title', 'Company details', 'script'),
(NULL, 1064, 'pjField', 1, 'title', 'Company Details', 'script'),
(NULL, 1065, 'pjField', 1, 'title', 'Enter your company details which will be used when you generate invoices for your clients.', 'script'),
(NULL, 1066, 'pjField', 1, 'title', 'Company details updated!', 'script'),
(NULL, 1067, 'pjField', 1, 'title', 'Changes made on company details has been saved.', 'script'),
(NULL, 1068, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 1069, 'pjField', 1, 'title', 'Quantity', 'script'),
(NULL, 1070, 'pjField', 1, 'title', 'Add product +', 'script'),
(NULL, 1071, 'pjField', 1, 'title', 'Template', 'script'),
(NULL, 1072, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 1073, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 1074, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 1075, 'pjField', 1, 'title', 'Duplicate', 'script'),
(NULL, 1076, 'pjField', 1, 'title', 'View', 'script'),
(NULL, 1077, 'pjField', 1, 'title', 'Duplicate invoice', 'script'),
(NULL, 1078, 'pjField', 1, 'title', 'Duplicated invoice has been created.', 'script'),
(NULL, 1079, 'pjField', 1, 'title', 'Do you want to duplicate the selected invoice?', 'script'),
(NULL, 1080, 'pjField', 1, 'title', 'Duplicate', 'script'),
(NULL, 1081, 'pjField', 1, 'title', 'Created', 'script'),
(NULL, 1082, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 1083, 'pjField', 1, 'title', 'View details', 'script'),
(NULL, 1084, 'pjField', 1, 'title', 'Invoices created', 'script'),
(NULL, 1085, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 1086, 'pjField', 1, 'title', 'Manager', 'script'),
(NULL, 1087, 'pjField', 1, 'title', 'Report', 'script'),
(NULL, 1088, 'pjField', 1, 'title', 'Report', 'script'),
(NULL, 1089, 'pjField', 1, 'title', 'Select "From" and "To" dates to view invoices created for the period.', 'script'),
(NULL, 1090, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 1091, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 1092, 'pjField', 1, 'title', 'Submit', 'script'),
(NULL, 1093, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 1094, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 1095, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 1096, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 1097, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 1098, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 1099, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 1100, 'pjField', 1, 'title', 'Title        FirstName        LastName        Email        Position        CompanyName etc.', 'script'),
(NULL, 1101, 'pjField', 1, 'title', 'Summary', 'script'),
(NULL, 1102, 'pjField', 1, 'title', 'Invoices Summary', 'script'),
(NULL, 1103, 'pjField', 1, 'title', 'Product name', 'script'),
(NULL, 1104, 'pjField', 1, 'title', 'Add product', 'script'),
(NULL, 1105, 'pjField', 1, 'title', 'Payment is processing...', 'script'),
(NULL, 1106, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor for PayPal...', 'script'),
(NULL, 1107, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor for Authorize.net...', 'script'),
(NULL, 1108, 'pjField', 1, 'title', 'Thank you for your payment. Please see the back account below to complete the payment.', 'script'),
(NULL, 1109, 'pjField', 1, 'title', 'Thank you! Your credit card details has been saved into the system.', 'script'),
(NULL, 1110, 'pjField', 1, 'title', 'Thank you! Please contact us to complete your payment.', 'script'),
(NULL, 1111, 'pjField', 1, 'title', 'Next invoice', 'script'),
(NULL, 1112, 'pjField', 1, 'title', 'Invoice number is already used.', 'script'),
(NULL, 1113, 'pjField', 1, 'title', 'Payment template', 'script'),
(NULL, 1114, 'pjField', 1, 'title', 'Payment template', 'script'),
(NULL, 1115, 'pjField', 1, 'title', 'This template will be loaded when clients open the page to make the payment for invoices. You can also use the available tokens to personalize them.', 'script'),
(NULL, 1116, 'pjField', 1, 'title', 'Your payment has been proceeded successfully. Thank you!', 'script');

INSERT INTO `invoicemanager_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 5, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 7, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 8, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 9, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_vat', 2, '0.00', NULL, 'int', 3, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_invoice_template', 3, '<div style="width: 800px;">\r\n<table style="width: 100%;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="width: 50%;" rowspan="3" width="81%">\r\n<table style="width: 100%%;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;"><strong style="font-weight: bold;">Bill To:</strong></td>\r\n</tr>\r\n<tr>\r\n<td><strong style="font-weight: bold;">{CLIENT_COMPANY_NAME}</strong></td>\r\n</tr>\r\n<tr>\r\n<td>{CLIENT_ADDRESS}</td>\r\n</tr>\r\n<tr>\r\n<td>{CLIENT_CITY}</td>\r\n</tr>\r\n<tr>\r\n<td>{CLIENT_STATE} {CLIENT_ZIP}</td>\r\n</tr>\r\n<tr>\r\n<td>Phone: {CLIENT_PHONE}</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align="right" width="19%">\r\n<p><strong style="font-weight: bold;">Invoice no.</strong> {INVOICE_NUMBER}</p>\r\n<p><strong style="font-weight: bold;">Date</strong>: {INVOICE_DATE_ISSUED}</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<h1 style="text-align: center;"><span style="font-size: 30px;"><strong>Invoice</strong></span></h1>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>{INVOICE_DESCRIPTION}</p>\r\n<p>&nbsp;</p>\r\n<table style="width: 100%;" border="0">\r\n<tbody>\r\n<tr>\r\n<td width="51%">&nbsp;</td>\r\n<td style="text-align: right;" width="17%">SubTotal:</td>\r\n<td style="text-align: right;" width="32%">{INVOICE_AMOUNT}</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td style="text-align: right;">VAT:</td>\r\n<td style="text-align: right;">{INVOICE_VAT}</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td style="text-align: right;"><strong>Total:</strong></td>\r\n<td style="text-align: right;"><strong>{INVOICE_TOTAL}</strong></td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td style="text-align: right;">&nbsp;</td>\r\n<td style="text-align: right;">&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<table style="width: 100%; border-collapse: collapse;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="font-size: 20px; font-weight: bold;" colspan="2" align="center">Thanks for your business!</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px; font-size: 16px; font-weight: bold;"><strong>{MY_COMPANY_NAME}</strong></td>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;">&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td>{MY_ADDRESS}</td>\r\n<td align="right">Phone: {MY_PHONE}</td>\r\n</tr>\r\n<tr>\r\n<td>{MY_CITY}</td>\r\n<td align="right">Email: {MY_EMAIL}</td>\r\n</tr>\r\n<tr>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;">{MY_STATE} {MY_ZIP}</td>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;" align="right">Website: {MY_COMPANY_WEB}</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>', NULL, 'text', 1, 1, NULL),
(1, 'o_new_invoice_subject', 3, 'New Invoice', NULL, 'string', 2, 1, NULL),
(1, 'o_new_invoice_template', 3, '<div>Dear {CLIENT_TITLE} {CLIENT_LNAME},</div>\r\n<div>&nbsp;</div>\r\n<div>&nbsp;</div>\r\n<div>to pay the invoice, please use the following URL</div>\r\n<div>&nbsp;</div>\r\n<div>{INVOICE_PAY}</div>\r\n<div>&nbsp;</div>\r\n<div>&nbsp;</div>\r\n<div>Thank you,</div>\r\n<div>&nbsp;</div>\r\n<div>The Team</div>', NULL, 'text', 3, 1, NULL),
(1, 'o_paid_invoice_subject', 3, 'Paid invoice', NULL, 'string', 4, 1, NULL),
(1, 'o_paid_invoice_template', 3, '<div>Dear {CLIENT_TITLE} {CLIENT_LNAME},</div>\r\n<div>&nbsp;</div>\r\n<div>invoice&nbsp;{INVOICE_NUMBER} issued on&nbsp;{INVOICE_DATE_ISSUED} has been paid. You can view the invoice at</div>\r\n<div>&nbsp;</div>\r\n<div>&nbsp;</div>\r\n<div>{INVOICE_VIEW}</div>\r\n<div>&nbsp;</div>\r\n<div>&nbsp;</div>\r\n<div>Thank you,</div>\r\n<div>&nbsp;</div>\r\n<div>The Team</div>\r\n<p><br /><br /></p>', NULL, 'text', 5, 1, NULL),
(1, 'o_print_template', 3, '<div style="width: 1000px;">\r\n<table style="width: 100%;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="width: 50%;"><strong>{MY_COMPANY_NAME}</strong></td>\r\n<td><strong>Invoice no.</strong> {INVOICE_NUMBER}</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td><strong>Date</strong> {INVOICE_DATE_ISSUED}</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<table style="width: 85%;" border="0" align="center">\r\n<tbody>\r\n<tr>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;"><strong>Bill To:</strong></td>\r\n</tr>\r\n<tr>\r\n<td><strong>{CLIENT_FULL_NAME}</strong></td>\r\n</tr>\r\n<tr>\r\n<td><strong>{CLIENT_COMPANY_NAME}</strong></td>\r\n</tr>\r\n<tr>\r\n<td>{CLIENT_ADDRESS}</td>\r\n</tr>\r\n<tr>\r\n<td>{CLIENT_CITY}</td>\r\n</tr>\r\n<tr>\r\n<td>{CLIENT_STATE} {CLIENT_ZIP}</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td>Phone: {CLIENT_PHONE}, Fax: {CLIENT_FAX}</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<p style="text-align: center;"><span style="font-size: large;"><strong>Invoice</strong></span></p>\r\n<p>{INVOICE_DESCRIPTION}</p>\r\n<p>&nbsp;</p>\r\n<table style="width: 100%;" border="0">\r\n<tbody>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td style="text-align: right;">SubTotal:</td>\r\n<td style="text-align: right;">{INVOICE_AMOUNT}</td>\r\n</tr>\r\n<tr>\r\n<td>Thanks for your business!</td>\r\n<td style="text-align: right;">VAT:</td>\r\n<td style="text-align: right;">{INVOICE_VAT}</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td style="text-align: right;"><strong>Total:</strong></td>\r\n<td style="text-align: right;"><strong>{INVOICE_TOTAL}</strong></td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td style="text-align: right;">&nbsp;</td>\r\n<td style="text-align: right;">&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<table style="width: 100%; border-collapse: collapse;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;"><strong>{MY_COMPANY_NAME}</strong></td>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;">&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td>{MY_ADDRESS}</td>\r\n<td>Phone: {MY_PHONE}</td>\r\n</tr>\r\n<tr>\r\n<td>{MY_CITY}</td>\r\n<td>Email: {MY_EMAIL}</td>\r\n</tr>\r\n<tr>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;">{MY_STATE} {MY_ZIP}</td>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;">Website: {MY_COMPANY_WEB}</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>', NULL, 'text', 6, 1, NULL),
(1, 'o_payment_template', 3, '<div style="width: 800px;">\r\n<p>Scroll down to pay the invoice!</p>\r\n<p>&nbsp;</p>\r\n<table style="width: 100%;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="width: 50%;" rowspan="3" width="81%">\r\n<table style="width: 100%%;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;"><strong style="font-weight: bold;">Bill To:</strong></td>\r\n</tr>\r\n<tr>\r\n<td><strong style="font-weight: bold;">{CLIENT_COMPANY_NAME}</strong></td>\r\n</tr>\r\n<tr>\r\n<td>{CLIENT_ADDRESS}</td>\r\n</tr>\r\n<tr>\r\n<td>{CLIENT_CITY}</td>\r\n</tr>\r\n<tr>\r\n<td>{CLIENT_STATE} {CLIENT_ZIP}</td>\r\n</tr>\r\n<tr>\r\n<td>Phone: {CLIENT_PHONE}</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align="right" width="19%">\r\n<p><strong style="font-weight: bold;">Invoice no.</strong> {INVOICE_NUMBER}</p>\r\n<p><strong style="font-weight: bold;">Date</strong>: {INVOICE_DATE_ISSUED}</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<h1 style="text-align: center;"><span style="font-size: 30px;"><strong>Invoice</strong></span></h1>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>{INVOICE_DESCRIPTION}</p>\r\n<p>&nbsp;</p>\r\n<table style="width: 100%;" border="0">\r\n<tbody>\r\n<tr>\r\n<td width="51%">&nbsp;</td>\r\n<td style="text-align: right;" width="17%">SubTotal:</td>\r\n<td style="text-align: right;" width="32%">{INVOICE_AMOUNT}</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td style="text-align: right;">VAT:</td>\r\n<td style="text-align: right;">{INVOICE_VAT}</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td style="text-align: right;"><strong>Total:</strong></td>\r\n<td style="text-align: right;"><strong>{INVOICE_TOTAL}</strong></td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td style="text-align: right;">&nbsp;</td>\r\n<td style="text-align: right;">&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<table style="width: 100%; border-collapse: collapse;" border="0">\r\n<tbody>\r\n<tr>\r\n<td style="font-size: 20px; font-weight: bold;" colspan="2" align="center">Thanks for your business!</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px; font-size: 16px; font-weight: bold;"><strong>{MY_COMPANY_NAME}</strong></td>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;">&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td>{MY_ADDRESS}</td>\r\n<td align="right">Phone: {MY_PHONE}</td>\r\n</tr>\r\n<tr>\r\n<td>{MY_CITY}</td>\r\n<td align="right">Email: {MY_EMAIL}</td>\r\n</tr>\r\n<tr>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;">{MY_STATE} {MY_ZIP}</td>\r\n<td style="border-bottom-style: solid; border-bottom-width: 1px;" align="right">Website: {MY_COMPANY_WEB}</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>', NULL, 'text', 7, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', 'Yes|No', 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `invoicemanager_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

INSERT INTO `invoicemanager_clients` (`id`, `title`, `first_name`, `last_name`, `email`, `position`, `company_name`, `vat_number`, `website`, `address`, `city`, `state`, `country_id`, `zip`, `phone`, `fax`, `notes`, `modified`, `created`, `status`) VALUES
(1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NOW(), 'T');

COMMIT;