<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminClients extends pjAdmin
{
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['email']) || empty($_GET['email']))
			{
				echo 'false';
				exit;
			}
			$pjClientModel = pjClientModel::factory()->where('t1.email', $_GET['email']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjClientModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjClientModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['client_create']))
			{
				$id = pjClientModel::factory()->setAttributes($_POST)->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AC03';
				} else {
					$err = 'AC04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminClients&action=pjActionIndex&err=$err");
			} else {
				$country_arr = pjCountryModel::factory()
					->select('t1.*, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('status', 'T')->orderBy('country_title ASC')->findAll()->getData();
				
				$this->set('country_arr', $country_arr);
				
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminClients.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteClient()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$response = array();
			if ($this->isAdmin())
			{
				if (pjClientModel::factory()->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					pjProductModel::factory()->where("invoice_id IN(SELECT TI.id FROM `".pjInvoiceModel::factory()->getTable()."` AS TI WHERE TI.client_id='".$_GET['id']."')")->eraseAll();
					pjInvoiceModel::factory()->where('client_id', $_GET['id'])->eraseAll();
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteClientBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if ($this->isAdmin() || $this->isEditor())
			{
				if (isset($_POST['record']) && count($_POST['record']) > 0)
				{
					pjClientModel::factory()->reset()->whereIn('id', $_POST['record'])->eraseAll();
					pjProductModel::factory()->where("invoice_id IN(SELECT TI.id FROM `".pjInvoiceModel::factory()->getTable()."` AS TI WHERE TI.client_id IN(".join(",", $_POST['record']).") )")->eraseAll();
					pjInvoiceModel::factory()->whereIn('client_id', $_POST['record'])->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionExportClient()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjClientModel::factory()
				->select("t1.*")
				->whereIn('id', $_POST['record'])
				->findAll()
				->getData();
			
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Clients-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjClientModel = pjClientModel::factory();
			$pjClientModel->where('t1.id >', 1);
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = $pjClientModel->escapeStr($_GET['q']);
				$q = str_replace(array('%', '_'), array('\%', '\_'), trim($q));
				$pjClientModel->where("(t1.first_name LIKE '%$q%' OR t1.last_name LIKE '%$q%' OR t1.email LIKE '%$q%')");
			}
			if (isset($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjClientModel->where("t1.status", $_GET['status']);
			}	
			$column = 'first_name';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjClientModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjClientModel
				->select("
							t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`,
							CONCAT(t1.first_name, ' ', t1.last_name) AS name, 
							(SELECT COUNT(TI.id) FROM `".pjInvoiceModel::factory()->getTable()."` AS TI WHERE TI.client_id=t1.id) AS cnt_invoices
						")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();

			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminClients.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if($_POST['column'] == 'first_name')
			{
				if($_POST['value'] != '')
				{
					pjClientModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
				}
			}else{
				pjClientModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$pjClientModel = pjClientModel::factory();
			if (isset($_POST['client_update']))
			{
				$data = array();
				$data['modified'] = date('Y-m-d H:i:s');
				$data = array_merge($_POST, $data);
				
				$pjClientModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll($data);
								
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminClients&action=pjActionIndex&err=AC01");
				
			} else {
				$arr = $pjClientModel->find($_GET['id'])->getData();
				
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminClients&action=pjActionIndex&err=AC08");
				}
				$this->set('arr', $arr);
				
				$country_arr = pjCountryModel::factory()
					->select('t1.*, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('status', 'T')
					->orderBy('country_title ASC')
					->findAll()
					->getData();
				
				$this->set('country_arr', $country_arr);
				
				$pjInvoiceModel = pjInvoiceModel::factory();
				$_invoice_arr = $pjInvoiceModel->where('t1.client_id', $_GET['id'])->findAll()->getData();
				
				$invoice_arr = array();
				$currency_arr = array();
				foreach($_invoice_arr as $k => $v)
				{
					if(!in_array($v['currency'], $currency_arr))
					{
						$currency_arr[] = $v['currency'];
					}
					$invoice_arr[$v['status']][$v['currency']]['cnt'] += 1; 
					$invoice_arr[$v['status']][$v['currency']]['amount'] += $v['total'];
				}
				
				$this->set('cnt_invoices', count($_invoice_arr));
				$this->set('invoice_arr', $invoice_arr);
				$this->set('currency_arr', $currency_arr);
				
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminClients.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionImport()
	{
		$this->checkLogin();
	
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['client_import']))
			{
				$map = array('title','first_name','last_name','email','position','company_name','vat_number','website','address','city','state','country_id','zip','phone','fax','notes','status');
	
				if (isset($_FILES['csv']) && !empty($_FILES['csv']['tmp_name']))
				{
					if(pjUtil::getFileExtension($_FILES['csv']['name']) == 'csv')
					{
						$csv_data = $this->loadCSV($_FILES['csv']);

						$pjClientModel = pjClientModel::factory();
						
						$country_data = array();
						$country_arr = pjCountryModel::factory()->select('t1.*')->findAll()->getData();

						foreach($country_arr as $country)
						{
							$country_data[$country['alpha_2']] = $country['id'];
						}
						$valid = true;
						$lang_arr = array();
						foreach ($csv_data as $row)
						{
							if(count($row) != count($map))
							{
								$valid = false;
								break;
							}else{
								$same = true;
								foreach($row as $col => $whatever)
								{
									if(!in_array($col, $map))
									{
										$same = false;
									}
								}
							}
							if($same == false)
							{
								$valid = false;
								break;
							}
							if(isset($row['country_id']) && !empty($country_data))
							{
								$row['country_id'] = $country_data[$row['country_id']] ;
							}else{
								$row['country_id'] = ':NULL';
							}
							if(isset($row['id'])){
								unset($row['id']);
							}
							if(isset($row['created'])){
								unset($row['created']);
							}
							if(isset($row['modified'])){
								unset($row['modified']);
							}
							foreach($locale_arr as $locale)
							{
								$lang_arr[$locale['id']]['name'] = $row['name'];
								$lang_arr[$locale['id']]['address'] = $row['address'];
								$lang_arr[$locale['id']]['city'] = $row['city'];
								$lang_arr[$locale['id']]['state'] = $row['state'];
							}
							unset($row['name']);
							unset($row['address']);
							unset($row['city']);
							unset($row['state']);
								
							if($pjClientModel->reset()->where('t1.email', $row['email'])->findCount()->getData() == 0)
							{
								$id = $pjClientModel->reset()->setAttributes($row)->insert()->getInsertId();
							}else{
								if(isset($_POST['update_clients']))
								{
									$pjClientModel->reset()->where('t1.email', $row['email']);
										
									$client_arr = $pjClientModel->findAll()->getData();
									if(count($client_arr) > 0)
									{
										$id = $client_arr[0]['id'];
										$row['modified'] = date('Y-m-d H:i:s');
										$pjClientModel->reset()->set('id', $id)->modify($row);
									}
								}
							}
						}
						if($valid == true)
						{
							if(isset($_POST['update_clients']))
							{
								pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminClients&action=pjActionIndex&err=AC12");
							}else{
								pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminClients&action=pjActionIndex&err=AC23");
							}
						}else{
							pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminClients&action=pjActionImport&err=AC21");
						}
					}else{
						pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminClients&action=pjActionImport&err=AC22");
					}
				}else{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminClients&action=pjActionImport&err=AC11");
				}
	
			}else{
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminClients.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionExport()
	{
		$this->checkLogin();
	
		if ($this->isAdmin() || $this->isEditor())
		{
			if(isset($_POST['clients_export']))
			{
				$pjClientModel = pjClientModel::factory();
					
				$column = 't1.created';
				$direction = 'ASC';
				$where_str = pjUtil::getMadeWhere($_POST['made_period'], $this->option_arr['o_week_start']);
				if($where_str != '')
				{
					$pjClientModel->where($where_str);
				}
	
				$arr= $pjClientModel
					->where('t1.id <>', 1)
					->orderBy("$column $direction")
					->findAll()
					->getData();
				
				if($_POST['type'] == 'file')
				{
					$this->setLayout('pjActionEmpty');
	
					if($_POST['format'] == 'csv')
					{
						foreach($arr as $k => $v)
						{
							unset($v['id']);
							unset($v['modified']);
							unset($v['created']);
							$arr[$k] = $v;
						}
	
						$csv = new pjCSV();
						$csv
							->setHeader(true)
							->setName("Export-".time().".csv")
							->process($arr)
							->download();
					}
					if($_POST['format'] == 'xml')
					{
						$xml = new pjXML();
						$xml
							->setEncoding('UTF-8')
							->setName("Export-".time().".xml")
							->process($arr)
							->download();
					}
					exit;
				}else{
					$pjPasswordModel = pjPasswordModel::factory();
					$password = md5($_POST['password'].PJ_SALT);
					$arr = $pjPasswordModel
						->where("t1.password", $password)
						->where("t1.format", $_POST['format'])
						->where("t1.period", $_POST['made_period'])
						->limit(1)
						->findAll()
						->getData();
					if (count($arr) != 1)
					{
						$pjPasswordModel->setAttributes(array('password' => $password, 'format' => $_POST['format'], 'period' => $_POST['made_period']))->insert();
					}
					$this->set('password', $password);
				}
			}
	
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminClients.js');			
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionExportFeed()
	{
		$this->setLayout('pjActionEmpty');
		$access = true;
		if(isset($_GET['p']))
		{
			$pjPasswordModel = pjPasswordModel::factory();
			$arr = $pjPasswordModel
				->where('t1.password', $_GET['p'])
				->where("t1.format", $_GET['format'])
				->where("t1.period", $_GET['period'])
				->limit(1)
				->findAll()
				->getData();
			if (count($arr) != 1)
			{
				$access = false;
			}
		}
		if($access == true)
		{
			$arr = $this->pjGetFeedData($_GET);
			if(!empty($arr))
			{
				if($_GET['format'] == 'xml')
				{
					$xml = new pjXML();
					echo $xml
						->setEncoding('UTF-8')
						->process($arr)
						->getData();
	
				}
				if($_GET['format'] == 'csv')
				{
					foreach($arr as $k => $v)
					{
						unset($v['id']);
						unset($v['modified']);
						unset($v['created']);
						$arr[$k] = $v;
					}
					$csv = new pjCSV();
					echo $csv
						->setHeader(true)
						->process($arr)
						->getData();
	
				}
			}
		}else{
			__('lblNoAccessToFeed');
		}
		exit;
	}
	public function pjGetFeedData($get)
	{
		$arr = array();
		$status = true;
		$period = '';
		if(isset($get['period']))
		{
			if(!ctype_digit($get['period']))
			{
				$status = false;
			}else{
				$period = $get['period'];
			}
		}else{
			$status = false;
		}
	
		if($status == true && $period != '')
		{
			$pjClientModel = pjClientModel::factory();
			$column = 't1.created';
			$direction = 'DESC';
			$where_str = pjUtil::getMadeWhere($period, $this->option_arr['o_week_start']);
			if($where_str != '')
			{
				$pjClientModel->where($where_str);
			}
			$arr= $pjClientModel
				->where('t1.id <>', 1)
				->orderBy("$column $direction")
				->findAll()
				->getData();
		}
		return $arr;
	}
	
	public function pjActionGetPassword()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjPasswordModel = pjPasswordModel::factory();
	
			$column = 'id';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}
	
			$total = $pjPasswordModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
	
			$data = $pjPasswordModel->select("t1.*")->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();
	
			$export_formats = __('export_formats', true, false);
			$made_arr = __('made_arr', true, false);
			foreach($data as $k => $v)
			{
				$v['params'] = '&format=' . $v['format'] . '&period=' . $v['period'] . '&p=' . $v['password'];
				$v['period'] = $made_arr[$v['period']];
				$v['format'] = $export_formats[$v['format']];
				$data[$k] = $v;
			}
	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	public function pjActionDeletePassword()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjPasswordModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeletePasswordBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjPasswordModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
}
?>