<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminInvoices extends pjAdmin
{
	public function pjActionCheckInvoice()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['invoice_number']) || empty($_GET['invoice_number']))
			{
				echo 'false';
				exit;
			}
			$pjInvoiceModel = pjInvoiceModel::factory()->where('t1.invoice_number', $_GET['invoice_number']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjInvoiceModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjInvoiceModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['invoice_create']))
			{
				$data = array();
				$data['created'] = date('Y-m-d H:i:s');
				$data['user_id'] = $this->getUserId();
				$data['date_issued'] = pjUtil::formatDate($_POST['date_issued'], $this->option_arr['o_date_format']);
				if($_POST['recurring'] != '')
				{
					$data['recurring_date'] = pjUtil::formatDate($_POST['recurring_date'], $this->option_arr['o_date_format']);;
				}else{
					$data['recurring_date'] = ':NULL';
				}
				$id = pjInvoiceModel::factory()->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					if(isset($_POST['product_title']) && count($_POST['product_title']))
					{
						$pjProductModel = pjProductModel::factory();
						$pjProductModel->begin();
						foreach($_POST['product_title'] as $k => $product_title)
						{
							$pdata = array();
							$pdata['invoice_id'] = $id;
							$pdata['product_title'] = $product_title;
							$pdata['price'] = $_POST['price'][$k];
							$pdata['quantity'] = $_POST['quantity'][$k];
							$pjProductModel->reset()->setAttributes($pdata)->insert();
						}
						$pjProductModel->commit();
					}
					$err = 'AI03';
				} else {
					$err = 'AI04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminInvoices&action=pjActionIndex&err=$err");
			} else {
				$client_arr = pjClientModel::factory()
					->where('status', 'T')
					->where('t1.id > 1')
					->orderBy('first_name ASC')
					->findAll()
					->getData();
				$o_arr = $this->models['Option']
					->where('t1.foreign_id', $this->getForeignId())
					->where('`key`', 'o_currency')
					->orderBy('t1.key ASC')
					->findAll()
					->getData();

				$invoice_arr = pjInvoiceModel::factory()
					->select("t1.*, t2.first_name, t2.last_name, t2.company_name")
					->join('pjClient', 't2.id=t1.client_id', 'left')
					->orderBy("created DESC")
					->limit(5)
					->findAll()
					->getData();
				
				if(isset($_GET['id']))
				{
					$arr = pjInvoiceModel::factory()->find($_GET['id'])->getData();
					$product_arr = pjProductModel::factory()->where('invoice_id', $_GET['id'])->findAll()->getData();
					
					$this->set('arr', $arr);
					$this->set('product_arr', $product_arr);
				}
				
				$this->set('client_arr', $client_arr);
				$this->set('invoice_arr', $invoice_arr);
				$this->set('currency_arr', $o_arr[0]);
				
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminInvoices.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteInvoice()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$response = array();
			if ($this->isAdmin() || $this->isEditor())
			{
				if (pjInvoiceModel::factory()->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					pjProductModel::factory()->where("invoice_id", $_GET['id'])->eraseAll();
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteInvoiceBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if ($this->isAdmin() || $this->isEditor())
			{
				if (isset($_POST['record']) && count($_POST['record']) > 0)
				{
					pjInvoiceModel::factory()->reset()->whereIn('id', $_POST['record'])->eraseAll();
					pjProductModel::factory()->whereIn("invoice_id", $_POST['record'])->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionExportInvoice()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjInvoiceModel::factory()
				->select("t1.*")
				->whereIn('id', $_POST['record'])
				->findAll()
				->getData();
			
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Invoices-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetInvoice()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjInvoiceModel = pjInvoiceModel::factory()->join('pjClient', 't2.id=t1.client_id', 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = $pjInvoiceModel->escapeStr($_GET['q']);
				$q = str_replace(array('%', '_'), array('\%', '\_'), trim($q));
				$pjInvoiceModel->where("(t1.invoice_number LIKE '%$q%' OR t2.first_name LIKE '%$q%' OR t2.last_name LIKE '%$q%' OR t2.email LIKE '%$q%' OR t2.company_name LIKE '%$q%')");
			}
			if (isset($_GET['status']))
			{
				if(in_array($_GET['status'], array('new', 'paid', 'cancelled')))
				{
					$pjInvoiceModel->where("t1.status", $_GET['status']);
				}else if($_GET['status'] == 'recurring'){
					$pjInvoiceModel->where("t1.recurring_date", date('Y-m-d'));
				}
				
			}	
			if (isset($_GET['client_id']) && (int) $_GET['client_id'] > 0)
			{
				$pjInvoiceModel->where("t1.client_id", $_GET['client_id']);
			}else if($this->isClient()){
				$pjInvoiceModel->where("t1.client_id", $this->getUserId());
			}
			
			if (isset($_GET['currency']) && $_GET['currency'] != '')
			{
				$pjInvoiceModel->where("t1.currency", $_GET['currency']);
			}
			if (isset($_GET['user_id']) && (int) $_GET['user_id'] > 0)
			{
				$pjInvoiceModel->where("t1.user_id", $_GET['user_id']);
			}
			if (isset($_GET['date_issued_from']) && $_GET['date_issued_from'] != '' && isset($_GET['date_issued_to']) && $_GET['date_issued_to'] != '')
			{
				$date_issued_from = pjUtil::formatDate($_GET['date_issued_from'], $this->option_arr['o_date_format']);
				$date_issued_to = pjUtil::formatDate($_GET['date_issued_to'], $this->option_arr['o_date_format']);
				$pjInvoiceModel->where("(t1.date_issued >= '$date_issued_from' AND t1.date_issued <= '$date_issued_to')");
			} else {
				if (isset($_GET['date_issued_from']) && $_GET['date_issued_from'] != '')
				{
					$date_issued_from = pjUtil::formatDate($_GET['date_issued_from'], $this->option_arr['o_date_format']);
					$pjInvoiceModel->where("(t1.date_issued >= '$date_issued_from')");
				} else if (isset($_GET['date_issued_to']) && $_GET['date_issued_to'] != '') {
					$date_issued_to = pjUtil::formatDate($_GET['date_issued_to'], $this->option_arr['o_date_format']);
					$pjInvoiceModel->where("(t1.date_issued <= '$date_issued_to')");
				}
			}
			if (isset($_GET['date_paid_from']) && $_GET['date_paid_from'] != '' && isset($_GET['date_paid_to']) && $_GET['date_paid_to'] != '')
			{
				$date_paid_from = pjUtil::formatDate($_GET['date_paid_from'], $this->option_arr['o_date_format']);
				$date_paid_to = pjUtil::formatDate($_GET['date_paid_to'], $this->option_arr['o_date_format']);
				$pjInvoiceModel->where("(t1.processed_on >= '$date_paid_from' AND t1.processed_on <= '$date_paid_to')");
			} else {
				if (isset($_GET['date_paid_from']) && $_GET['date_paid_from'] != '')
				{
					$date_paid_from = pjUtil::formatDate($_GET['date_paid_from'], $this->option_arr['o_date_format']);
					$pjInvoiceModel->where("(t1.processed_on >= '$date_paid_from')");
				} else if (isset($_GET['date_paid_to']) && $_GET['date_paid_to'] != '') {
					$date_paid_to = pjUtil::formatDate($_GET['date_paid_to'], $this->option_arr['o_date_format']);
					$pjInvoiceModel->where("(t1.processed_on <= '$date_paid_to')");
				}
			}
			if (isset($_GET['recurring']) && $_GET['recurring'] != '')
			{
				$pjInvoiceModel->where("t1.recurring", $_GET['recurring']);
			}
			if (isset($_GET['invoice_number']) && $_GET['invoice_number'] != '')
			{
				$pjInvoiceModel->where("(t1.invoice_number LIKE '%".$_GET['invoice_number']."%')");
			}
			if (isset($_GET['product_name']) && $_GET['product_name'] != '')
			{
				$pjInvoiceModel->where("(t1.id IN (SELECT TP.invoice_id FROM `".pjProductModel::factory()->getTable()."` AS TP WHERE TP.product_title LIKE '%".$_GET['invoice_number']."%') )");
			}
			if (isset($_GET['total']) && $_GET['total'] != '')
			{
				$pjInvoiceModel->where("t1.total", $_GET['total']);
			}
			if (isset($_GET['txn_id']) && $_GET['txn_id'] != '')
			{
				$pjInvoiceModel->where("(t1.txn_id LIKE '%".$_GET['txn_id']."%')");
			}
			if (isset($_GET['payment_method']) && $_GET['payment_method'] != '')
			{
				$pjInvoiceModel->where("t1.payment_method", $_GET['payment_method']);
			}
			
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjInvoiceModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjInvoiceModel
				->select("t1.*, t2.first_name, t2.last_name, t2.company_name")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				$v['hash'] = sha1($v['id'].$v['created'].PJ_SALT);
				if(!empty($v['date_issued']))
				{
					$v['date_issued'] = date($this->option_arr['o_date_format'], strtotime($v['date_issued']));
				}
				$v['total'] = pjUtil::formatCurrencySign($v['total'], $v['currency']);
				$name_arr = array();
				if(!empty($v['first_name']))
				{
					$name_arr[] = $v['first_name'];
				}
				if(!empty($v['last_name']))
				{
					$name_arr[] = $v['last_name'];
				}
				$v['first_name'] = implode(" ", $name_arr);
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isClient())
		{
			$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminInvoices.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveInvoice()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if($_POST['column'] == 'invoice_number')
			{
				if($_POST['value'] != '')
				{
					pjInvoiceModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
				}
			}else{
				pjInvoiceModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$pjInvoiceModel = pjInvoiceModel::factory();
			if (isset($_POST['invoice_update']))
			{
				$data = array();
				$data['modified'] = date('Y-m-d H:i:s');
				$data['date_issued'] = pjUtil::formatDate($_POST['date_issued'], $this->option_arr['o_date_format']);
				if(!empty($_POST['processed_on']))
				{
					$data['processed_on'] = pjUtil::formatDate($_POST['processed_on'], $this->option_arr['o_date_format']);
				}
				if($_POST['recurring'] != '')
				{
					$data['recurring_date'] = pjUtil::formatDate($_POST['recurring_date'], $this->option_arr['o_date_format']);;
				}else{
					$data['recurring_date'] = ':NULL';
				}
				
				$pjInvoiceModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));

				$pjProductModel = pjProductModel::factory();
				$pjProductModel->where("invoice_id", $_POST['id'])->eraseAll();
				if(isset($_POST['product_title']) && count($_POST['product_title']))
				{
					$pjProductModel->reset()->begin();
					foreach($_POST['product_title'] as $k => $product_title)
					{
						$pdata = array();
						$pdata['invoice_id'] = $_POST['id'];
						$pdata['product_title'] = $product_title;
						$pdata['price'] = $_POST['price'][$k];
						$pdata['quantity'] = $_POST['quantity'][$k];
						$pjProductModel->reset()->setAttributes($pdata)->insert();
					}
					$pjProductModel->commit();
				}
				
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminInvoices&action=pjActionUpdate&id=".$_POST['id']."&err=AI01");
			} else {
				$arr = $pjInvoiceModel->find($_GET['id'])->getData();
				
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminInvoices&action=pjActionIndex&err=AI08");
				}
				$this->set('arr', $arr);
				
				$client_arr = pjClientModel::factory()
					->where('status', 'T')
					->where('t1.id > 1')
					->orderBy('first_name ASC')
					->findAll()
					->getData();
				
				$client = pjClientModel::factory()->find($arr['client_id'])->getData();
				
				$user = pjUserModel::factory()->find($arr['user_id'])->getData();
				
				$invoice_arr = pjInvoiceModel::factory()
					->select("t1.*, t2.first_name, t2.last_name, t2.company_name")
					->join('pjClient', 't2.id=t1.client_id', 'left')
					->where('t1.id <>', $_GET['id'])
					->orderBy("created DESC")
					->limit(5)
					->findAll()
					->getData();
				
				$o_arr = $this->models['Option']
					->where('t1.foreign_id', $this->getForeignId())
					->where('`key`', 'o_currency')
					->orderBy('t1.key ASC')
					->findAll()
					->getData();
				
				$product_arr = pjProductModel::factory()
					->where('t1.invoice_id', $_GET['id'])
					->findAll()
					->getData();
				
				$tokens = pjAppController::getTokens($arr, $client, $this->my_arr, $this->option_arr, PJ_SALT, $this->getLocaleId());
				$incoive = str_replace($tokens['search'], $tokens['replace'], $this->option_arr['o_invoice_template']);
				
				$this->set('client_arr', $client_arr);
				$this->set('invoice_arr', $invoice_arr);
				$this->set('currency_arr', $o_arr[0]);
				$this->set('product_arr', $product_arr);
				$this->set('client', $client);
				$this->set('user', $user);
				$this->set('invoice', $incoive);
				
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminInvoices.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionView()
	{
		$this->setLayout('pjActionView');
	
		if (isset($_GET['hash']) && isset($_GET['id']))
		{
			$pjInvoiceModel = pjInvoiceModel::factory();
			
			$arr = $pjInvoiceModel->find($_GET['id'])->getData();
			if (count($arr) == 0)
			{
				$this->set('status', 2);
			}else{
				$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
				if ($_GET['hash'] != $hash)
				{
					$this->set('status', 3);
				}else{
					$pjClientModel = pjClientModel::factory();
					$client_id = $arr['client_id'];
					$client_arr = $pjClientModel->find($arr['client_id'])->getData();
					
					$tokens = pjAppController::getTokens($arr, $client_arr, $this->my_arr, $this->option_arr, PJ_SALT, $this->getLocaleId());
					
					$incoive = str_replace($tokens['search'], $tokens['replace'], $this->option_arr['o_invoice_template']);
					
					$this->set('invoice', $incoive);
				}
			}
		}else if (!isset($_GET['err'])) {
			$this->set('status', 1);
		}
	}
	
	public function pjActionPrint()
	{
		$this->setLayout('pjActionPrint');
	
		if (isset($_GET['hash']) && isset($_GET['id']))
		{
			$pjInvoiceModel = pjInvoiceModel::factory();
				
			$arr = $pjInvoiceModel->find($_GET['id'])->getData();
			if (count($arr) == 0)
			{
				$this->set('status', 2);
			}else{
				$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
				if ($_GET['hash'] != $hash)
				{
					$this->set('status', 3);
				}else{
					$pjClientModel = pjClientModel::factory();
					$client_id = $arr['client_id'];
					$client_arr = $pjClientModel->find($arr['client_id'])->getData();
						
					$tokens = pjAppController::getTokens($arr, $client_arr, $this->my_arr, $this->option_arr, PJ_SALT, $this->getLocaleId());
						
					$incoive = str_replace($tokens['search'], $tokens['replace'], $this->option_arr['o_print_template']);
						
					$this->set('invoice', $incoive);
				}
			}
		}else if (!isset($_GET['err'])) {
			$this->set('status', 1);
		}
	}
	
	public function pjActionGetCurrencySign()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			echo  pjUtil::formatCurrencySign(NULL, $_GET['currency'], "");
		}
		exit;
	}
	
	public function pjActionGetContent()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$arr = pjInvoiceModel::factory()->find($_GET['id'])->getData();
			$client = pjClientModel::factory()->find($arr['client_id'])->getData();
			
			$tokens = pjAppController::getTokens($arr, $client, $this->my_arr, $this->option_arr, PJ_SALT, $this->getLocaleId());
			if($arr['status'] == 'cancelled' || $arr['status'] == 'new')
			{
				$invoice = str_replace($tokens['search'], $tokens['replace'], $this->option_arr['o_new_invoice_template']);
			}else{
				$invoice = str_replace($tokens['search'], $tokens['replace'], $this->option_arr['o_paid_invoice_template']);
			}
			$subject = $this->option_arr['o_new_invoice_subject'];
			if($arr['status'] == 'paid')
			{
				$subject = $this->option_arr['o_paid_invoice_subject'];
			}
			$this->set('arr', $arr);
			$this->set('client', $client);
			$this->set('invoice', $invoice);
			$this->set('subject', $subject);
		}
	}
	
	public function pjActionDuplicate()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$response = array();
			
			$pjInvoiceModel = pjInvoiceModel::factory();
			$pjProductModel = pjProductModel::factory();
			
			$arr = $pjInvoiceModel->find($_GET['id'])->getData();
			$product_arr = $pjProductModel
				->where('t1.invoice_id', $_GET['id'])
				->findAll()
				->getData();
			
			unset($arr['id']);
			unset($arr['modified']);
			
			$data = array();
			$data['created'] = date('Y-m-d H:i:s');
			$data['user_id'] = $this->getUserId();
			
			$id = $pjInvoiceModel->reset()->setAttributes(array_merge($arr, $data))->insert()->getInsertId();
			
			if ($id !== false && (int) $id > 0)
			{
				if(isset($product_arr) && count($product_arr))
				{
					$pjProductModel = pjProductModel::factory();
					$pjProductModel->begin();
					foreach($product_arr as $k => $v)
					{
						$pdata = array();
						$pdata['invoice_id'] = $id;
						$pdata['product_title'] = $v['product_title'];
						$pdata['price'] = $v['price'];
						$pdata['quantity'] = $v['quantity'];
						$pjProductModel->reset()->setAttributes($pdata)->insert();
					}
					$pjProductModel->commit();
				}
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
			exit;	
		}
	}
	
	public function pjActionGetRecurringDate()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$date_issued = pjUtil::formatDate($_GET['date_issued'], $this->option_arr['o_date_format']);
			$this->set('recurring_date', pjUtil::getRecurringDate($date_issued, $_GET['recurring']));
		}
	}
	
	public function pjActionSend()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$to = $_POST['to'];
			$subject = $_POST['subject'];
			$message = $_POST['message'];
			
			$pjEmail = new pjEmail();
			
			if ($this->option_arr['o_send_email'] == 'smtp')
			{
				$pjEmail
					->setTransport('smtp')
					->setSmtpHost($this->option_arr['o_smtp_host'])
					->setSmtpPort($this->option_arr['o_smtp_port'])
					->setSmtpUser($this->option_arr['o_smtp_user'])
					->setSmtpPass($this->option_arr['o_smtp_pass'])
					->setSender($this->option_arr['o_smtp_user']);
			}
			
			$from = $this->getAdminEmail();
			
			$pjEmail->setContentType('text/html');
			$pjEmail->setTo($to);
			$pjEmail->setFrom($from);
			$pjEmail->setSubject($subject);
			$pjEmail->send($message);
		}
		exit;
	}
}
?>