<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjAdminOptions extends pjAdmin
{
	public function pjActionIndex()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
			
			$this->set('arr', $arr);
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			if (isset($_POST['options_update']))
			{
				$OptionModel = new pjOptionModel();
				
				foreach ($_POST as $key => $value)
				{
					if (preg_match('/value-(string|text|int|float|enum|bool|color)-(.*)/', $key) === 1)
					{
						list(, $type, $k) = explode("-", $key);
						if (!empty($k))
						{
							$OptionModel
								->reset()
								->where('foreign_id', $this->getForeignId())
								->where('`key`', $k)
								->limit(1)
								->modifyAll(array('value' => $value));
							
						}
					}
				}
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], 1, 'pjOption', 'data');
				}
				
				$err = 'AO01';
				if (isset($_POST['next_action']))
				{
					switch ($_POST['next_action'])
					{
						case 'pjActionIndex':
							$err = 'AO01';
							break;
						case 'pjActionPayment':
							$err = 'AO02';
							break;
						case 'pjActionTemplate':
							$err = 'AO03';
							pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminOptions&action=" . @$_POST['next_action'] . "&opt=".$_POST['template']."&err=$err");
							break;
					}
				}
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminOptions&action=" . @$_POST['next_action'] . "&err=$err");
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionPayment()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			$pjOptionModel = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll();
	
			$this->set('arr', $pjOptionModel->getData());
			$this->set('o_arr', $pjOptionModel->getDataPair('key'));
	
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionTemplate()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			$pjOptionModel = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll();
	
			$this->set('arr', $pjOptionModel->getData());
			$this->set('o_arr', $pjOptionModel->getDataPair('key'));
	
			$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionCompany()
	{
		$this->checkLogin();
	
		if ($this->isAdmin())
		{
			$pjClientModel = pjClientModel::factory();
			if (isset($_POST['client_update']))
			{
				$data = array();
				$data['modified'] = date('Y-m-d H:i:s');
				$data = array_merge($_POST, $data);
	
				$pjClientModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll($data);
	
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminOptions&action=pjActionCompany&tab_id=".$_POST['tab_id']."&err=AO04");
	
			} else {
				$arr = $pjClientModel->find(1)->getData();
	
				$country_arr = pjCountryModel::factory()
					->select('t1.*, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('status', 'T')
					->orderBy('country_title ASC')
					->findAll()
					->getData();
				
				$this->set('arr', $arr);
				$this->set('country_arr', $country_arr);
	
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminClients.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>