<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminReports extends pjAdmin
{
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$date_from = date('Y-m-01', time());
			$date_to = date('Y-m-t', time());
			
			if(isset($_POST['report']))
			{
				$date_from = pjUtil::formatDate($_POST['date_from'], $this->option_arr['o_date_format']);
				$date_to = pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']);
			}	
			$pjInvoiceModel = pjInvoiceModel::factory();
			$_invoice_arr = $pjInvoiceModel
				->where("t1.date_issued BETWEEN '$date_from' AND '$date_to'")
				->findAll()
				->getData();

			$invoice_arr = array();
			$currency_arr = array();
			foreach($_invoice_arr as $k => $v)
			{
				if(!in_array($v['currency'], $currency_arr))
				{
					$currency_arr[] = $v['currency'];
				}
				if (!isset($invoice_arr[$v['status']]))
				{
					$invoice_arr[$v['status']] = array();
				}
				if (!isset($invoice_arr[$v['status']][$v['currency']]))
				{
					$invoice_arr[$v['status']][$v['currency']] = array('cnt' => 0, 'amount' => 0);
				}
				$invoice_arr[$v['status']][$v['currency']]['cnt'] += 1;
				$invoice_arr[$v['status']][$v['currency']]['amount'] += $v['total'];
			}
			
			$this->set('cnt_invoices', count($_invoice_arr));
			$this->set('invoice_arr', $invoice_arr);
			$this->set('currency_arr', $currency_arr);
			
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminReports.js');
		} else {
			$this->set('status', 2);
		}
	}
}
?>