<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjAppController extends pjController
{
	public $models = array();

	public $defaultLocale = 'admin_locale_id';
	
	public $defaultFields = 'fields';
	
	public $defaultFieldsIndex = 'fields_index';
	
	protected function loadSetFields($force=FALSE)
	{
		$registry = pjRegistry::getInstance();
		if ($force
				|| !isset($_SESSION[$this->defaultFieldsIndex])
				|| $_SESSION[$this->defaultFieldsIndex] != $this->option_arr['o_fields_index']
				|| !isset($_SESSION[$this->defaultFields])
				|| empty($_SESSION[$this->defaultFields]))
		{
			pjAppController::setFields($this->getLocaleId());
	
			if ($registry->is('fields'))
			{
				$_SESSION[$this->defaultFields] = $registry->get('fields');
			}
			$_SESSION[$this->defaultFieldsIndex] = $this->option_arr['o_fields_index'];
		}
	
		if (isset($_SESSION[$this->defaultFields]) && !empty($_SESSION[$this->defaultFields]))
		{
			$registry->set('fields', $_SESSION[$this->defaultFields]);
		}
			
		return TRUE;
	}
	
	public function isEditor()
    {
   		return $this->getRoleId() == 2;
    }
    public function isClient()
    {
    	if(isset($_SESSION[$this->defaultUser]))
    	{
    		$client = $_SESSION[$this->defaultUser];
    		if(isset($client['is_client']))
    		{
    			return true;
    		}else{
    			return false;
    		}
    	}else{
    		return false;
    	}
    }
    public function isCountryReady()
    {
    	return $this->isAdmin();
    }
	public function isOneAdminReady()
    {
    	return $this->isAdmin();
    }
	
	public static function setTimezone($timezone="UTC")
    {
    	if (in_array(version_compare(phpversion(), '5.1.0'), array(0,1)))
		{
			date_default_timezone_set($timezone);
		} else {
			$safe_mode = ini_get('safe_mode');
			if ($safe_mode)
			{
				putenv("TZ=".$timezone);
			}
		}
    }

	public static function setMySQLServerTime($offset="-0:00")
    {
    	pjAppModel::factory()->prepare("SET SESSION time_zone = :offset;")->exec(compact('offset'));
    }
    
	public function setTime()
	{
		if (isset($this->option_arr['o_timezone']))
		{
			$offset = $this->option_arr['o_timezone'] / 3600;
			if ($offset > 0)
			{
				$offset = "-".$offset;
			} elseif ($offset < 0) {
				$offset = "+".abs($offset);
			} elseif ($offset === 0) {
				$offset = "+0";
			}
	
			pjAppController::setTimezone('Etc/GMT' . $offset);
			if (strpos($offset, '-') !== false)
			{
				$offset = str_replace('-', '+', $offset);
			} elseif (strpos($offset, '+') !== false) {
				$offset = str_replace('+', '-', $offset);
			}
			pjAppController::setMySQLServerTime($offset . ":00");
		}
	}
    
    public function beforeFilter()
    {
    	$this->appendJs('jquery.min.js', PJ_THIRD_PARTY_PATH . 'jquery/');
    	$baseDir = defined("PJ_INSTALL_PATH") ? PJ_INSTALL_PATH : null;
		$dm = new pjDependencyManager($baseDir, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
		$this->appendJs('jquery-migrate.min.js', $dm->getPath('jquery_migrate'), FALSE, FALSE);
		$this->appendJs('pjAdminCore.js');
		$this->appendCss('reset.css');
		 
		$this->appendJs('js/jquery-ui.custom.min.js', PJ_THIRD_PARTY_PATH . 'jquery_ui/');
		$this->appendCss('css/smoothness/jquery-ui.min.css', PJ_THIRD_PARTY_PATH . 'jquery_ui/');
				
		$this->appendCss('pj-all.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('admin.css');
				
    	if ($_GET['controller'] != 'pjInstaller')
		{
			$this->models['Option'] = pjOptionModel::factory();
			$this->option_arr = $this->models['Option']->getPairs($this->getForeignId());
			$this->set('option_arr', $this->option_arr);
			$this->setTime();
			
			if (!isset($_SESSION[$this->defaultLocale])) {
				$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
				if (count($locale_arr) === 1){
					$this->setLocaleId($locale_arr[0]['id']);
				}
			}
			
			$this->my_arr = pjClientModel::factory()->find(1)->getData();
			$this->set('my_arr', $this->my_arr);
			
			if (!in_array($_GET['action'], array()))
			{
				$this->loadSetFields(true);
			}
		}
    }
	public function pjActionCheckInstall()
	{
		$this->setLayout('pjActionEmpty');
		
		$result = array('status' => 'OK', 'code' => 200, 'text' => 'Operation succeeded', 'info' => array());
		$folders = array(
			
		);
		foreach ($folders as $dir)
		{
			if (!is_writable($dir))
			{
				$result['status'] = 'ERR';
				$result['code'] = 101;
				$result['text'] = 'Permission requirement';
				$result['info'][] = sprintf('Folder \'<span class="bold">%1$s</span>\' is not writable. You need to set write permissions (chmod 777) to directory located at \'<span class="bold">%1$s</span>\'', $dir);
			}
		}
		
		return $result;
	}
	
    public function getForeignId()
    {
    	return 1;
    }
    
    public static function setFields($locale)
    {
   	 	if(isset($_SESSION['lang_show_id']) && (int) $_SESSION['lang_show_id'] == 1)
		{
			$fields = pjMultiLangModel::factory()
				->select('CONCAT(t1.content, CONCAT(":", t2.id, ":")) AS content, t2.key')
				->join('pjField', "t2.id=t1.foreign_id", 'inner')
				->where('t1.locale', $locale)
				->where('t1.model', 'pjField')
				->where('t1.field', 'title')
				->findAll()
				->getDataPair('key', 'content');
		}else{
			$fields = pjMultiLangModel::factory()
				->select('t1.content, t2.key')
				->join('pjField', "t2.id=t1.foreign_id", 'inner')
				->where('t1.locale', $locale)
				->where('t1.model', 'pjField')
				->where('t1.field', 'title')
				->findAll()
				->getDataPair('key', 'content');
		}
		$registry = pjRegistry::getInstance();
		$tmp = array();
		if ($registry->is('fields'))
		{
			$tmp = $registry->get('fields');
		}
		$arrays = array();
		foreach ($fields as $key => $value)
		{
			if (strpos($key, '_ARRAY_') !== false)
			{
				list($prefix, $suffix) = explode("_ARRAY_", $key);
				if (!isset($arrays[$prefix]))
				{
					$arrays[$prefix] = array();
				}
				$arrays[$prefix][$suffix] = $value;
			}
		}
		require PJ_CONFIG_PATH . 'settings.inc.php';
		$fields = array_merge($tmp, $fields, $settings, $arrays);
		$registry->set('fields', $fields);
    }

    public static function jsonDecode($str)
	{
		$Services_JSON = new pjServices_JSON();
		return $Services_JSON->decode($str);
	}
	
	public static function jsonEncode($arr)
	{
		$Services_JSON = new pjServices_JSON();
		return $Services_JSON->encode($arr);
	}
	
	public static function jsonResponse($arr)
	{
		header("Content-Type: application/json; charset=utf-8");
		echo pjAppController::jsonEncode($arr);
		exit;
	}

	public function getLocaleId()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : false;
	}
	
	public function setLocaleId($locale_id)
	{
		$_SESSION[$this->defaultLocale] = (int) $locale_id;
	}
	
	public function friendlyURL($str, $divider='-')
	{
		$str = mb_strtolower($str, mb_detect_encoding($str));
		$str = trim($str);
		$str = preg_replace('/[_|\s]+/', $divider, $str);
		$str = preg_replace('/\x{00C5}/u', 'AA', $str);
		$str = preg_replace('/\x{00C6}/u', 'AE', $str);
		$str = preg_replace('/\x{00D8}/u', 'OE', $str);
		$str = preg_replace('/\x{00E5}/u', 'aa', $str);
		$str = preg_replace('/\x{00E6}/u', 'ae', $str);
		$str = preg_replace('/\x{00F8}/u', 'oe', $str);
		$str = preg_replace('/[^a-z\x{0400}-\x{04FF}0-9-]+/u', '', $str);
		$str = preg_replace('/[-]+/', $divider, $str);
		$str = preg_replace('/^-+|-+$/', '', $str);
		return $str;
	}
	
	static public function getAdminEmail()
	{
		$arr = pjUserModel::factory()
			->findAll()
			->orderBy("t1.id ASC")
			->limit(1)
			->getData();
		return !empty($arr) ? $arr[0]['email'] : null;
	}
	
	static public function getAdminPhone()
	{
		$arr = pjUserModel::factory()
			->findAll()
			->orderBy("t1.id ASC")
			->limit(1)
			->getData();
		return !empty($arr) ? (!empty($arr[0]['phone']) ? $arr[0]['phone'] : null) : null;
	}
	
	public function loadCSV($file)
	{
		$pjUpload = new pjUpload();
		$pjUpload->setAllowedExt(array('csv'));
	
		$data = array();
		if ($pjUpload->load($file))
		{
			$filename = $pjUpload->getFile('tmp_name');
			$i = 1;
			if (($handle = fopen($filename, "r")) !== FALSE)
			{
				while (($values = fgetcsv($handle, 1000, ",")) !== FALSE)
				{
					if ($i == 1)
					{
						$keys = $values;
					} else {
						$data[] = array_combine($keys, $values);
					}
					$i++;
				}
				fclose($handle);
			}
		}
		return $data;
	}
	
	static public function getTokens($arr, $client_arr, $my_arr, $option_arr, $salt, $locale_id)
	{
		$client_country = NULL;
		$my_country = NULL;
		$client_name = NULL;
		$my_name = NULL;
		$invoice_desciption = NULL;
		$client_name_arr = array();
		$my_name_arr = array();
		$invoice_desciption_arr = NULL;
		
		$personal_titles = __('personal_titles', true);
		$payment_methods = __('payment_methods', true);
		$invoice_status = __('invoice_status', true);
		
		$client_title = $personal_titles[$client_arr['title']];
		$my_title = !empty($my_arr['title']) ? $personal_titles[$my_arr['title']] : NULL;
		$payment_method = !empty($arr['payment_method']) ? $payment_methods[$arr['payment_method']] : NULL;
		
		if(!empty($client_arr['first_name']))
		{
			$client_name_arr[] = $client_arr['first_name'];
		}
		if(!empty($client_arr['last_name']))
		{
			$client_name_arr[] = $client_arr['last_name'];
		}
		if(!empty($my_arr['first_name']))
		{
			$my_name_arr[] = $my_arr['first_name'];
		}
		if(!empty($my_arr['last_name']))
		{
			$my_name_arr[] = $my_arr['last_name'];
		}
		$client_name = implode(" ", $client_name_arr);
		$my_name = implode(" ", $my_name_arr);
		
		$pjCountryModel = pjCountryModel::factory();
		if (isset($client_arr['country_id']) && !empty($client_arr['country_id']))
		{
			if(isset($client_arr['country_id']) && (int) $client_arr['country_id'] > 0)
			{
				$country_arr = $pjCountryModel
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
					->find($client_arr['country_id'])
					->getData();
				if (!empty($country_arr))
				{
					$client_country = $country_arr['country_title'];
				}
			}
		}
		if (isset($my_arr['country_id']) && !empty($my_arr['country_id']))
		{
			if(isset($my_arr['country_id']) && (int) $my_arr['country_id'] > 0)
			{
				$country_arr = $pjCountryModel
					->reset()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
					->find($my_arr['country_id'])
					->getData();
				if (!empty($country_arr))
				{
					$my_country = $country_arr['country_title'];
				}
			}
		}
		
		$amount = pjUtil::formatCurrencySign($arr['amount'], $arr['currency']);
		$vat = $arr['vat'] . '%';
		$vat_amount = ($arr['vat'] * $arr['amount']) / 100;
		$vat_amount = pjUtil::formatCurrencySign(number_format($vat_amount, 2), $arr['currency']);
		$total = pjUtil::formatCurrencySign($arr['total'], $arr['currency']);
		$payment_fee = $arr['payment_fee'] != '' ? pjUtil::formatCurrencySign($arr['payment_fee'], $arr['currency']) : NULL;
	
		$date_issued = date($option_arr['o_date_format'], strtotime($arr['date_issued']));
		$date_paid = !empty($arr['processed_on']) ? date($option_arr['o_date_format'], strtotime($arr['processed_on'])) : NULL;
		
		$viewURL = PJ_INSTALL_URL . 'index.php?controller=pjAdminInvoices&action=pjActionView&id='.@$arr['id'].'&hash='.sha1(@$arr['id'].@$arr['created'].$salt);
		$printURL = PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionPrint&id='.@$arr['id'].'&hash='.sha1(@$arr['id'].@$arr['created'].$salt);
		$payURL = PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionPay&id='.@$arr['id'].'&hash='.sha1(@$arr['id'].@$arr['created'].$salt);
		
		$viewURL = '<a href="'.$viewURL.'">'.$viewURL.'</a>';
		$printURL = '<a href="'.$printURL.'">'.$printURL.'</a>';
		$payURL = '<a href="'.$payURL.'">'.$payURL.'</a>';
		
		$product_arr = pjProductModel::factory()
			->where('t1.invoice_id', $arr['id'])
			->findAll()
			->getData();
		foreach($product_arr as $v)
		{
			$invoice_desciption_arr[] = '<tr><td>'.$v['product_title'].'</td><td>'.pjUtil::formatCurrencySign($v['price'], $arr['currency']).'</td><td>'.$v['quantity'].'</td></tr>';
		}
		$invoice_desciption = '<table style="width: 100%;">
									<tr>
										<td>'.__('lblProductName', true).'</td>
										<td>'.__('lblPrice', true).'</td>
										<td>'.__('lblQuantity', true).'</td>
									</tr>
									'.implode("", $invoice_desciption_arr).'	
							   </table>';
		$search = array(
				'{INVOICE_VIEW}',
				'{INVOICE_PRINT}',
				'{INVOICE_PAY}',
				'{INVOICE_NUMBER}',
				'{INVOICE_STATUS}',
				'{INVOICE_CLIENT}',
				'{INVOICE_DATE_ISSUED}',
				'{INVOICE_AMOUNT}',
				'{INVOICE_DESCRIPTION}',
				'{INVOICE_DATE_PAID}',
				'{INVOICE_PAYMENT_ID}',
				'{INVOICE_PAYMENT_FEE}',
				'{INVOICE_PAYMENT_TYPE}',
				'{INVOICE_NOTES}',
				'{INVOICE_VAT}',
				'{INVOICE_VAT_AMOUNT}',
				'{INVOICE_TOTAL}',
				
				'{CLIENT_TITLE}',
				'{CLIENT_FNAME}',
				'{CLIENT_LNAME}',
				'{CLIENT_FULL_NAME}',
				'{CLIENT_POSITION}',
				'{CLIENT_COMPANY_NAME}',
				'{CLIENT_COMPANY_VAT}',
				'{CLIENT_COMPANY_WEB}',
				'{CLIENT_ADDRESS}',
				'{CLIENT_CITY}',
				'{CLIENT_STATE}',
				'{CLIENT_COUNTRY}',
				'{CLIENT_ZIP}',
				'{CLIENT_PHONE}',
				'{CLIENT_FAX}',
				'{CLIENT_EMAIL}',
				'{CLIENT_NOTES}',
				
				'{MY_TITLE}',
				'{MY_FNAME}',
				'{MY_LNAME}',
				'{MY_FULL_NAME}',
				'{MY_POSITION}',
				'{MY_COMPANY_NAME}',
				'{MY_COMPANY_VAT}',
				'{MY_COMPANY_WEB}',
				'{MY_ADDRESS}',
				'{MY_CITY}',
				'{MY_STATE}',
				'{MY_COUNTRY}',
				'{MY_ZIP}',
				'{MY_PHONE}',
				'{MY_FAX}',
				'{MY_EMAIL}',
				'{MY_NOTES}'
		);
		$replace = array(
				$viewURL,
				$printURL,
				$payURL,
				@$arr['invoice_number'],
				$invoice_status[$arr['status']],
				$client_name,
				$date_issued,
				$amount,
				$invoice_desciption,
				$date_paid,
				@$arr['txn_id'],
				$payment_fee,
				$payment_method,
				nl2br(@$arr['notes']),
				$vat,
				$vat_amount,
				$total,
				
				$client_title,
				@$client_arr['first_name'],
				@$client_arr['last_name'],
				$client_name,
				@$client_arr['position'],
				@$client_arr['company_name'],
				@$client_arr['vat_number'],
				@$client_arr['website'],
				@$client_arr['address'],
				@$client_arr['city'],
				@$client_arr['state'],
				$client_country,
				@$client_arr['zip'],
				@$client_arr['phone'],
				@$client_arr['fax'],
				@$client_arr['email'],
				nl2br(@$client_arr['notes']),
				
				$my_title,
				@$my_arr['first_name'],
				@$my_arr['last_name'],
				$my_name,
				@$my_arr['position'],
				@$my_arr['company_name'],
				@$my_arr['vat_number'],
				@$my_arr['website'],
				@$my_arr['address'],
				@$my_arr['city'],
				@$my_arr['state'],
				$my_country,
				@$my_arr['zip'],
				@$my_arr['phone'],
				@$my_arr['fax'],
				@$my_arr['email'],
				nl2br(@$my_arr['notes'])
		);
		return compact('search', 'replace');
	}
}
?>