<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjCron extends pjAppController
{
	public function pjActionIndex()
	{
		$this->setLayout('pjActionEmpty');
	
		set_time_limit(0);
	
		$pjInvoiceModel = pjInvoiceModel::factory();
		$pjProductModel = pjProductModel::factory();
		
		$arr = $pjInvoiceModel->where("recurring_date = CURDATE()")->findAll()->getData();
		
		foreach($arr as $invoice)
		{
			$invoice_id = $invoice['id'];
			$recurring_date = pjUtil::getRecurringDate($invoice['recurring_date'], $invoice['recurring']);
			$number_of_recurring = $pjInvoiceModel->reset()->where('t1.invoice_id', $invoice['id'])->findCount()->getData();
			$count = $number_of_recurring + 1;
			
			$invoice['created'] = date('Y-m-d H:i:s');
			$invoice['date_issued'] = date('Y-m-d');
			$invoice['invoice_number'] = $invoice['invoice_number'] . "-" . $count;
			$invoice['status'] = 'new';
			$invoice['recurring'] = ':NULL';
			$invoice['recurring_date'] = ':NULL';
			$invoice['modified'] = ':NULL';
			unset($invoice['id']);
			$id = $pjInvoiceModel->reset()->setAttributes($invoice)->insert()->getInsertId();
			
			if ($id !== false && (int) $id > 0)
			{
				$product_arr = $pjProductModel
					->reset()
					->where('invoice_id', $invoice_id)
					->findAll()
					->getData();
				if(count($product_arr) > 0)
				{
					$pjProductModel->begin();
					foreach($product_arr as $product)
					{
						$pdata = array();
						$pdata['invoice_id'] = $id;
						$pdata['product_title'] = $product['product_title'];
						$pdata['price'] = $product['price'];
						$pdata['quantity'] = $product['quantity'];
						$pjProductModel->reset()->setAttributes($pdata)->insert();
					}
					$pjProductModel->commit();
				}
			}
			
			$data = array();
			$data['recurring_date'] = $recurring_date;
			$pjInvoiceModel->reset()->where('id', $invoice_id)->limit(1)->modifyAll($data);
		}
		exit;
	}
}
?>