<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'StivaSoftCaptcha';
	
	public $defaultLocale = 'front_locale_id';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
	}
	
	public function afterFilter()
	{
		if (!isset($_GET['hide']) || (isset($_GET['hide']) && (int) $_GET['hide'] !== 1) &&
			in_array($_GET['action'], array()))
		{
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$this->set('locale_arr', $locale_arr);
		}
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		$this->my_arr = pjClientModel::factory()->find(1)->getData();
		$this->set('my_arr', $this->my_arr);
		
		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		if (!in_array($_GET['action'], array('pjActionLoadCss')))
		{
			$this->loadSetFields(true);
		}
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH.'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
				
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
	}
	
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				
				$this->loadSetFields(true);
				
				$day_names = __('day_names', true);
				ksort($day_names, SORT_NUMERIC);
				
				$months = __('months', true);
				ksort($months, SORT_NUMERIC);
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Locale have been changed.', 'opts' => array(
					'day_names' => array_values($day_names),
					'month_names' => array_values($months)
				)));
			}
		}
		exit;
	}
	
	public function pjActionSetLocale()
	{
		$this->setLocaleId(@$_GET['locale']);
		pjUtil::redirect($_SERVER['HTTP_REFERER']);
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	public function pjActionPrint()
	{
		if (isset($_GET['hash']) && isset($_GET['id']))
		{
			$pjInvoiceModel = pjInvoiceModel::factory();
	
			$arr = $pjInvoiceModel->find($_GET['id'])->getData();
			if (count($arr) == 0)
			{
				$this->set('status', 2);
			}else{
				$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
				if ($_GET['hash'] != $hash)
				{
					$this->set('status', 3);
				}else{
					$pjClientModel = pjClientModel::factory();
					$client_id = $arr['client_id'];
					$client_arr = $pjClientModel->find($arr['client_id'])->getData();
	
					$tokens = pjAppController::getTokens($arr, $client_arr, $this->my_arr, $this->option_arr, PJ_SALT, $this->getLocaleId());
	
					$incoive = str_replace($tokens['search'], $tokens['replace'], $this->option_arr['o_print_template']);
	
					$this->set('invoice', $incoive);
					
					$this->setLayout('pjActionPrint');
				}
			}
		}else if (!isset($_GET['err'])) {
			$this->set('status', 1);
		}
	}
	
	public function pjActionPay()
	{
		if (isset($_GET['hash']) && isset($_GET['id']))
		{
			$pjInvoiceModel = pjInvoiceModel::factory();
		
			$arr = $pjInvoiceModel->find($_GET['id'])->getData();
			if (count($arr) == 0)
			{
				$this->set('status', 2);
			}else{
				$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
				if ($_GET['hash'] != $hash)
				{
					$this->set('status', 3);
				}else{
					
					$pjClientModel = pjClientModel::factory();
					$client_id = $arr['client_id'];
					$client_arr = $pjClientModel->find($arr['client_id'])->getData();
		
					$tokens = pjAppController::getTokens($arr, $client_arr, $this->my_arr, $this->option_arr, PJ_SALT, $this->getLocaleId());
		
					$incoive = str_replace($tokens['search'], $tokens['replace'], $this->option_arr['o_payment_template']);
		
					$this->set('invoice', $incoive);
					$this->set('arr', $arr);
					
					$this->appendJs('jquery.min.js', PJ_THIRD_PARTY_PATH . 'jquery/');
					$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
					$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
					$this->appendJs('jquery-migrate.min.js', $dm->getPath('jquery_migrate'), FALSE, FALSE);
					$this->appendJs('pjFront.js');
				}
			}
		}else if (!isset($_GET['err'])) {
			$this->set('status', 1);
		}
	}
	
	public function pjActionThankyou()
	{
		
	}
	
	public function pjActionSavePayment()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$pjInvoiceModel = pjInvoiceModel::factory();
			$data = array();
			if($_POST['payment_method'] != 'creditcard')
			{
				$data['cc_type'] = ':NULL';
				$data['cc_num'] = ':NULL';
				$data['cc_exp_month'] = ':NULL';
				$data['cc_exp_year'] = ':NULL';
				$data['cc_code'] = ':NULL';
			}
			$pjInvoiceModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
			$arr = $pjInvoiceModel->reset()->find($_POST['id'])->getData();
			
			$json = array('code' => 200, 'text' => '', 'id' => $arr['id'], 'payment' => $_POST['payment_method']);
			pjAppController::jsonResponse($json);
			exit;
		}
	}
	
	public function pjActionGetPaymentForm()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$arr = pjInvoiceModel::factory()->find($_GET['id'])->getData();
				
			if (!empty($arr))
			{
				switch ($arr['payment_method'])
				{
					case 'paypal':
						$this->set('params', array(
								'name' => 'imPaypal',
								'id' => 'imPaypal',
								'business' => $this->option_arr['o_paypal_address'],
								'item_name' => pjSanitize::html($arr['invoice_number']),
								'custom' => $arr['id'],
								'amount' => $arr['total'],
								'currency_code' => $arr['currency'],
								'return' => PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionThankyou',
								'notify_url' => PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionConfirmPaypal',
								'target' => '_self',
								'charset' => 'utf-8'
						));
						break;
					case 'authorize':
						$this->set('params', array(
								'name' => 'imAuthorize',
								'id' => 'imAuthorize',
								'target' => '_self',
								'timezone' => $this->option_arr['o_authorize_timezone'],
								'transkey' => $this->option_arr['o_authorize_transkey'],
								'x_login' => $this->option_arr['o_authorize_merchant_id'],
								'x_description' => pjSanitize::html($arr['invoice_number']),
								'x_amount' => $arr['total'],
								'x_invoice_num' => $arr['id'],
								'x_receipt_link_url' => PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionThankyou',
								'x_relay_url' => PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionConfirmAuthorize'
						));
						break;
				}
			}
			$this->set('arr', $arr);
			$this->set('get', $_GET);
		}
	}
	
	public function pjActionConfirmAuthorize()
	{
		$this->setAjax(true);
	
		if (pjObject::getPlugin('pjAuthorize') === NULL)
		{
			$this->log('Authorize.NET plugin not installed');
			exit;
		}
		$pjInvoiceModel = pjInvoiceModel::factory();
	
		$invoice_arr = $pjInvoiceModel
			->find($_POST['x_invoice_num'])
			->getData();
		if (count($invoice_arr) == 0)
		{
			$this->log('No such invoice');
			pjUtil::redirect(PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionThankyou');
		}
	
		if (count($invoice_arr) > 0)
		{
			$params = array(
					'transkey' => $this->option_arr['o_authorize_transkey'],
					'x_login' => $this->option_arr['o_authorize_merchant_id'],
					'md5_setting' => $this->option_arr['o_authorize_md5_hash'],
					'key' => md5($this->option_arr['private_key'] . PJ_SALT)
			);
				
			$response = $this->requestAction(array('controller' => 'pjAuthorize', 'action' => 'pjActionConfirm', 'params' => $params), array('return'));
			if ($response !== FALSE && $response['status'] === 'OK')
			{
				$pjInvoiceModel->reset()
					->setAttributes(array('id' => $response['transaction_id']))
					->modify(array('status' => 'paid', 'processed_on' => ':NOW()'));
				
				pjFront::pjActionConfirmSend($this->option_arr, $invoice_arr, PJ_SALT, $this->getLocaleId());
				
			} elseif (!$response) {
				$this->log('Authorization failed');
			} else {
				$this->log('Booking not confirmed. ' . $response['response_reason_text']);
			}
			pjUtil::redirect(PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionThankyou');
		}
	}
	
	public function pjActionConfirmPaypal()
	{
		$this->setAjax(true);
	
		if (pjObject::getPlugin('pjPaypal') === NULL)
		{
			$this->log('Paypal plugin not installed');
			exit;
		}
		$pjInvoiceModel = pjInvoiceModel::factory();
	
		$invoice_arr = $pjInvoiceModel
			->find($_POST['custom'])
			->getData();
		if (count($invoice_arr) == 0)
		{
			$this->log('No such booking');
			pjUtil::redirect(PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionThankyou');
		}
	
		$params = array(
				'txn_id' => @$invoice_arr['txn_id'],
				'paypal_address' => $this->option_arr['o_paypal_address'],
				'deposit' => @$invoice_arr['total'],
				'currency' => $invoice_arr['currency'],
				'key' => md5($this->option_arr['private_key'] . PJ_SALT)
		);
		$response = $this->requestAction(array('controller' => 'pjPaypal', 'action' => 'pjActionConfirm', 'params' => $params), array('return'));
	
		if ($response !== FALSE && $response['status'] === 'OK')
		{
			$this->log('Invoice confirmed');
			$pjInvoiceModel->reset()->setAttributes(array('id' => $invoice_arr['id']))->modify(array(
					'status' => 'paid',
					'txn_id' => $response['transaction_id'],
					'processed_on' => ':NOW()'
			));
			pjFront::pjActionConfirmSend($this->option_arr, $invoice_arr, PJ_SALT, $this->getLocaleId());
				
		} elseif (!$response) {
			$this->log('Paypal failed');
		} else {
			$this->log('Invoice not confirmed');
		}
		pjUtil::redirect(PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionThankyou');
	}
	
	public function pjActionConfirmSend($option_arr, $invoice_arr, $salt, $locale_id)
	{
		$Email = new pjEmail();
		if ($option_arr['o_send_email'] == 'smtp')
		{
			$Email
				->setTransport('smtp')
				->setSmtpHost($option_arr['o_smtp_host'])
				->setSmtpPort($option_arr['o_smtp_port'])
				->setSmtpUser($option_arr['o_smtp_user'])
				->setSmtpPass($option_arr['o_smtp_pass'])
				->setSender($option_arr['o_smtp_user'])
			;
		}
		$Email->setContentType('text/html');
		
		$admin_email = $this->getAdminEmail();
		$from_email = $admin_email;
		
		$pjClientModel = pjClientModel::factory();
		$client_id = $invoice_arr['client_id'];
		$client_arr = $pjClientModel->find($invoice_arr['client_id'])->getData();
		
		$tokens = pjAppController::getTokens($invoice_arr, $client_arr, $this->my_arr, $option_arr, PJ_SALT, $locale_id);

		$subject = $option_arr['o_paid_invoice_subject'];
		$message = str_replace($tokens['search'], $tokens['replace'], $option_arr['o_paid_invoice_template']);
	
		if (!empty($subject) && !empty($message))
		{
			if(!empty($client_arr['email']))
			{
				$Email
					->setTo($client_arr['email'])
					->setFrom($from_email)
					->setSubject($subject)
					->send($message);
			}
			$Email
				->setTo($from_email)
				->setFrom($from_email)
				->setSubject($subject)
				->send($message);
		}
	}
}
?>