<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	include_once PJ_VIEWS_PATH . 'pjAdminClients/elements/menu.php';
	pjUtil::printNotice(__('infoUpdateClientTitle', true, false), __('infoUpdateClientDesc', true, false));
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate" method="post" id="frmUpdateClient" class="form pj-form" autocomplete="off">
		<input type="hidden" name="client_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabPersonalDetails');?></a></li>
				<li><a href="#tabs-2"><?php __('tabCompanyDetails');?></a></li>
				<li><a href="#tabs-3"><?php __('tabContactDetails');?></a></li>
				<li><a href="#tabs-4"><?php __('tabNotes');?></a></li>
				<?php
				if($tpl['cnt_invoices'] > 0)
				{
					?><li><a href="#tabs-5"><?php __('lblInvoicesSummary');?></a></li><?php
				}
				?>
			</ul>
			<div id="tabs-1">
				<p>
					<label class="title"><?php __('lblInvoices');?></label>
					<span class="inline-block">
						<?php
						if($tpl['cnt_invoices'] > 0)
						{ 
							?>
							<label class="block t5"><?php echo $tpl['cnt_invoices'];?> (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminInvoices&amp;action=pjActionIndex&amp;client_id=<?php echo $tpl['arr']['id'];?>"><?php __('lblInvoices');?></a> / <a href="#" class="pjImViewInvoices"><?php __('lblSummary');?></a>)</label>
							<?php
						}else{
							?>
							<label class="block t5"><?php echo $tpl['cnt_invoices'];?></label>
							<?php
						} 
						?>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblClientTitle'); ?></label>
					<span class="inline-block">
						<select name="title" id="title" class="pj-form-field w150 required" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ( __('personal_titles', true, false) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['title'] == $k ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblFirstName'); ?></label>
					<span class="inline-block">
						<input type="text" name="first_name" id="first_name" value="<?php echo pjSanitize::html($tpl['arr']['first_name']);?>" class="pj-form-field w300 required" data-msg-required="<?php __('lblFieldRequired');?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblLastName'); ?></label>
					<span class="inline-block">
						<input type="text" name="last_name" id="last_name" value="<?php echo pjSanitize::html($tpl['arr']['last_name']);?>" class="pj-form-field w300 required" data-msg-required="<?php __('lblFieldRequired');?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('email'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
						<input type="text" name="email" id="email" value="<?php echo pjSanitize::html($tpl['arr']['email']);?>" class="pj-form-field required email w300" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-email="<?php __('lblEmailInvalid');?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('pass'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
						<input type="password" name="password" id="password" class="pj-form-field required w200" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['password'])); ?>" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblPosition'); ?></label>
					<span class="inline_block">
						<input type="text" name="position" id="position" value="<?php echo pjSanitize::html($tpl['arr']['position']);?>" class="pj-form-field w300" />
					</span>				
				</p>
				<p>
					<label class="title"><?php __('lblStatus'); ?></label>
					<span class="inline_block">
						<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('u_statarr', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : null;?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminClients&action=pjActionIndex';" />
				</p>
			</div><!-- #tabs-1 -->
			<div id="tabs-2">
				<p>
					<label class="title"><?php __('lblCompanyName'); ?></label>
					<span class="inline_block">
						<input type="text" name="company_name" id="company_name" value="<?php echo pjSanitize::html($tpl['arr']['company_name']);?>" class="pj-form-field w300" />
					</span>				
				</p>
				<p>
					<label class="title"><?php __('lblVatNumber'); ?></label>
					<span class="inline_block">
						<input type="text" name="vat_number" id="vat_number" class="pj-form-field w300" value="<?php echo pjSanitize::html($tpl['arr']['vat_number']);?>"/>
					</span>				
				</p>
				<p>
					<label class="title"><?php __('lblWebsite'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
						<input type="text" name="website" id="website" class="pj-form-field w300" value="<?php echo pjSanitize::html($tpl['arr']['website']);?>"/>
					</span>				
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminClients&action=pjActionIndex';" />
				</p>
			</div><!-- #tabs-2 -->
			<div id="tabs-3">
				<p>
					<label class="title"><?php __('lblAddress'); ?></label>
					<span class="inline_block">
						<input type="text" name="address" id="address" class="pj-form-field w300" value="<?php echo pjSanitize::html($tpl['arr']['address']);?>"/>
					</span>				
				</p>
				<p>
					<label class="title"><?php __('lblCity'); ?></label>
					<span class="inline_block">
						<input type="text" name="city" id="city" class="pj-form-field w300" value="<?php echo pjSanitize::html($tpl['arr']['city']);?>"/>
					</span>				
				</p>
				<p>
					<label class="title"><?php __('lblState'); ?></label>
					<span class="inline_block">
						<input type="text" name="state" id="state" class="pj-form-field w300" value="<?php echo pjSanitize::html($tpl['arr']['state']);?>"/>
					</span>				
				</p>
				<p>
					<label class="title"><?php __('lblCountry'); ?></label>
					<span class="inline-block">
						<select name="country_id" id="country_id" class="pj-form-field w400">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['country_arr'] as $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo $tpl['arr']['country_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['country_title']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblZip'); ?></label>
					<span class="inline_block">
						<input type="text" name="zip" id="zip" value="<?php echo pjSanitize::html($tpl['arr']['zip']);?>" class="pj-form-field w300" />
					</span>				
				</p>
				<p>
					<label class="title"><?php __('lblPhone'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
						<input type="text" name="phone" id="phone" class="pj-form-field w300" value="<?php echo pjSanitize::html($tpl['arr']['phone']);?>"/>
					</span>				
				</p>
				<p>
					<label class="title"><?php __('lblFax'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
						<input type="text" name="fax" id="fax" class="pj-form-field w300" value="<?php echo pjSanitize::html($tpl['arr']['fax']);?>"/>
					</span>				
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminClients&action=pjActionIndex';" />
				</p>
			</div><!-- #tabs-3 -->
			<div id="tabs-4">
				<p>
					<label class="title"><?php __('lblNotes'); ?></label>
					<textarea name="notes" class="pj-form-field w500 h200"><?php echo stripslashes($tpl['arr']['notes']);?></textarea>		
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminClients&action=pjActionIndex';" />
				</p>
			</div><!-- #tabs-4 -->
			<?php
			if($tpl['cnt_invoices'] > 0)
			{ 
				$invoice_status = __('invoice_status', true);
				?>
				<div id="tabs-5">
					
					<div class="dContainer">
						<div class="dWrapper">
							<table class="pj-table dTable" cellpadding="0" cellspacing="0">
								<tbody>
									<tr>
										<td class="dHeadcol">&nbsp;</td>
										<?php
										foreach($tpl['currency_arr'] as $currency)
										{
											?><td colspan="2" class="dHead"><?php echo $currency; ?> </td><?php
										}
										?>
									</tr>
									<?php
									foreach($invoice_status as $k => $status)
									{
										?>
										<tr>
											<td class="dHeadcol"><?php echo $status; ?></td>
											<?php
											foreach($tpl['currency_arr'] as $currency)
											{
												$count = 0;
												$amount = 0;
												if(isset($tpl['invoice_arr'][$k][$currency]))
												{
													$count = $tpl['invoice_arr'][$k][$currency]['cnt'];
													$amount = $tpl['invoice_arr'][$k][$currency]['amount'];
													?>
													<td class="dSlot tdRight tdCount dSlot_<?php echo $k; ?>"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminInvoices&amp;action=pjActionIndex&amp;client_id=<?php echo $tpl['arr']['id']?>&amp;status=<?php echo $k;?>&amp;currency=<?php echo $currency;?>"><?php echo $count;?></a></td>
													<td class="dSlot tdRight dSlot_<?php echo $k; ?>"><?php echo pjUtil::formatCurrencySign(number_format($amount, 2), $currency);?></td>
													<?php
												}else{
													?>
													<td class="dSlot tdRight tdCount dSlot_<?php echo $k; ?>"><?php echo $count;?></td>
													<td class="dSlot tdRight dSlot_<?php echo $k; ?>"><?php echo pjUtil::formatCurrencySign(number_format($amount, 2), $currency);?></td>
													<?php
												}
											} 
											?>
										</tr>
										<?php
									} 
									?>
								</tbody>
							</table>
						</div>
					</div>
				</div><!-- #tabs-4 -->
				<?php
			} 
			?>
		</div>
	</form>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	</script>
	<?php
}
?>