<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoAddInvoiceTitle', true, false), __('infoAddInvoiceDesc', true, false));
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	$client_id = null;
	if(isset($_GET['client_id']))
	{
		$client_id = $_GET['client_id'];
	}
	if(isset($tpl['arr']))
	{
		$client_id = $tpl['arr']['client_id'];
	}
	
	$recurring_arr = __('recurring', true, false);
	$recurring_arr = pjUtil::sortArrayByArray($recurring_arr, array('weekly', 'monthly', 'quarterly', 'yearly'));
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminInvoices&amp;action=pjActionCreate" method="post" id="frmCreateInvoice" class="form pj-form" autocomplete="off">
		<input type="hidden" name="invoice_create" value="1" />
		<p>
			<label class="title"><?php __('lblClient'); ?></label>
			<span class="inline-block">
				<select name="client_id" id="client_id" class="pj-form-field w300 required" data-msg-required="<?php __('lblFieldRequired');?>">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach ($tpl['client_arr'] as $k => $v)
					{
						$client_name = array();
						$name_arr = array();
						if(!empty($v['first_name']))
						{
							$name_arr[] = $v['first_name'];
						}
						if(!empty($v['last_name']))
						{
							$name_arr[] = $v['last_name'];
						}
						if(!empty($name_arr))
						{
							$client_name[] = implode(" ", $name_arr);
						}
						if(!empty($v['company_name']))
						{
							$client_name[] = $v['company_name'];
						}
						
						?><option value="<?php echo $v['id']; ?>"<?php echo $client_id == $v['id'] ? ' selected="selected"' : NULL;?>><?php echo implode(", ", $client_name); ?></option><?php
					}
					?>
				</select>
				<a id="pjImEditClient" href="#" class="pj-edit" style="display: none;"></a>
			</span>
		</p>
		<p>
			<label class="title"><?php __('opt_o_currency');?></label>
			<span class="inline-block">
				<select id="currency" name="currency" class="pj-form-field w150 required">
					<?php
					$selected_currency = $tpl['option_arr']['o_currency'];
					$default = explode("::", $tpl['currency_arr']['value']);
					$enum = explode("|", $default[0]);
						
					$enumLabels = array();
					if (!empty($tpl['currency_arr']['label']) && strpos($tpl['currency_arr']['label'], "|") !== false)
					{
						$enumLabels = explode("|", $tpl['currency_arr']['label']);
					}
					if(isset($tpl['arr']))
					{
						$default[1] = $tpl['arr']['currency']; 
					}
					foreach ($enum as $k => $el)
					{
						if($default[1] == $el)
						{
							$selected_currency = $el;
						}
						?><option value="<?php echo $el; ?>"<?php echo $default[1] == $el ? ' selected="selected"' : NULL;?>><?php echo array_key_exists($k, $enumLabels) ? stripslashes($enumLabels[$k]) : stripslashes($el); ?></option><?php
					} 
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblDateIssued'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-after">
				<input type="text" id="date_issued" name="date_issued" value="<?php echo date($tpl['option_arr']['o_date_format'], time());?>" class="pj-form-field pointer w90 required datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
				<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblRecurring'); ?></label>
			<span class="block float_left r10">
				<select name="recurring" id="recurring" class="pj-form-field w110" data-msg-required="<?php __('lblFieldRequired');?>">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach ( $recurring_arr as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo isset($tpl['arr']) ? ($tpl['arr']['recurring'] == $k ? ' selected="selected"' : NULL) : NULL;?>><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
			<span id="pjImNextInvoice" class="float_left r10" style="display: <?php echo isset($tpl['arr']) ? ($tpl['arr']['recurring'] != '' ? 'block' : 'none') : 'none';?>">
				<label class="block float_left t7 r10"><?php __('lblNextInvoice');?></label>
					<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" id="recurring_date" name="recurring_date" value="<?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['recurring_date']));?>" class="pj-form-field pointer w90 required datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblInvoiceNumber'); ?></label>
			<span class="inline_block">
				<input type="text" name="invoice_number" id="invoice_number" class="pj-form-field w150 required" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-remote="<?php __('lblInvoiceNumberDuplidated');?>"/>
				<?php
				if(count($tpl['invoice_arr']))
				{ 
					?><a class="inline-block pjImFiveInvoices" href="#"><?php __('lblLastFiveInvoices');?></a><?php
				} 
				?>
			</span>
		</p>
		<p class="pj-size-count pj-size-title">
			<label class="title"><?php __('lblProducts');?></label>
			<span class="inline_block">
				<label class="content float_left" style="width: 276px;"><?php __('lblProductName');?></label>
				<label class="content float_left" style="width: 110px;"><?php __('lblPrice');?></label>
				<label class="content float_left"><?php __('lblQuantity');?></label>
			</span>
		</p>
		<div id="im_product_list" class="fd-size-list">
			<?php
			if(isset($tpl['product_arr']) && count($tpl['product_arr']) > 0)
			{
				foreach($tpl['product_arr'] as $k => $v)
				{ 
					?>
					<div class="im-product-row">
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline_block">
								<input type="text" name="product_title[]" value="<?php echo pjSanitize::html($v['product_title']);?>" placeholder="<?php __('lblAddProduct');?>" class="pj-form-field float_left r3 w250 imRequired"/>
							</span>
						</p>
						<div class="pj-size-count">
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text pj-currency-sign"><?php echo pjUtil::formatCurrencySign(NULL, $selected_currency, ""); ?></abbr></span>
								<input type="text" name="price[]" value="<?php echo pjSanitize::html($v['price']);?>" class="pj-form-field w60 imPositive"/>
							</span>
						</div>
						<div class="pj-quantity">
							<input type="text" name="quantity[]" value="<?php echo pjSanitize::html($v['quantity']);?>" class="pj-form-field field-int w60 imPositive"/>
						</div>
						<?php
						if($k > 0)
						{
							?>
							<div class="size-icons">
								<input type="button" value="<?php __('btnRemove'); ?>" class="pj-button pj-remove-product" />
							</div>
							<?php
						} 
						?>
					</div>
					<?php
				}
			}else{ 
				?>
				<div class="im-product-row">
					<p>
						<label class="title">&nbsp;</label>
						<span class="inline_block">
							<input type="text" name="product_title[]" placeholder="<?php __('lblAddProduct');?>" class="pj-form-field float_left r3 w250 imRequired"/>
						</span>
					</p>
					<div class="pj-size-count">
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text pj-currency-sign"><?php echo pjUtil::formatCurrencySign(NULL, $selected_currency, ""); ?></abbr></span>
							<input type="text" name="price[]" class="pj-form-field w60 imPositive"/>
						</span>
					</div>
					<div class="pj-quantity">
						<input type="text" name="quantity[]" value="1" class="pj-form-field field-int w60 imPositive"/>
					</div>
				</div>
				<?php
			} 
			?>
		</div>
		<p>
			<label class="title">&nbsp;</label>
			<input type="button" value="<?php __('btnAddProduct'); ?>" class="pj-button pj-add-product" />
		</p>
		<p>
			<label class="title"><?php __('lblAmount'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text pj-currency-sign"><?php echo pjUtil::formatCurrencySign(NULL, $selected_currency, ""); ?></abbr></span>
				<input type="text" id="amount" name="amount" value="<?php echo isset($tpl['arr']) ? $tpl['arr']['amount'] : NULL;?>" class="pj-form-field w70 align_right required pjPositive" data-msg-required="<?php __('lblFieldRequired');?>"  data-msg-pjPositive="<?php __('lblEnterPositiveNumber');?>"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblVAT'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-after">
				<input type="text" id="vat" name="vat" value="<?php echo isset($tpl['arr']) ? $tpl['arr']['vat'] : $tpl['option_arr']['o_vat'];?>" class="pj-form-field w70 align_right required pjPositive" data-msg-pjPositive="<?php __('lblEnterPositiveNumber');?>"/>
				<span class="pj-form-field-after"><abbr class="pj-form-field-icon-text">%</abbr></span>
			</span>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text pj-currency-sign"><?php echo pjUtil::formatCurrencySign(NULL, $selected_currency, ""); ?></abbr></span>
				<input type="text" id="vat_amount" name="vat_amount" value="" class="pj-form-field w70 align_right required" readonly="readonly" disabled="disabled"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblTotal'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text pj-currency-sign"><?php echo pjUtil::formatCurrencySign(NULL, $selected_currency, ""); ?></abbr></span>
				<input type="text" id="total" name="total" value="<?php echo isset($tpl['arr']) ? $tpl['arr']['total'] : NULL;?>" class="pj-form-field w70 align_right required" readonly="readonly"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblNotes'); ?></label>
			<textarea name="notes" class="pj-form-field w500 h100"></textarea>		
		</p>
		<p>
			<label class="title"><?php __('lblStatus'); ?></label>
			<span class="inline-block">
				<select name="status" id="status" class="pj-form-field w150 required" data-msg-required="<?php __('lblFieldRequired');?>">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach ( __('invoice_status', true, false) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo $k == 'new' ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
			<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminInvoices&action=pjActionIndex';" />
		</p>
	</form>
	
	<div id="im_product_clone" style="display: none;">
		<div class="im-product-row">
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="text" name="product_title[]" placeholder="<?php __('lblAddProduct');?>" class="pj-form-field float_left r3 w250 imRequired"/>
				</span>
			</p>
			<div class="pj-size-count">
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text pj-currency-sign"><?php echo pjUtil::formatCurrencySign(NULL, $selected_currency, ""); ?></abbr></span>
					<input type="text" name="price[]" class="pj-form-field w60 imPositive"/>
				</span>
			</div>
			<div class="pj-quantity">
				<input type="text" name="quantity[]" value="1" class="pj-form-field {FIELDINT} w60 imPositive"/>
			</div>
			<div class="size-icons">
				<input type="button" value="<?php __('btnRemove'); ?>" class="pj-button pj-remove-product" />
			</div>
		</div>
	</div>
	
	<?php
	if(count($tpl['invoice_arr']) > 0)
	{ 
		?>
		<div id="dialogFiveInvoices" title="<?php __('lblLastFiveInvoices'); ?>" style="display: none">
			<table class="pj-table" cellspacing="0" cellpadding="0" style="width: 100%;">
				<thead>
					<tr>
						<th style="width: 85px;"><?php __('lblInvoiceNo');?></th>
						<th style="width: 70px;"><?php __('lblAmount');?></th>
						<th style="width: 90px;"><?php __('lblDateIssued');?></th>
						<th style="width: 140px;"><?php __('lblClient');?></th>
						<th><?php __('lblCompanyName');?></th>
					</tr>
				</thead>
				<tbody>
					<?php
					foreach($tpl['invoice_arr'] as $v)
					{
						if(!empty($v['date_issued']))
						{
							$v['date_issued'] = date($tpl['option_arr']['o_date_format'], strtotime($v['date_issued']));
						}
						$v['amount'] = pjUtil::formatCurrencySign($v['amount'], $v['currency']);
						$name_arr = array();
						if(!empty($v['first_name']))
						{
							$name_arr[] = $v['first_name'];
						}
						if(!empty($v['last_name']))
						{
							$name_arr[] = $v['last_name'];
						}
						$v['first_name'] = implode(" ", $name_arr);
						?>
						<tr>
							<td><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminInvoices&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['invoice_number']);?></a></td>
							<td><?php echo $v['amount'];?></td>
							<td><?php echo $v['date_issued'];?></td>
							<td><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&amp;id=<?php echo $v['client_id'];?>"><?php echo pjSanitize::html($v['first_name']);?></a></td>
							<td><?php echo pjSanitize::html($v['company_name']);?></td>
						</tr>
						<?php
					} 
					?>
				</tbody>
			</table>
		</div>
		<?php
	} 
	?>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	</script>
	<?php
}
?>