<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	$recurring_arr = __('recurring', true, false);
	$recurring_arr = pjUtil::sortArrayByArray($recurring_arr, array('weekly', 'monthly', 'quarterly', 'yearly'));
	
	if(!$controller->isClient())
	{
		pjUtil::printNotice(__('infoInvoicesTitle', true), __('infoInvoicesDesc', true));
	}else{
		pjUtil::printNotice(__('infoClientInvoicesTitle', true), __('infoClientInvoicesDesc', true));
	}
	?>
	<div class="b10">
		<?php
		if(!$controller->isClient())
		{ 
			?>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
				<input type="hidden" name="controller" value="pjAdminInvoices" />
				<input type="hidden" name="action" value="pjActionCreate" />
				<input type="submit" class="pj-button" value="<?php __('btnAddInvoice'); ?>" />
			</form>
			<?php
		} 
		?>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$invoice_status = __('invoice_status', true);
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all"><?php __('lblAll');?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="new"><?php echo $invoice_status['new']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="paid"><?php echo $invoice_status['paid']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="cancelled"><?php echo $invoice_status['cancelled']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="recurring"><?php __('lblRecurring'); ?></a>
		</div>
		<br class="clear_both" />
	</div>

	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<p>
				<label class="title120"><?php __('lblDateIssued'); ?></label>
				<label class="float_left r3 t5"><?php __('lblFrom');?></label>
				<span class="inline_block float_left r5">
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" id="date_issued_from" name="date_issued_from" class="pj-form-field pointer w80 datepick-search" readonly="readonly" rel="1" rev="<?php echo $jqDateFormat; ?>" value="" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</span>
				<label class="float_left r5 t5"><?php __('lblTo');?></label>
				<span class="inline_block float_left">
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" id="date_issued_to" name="date_issued_to" class="pj-form-field pointer w80 datepick-search" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</span>
				
			</p>
			<p>
				<label class="title120"><?php __('lblDatePaid'); ?></label>
				<label class="float_left r3 t5"><?php __('lblFrom');?></label>
				<span class="inline_block float_left r5">
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" id="date_paid_from" name="date_paid_from" class="pj-form-field pointer w80 datepick-paid-search" readonly="readonly" rel="1" rev="<?php echo $jqDateFormat; ?>" value="" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</span>
				<label class="float_left r5 t5"><?php __('lblTo');?></label>
				<span class="inline_block float_left">
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" id="date_paid_to" name="date_paid_to" class="pj-form-field pointer w80 datepick-paid-search" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</span>
				
			</p>
			<div class="clear_both"></div>
			<div class="float_left w350">
				<p>
					<label class="title120"><?php __('lblRecurring'); ?></label>
					<span class="block float_left r10">
						<select id="recurring" name="recurring" class="pj-form-field w150" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ( $recurring_arr as $k => $v)
							{
								?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title120"><?php __('lblProductName'); ?></label>
					<span class="inline_block">
						<input type="text" id="product_name" name="product_name" class="pj-form-field w150"/>
					</span>
				</p>
				<p>
					<label class="title120"><?php __('lblPaymentID'); ?></label>
					<span class="inline_block">
						<input type="text" name="txn_id" id="txn_id" class="pj-form-field w150"/>
					</span>
				</p>
				<p>
					<label class="title120"><?php __('lblStatus'); ?></label>
					<span class="inline-block">
						<select name="status" id="status" class="pj-form-field w150">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ( __('invoice_status', true, false) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
			</div>
			<div class="float_right w350">
				<p>
					<label class="title120"><?php __('lblInvoiceNumber'); ?></label>
					<span class="inline_block">
						<input type="text" id="invoice_number" name="invoice_number" class="pj-form-field w150"/>
					</span>
				</p>
				<p>
					<label class="title120"><?php __('lblTotal'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text pj-currency-sign"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="total" name="total" class="pj-form-field w70 align_right"/>
					</span>
				</p>
				<p>
					<label class="title120"><?php __('lblPaymentMethod');?></label>
					<span class="inline-block">
						<select name="payment_method" id="payment_method" class="pj-form-field w150">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('payment_methods', true, false) as $k => $v)
							{
								if ($tpl['option_arr']['o_allow_' . $k] === "Yes")
								{
									?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
								}
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
					<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
				</p>
			</div>
			<div class="clear_both"></div>
			
		</form>
	</div>
	
	<div id="grid" class="<?php echo $controller->isClient() ? 'clientGrid' : NULL;?>"></div>
	
	<div id="dialogSend" title="<?php __('lblSendInvoiceEmail'); ?>" style="display: none">
		<form id="frmSendEmail" class="form pj-form"></form>
	</div>
	<script type="text/javascript">
		var pjGrid = pjGrid || {};
		pjGrid.queryString = "";
		<?php
		if (isset($_GET['user_id']) && (int) $_GET['user_id'] > 0)
		{
			?>pjGrid.queryString += "&user_id=<?php echo (int) $_GET['user_id']; ?>";<?php
		}
		if (isset($_GET['client_id']) && (int) $_GET['client_id'] > 0)
		{
			?>pjGrid.queryString += "&client_id=<?php echo (int) $_GET['client_id']; ?>";<?php
		}
		if (isset($_GET['status']) && $_GET['status'] != '')
		{
			?>pjGrid.queryString += "&status=<?php echo $_GET['status']; ?>";<?php
		}
		if (isset($_GET['currency']) && $_GET['currency'] != '')
		{
			?>pjGrid.queryString += "&currency=<?php echo $_GET['currency']; ?>";<?php
		}
		if($controller->isClient())
		{
			?>pjGrid.queryString += "&client_id=<?php echo (int) $_SESSION[$controller->defaultUser]['id']; ?>";<?php
		}
		?>
		pjGrid.isClient = <?php echo $controller->isClient() ? 'true' : 'false'; ?>;
		var myLabel = myLabel || {};
		myLabel.total = "<?php __('lblTotal'); ?>";
		myLabel.date_issued = "<?php __('lblDateIssued'); ?>";
		myLabel.company_name = "<?php __('lblCompanyName'); ?>";
		myLabel.invoice_number = "<?php __('lblInvoiceNo'); ?>";
		myLabel.client = "<?php __('lblClient'); ?>";
		myLabel.edit = "<?php __('lblEdit'); ?>";
		myLabel.delete = "<?php __('lblDelete'); ?>";
		myLabel.send = "<?php __('lblSend'); ?>";
		myLabel.duplicate = "<?php __('lblDuplicate'); ?>";
		myLabel.view = "<?php __('lblView'); ?>";
		myLabel.new = "<?php echo $invoice_status['new']; ?>";
		myLabel.paid = "<?php echo $invoice_status['paid']; ?>";
		myLabel.cancelled = "<?php echo $invoice_status['cancelled']; ?>";
		myLabel.delete_selected = "<?php __('delete_selected'); ?>";
		myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
		myLabel.status = "<?php __('lblStatus'); ?>";
	</script>
	<?php
}
?>