<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	pjUtil::printNotice(__('infoReportsTitle', true), __('infoReportsDesc', true));
	
	$months = __('months', true);
	$short_months = __('short_months', true);
	ksort($months);
	ksort($short_months);
	$days = __('days', true);
	$short_days = __('short_days', true);
	
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	$date_from = date($tpl['option_arr']['o_date_format'], strtotime(date('Y-m-01', time()))); 
	$date_to = date($tpl['option_arr']['o_date_format'], strtotime(date('Y-m-t', time())));
	if(isset($_POST['report']))
	{
		$date_from = $_POST['date_from'];
		$date_to = $_POST['date_to'];
	}
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReports&amp;action=pjActionIndex" method="post" id="frmReport" class="form pj-form" autocomplete="off">
		<input type="hidden" name="report" value="1" />
		<p>
			<div class="float_left r20">
				<label class="block float_left t7 w40"><?php __('lblFrom');?>:</label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="date_from" value="<?php echo $date_from;?>" class="pj-form-field pointer w100 required datepick" readonly="readonly" data-fday="<?php echo $week_start; ?>" data-dformat="<?php echo $jqDateFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</div>
			<div class="float_left r20">
				<label class="block float_left t7 w25"><?php __('lblTo');?>:</label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="date_to" value="<?php echo $date_to;?>" class="pj-form-field pointer w100 required datepick" readonly="readonly" data-fday="<?php echo $week_start; ?>" data-dformat="<?php echo $jqDateFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</div>
			<div class="float_left r10">
				<input type="submit" value="<?php __('btnSubmit'); ?>" class="pj-button" />
			</div>
		</p>
		<div class="clear_both"></div>
		
		<?php
		
		if($tpl['cnt_invoices'] > 0)
		{ 
			$invoice_status = __('invoice_status', true);
			?>
			<div class="dContainer">
				<div class="dWrapper">
					<table class="pj-table dTable" cellpadding="0" cellspacing="0">
						<tbody>
							<tr>
								<td class="dHeadcol">&nbsp;</td>
								<?php
								foreach($tpl['currency_arr'] as $currency)
								{
									?><td colspan="2" class="dHead"><?php echo $currency; ?> </td><?php
								}
								?>
							</tr>
							<?php
							foreach($invoice_status as $k => $status)
							{
								?>
								<tr>
									<td class="dHeadcol"><?php echo $status; ?></td>
									<?php
									foreach($tpl['currency_arr'] as $currency)
									{
										$count = 0;
										$amount = 0;
										if(isset($tpl['invoice_arr'][$k][$currency]))
										{
											$count = $tpl['invoice_arr'][$k][$currency]['cnt'];
											$amount = $tpl['invoice_arr'][$k][$currency]['amount'];
											?>
											<td class="dSlot tdRight tdCount dSlot_<?php echo $k; ?>"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminInvoices&amp;action=pjActionIndex&amp;client_id=<?php echo $tpl['arr']['id']?>&amp;status=<?php echo $k;?>&amp;currency=<?php echo $currency;?>"><?php echo $count;?></a></td>
											<td class="dSlot tdRight dSlot_<?php echo $k; ?>"><?php echo pjUtil::formatCurrencySign(number_format($amount, 2), $currency);?></td>
											<?php
										}else{
											?>
											<td class="dSlot tdRight tdCount dSlot_<?php echo $k; ?>"><?php echo $count;?></td>
											<td class="dSlot tdRight dSlot_<?php echo $k; ?>"><?php echo pjUtil::formatCurrencySign(number_format($amount, 2), $currency);?></td>
											<?php
										}
									} 
									?>
								</tr>
								<?php
							} 
							?>
						</tbody>
					</table>
				</div>
			</div>
			<?php
		} 
		?>
		
	</form>
	
	<script type="text/javascript">
		var pjGrid = pjGrid || {};
		pjGrid.queryString = "";
		var myLabel = myLabel || {};
	</script>
	<?php
}
?>