<?php
if(isset($tpl['status']))
{
	$invoice_err = __('invoice_err', true);
	echo $invoice_err[$tpl['status']];
}else{
	echo $tpl['invoice'];
	?>
	<br/>
	<div class="pjImForm">
		<?php
		if($tpl['arr']['status'] != 'paid')
		{ 
			$payment_disabled = true;
			foreach (__('payment_methods', true, false) as $k => $v)
			{
				if ($tpl['option_arr']['o_allow_' . $k] === "Yes")
				{
					$payment_disabled = false;
				}
			}
			?>
			<form method="post" id="frmInvoicePayment">
				<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>"/>
				<?php
				if($payment_disabled == false)
				{
					?>
					<p>
						<label class="title"><?php __('lblPaymentMethod');?></label>
						<span class="inline-block">
							<select name="payment_method" id="payment_method" class="pj-form-field required">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach (__('payment_methods', true, false) as $k => $v)
								{
									if ($tpl['option_arr']['o_allow_' . $k] === "Yes")
									{
										?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
									}
								}
								?>
							</select>
						</span>
					</p>
					<p class="boxBank" style="display: none;">
						<label class="title">&nbsp;</label>
						<span class="inline-block">
							<?php echo pjSanitize::html($tpl['option_arr']['o_bank_account']);?>
						</span>
					</p>
					<p class="boxCC" style="display: none;">
						<label class="title"><?php __('lblCCType'); ?></label>
						<span class="inline-block">
							<select name="cc_type" class="pj-form-field w150 required">
								<option value="">---</option>
								<?php
								foreach (__('cc_types', true, false) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p class="boxCC" style="display: none;">
						<label class="title"><?php __('lblCCNum'); ?></label>
						<span class="inline-block">
							<input type="text" name="cc_num" id="cc_num" class="pj-form-field required" />
						</span>
					</p>
					<p class="boxCC" style="display: none;">
						<label class="title"><?php __('lblCCExp'); ?></label>
						<span class="inline-block">
							<select name="cc_exp_month" class="pj-form-field">
								<?php
								$month_arr = __('months', true, false);
								ksort($month_arr);
								foreach ($month_arr as $key => $val)
								{
									?><option value="<?php echo $key;?>"><?php echo $val;?></option><?php
								}
								?>
							</select>
							<select name="cc_exp_year" class="pj-form-field">
								<?php
								$y = (int) date('Y');
								for ($i = $y; $i <= $y + 10; $i++)
								{
									?><option value="<?php echo $i; ?>"><?php echo $i; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p class="boxCC" style="display: none;">
						<label class="title"><?php __('lblCCCode'); ?></label>
						<span class="inline-block">
							<input type="text" name="cc_code" id="cc_code" class="pj-form-field w100 required" />
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					</p>
					<?php 
				}
				?>
			</form>
			<p id="pjImPaymentMessage" style="display: none;">
				<label class="title">&nbsp;</label>
				<span class="inline-block"><?php __('front_payment_processing');?></span>
			</p>
			<div style="display: none;">
				<label class="title">&nbsp;</label>
				<span id="pjImPayment" class="inline-block"><?php __('front_payment_processing');?></span>
			</div>
			<?php
		}else{
			?><p><?php __('front_invoice_paid');?></p><?php
		} 
		?>
	</div>
	<?php
}
?>