var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateInvoice = $("#frmCreateInvoice"),
			$frmUpdateInvoice = $("#frmUpdateInvoice"),
			$frmSendEmail = $('#frmSendEmail'),
			$dialogFiveInvoices = $("#dialogFiveInvoices"),
			$dialogSend = $('#dialogSend'),
			datepicker = ($.fn.datepicker !== undefined),
			chosen = ($.fn.chosen !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			editor_id = $('#mceEditor'),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			};
		
		function validField($this)
		{
			if($this.hasClass('field-int'))
			{
				if($this.val() == '')
				{
					$this.removeClass('pj-error-field');
				}else{
					if(Number($this.val()) <= 0 || $.isNumeric($this.val()) == false)
				    {
						$this.addClass('pj-error-field');
				    }else{
				    	$this.removeClass('pj-error-field');
				    }
				}
			}
		}
		function setEditClient()
		{
			var client_id = $('#client_id').val();
			if(client_id == '')
			{
				$('#pjImEditClient').css('display', 'none');
			}else{
				$('#pjImEditClient').attr('href', 'index.php?controller=pjAdminClients&action=pjActionUpdate&id=' + client_id).css('display', 'inline-block');
			}
		}
		if ($tabs.length > 0 && tabs) 
		{
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 1,
			stop: function( event, ui ) {
				validField($(this));
				calcTotal();
			}
		});
		
		if ($frmCreateInvoice.length > 0 && validate) {
			$.validator.addMethod(
		        "pjPositive", 
		        function(value, element) {
		        	if(value != '')
		        	{
		        		if(Number(value) < 0 || $.isNumeric(value) == false)
					    {
							return false;
					    }else{
					    	return true;
					    }
		        	}else{
		        		return true;
		        	}
		        }
		    );
			$frmCreateInvoice.validate({
				rules: {
					"invoice_number": {
						required: true,
						remote: "index.php?controller=pjAdminInvoices&action=pjActionCheckInvoice"
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: '',
				submitHandler: function(form){
					var valid = true;
					
					$("#frmCreateInvoice .imPositive").each(function() {
						if($(this).val() == '')
						{
							valid = false;
							$(this).addClass('pj-error-field');
						}else{
							if($(this).hasClass('field-int'))
							{
								if(Number($(this).val()) <= 0 || $.isNumeric($(this).val()) == false)
							    {
									valid = false;
							    	$(this).addClass('pj-error-field');
							    }else{
							    	valid = true;
							    	$(this).removeClass('pj-error-field');
							    }
							}else{
								if(Number($(this).val()) < 0 || $.isNumeric($(this).val()) == false)
							    {
									valid = false;
							    	$(this).addClass('pj-error-field');
							    }else{
							    	valid = true;
							    	$(this).removeClass('pj-error-field');
							    }
							}
						}
					});
					$("#frmCreateInvoice .imRequired").each(function() {
						if($(this).val() == '')
						{
							valid = false;
					    	$(this).addClass('pj-error-field');
						}else{
							$(this).removeClass('pj-error-field');
						}
					});
					if(valid == true)
					{
						form.submit();
					}
				}
			});
			setEditClient();
		}
		if ($frmUpdateInvoice.length > 0 && validate) {
			$.validator.addMethod(
		        "pjPositive", 
		        function(value, element) {
		        	if(value != '')
		        	{
		        		if(Number(value) < 0 || $.isNumeric(value) == false)
					    {
							return false;
					    }else{
					    	return true;
					    }
		        	}else{
		        		return true;
		        	}
		        }
		    );
			$frmUpdateInvoice.validate({
				rules: {
					"invoice_number": {
						required: true,
						remote: "index.php?controller=pjAdminInvoices&action=pjActionCheckInvoice&id=" + $frmUpdateInvoice.find("input[name='id']").val()
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: '',
				invalidHandler: function (event, validator) {
				    if (validator.numberOfInvalids()) {
				    	var index = $(validator.errorList[0].element, this).closest("div[id^='tabs-']").index();
				    	if ($tabs.length > 0 && tabs && index !== -1) {
				    		$tabs.tabs(tOpt).tabs("option", "active", index-1);
				    	}
				    }
				},
				submitHandler: function(form){
					var valid = true;
					$("#frmUpdateInvoice .imPositive").each(function() {
						if($(this).val() == '')
						{
							valid = false;
							$(this).addClass('pj-error-field');
						}else{
							if($(this).hasClass('field-int'))
							{
								if(Number($(this).val()) <= 0 || $.isNumeric($(this).val()) == false)
							    {
									valid = false;
							    	$(this).addClass('pj-error-field');
							    }else{
							    	valid = true;
							    	$(this).removeClass('pj-error-field');
							    }
							}else{
								if(Number($(this).val()) < 0 || $.isNumeric($(this).val()) == false)
							    {
									valid = false;
							    	$(this).addClass('pj-error-field');
							    }else{
							    	valid = true;
							    	$(this).removeClass('pj-error-field');
							    }
							}
						}
					});
					$("#frmUpdateInvoice .imRequired").each(function() {
						if($(this).val() == '')
						{
							valid = false;
					    	$(this).addClass('pj-error-field');
						}else{
							$(this).removeClass('pj-error-field');
						}
					});
					if(valid == true)
					{
						form.submit();
					}
				}
			});
		}
		
		if (chosen) {
			$("#client_id").chosen();
		}
		
		if($dialogFiveInvoices.length > 0)
		{
			$dialogFiveInvoices.dialog({
				modal: true,
				resizable: false,
				draggable: false,
				autoOpen: false,
				width: 650,
				buttons: (function () {
					var buttons = {};
					buttons[imApp.locale.button.ok] = function () {
						$dialogFiveInvoices.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
		
		if($dialogSend.length > 0)
		{
			$dialogSend.dialog({
				modal: true,
				resizable: false,
				draggable: false,
				autoOpen: false,
				width: 770,
				position: ['center',20],
				open: function( event, ui ) {
					var invoice_id = $dialogSend.data('id');
					$frmSendEmail.html("");
					$.get(["index.php?controller=pjAdminInvoices&action=pjActionGetContent"].join(""), {id: invoice_id}).done(function (data) {
						$frmSendEmail.html(data);
						tinymce.init({
							relative_urls : true,
							browser_spellcheck : true,
						    contextmenu: false,
						    selector: 'textarea#mceEditor',
						    theme: "modern",
						    width: 738,
						    height: 300,
						    plugins: [
						         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
						         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
						         "save table contextmenu directionality emoticons template paste textcolor"
						    ],
						    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons"
						});
						if (tinymce.editors.length > 0) 
						{							
							tinymce.execCommand('mceAddEditor',true, "mceEditor");
						}
					}).fail(function () {
						
					});
				},
				buttons: (function () {
					var buttons = {};
					buttons[imApp.locale.button.send] = function () {
						$.post(["index.php?controller=pjAdminInvoices&action=pjActionSend"].join(""), $('#frmSendEmail').serialize()).done(function (data) {
							$frmSendEmail.html("");
							if (tinymce.editors.length > 0) 
							{
						        tinymce.execCommand('mceRemoveEditor',true, "mceEditor");
						    }
							$dialogSend.dialog("close");
						}).fail(function () {
							
						});
					};
					buttons[imApp.locale.button.cancel] = function () {
						$frmSendEmail.html("");
						if (tinymce.editors.length > 0) 
						{
					        tinymce.execCommand('mceRemoveEditor',true, "mceEditor");
					    }
						$dialogSend.dialog("close");
					};
					return buttons;
				})()
			});
		}
		if ($("#grid").length > 0 && datagrid) 
		{
			function onBeforeShow (obj) {
				return true;
			}
			function formatInvoiceID(str, obj)
			{
				if(pjGrid.isClient == false)
				{
					return '<a href="index.php?controller=pjAdminInvoices&action=pjActionUpdate&id='+obj.id+'">'+str+'</a>';
				}else{
					return '<a href="index.php?controller=pjAdminInvoices&action=pjActionView&id='+obj.id+'&hash='+obj.hash+'" target="_blank">'+str+'</a>';
				}
			}
			var gridOpts = {
					buttons: [{type: "copy", url: "index.php?controller=pjAdminInvoices&action=pjActionCreate&id={:id}", title: myLabel.duplicate},
					          {type: "send", target: '_blank', url: "index.php?controller=pjAdminInvoices&action=pjActionSend&id={:id}", title: myLabel.send},
					          {type: "view", target: '_blank', url: "index.php?controller=pjAdminInvoices&action=pjActionView&id={:id}&hash={:hash}", title: myLabel.view},
					          {type: "edit", url: "index.php?controller=pjAdminInvoices&action=pjActionUpdate&id={:id}", title: myLabel.edit},
					          {type: "delete", url: "index.php?controller=pjAdminInvoices&action=pjActionDeleteInvoice&id={:id}", beforeShow: onBeforeShow, title: myLabel.delete}],
							  
					columns: [{text: myLabel.invoice_number, type: "text", sortable: true, editable: false, width: 85, renderer: formatInvoiceID},
					          {text: myLabel.total, type: "text", sortable: true, editable: false, width: 90},
					          {text: myLabel.date_issued, type: "text", sortable: true, editable: false, width: 95},
					          {text: myLabel.client, type: "text", sortable: true, editable: false, width: 130},
					          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, options: [
					                                                                                     {label: myLabel.new, value: "new"}, 
					                                                                                     {label: myLabel.paid, value: "paid"},
					                                                                                     {label: myLabel.cancelled, value: "cancelled"}
					                                                                                     ], applyClass: "pj-status"}],
					dataUrl: "index.php?controller=pjAdminInvoices&action=pjActionGetInvoice" + pjGrid.queryString,
					dataType: "json",
					fields: ['invoice_number', 'total', 'date_issued', 'first_name', 'status'],
					paginator: {
						actions: [
						   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminInvoices&action=pjActionDeleteInvoiceBulk", render: true, confirmation: myLabel.delete_confirmation},
						   {text: myLabel.exported, url: "index.php?controller=pjAdminInvoices&action=pjActionExportInvoice", ajax: false}
						],
						gotoPage: true,
						paginate: true,
						total: true,
						rowCount: true
					},
					saveUrl: "index.php?controller=pjAdminInvoices&action=pjActionSaveInvoice&id={:id}",
					select: {
						field: "id",
						name: "record[]"
					}
				};
			if(pjGrid.isClient == true)
			{
				gridOpts = {
					buttons: [{type: "send", target: '_blank', url: "index.php?controller=pjAdminInvoices&action=pjActionSend&id={:id}", title: myLabel.send},
					          {type: "view", target: '_blank', url: "index.php?controller=pjAdminInvoices&action=pjActionView&id={:id}&hash={:hash}", title: myLabel.view}],
							  
					columns: [{text: myLabel.invoice_number, type: "text", sortable: true, editable: false, width: 160, renderer: formatInvoiceID},
					          {text: myLabel.total, type: "text", sortable: true, editable: false, width: 130},
					          {text: myLabel.date_issued, type: "text", sortable: true, editable: false, width: 200},
					          {text: myLabel.status, type: "select", sortable: true, editable: false, width: 130, options: [
					                                                                                     {label: myLabel.new, value: "new"}, 
					                                                                                     {label: myLabel.paid, value: "paid"},
					                                                                                     {label: myLabel.cancelled, value: "cancelled"}
					                                                                                     ], applyClass: "pj-status"}],
					dataUrl: "index.php?controller=pjAdminInvoices&action=pjActionGetInvoice" + pjGrid.queryString,
					dataType: "json",
					fields: ['invoice_number', 'total', 'date_issued', 'status'],
					paginator: {
						gotoPage: true,
						paginate: true,
						total: true,
						rowCount: true
					},
					saveUrl: "index.php?controller=pjAdminInvoices&action=pjActionSaveInvoice&id={:id}",
					select: {
						field: "id",
						name: "record[]"
					}
				};
			}
			var $grid = $("#grid").datagrid(gridOpts);
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: "",
				date_issued_from: "",
				date_issued_to: "",
				date_paid_from: "",
				date_paid_to: "",
				recurring: "",
				invoice_number: "",
				product_name: "",
				total: "",
				txn_id: "",
				payment_method: "",
				status: ""
				
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminInvoices&action=pjActionGetInvoice", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminInvoices&action=pjActionGetInvoice", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-status-1", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			return false;
		}).on("click", ".pj-status-0", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$.post("index.php?controller=pjAdminInvoices&action=pjActionSetActive", {
				id: $(this).closest("tr").data("object")['id']
			}).done(function (data) {
				$grid.datagrid("load", "index.php?controller=pjAdminInvoices&action=pjActionGetInvoice");
			});
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val(),
				date_issued_from: "",
				date_issued_to: "",
				date_paid_from: "",
				date_paid_to: "",
				recurring: "",
				invoice_number: "",
				product_name: "",
				total: "",
				txn_id: "",
				payment_method: "",
				status: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminInvoices&action=pjActionGetInvoice", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
			e.stopPropagation();
			$(".pj-form-filter-advanced").toggle();
		}).on("submit", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var obj = {},
				$this = $(this),
				arr = $this.serializeArray(),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
				obj[arr[i].name] = arr[i].value;
			}
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminInvoices&action=pjActionGetInvoice", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("reset", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(".pj-button-detailed").trigger("click");
			
			$('#recurring').val('');
			$('#product_name').val('');
			$('#txn_id').val('');
			$('#status').val('');
			$('#invoice_number').val('');
			$('.datepick-search').val('');
			$('.datepick-paid-search').val('');
			$('#payment_method').val('');
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
		}).on("focusin", ".datepick", function (e) {
			var $this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev"),
					onClose: function(dateText){
						if($(this).attr('name') == 'date_issued')
						{
							getRecurringDate();
						}
					}
				};
			$this.not('.hasDatepicker').datepicker($.extend(o, custom));
		}).on("change", "#client_id", function (e) {
			setEditClient();
			return false;
		}).on("focusin", ".datepick-search", function (e) {
			var $this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
			};
			switch ($this.attr("name")) {
			case "date_issued_from":
				maxDate = $(".datepick-search[name='date_issued_to']").datepicker({
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
				}).datepicker("getDate");
				$(".datepick-search[name='date_issued_to']").datepicker("destroy").removeAttr("id");
				if (maxDate !== null) {
					custom.maxDate = maxDate;
				}
				break;
			case "date_issued_to":
				minDate = $(".datepick-search[name='date_issued_from']").datepicker({
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
				}).datepicker("getDate");
				$(".datepick-search[name='date_issued_from']").datepicker("destroy").removeAttr("id");
				if (minDate !== null) {
					custom.minDate = minDate;
				}
				break;
			}
			$this.not('.hasDatepicker').datepicker($.extend(o, custom));
		}).on("focusin", ".datepick-paid-search", function (e) {
			var $this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
			};
			switch ($this.attr("name")) {
			case "date_paid_from":
				maxDate = $(".datepick-paid-search[name='date_paid_to']").datepicker({
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
				}).datepicker("getDate");
				$(".datepick-paid-search[name='date_paid_to']").datepicker("destroy").removeAttr("id");
				if (maxDate !== null) {
					custom.maxDate = maxDate;
				}
				break;
			case "date_paid_to":
				minDate = $(".datepick-paid-search[name='date_paid_from']").datepicker({
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
				}).datepicker("getDate");
				$(".datepick-paid-search[name='date_paid_from']").datepicker("destroy").removeAttr("id");
				if (minDate !== null) {
					custom.minDate = minDate;
				}
				break;
			}
			$this.not('.hasDatepicker').datepicker($.extend(o, custom));
		}).on("click", '.pj-add-product', function(e){
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var clone_text = $('#im_product_clone').html(),
				index = Math.ceil(Math.random() * 999999),
				number_of_product = $('#im_product_list').find(".im-product-row").length;
			clone_text = clone_text.replace(/\{INDEX\}/g, 'im_' + index);
			clone_text = clone_text.replace(/\{FIELDINT\}/g, 'field-int');
			$('#im_product_list').append(clone_text);
			$(".field-int").spinner({
				min: 1,
				stop: function( event, ui ) {
					validField($(this));
					calcTotal();
				}
			});
		}).on("click", '.pj-remove-product', function(e){
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).parent().parent().remove();
			calcTotal();
		}).on("keyup", '.imPositive', function(e){
			if($(this).val() == '')
			{
				$(this).removeClass('pj-error-field');
			}else{
				if(Number($(this).val()) < 0 || $.isNumeric($(this).val()) == false)
			    {
			    	$(this).addClass('pj-error-field');
			    }else{
			    	$(this).removeClass('pj-error-field');
			    }
			}
			validField($(this));
		}).on("keyup", '.imRequired', function(e){
			if($(this).val() == '')
			{
				$(this).addClass('pj-error-field');
			}else{
				$(this).removeClass('pj-error-field');
			}
			
		}).on("change", '#currency', function(e){
			var $frm = null;
			if ($frmCreateInvoice.length > 0)
			{
				$frm = $frmCreateInvoice;
			}
			if ($frmUpdateInvoice.length > 0)
			{
				$frm = $frmUpdateInvoice;
			}
			$.get(["index.php?controller=pjAdminInvoices&action=pjActionGetCurrencySign"].join(""), {currency: $(this).val()}).done(function (data) {
				$frm.find('.pj-currency-sign').html(data);
				$('#im_product_clone').find('.pj-currency-sign').html(data);
			}).fail(function () {
				
			});
		}).on("click", '.pjImFiveInvoices', function(e){
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$dialogFiveInvoices.dialog("open");
		}).on("change", "#payment_method", function (e) {
			switch ($("option:selected", this).val()) {
				case 'creditcard':
					$(".boxCC").show();
					break;
				default:
					$(".boxCC").hide();
			}
		}).on("click", '.pjImSendInvoice', function(e){
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if (tinymce.editors.length > 0) 
			{
		        tinymce.execCommand('mceRemoveEditor',true, "mceEditor");
		    }
			$dialogSend.data('id', $(this).attr('data-id')).dialog("open");
		}).on("click", ".pj-table-icon-send", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var href = $(this).attr('href'),
				id_str = $(this).closest('tr').attr('data-id'),
				id = id_str.replace("id_", "");
			
			if(href.indexOf('pjActionSend') != -1)
			{
				if (tinymce.editors.length > 0) 
				{
			        tinymce.execCommand('mceRemoveEditor',true, "mceEditor");
			    }
				$dialogSend.data('id', id).dialog("open");
			}
		}).on("change", "#recurring", function (e) {
			getRecurringDate();
		});
		
		function getRecurringDate()
		{
			var recurring = $('#recurring').val();
			if(recurring != '')
			{
				$.get(["index.php?controller=pjAdminInvoices&action=pjActionGetRecurringDate"].join(""), {date_issued: $('#date_issued').val(), recurring: $('#recurring').val()}).done(function (data) {
					$('#pjImNextInvoice').html(data).css('display', 'block');
				}).fail(function () {
					
				});
			}else{
				$('#pjImNextInvoice').html('').hide();
			}
		}
		
		$("#frmCreateInvoice input[name*='price']").live("keyup", function(e){
			calcTotal();
		});
		$("#frmCreateInvoice input[name='vat']").live("keyup", function(e){
			calcTotal();
		});
		$("#frmCreateInvoice input[name*='quantity']").live("keyup", function(e){
			calcTotal();
		});
		$("#frmUpdateInvoice input[name*='price']").live("keyup", function(e){
			calcTotal();
		});
		$("#frmUpdateInvoice input[name*='quantity']").live("keyup", function(e){
			calcTotal();
		});
		$("#frmUpdateInvoice input[name='vat']").live("keyup", function(e){
			calcTotal();
		});
		function calcTotal()
		{
			var total = 0,
				total_price = 0,
				valid = true,
				$frm = null;
			if ($frmCreateInvoice.length > 0)
			{
				$frm = $frmCreateInvoice;
			}
			if ($frmUpdateInvoice.length > 0)
			{
				$frm = $frmUpdateInvoice;
			}
			var all_prices = $frm.find("input[name*='price']"),
				all_qty = $frm.find("input[name*='quantity']");
			
			for (i = 0; i < all_prices.length; i++) 
			{
				var price = all_prices.eq(i).val(),
					qty = all_qty.eq(i).val();
				if(price != '' && qty != '')
				{
					if(price.indexOf(",") !== -1)
					{
						price = price.replace(/,/g,"");
					}
					if(price.indexOf(" ") !== -1)
					{
						price = price.replace(/ /g,"");
					}

					if(qty.indexOf(" ") !== -1)
					{
						qty = qty.replace(/ /g,"");
					}

					if(isNaN(price) || isNaN(qty))
					{
						valid = false;
					}else{
						total_price += parseFloat(price) * parseInt(qty, 10);
					}
				}
			}
			if(isNaN($("#vat").val()) || isNaN($("#amount").val()))
			{
				valid = false;
			}
			if(valid == true)
			{
				$("#amount").val(total_price.toFixed(2));
				var vat = 0;
				if($("#vat").val() != "")
				{
					vat = total_price * parseFloat($("#vat").val()) / 100;
				}
				$("#vat_amount").val(vat.toFixed(2));
				total = total_price + vat;
				$("#total").val(total.toFixed(2));
			}
		}
	});
})(jQuery_1_8_2);