var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmInvoicePayment = $("#frmInvoicePayment"),
			validate = ($.fn.validate !== undefined);
		
		function getPaymentForm(obj)
		{
			var params = {
					"id": obj.id, 
					"payment_method": obj.payment
				};
			$.get(["index.php?controller=pjFront&action=pjActionGetPaymentForm"].join(""), params).done(function (data) {
				$('#pjImPaymentMessage').hide();
				$('#pjImPayment').html(data).parent().show();
				switch (obj.payment) {
					case 'paypal':
						$('#imPaypal').trigger('submit');
						break;
					case 'authorize':
						$('#imAuthorize').trigger('submit');
						break;
					case 'creditcard':
					case 'bank':
					case 'cash':
						break;
				}
			}).fail(function () {
				
			});
		}
		
		if($frmInvoicePayment.length > 0 && validate)
		{
			$frmInvoicePayment.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				submitHandler: function(form){
					$('.pj-button').attr("disabled", "disabled");
					$('#pjImPaymentMessage').show();
					var $form = $(form);
					$.post(["index.php?controller=pjFront&action=pjActionSavePayment"].join(""), $form.serialize()).done(function (data) {
						if (data.code == "200") {
							getPaymentForm(data);
						} else if (data.code == "119") {
							$('.pj-button').removeAttr("disabled");
						}
					}).fail(function () {
						$('.pj-button').removeAttr("disabled");
					});
					return false;
				}
			});
		}
		
		$frmInvoicePayment.on("change", "#payment_method", function (e) {
			$(".boxBank").hide();
			$(".boxCC").hide();
			switch ($("option:selected", this).val()) {
				case 'creditcard':
					$(".boxCC").show();
					break;
				case 'bank':
					$(".boxBank").show();
					break;
				default:
					$(".boxCC").hide();
			}
		})
	});
})(jQuery_1_8_2);