DROP TABLE IF EXISTS `pas_products`;
CREATE TABLE IF NOT EXISTS `pas_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `closed` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pas_categories`;
CREATE TABLE IF NOT EXISTS `pas_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pas_clients`;
CREATE TABLE IF NOT EXISTS `pas_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pas_bids`;
CREATE TABLE IF NOT EXISTS `pas_bids` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `bid_price` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('received','rejected','won') NOT NULL DEFAULT 'received',
  `modified` datetime NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pas_fields`;
CREATE TABLE IF NOT EXISTS `pas_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pas_multi_lang`;
CREATE TABLE IF NOT EXISTS `pas_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pas_options`;
CREATE TABLE IF NOT EXISTS `pas_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pas_roles`;
CREATE TABLE IF NOT EXISTS `pas_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pas_users`;
CREATE TABLE IF NOT EXISTS `pas_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `pas_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(5, 'btnAddBid', 'backend', 'Button / + Add bid', 'script', NULL),
(6, 'btnAddCategory', 'backend', 'Button / + Add category', 'script', NULL),
(7, 'btnAddClient', 'backend', 'Button / + Add client', 'script', NULL),
(8, 'btnAddProduct', 'backend', 'Button / + Add product', 'script', NULL),
(9, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(10, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(11, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(12, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(13, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(14, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(15, 'btnLogin', 'backend', 'Login', 'script', NULL),
(16, 'btnReset', 'backend', 'Reset', 'script', NULL),
(17, 'btnSave', 'backend', 'Save', 'script', NULL),
(18, 'btnSearch', 'backend', 'Search', 'script', NULL),
(19, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(20, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(21, 'btnUseThisTheme', 'backend', 'Label / User this theme', 'script', NULL),
(22, 'created', 'backend', 'Created', 'script', NULL),
(23, 'dash_bid', 'backend', 'Dash / bid', 'script', NULL),
(24, 'dash_bidding_closes', 'backend', 'Label / Bidding closes', 'script', NULL),
(25, 'dash_bids', 'backend', 'Label / bids', 'script', NULL),
(26, 'dash_bids_so_far', 'backend', 'Label / bids so far', 'script', NULL),
(27, 'dash_bid_so_far', 'backend', 'Label / bid so far', 'script', NULL),
(28, 'dash_client', 'backend', 'Dash / client', 'script', NULL),
(29, 'dash_highest_bid', 'backend', 'Label / highest bid', 'script', NULL),
(30, 'dash_latest_bids', 'backend', 'Label / Latest bids', 'script', NULL),
(31, 'dash_latest_clients', 'backend', 'Label / Latest clients', 'script', NULL),
(32, 'dash_no_bids', 'backend', 'Label / No bids found.', 'script', NULL),
(33, 'dash_no_clients', 'backend', 'Label / No clients found.', 'script', NULL),
(34, 'dash_no_products', 'backend', 'Label / No products found.', 'script', NULL),
(35, 'dash_product', 'backend', 'Dash / product', 'script', NULL),
(36, 'dash_total_bids', 'backend', 'Dash / total bids', 'script', NULL),
(37, 'dash_total_clients', 'backend', 'Dash / total clients', 'script', NULL),
(38, 'dash_total_products', 'backend', 'Dash / total products', 'script', NULL),
(39, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(40, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(41, 'email', 'backend', 'E-Mail', 'script', NULL),
(42, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(43, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(44, 'email_message', 'backend', 'Label / Message', 'script', NULL),
(45, 'email_subject', 'backend', 'Label / Subject', 'script', NULL),
(46, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(47, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(48, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(49, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(50, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(51, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(52, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(53, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(54, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(55, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(56, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(57, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(58, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(59, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(60, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(61, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(62, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(63, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(64, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(65, 'infoAddBidDesc', 'backend', 'Infobox / Add bid', 'script', NULL),
(66, 'infoAddBidTitle', 'backend', 'Infobox / Add bid', 'script', NULL),
(67, 'infoAddCategoryDesc', 'backend', 'Infobox / Add Category', 'script', NULL),
(68, 'infoAddCategoryTitle', 'backend', 'Infobox / Add Category', 'script', NULL),
(69, 'infoAddClientDesc', 'backend', 'Infobox / Add client', 'script', NULL),
(70, 'infoAddClientTitle', 'backend', 'Infobox / Add client', 'script', NULL),
(71, 'infoAddProductDesc', 'backend', 'Infobox / Add product', 'script', NULL),
(72, 'infoAddProductTitle', 'backend', 'Infobox / Add product', 'script', NULL),
(73, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(74, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(75, 'infoBidsDesc', 'backend', 'Infobox / Bids', 'script', NULL),
(76, 'infoBidsTitle', 'backend', 'Infobox / Bids', 'script', NULL),
(77, 'infoCategoriesDesc', 'backend', 'Infobox / Categories', 'script', NULL),
(78, 'infoCategoriesTitle', 'backend', 'Infobox / Categories', 'script', NULL),
(79, 'infoClientsDesc', 'backend', 'Infobox / List of clients', 'script', NULL),
(80, 'infoClientsTitle', 'backend', 'Infobox / List of clients', 'script', NULL),
(81, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(82, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(83, 'infoNotificationsDesc', 'backend', 'Infobox / Notifications', 'script', NULL),
(84, 'infoNotificationsTitle', 'backend', 'Infobox / Notifications', 'script', NULL),
(85, 'infoPreviewInstallDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(86, 'infoPreviewInstallTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(87, 'infoProductPhotosDesc', 'backend', 'Infobox / Photos', 'script', NULL),
(88, 'infoProductPhotosTitle', 'backend', 'Infobox / Photos', 'script', NULL),
(89, 'infoProductsDesc', 'backend', 'Infobox / Products', 'script', NULL),
(90, 'infoProductsTitle', 'backend', 'Infobox / Products', 'script', NULL),
(91, 'infoUpdateBidDesc', 'backend', 'Label / Update bid', 'script', NULL),
(92, 'infoUpdateBidTitle', 'backend', 'Label / Update bid', 'script', NULL),
(93, 'infoUpdateCategoryDesc', 'backend', 'Infobox/ Update Category', 'script', NULL),
(94, 'infoUpdateCategoryTitle', 'backend', 'Infobox/ Update Category', 'script', NULL),
(95, 'infoUpdateClientDesc', 'backend', 'Infobox / Update', 'script', NULL),
(96, 'infoUpdateClientTitle', 'backend', 'Infobox / Update', 'script', NULL),
(97, 'infoUpdateProductDesc', 'backend', 'Infobox / Update product', 'script', NULL),
(98, 'infoUpdateProductTitle', 'backend', 'Infobox / Update product', 'script', NULL),
(99, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(100, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(101, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(102, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(103, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(104, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(105, 'lblBiddingClosedAt', 'backend', 'Label / Bidding closed at', 'script', NULL),
(106, 'lblBidPrice', 'backend', 'Label / Bid price', 'script', NULL),
(107, 'lblBids', 'backend', 'Label / Bids', 'script', NULL),
(108, 'lblBidsClosedAt', 'backend', 'Label / Bids closed at', 'script', NULL),
(109, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(110, 'lblCategoryName', 'backend', 'Label / Category name', 'script', NULL),
(111, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(112, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(113, 'lblClient', 'backend', 'Label / Client', 'script', NULL),
(114, 'lblCreated', 'backend', 'Label / Created', 'script', NULL),
(115, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(116, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(117, 'lblDays', 'backend', 'Days', 'script', NULL),
(118, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(119, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(120, 'lblDeleteImageConfirm', 'backend', 'Label / Delete image confirmation', 'script', NULL),
(121, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(122, 'lblError', 'backend', 'Error', 'script', NULL),
(123, 'lblExport', 'backend', 'Export', 'script', NULL),
(124, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(125, 'lblFullDescription', 'backend', 'Label / Full description', 'script', NULL),
(126, 'lblHighestBid', 'backend', 'Label / Highest bid', 'script', NULL),
(127, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(128, 'lblInstallConfig', 'backend', 'Language options', 'script', NULL),
(129, 'lblInstallConfigHide', 'backend', 'Hide language selector', 'script', NULL),
(130, 'lblInstallConfigLocale', 'backend', 'Language', 'script', NULL),
(131, 'lblInstallJs1_body', 'backend', 'Label / Install code', 'script', NULL),
(132, 'lblInstallJs1_title', 'backend', 'Label / Install code', 'script', NULL),
(133, 'lblIp', 'backend', 'IP address', 'script', NULL),
(134, 'lblIPAddress', 'backend', 'Label / IP address', 'script', NULL),
(135, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(136, 'lblLastBid', 'backend', 'Label / Latest bid', 'script', NULL),
(137, 'lblNa', 'backend', 'Label / n/a', 'script', NULL),
(138, 'lblName', 'backend', 'Name', 'script', NULL),
(139, 'lblNameAndCategory', 'backend', 'Label / Name & Category', 'script', NULL),
(140, 'lblNo', 'backend', 'No', 'script', NULL),
(141, 'lblNoCategoriesFound', 'backend', 'Label / No categories found.', 'script', NULL),
(142, 'lblNoProductsAdded', 'backend', 'Label / No products added. Add here', 'script', NULL),
(143, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL),
(144, 'lblOption', 'backend', 'Option', 'script', NULL),
(145, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(146, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(147, 'lblProduct', 'backend', 'Label / Product', 'script', NULL),
(148, 'lblProducts', 'backend', 'Label / Products', 'script', NULL),
(149, 'lblRole', 'backend', 'Role', 'script', NULL),
(150, 'lblSendEmailConfirmation', 'backend', 'Label / Send email confirmation', 'script', NULL),
(151, 'lblSetWon', 'backend', 'Label / Set as won bid', 'script', NULL),
(152, 'lblShortDescription', 'backend', 'Label / Short description', 'script', NULL),
(153, 'lblStatus', 'backend', 'Status', 'script', NULL),
(154, 'lblTotalBids', 'backend', 'Label / Total bids', 'script', NULL),
(155, 'lblType', 'backend', 'Type', 'script', NULL),
(156, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(157, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(158, 'lblValidNumberMessage', 'backend', 'Label / Please enter a valid currency.', 'script', NULL),
(159, 'lblValue', 'backend', 'Value', 'script', NULL),
(160, 'lblWon', 'backend', 'Label / Won', 'script', NULL),
(161, 'lblYes', 'backend', 'Yes', 'script', NULL),
(162, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(163, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(164, 'locales', 'backend', 'Languages', 'script', NULL),
(165, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(166, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(167, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(168, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(169, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(170, 'menuBids', 'backend', 'Menu / Bids', 'script', NULL),
(171, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(172, 'menuClients', 'backend', 'Menu / Clients', 'script', NULL),
(173, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(174, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(175, 'menuInstallPreview', 'backend', 'Menu / Preview & Install', 'script', NULL),
(176, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(177, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(178, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(179, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(180, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(181, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(182, 'menuProducts', 'backend', 'Label / Products', 'script', NULL),
(183, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(184, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(185, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(186, 'opt_o_bids_per_page', 'backend', 'Options / Number of bids per page', 'script', NULL),
(187, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(188, 'opt_o_currency_format', 'backend', 'Options / Currency format', 'script', NULL),
(189, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(190, 'opt_o_email_admin_new_account', 'backend', 'Option / New user registered', 'script', NULL),
(191, 'opt_o_email_admin_new_account_message', 'backend', 'Option / Email message', 'script', NULL),
(192, 'opt_o_email_admin_new_account_message_text', 'backend', 'Option / Email message', 'script', NULL),
(193, 'opt_o_email_admin_new_account_subject', 'backend', 'Option / Email subject', 'script', NULL),
(194, 'opt_o_email_admin_new_account_text', 'backend', 'Option / New user registered', 'script', NULL),
(195, 'opt_o_email_bid_won', 'backend', 'Option / Bid won', 'script', NULL),
(196, 'opt_o_email_bid_won_message', 'backend', 'Option / Email message', 'script', NULL),
(197, 'opt_o_email_bid_won_message_text', 'backend', 'Option / Email message', 'script', NULL),
(198, 'opt_o_email_bid_won_subject', 'backend', 'Option / Email subject', 'script', NULL),
(199, 'opt_o_email_bid_won_text', 'backend', 'Option / Bid won', 'script', NULL),
(200, 'opt_o_email_forgot', 'backend', 'Options / Password recovery email', 'script', NULL),
(201, 'opt_o_email_forgot_message', 'backend', 'Option / Email subject', 'script', NULL),
(202, 'opt_o_email_forgot_message_text', 'backend', 'Option / Email message', 'script', NULL),
(203, 'opt_o_email_forgot_subject', 'backend', 'Option / Email subject', 'script', NULL),
(204, 'opt_o_email_forgot_text', 'backend', 'Options / Password recovery', 'script', NULL),
(205, 'opt_o_email_new_account', 'backend', 'Option / User registration confirmation', 'script', NULL),
(206, 'opt_o_email_new_account_message', 'backend', 'Option / Email subject', 'script', NULL),
(207, 'opt_o_email_new_account_message_text', 'backend', 'Option / Email message', 'script', NULL),
(208, 'opt_o_email_new_account_subject', 'backend', 'Option / Email subject', 'script', NULL),
(209, 'opt_o_email_new_account_text', 'backend', 'Option / User registration confirmation', 'script', NULL),
(210, 'opt_o_email_new_bid', 'backend', 'Option / New bid placed', 'script', NULL),
(211, 'opt_o_email_new_bid_message', 'backend', 'Option / Email message', 'script', NULL),
(212, 'opt_o_email_new_bid_message_text', 'backend', 'Option / Email message', 'script', NULL),
(213, 'opt_o_email_new_bid_subject', 'backend', 'Option / Email subject', 'script', NULL),
(214, 'opt_o_email_new_bid_text', 'backend', 'Option / New bid placed', 'script', NULL),
(215, 'opt_o_products_per_page', 'backend', 'Options / Number of products per page', 'script', NULL),
(216, 'opt_o_registration_confirm', 'backend', 'Options / Status of clients'' account after registration', 'script', NULL),
(217, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(218, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(219, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(220, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(221, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(222, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(223, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(224, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(225, 'pass', 'backend', 'Password', 'script', NULL),
(226, 'pj_email_invalid', 'backend', 'Label / Please enter a valid email.', 'script', NULL),
(227, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(228, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(229, 'pj_number_validation', 'backend', 'Label / Please enter a valid number.', 'script', NULL),
(230, 'pj_same_category', 'backend', 'Label / Category name was already used.', 'script', NULL),
(231, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(232, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(233, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(234, 'url', 'backend', 'URL', 'script', NULL),
(235, 'user', 'backend', 'Username', 'script', NULL),
(236, 'front_all_bids', 'frontend', 'Label / All bids', 'script', NULL),
(237, 'front_all_categories', 'frontend', 'Label / All categories', 'script', NULL),
(238, 'front_back', 'frontend', 'Label / Back', 'script', NULL),
(239, 'front_bidding_closed', 'frontend', 'Label / Bidding closed', 'script', NULL),
(240, 'front_bidding_closed_in', 'frontend', 'Label / Biding closed in {X} hours', 'script', NULL),
(241, 'front_bidding_closed_in_day', 'frontend', 'Label / Biding closed in 1 day {X} hours', 'script', NULL),
(242, 'front_bidding_closed_in_days', 'frontend', 'Label / Biding closed in {D} days {X} hours', 'script', NULL),
(243, 'front_bids_lost', 'frontend', 'Label / Bids lost', 'script', NULL),
(244, 'front_bids_placed', 'frontend', 'Label / Bids placed', 'script', NULL),
(245, 'front_bids_won', 'frontend', 'Label / Bids won', 'script', NULL),
(246, 'front_bid_placed', 'frontend', 'Label / Bid placed', 'script', NULL),
(247, 'front_bid_won', 'frontend', 'Label / Bid won', 'script', NULL),
(248, 'front_btn_change_bid', 'frontend', 'Button / Change bid', 'script', NULL),
(249, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(250, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(251, 'front_btn_login', 'frontend', 'Button / Login', 'script', NULL),
(252, 'front_btn_register', 'frontend', 'Button / Register', 'script', NULL),
(253, 'front_btn_save', 'frontend', 'Button / Save', 'script', NULL),
(254, 'front_btn_send', 'frontend', 'Button / Send', 'script', NULL),
(255, 'front_btn_submit_bid', 'frontend', 'Button / Submit bid', 'script', NULL),
(256, 'front_confirm_bid', 'frontend', 'Label / Confirm Bid', 'script', NULL),
(257, 'front_confirm_bid_message', 'frontend', 'Label / confirm message', 'script', NULL),
(258, 'front_confirm_err', 'frontend', 'Label / Bid confirmation error', 'script', NULL),
(259, 'front_confirm_ok', 'frontend', 'Label / Bid confirmation OK', 'script', NULL),
(260, 'front_currency_invalid', 'frontend', 'Label / Please enter a valid currency.', 'script', NULL),
(261, 'front_email_address', 'frontend', 'Label / Email address', 'script', NULL),
(262, 'front_email_invalid', 'frontend', 'Label / Email address is invalid.', 'script', NULL),
(263, 'front_field_required', 'frontend', 'Label / This field is required.', 'script', NULL),
(264, 'front_forgot_password', 'frontend', 'Label / Forgot password?', 'script', NULL),
(265, 'front_have_an_account', 'frontend', 'Label / If you have an account', 'script', NULL),
(266, 'front_highest_bid', 'frontend', 'Label / Highest bid', 'script', NULL),
(267, 'front_home', 'frontend', 'Label / Home', 'script', NULL),
(268, 'front_if_have_account', 'frontend', 'Label / If you have an account,', 'script', NULL),
(269, 'front_login', 'frontend', 'Label / Login', 'script', NULL),
(270, 'front_login_here', 'frontend', 'Label / login here', 'script', NULL),
(271, 'front_login_to_place_bid', 'frontend', 'Label / Login to place a bid', 'script', NULL),
(272, 'front_menu_login', 'frontend', 'Label / Login', 'script', NULL),
(273, 'front_menu_logout', 'frontend', 'Label / Logout', 'script', NULL),
(274, 'front_menu_my_bids', 'frontend', 'Label / My bids', 'script', NULL),
(275, 'front_menu_profile', 'frontend', 'Label / Profile', 'script', NULL),
(276, 'front_menu_register', 'frontend', 'Label / Register', 'script', NULL),
(277, 'front_msg_repeat_password', 'frontend', 'Label / Please enter the same password again.', 'script', NULL),
(278, 'front_my_bid', 'frontend', 'Label / My bid', 'script', NULL),
(279, 'front_my_bids', 'frontend', 'Label / My bids', 'script', NULL),
(280, 'front_my_profile', 'frontend', 'Label / My Profile', 'script', NULL),
(281, 'front_na', 'frontend', 'Label / n/a', 'script', NULL),
(282, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(283, 'front_no_active_auctions', 'frontend', 'Label / No active auctions found.', 'script', NULL),
(284, 'front_no_bids_found', 'frontend', 'Label / No bids found.', 'script', NULL),
(285, 'front_number_invalid', 'frontend', 'Button / Please enter valid bid.', 'script', NULL),
(286, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(287, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(288, 'front_product', 'frontend', 'Label / Product', 'script', NULL),
(289, 'front_register', 'frontend', 'Label / Register', 'script', NULL),
(290, 'front_register_here', 'frontend', 'Label / register here', 'script', NULL),
(291, 'front_repeat_password', 'frontend', 'Label / Repeat password', 'script', NULL),
(292, 'front_repeat_your_password', 'frontend', 'Label / Repeat your password', 'script', NULL),
(293, 'front_see_past_1_bids', 'frontend', 'Label / See past 1 bid', 'script', NULL),
(294, 'front_see_past_3_bids', 'frontend', 'Label / See past 3 bids', 'script', NULL),
(295, 'front_set_your_bid', 'frontend', 'Label / Please set your bid first.', 'script', NULL),
(296, 'front_show', 'frontend', 'Label / Show', 'script', NULL),
(297, 'front_status', 'frontend', 'Label / Status', 'script', NULL),
(298, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(299, 'front_type_your_email', 'frontend', 'Label / Type your email address', 'script', NULL),
(300, 'front_type_your_name', 'frontend', 'Label / Type your name', 'script', NULL),
(301, 'front_type_your_password', 'frontend', 'Label / Type your password', 'script', NULL),
(302, 'front_your_bid', 'frontend', 'Label / Your bid', 'script', NULL),
(303, 'lblBidWon', 'frontend', 'Label / Bid won title', 'script', NULL),
(304, 'bidding_statuses_ARRAY_C', 'arrays', 'bidding_statuses_ARRAY_C', 'script', NULL),
(305, 'bidding_statuses_ARRAY_O', 'arrays', 'bidding_statuses_ARRAY_O', 'script', NULL),
(306, 'bidding_statuses_ARRAY_W', 'arrays', 'bidding_statuses_ARRAY_W', 'script', NULL),
(307, 'bid_statuses_ARRAY_C', 'arrays', 'bid_statuses_ARRAY_C', 'script', NULL),
(308, 'bid_statuses_ARRAY_O', 'arrays', 'bid_statuses_ARRAY_O', 'script', NULL),
(309, 'bid_statuses_ARRAY_W', 'arrays', 'bid_statuses_ARRAY_W', 'script', NULL),
(310, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(311, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(312, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(313, 'confirm_statuses_ARRAY_1', 'arrays', 'confirm_statuses_ARRAY_1', 'script', NULL),
(314, 'confirm_statuses_ARRAY_2', 'arrays', 'confirm_statuses_ARRAY_2', 'script', NULL),
(315, 'confirm_statuses_ARRAY_3', 'arrays', 'confirm_statuses_ARRAY_3', 'script', NULL),
(316, 'confirm_statuses_ARRAY_4', 'arrays', 'confirm_statuses_ARRAY_4', 'script', NULL),
(317, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(318, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(319, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(320, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(321, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(322, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(323, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(324, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(325, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(326, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(327, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(328, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(329, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(330, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(331, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(332, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(333, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(334, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(335, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(336, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(337, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(338, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(339, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(340, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(341, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(342, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(343, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(344, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(345, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(346, 'error_bodies_ARRAY_ABD01', 'arrays', 'error_bodies_ARRAY_ABD01', 'script', NULL),
(347, 'error_bodies_ARRAY_ABD03', 'arrays', 'error_bodies_ARRAY_ABD03', 'script', NULL),
(348, 'error_bodies_ARRAY_ABD04', 'arrays', 'error_bodies_ARRAY_ABD04', 'script', NULL),
(349, 'error_bodies_ARRAY_ABD08', 'arrays', 'error_bodies_ARRAY_ABD08', 'script', NULL),
(350, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(351, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(352, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(353, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(354, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(355, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(356, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(357, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(358, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(359, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(360, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(361, 'error_bodies_ARRAY_AP01', 'arrays', 'error_bodies_ARRAY_AP01', 'script', NULL),
(362, 'error_bodies_ARRAY_AP03', 'arrays', 'error_bodies_ARRAY_AP03', 'script', NULL),
(363, 'error_bodies_ARRAY_AP04', 'arrays', 'error_bodies_ARRAY_AP04', 'script', NULL),
(364, 'error_bodies_ARRAY_AP05', 'arrays', 'error_bodies_ARRAY_AP05', 'script', NULL),
(365, 'error_bodies_ARRAY_AP06', 'arrays', 'error_bodies_ARRAY_AP06', 'script', NULL),
(366, 'error_bodies_ARRAY_AP08', 'arrays', 'error_bodies_ARRAY_AP08', 'script', NULL),
(367, 'error_bodies_ARRAY_AP09', 'arrays', 'error_bodies_ARRAY_AP09', 'script', NULL),
(368, 'error_bodies_ARRAY_AP10', 'arrays', 'error_bodies_ARRAY_AP10', 'script', NULL),
(369, 'error_bodies_ARRAY_AP11', 'arrays', 'error_bodies_ARRAY_AP11', 'script', NULL),
(370, 'error_bodies_ARRAY_AP12', 'arrays', 'error_bodies_ARRAY_AP12', 'script', NULL),
(371, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(372, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(373, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(374, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(375, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(376, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(377, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(378, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(379, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(380, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(381, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(382, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(383, 'error_titles_ARRAY_ABD01', 'arrays', 'error_titles_ARRAY_ABD01', 'script', NULL),
(384, 'error_titles_ARRAY_ABD03', 'arrays', 'error_titles_ARRAY_ABD03', 'script', NULL),
(385, 'error_titles_ARRAY_ABD04', 'arrays', 'error_titles_ARRAY_ABD04', 'script', NULL),
(386, 'error_titles_ARRAY_ABD08', 'arrays', 'error_titles_ARRAY_ABD08', 'script', NULL),
(387, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(388, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(389, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(390, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(391, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(392, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(393, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(394, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(395, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(396, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(397, 'error_titles_ARRAY_AP01', 'arrays', 'error_titles_ARRAY_AP01', 'script', NULL),
(398, 'error_titles_ARRAY_AP03', 'arrays', 'error_titles_ARRAY_AP03', 'script', NULL),
(399, 'error_titles_ARRAY_AP04', 'arrays', 'error_titles_ARRAY_AP04', 'script', NULL),
(400, 'error_titles_ARRAY_AP05', 'arrays', 'error_titles_ARRAY_AP05', 'script', NULL),
(401, 'error_titles_ARRAY_AP06', 'arrays', 'error_titles_ARRAY_AP06', 'script', NULL),
(402, 'error_titles_ARRAY_AP08', 'arrays', 'error_titles_ARRAY_AP08', 'script', NULL),
(403, 'error_titles_ARRAY_AP09', 'arrays', 'error_titles_ARRAY_AP09', 'script', NULL),
(404, 'error_titles_ARRAY_AP10', 'arrays', 'error_titles_ARRAY_AP10', 'script', NULL),
(405, 'error_titles_ARRAY_AP11', 'arrays', 'error_titles_ARRAY_AP11', 'script', NULL),
(406, 'error_titles_ARRAY_AP12', 'arrays', 'error_titles_ARRAY_AP12', 'script', NULL),
(407, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(408, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(409, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(410, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(411, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(412, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(413, 'front_err_ARRAY_FOR01', 'arrays', 'front_err_ARRAY_FOR01', 'script', NULL),
(414, 'front_err_ARRAY_FOR02', 'arrays', 'front_err_ARRAY_FOR02', 'script', NULL),
(415, 'front_err_ARRAY_FOR03', 'arrays', 'front_err_ARRAY_FOR03', 'script', NULL),
(416, 'front_err_ARRAY_FOR04', 'arrays', 'front_err_ARRAY_FOR04', 'script', NULL),
(417, 'front_err_ARRAY_FOR05', 'arrays', 'front_err_ARRAY_FOR05', 'script', NULL),
(418, 'front_err_ARRAY_LOG01', 'arrays', 'front_err_ARRAY_LOG01', 'script', NULL),
(419, 'front_err_ARRAY_LOG02', 'arrays', 'front_err_ARRAY_LOG02', 'script', NULL),
(420, 'front_err_ARRAY_LOG03', 'arrays', 'front_err_ARRAY_LOG03', 'script', NULL),
(421, 'front_err_ARRAY_LOG04', 'arrays', 'front_err_ARRAY_LOG04', 'script', NULL),
(422, 'front_err_ARRAY_LOG05', 'arrays', 'front_err_ARRAY_LOG05', 'script', NULL),
(423, 'front_err_ARRAY_LOG06', 'arrays', 'front_err_ARRAY_LOG06', 'script', NULL),
(424, 'front_err_ARRAY_LOG07', 'arrays', 'front_err_ARRAY_LOG07', 'script', NULL),
(425, 'front_err_ARRAY_LOG08', 'arrays', 'front_err_ARRAY_LOG08', 'script', NULL),
(426, 'front_err_ARRAY_REG01', 'arrays', 'front_err_ARRAY_REG01', 'script', NULL),
(427, 'front_err_ARRAY_REG02', 'arrays', 'front_err_ARRAY_REG02', 'script', NULL),
(428, 'front_err_ARRAY_REG03', 'arrays', 'front_err_ARRAY_REG03', 'script', NULL),
(429, 'front_err_ARRAY_REG04', 'arrays', 'front_err_ARRAY_REG04', 'script', NULL),
(430, 'front_err_ARRAY_REG05', 'arrays', 'front_err_ARRAY_REG05', 'script', NULL),
(431, 'front_err_ARRAY_REG06', 'arrays', 'front_err_ARRAY_REG06', 'script', NULL),
(432, 'front_err_ARRAY_REG07', 'arrays', 'front_err_ARRAY_REG07', 'script', NULL),
(433, 'front_err_ARRAY_REG08', 'arrays', 'front_err_ARRAY_REG08', 'script', NULL),
(434, 'front_err_ARRAY_REG09', 'arrays', 'front_err_ARRAY_REG09', 'script', NULL),
(435, 'front_err_ARRAY_REG10', 'arrays', 'front_err_ARRAY_REG10', 'script', NULL),
(436, 'front_err_ARRAY_REG11', 'arrays', 'front_err_ARRAY_REG11', 'script', NULL),
(437, 'front_msg_ARRAY_FOR01', 'arrays', 'front_msg_ARRAY_FOR01', 'script', NULL),
(438, 'front_msg_ARRAY_PRO01', 'arrays', 'front_msg_ARRAY_PRO01', 'script', NULL),
(439, 'front_msg_ARRAY_REG01', 'arrays', 'front_msg_ARRAY_REG01', 'script', NULL),
(440, 'front_msg_ARRAY_REG02', 'arrays', 'front_msg_ARRAY_REG02', 'script', NULL),
(441, 'front_msg_ARRAY_REG03', 'arrays', 'front_msg_ARRAY_REG03', 'script', NULL),
(442, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(443, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(444, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(445, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(446, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(447, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(448, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(449, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(450, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(451, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(452, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(453, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(454, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(455, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(456, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(457, 'notify_email_ARRAY_account', 'arrays', 'notify_email_ARRAY_account', 'script', NULL),
(458, 'notify_email_ARRAY_account_admin', 'arrays', 'notify_email_ARRAY_account_admin', 'script', NULL),
(459, 'notify_email_ARRAY_bid_placed', 'arrays', 'notify_email_ARRAY_bid_placed', 'script', NULL),
(460, 'notify_email_ARRAY_bid_won', 'arrays', 'notify_email_ARRAY_bid_won', 'script', NULL),
(461, 'notify_email_ARRAY_forgot', 'arrays', 'notify_email_ARRAY_forgot', 'script', NULL),
(462, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(463, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(464, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(465, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(466, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(467, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(468, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(469, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(470, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(471, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(472, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(473, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(474, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(475, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(476, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(477, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(478, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(479, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(480, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(481, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(482, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(483, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(484, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(485, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(486, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(487, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(488, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(489, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(490, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(491, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(492, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(493, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(494, 'statuses_ARRAY_received', 'arrays', 'statuses_ARRAY_received', 'script', NULL),
(495, 'statuses_ARRAY_rejected', 'arrays', 'statuses_ARRAY_rejected', 'script', NULL),
(496, 'statuses_ARRAY_won', 'arrays', 'statuses_ARRAY_won', 'script', NULL),
(497, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(498, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(499, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(500, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(501, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(502, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(503, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(504, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(505, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(506, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(507, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(508, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(509, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(510, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(511, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(512, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(513, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(514, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(515, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(516, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(517, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(518, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(519, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(520, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(521, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(522, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(523, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(524, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(525, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(526, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(527, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(528, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(529, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(530, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(531, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(532, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(533, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(534, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(535, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(536, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(537, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(538, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `pas_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 1, 'title', '+ Add bid', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add category', 'script'),
(NULL, 7, 'pjField', 1, 'title', '+ Add client', 'script'),
(NULL, 8, 'pjField', 1, 'title', '+ Add product', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 10, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'bid', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Bidding closes', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'bids', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'bids so far', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'bid so far', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'client', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'highest bid', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Latest bids', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Latest clients', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'No bids found.', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'No clients found.', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'No products found.', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'product', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'total bids', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'total clients', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'total products', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Client with such email exists.', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 62, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Use the form below to add a new bid.', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Add bid', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Use the form below to add a new category to the system.', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Add a new category', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to add a new client.', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Add client', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Use the form below to add a new product to the online auction system. Add name, description, image, and category, and specify the bid closing time.', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Add product', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new user.', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Review a list of all bids you have created using the online auction script. If you want to add a new bid, click on the "+ Add bid" button. Click on the pencil icon of each bid entry to update the bid.', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Your bids', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Below is a list of all categories added to the auction system. Click on the “+ Add category”  button to add a new category or edit a category by clicking on the pencil icon.', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Below is a list of all clients. You can edit a specific client by clicking on the pencil icon in the corresponding entry.', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'List of clients', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Configure the general settings of your PHP Auction Script.', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new user account created, new bids placed, and bids won.', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'There are multiple color schemes available for the front-end user interface. Click on each of the thumbnails below to preview it and press "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Preview front-end', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Upload as many images as you want for this product. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Below is a list of all products you have added into the auction system. Click on the pencil icon of each product entry to check or edit product details, or add a new product by clicking on the "+ Add product" button.', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Make the necessary changes to the bid and click "Save" to update the information.', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Update bid', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'You can make any change on the form below and click "Save" button to update category information.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Update Category', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to edit client information.', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Update client', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'You can make any changes on the form below and click ''Save'' button to update the product information.', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Update product', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Make the necessary changes below and click "Save" to update the user information.', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Below is a list of all users (admins, editors). You can add new users, edit user details and change user status. ', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Bidding closing time', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Bid price', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Bids', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Bids closed at', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Category name', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Created', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Full description', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Highest bid', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Language options', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Hide language selector', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Copy the code below and paste it on your web page. It will show the front-end auction system. Please, note that the code should be used on a web page from the same domain name where the online auction script is installed.', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Latest bid', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'N/A', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Name & Category', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'No categories found. Add {STAG}here{ETAG}.', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'No products added. Add {STAG}here{ETAG}.', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Product', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Send email confirmation', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Set as won bid', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Short description', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Total bids', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Please enter a valid currency.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Won', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Bids', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Number of bids per page (Client Account)', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Currency format', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'New user registered', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 192, 'pjField', 1, 'title', '<u>Available tokens:</u><br/><br/>{Name}<br/>{Email}<br/>{Password}<br/>{Phone}', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Select "Yes", if you want to send email to administrators when there are new user accounts created. Otherwise, select "No".', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Bid won', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 197, 'pjField', 1, 'title', '<u>Available tokens:</u><br/><br/>{Product}<br/>{BidPrice}<br/>{Name}<br/>{Email}', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Select "Yes" if you want to send notification email to users to let them know that they won. Otherwise, select "No".', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Password recovery email', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 202, 'pjField', 1, 'title', '<u>Available tokens:</u><br/><br/>{Name}<br/>{Email}<br/>{Password}', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Select "Yes" if you''d like to allow to send password recovery to users. Otherwise, select "No".', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'User registration confirmation', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 207, 'pjField', 1, 'title', '<u>Available tokens:</u><br/><br/>{Name}<br/>{Email}<br/>{Password}<br/>{Phone}<br/>{ConfirmURL}', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Select "Yes" if you''d like to send confirmation email to users after their accounts created. Otherwise, select "No".', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'New bid placed', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 212, 'pjField', 1, 'title', '<u>Available tokens:</u><br/><br/>{Product}<br/>{BidPrice}<br/>{Name}<br/>{Email}', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Select "Yes" if you want to send notification emails to administrators when new bids placed. Otherwise, select "No".', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Number of products per page (Client Account)', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Status of client accounts after registration', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Please enter a valid email.', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'User with such email exists.', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Category name was already used.', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'All bids', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'All categories', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Bidding closed', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Bidding closes in {X} hours', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Bidding closes in 1 day {X} hours', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Bidding closes in {D} days {X} hours', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Bids lost', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Bids placed', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Bids won', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Bid placed', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Bid won', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Change bid', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Submit bid', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Confirm Bid', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'You are about to place a {PRICE} bid for {PRODUCT}. Please, confirm your bid!', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Your bid could not be placed.', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Your bid has been submitted successfully!', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Please enter a valid currency.', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'If you don''t have an account,', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Highest bid', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Home', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'If you already have an account,', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'log in here.', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Login to place a bid', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'My bids', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Please enter the same password again.', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'My bid', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'My bids', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'My Profile', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'N/A', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'No active auctions found.', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'No bids found.', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Please enter valid bid.', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Product', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'register here.', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Repeat password', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Repeat your password', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'See past 1 bid', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'See past {X} bids', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Please set your bid first.', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Show', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Type your email', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Type your name', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Type your password', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Your bid', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Bid won: {PRICE} by {CLIENT}', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Bidding closed', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Bidding open', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Bidding won', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Closed', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Opening', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Won', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Parameters are missing.', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Your account is confirmed.', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Security code does not match.', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Your account is already confirmed.', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Given email is not associated with any account.', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'All changes made to the bid have been saved.', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'New bid has been added into the system.', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'The bid could not be added successfully. Please try again.', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'The bid you are looking for is missing.', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'We are sorry, but the client has not been added.', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Client your looking for is missing.', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'New category has been added into the system.', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'The category could not be added successfully. Please try again.', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'The category you are looking for is missing.', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'All changes to the product have been saved.', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'New product has been added to the system.', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'We are sorry that new product could not be added successfully.', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'New product could not be added because image size is too big and your server cannot upload it. Maximum allowed post content is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'The product could not be updated successfully because image size is too big and your server cannot upload it. Maximum allowed post content is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'We are sorry that product you are looking for is missing.', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'New product has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'The product information was already saved, but the image could not be uploaded because the size is too big. Maximum allowed size is {MAXSIZE}. Please, upload another image.', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'The product information was already saved, but image could not be uploaded successfully.', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'The product information was already saved, but the image could not be uploaded because the size is too big. Maximum allowed size is {MAXSIZE}. Please, upload another image.', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Bid updated!', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Bid added!', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Bid failed to add!', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Bid not found!', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Client updated!', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Client added!', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Client failed to add.', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Client not found.', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Category updated!', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Category added!', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Category failed to add!', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Category not found!', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Product updated!', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Product added!', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Product failed to add!', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Image size too big!', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Image size too big!', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Product not found!', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Upload error!', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Image size too big', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Upload error!', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Image size too big', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Your account is already disabled.', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Email does not exist in the system.', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Your account does not exist.', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Your account is already disabled.', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Wrong password. Please try again.', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Name is missing.', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Name cannot be empty.', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Repeat password is missing.', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Repeat password cannot be empty.', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Repeat password is not the same as password.', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Account could not be created. Please check again.', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'The password was already sent to your email.', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Your profile has been saved.', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Your account has been created.', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Your account has been created, but it''s not active yet.', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Your account has been created. Please follow the link in the email to confirm your account.', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'User registration confirmation', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Admin - New user registered', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Admin - New bid placed', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Bid won', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Password recovery', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Received', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Rejected', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Won', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_bid_won_subject', 'Congrats! You have won the bid!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_new_bid_subject', 'New bid submitted', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_new_account_subject', 'Successful account registration', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_admin_new_account_subject', 'New user registration', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_bid_won_message', '<p>Dear (Name),</p><p>Congratulations! Your bid {BidPrice} for {Product} has won!</p><p>&nbsp;</p><p>Regards,</p><p>&nbsp;</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_new_bid_message', '<p>Dear Admin,</p><p>A new bid {BidPrice} has&nbsp;just been submitted for {Product}.</p><p>Bidder: {Name}<br />Email: {Email}</p><p><br />Regards,</p><p>&nbsp;</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_new_account_message', '<p>Dear {Name},</p><p>Thank you for your registration! Here are your access details:</p><p>User: {Email}<br />Password: {Password}</p><p>&nbsp;</p><p>Regards,</p><p>&nbsp;</p><p>&nbsp;</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_admin_new_account_message', '<p>Dear Admin,</p><p>A new user registration has just been made through your online auction system!</p><p>User: {Email}<br />Phone: {Phone}</p><p><br />Regards,</p><p>&nbsp;</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_subject', 'Recover your password', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_message', '<p>Dear {Name},</p><p>Your password is {Password}.</p><p>&nbsp;</p><p>Regards,</p>', 'data');

INSERT INTO `pas_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_currency', 1, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 6, 1, NULL),
(1, 'o_currency_format', 1, '1|2|3|4::1', '1,234,567.89|1 234 567.89|1.234.567,89|1 234 567,89', 'enum', 7, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 7, 0, NULL),
(1, 'o_products_per_page', 1, '5', NULL, 'int', 7, 1, NULL),
(1, 'o_bids_per_page', 1, '10', NULL, 'int', 8, 1, NULL),
(1, 'o_registration_confirm', 1, '0|1|2::1', 'Confirmed|Confirm via email|Not confirmed', 'enum', 9, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 10, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 11, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 13, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 14, 1, NULL),

(1, 'o_email_new_account', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_new_account_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_new_account_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_admin_new_account', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_admin_new_account_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_admin_new_account_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_new_bid', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_new_bid_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_new_bid_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_bid_won', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_bid_won_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_bid_won_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_forgot', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_forgot_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_forgot_message', 3, '', NULL, 'text', 3, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `pas_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');