<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFrontEnd extends pjFront
{
	public function __construct()
	{
		parent::__construct();
		$this->setAjax(true);
		$this->setLayout('pjActionEmpty');
	}

	public function pjActionLoad()
	{
		$this->setAjax(false);
		$this->setLayout('pjActionFront');
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
	}
	
	public function pjActionLoadCss()
	{
		$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
		
		$theme = $this->option_arr['o_theme'];
		$fonts = $this->option_arr['o_theme'];
		if(isset($_GET['theme']) && in_array($_GET['theme'], array('theme1','theme2','theme3','theme4','theme5','theme6','theme7','theme8','theme9','theme10')))
		{
			$theme = $_GET['theme'];
			$fonts = $_GET['theme'];
		}
		
		$arr = array(
				array('file' => "$fonts.css", 'path' => PJ_CSS_PATH . "fonts/"),
				array('file' => 'pjQuery.fancybox.css', 'path' => $dm->getPath('pj_fancybox')),
				array('file' => "style.css", 'path' => PJ_CSS_PATH),
				array('file' => "$theme.css", 'path' => PJ_CSS_PATH . "themes/"),
				array('file' => 'transitions.css', 'path' => PJ_CSS_PATH)
		);
		
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			$string = FALSE;
			if ($stream = fopen($item['path'] . $item['file'], 'rb'))
			{
				$string = stream_get_contents($stream);
				fclose($stream);
			}
			
			if ($string !== FALSE)
			{
				echo str_replace(
					array("pjWrapper", "images/", "url('fancybox", "url('blank.gif')"),
					array("pjWrapperPHPAuction_" . $theme, 
							PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/', 
							"url('" . PJ_INSTALL_URL . $dm->getPath('pj_fancybox') . "fancybox",
							"url('" . PJ_INSTALL_URL . $dm->getPath('pj_fancybox') . "blank.gif')"
					),
					$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH . 'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH . 'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	
	public function pjActionLogout()
	{
		if($this->isXHR())
		{
			if ($this->isFrontLogged())
			{
				unset($_SESSION[$this->defaultFrontClient]);
			}
		}
		exit;
	}
	
	public function pjActionSetBid()
	{
		if($this->isXHR())
		{
			$_SESSION[$this->defaultStore] = $_POST;
			$bid_price = pjUtil::convertToMySQLNumber($_POST['bid_price'], $this->option_arr);
			$message = __('front_confirm_bid_message', true);
			$message = str_replace("{PRICE}", pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($bid_price, $this->option_arr), $this->option_arr['o_currency']), $message);
			$message = str_replace("{PRODUCT}", $_POST['product'], $message);
			
			pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => $message));
		}
	}
	
	public function pjActionSaveBid()
	{
		if($this->isXHR())
		{
			if (!isset($_SESSION[$this->defaultStore]) || empty($_SESSION[$this->defaultStore]))
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'msg' => __('front_set_your_bid', true)));
			}
			if(isset($_GET['confirm']))
			{
				$STORE = $_SESSION[$this->defaultStore];
				$data = array();
				$data['product_id'] = $STORE['product_id'];
				$data['client_id'] = $STORE['client_id'];
				$data['bid_price'] = $data['bid_price'] = pjUtil::convertToMySQLNumber($STORE['bid_price'], $this->option_arr);;
				$data['created'] = date('Y-m-d H:i:s');
				$data['status'] = "received";
				$data['modified'] = ":NULL";
				
				$id = pjBidModel::factory()->setAttributes($data)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					pjAppController::pjActionConfirmSend($this->option_arr, $id, PJ_SALT, 'bid_placed', $this->getLocaleId());
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'product_id' => $data['product_id'], 'msg' => __('front_confirm_ok', true)));
				} else {
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 102, 'msg' => __('front_confirm_err', true)));
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 101, 'msg' => __('front_confirm_err', true)));
			}
		}
	}
	
	public function pjActionConfirm()
	{
		$this->setAjax(false);
		
		$this->setLayout('pjActionConfirm');
		
		$pjClientModel = pjClientModel::factory();
		
		if (isset($_GET['hash']) && isset($_GET['id']))
		{
			$arr = $pjClientModel->find($_GET['id'])->getData();
			$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
			if ($_GET['hash'] != $hash)
			{
				$this->set('status', 3);
			}else if($arr['status'] == 'T'){
				$this->set('status', 4);
			} else {
				$pjClientModel->reset()->where('id', $arr['id'])->limit(1)->modifyAll(array('status' => 'T'));
				$this->set('status', 2);
			}
		} elseif (!isset($_GET['err'])) {
			$this->set('status', 1);
		}
	}
}
?>