<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoAddBidTitle', true, false), __('infoAddBidDesc', true, false)); 
	
	?>
	
	<div class="clear_both">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBids&amp;action=pjActionCreate" method="post" id="frmCreateBid" class="form pj-form" autocomplete="off">
			<input type="hidden" name="bid_create" value="1" />
			<p>
				<label class="title"><?php __('lblProduct'); ?></label>
				<span class="inline_block">
					<?php
					if(!empty($tpl['product_arr']))
					{ 
						?>
						<span class="block float_left r5">
							<select name="product_id" id="product_id" class="pj-form-field w300 required" data-msg-required="<?php __('pj_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['product_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
								}
								?>
							</select>
						</span>
						<a id="pjFdEditProduct" href="#" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminProducts&amp;action=pjActionUpdate&id={ID}" class="pj-edit-product" style="display:none;"></a>
						<?php
					} else {
						$message = __('lblNoProductsAdded', true, false);
						$message = str_replace("{STAG}", '<a href="index.php?controller=pjAdminProducts&amp;action=pjActionCreate">', $message);
						$message = str_replace("{ETAG}", '</a>', $message);
						?>
						<input type="hidden" name="hidden_product_id" id="hidden_product_id" class="required" data-msg-required="<?php __('pj_field_required'); ?>"/>
						<label class="content"><?php echo $message;?></label>
						<?php
					}
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblClient'); ?></label>
				<span class="inline_block">
					<?php
					if(!empty($tpl['client_arr']))
					{ 
						?>
						<span class="block float_left r5">
							<select name="client_id" id="client_id" class="pj-form-field w200 required" data-msg-required="<?php __('pj_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['client_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
								}
								?>
							</select>
						</span>
						<a id="pjFdEditClient" href="#" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClient&amp;action=pjActionUpdate&id={ID}" class="pj-edit-client" style="display:none;"></a>
						<?php
					} else {
						$message = __('lblNoClientsAdded', true, false);
						$message = str_replace("{STAG}", '<a href="index.php?controller=pjAdminClients&amp;action=pjActionCreate">', $message);
						$message = str_replace("{ETAG}", '</a>', $message);
						?>
						<input type="hidden" name="hidden_client_id" id="hidden_client_id" class="required" data-msg-required="<?php __('pj_field_required'); ?>"/>
						<label class="content"><?php echo $message;?></label>
						<?php
					}
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblBidPrice'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
					<input type="text" id="bid_price" name="bid_price" class="pj-form-field required w100<?php echo isset($tpl['option_arr']['o_currency_format']) ? ' pjNumber' : ' number';?>" data-currency_format="<?php echo isset($tpl['option_arr']['o_currency_format']) ? $tpl['option_arr']['o_currency_format'] : 0;?>" data-msg-required="<?php __('pj_field_required'); ?>" data-msg-number="<?php __('pj_number_validation'); ?>" data-msg-pjNumber="<?php __('lblValidNumberMessage');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('pj_field_required');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach (__('statuses', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo $k == 'received' ? ' selected="selected"' : null;?>><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBids&action=pjActionIndex';" />
				</span>
			</p>
		</form>
	</div>
	
	<?php
}
?>