<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoUpdateClientTitle', true, false), __('infoUpdateClientDesc', true, false));
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate" method="post" id="frmUpdateClient" class="form pj-form">
		<input type="hidden" name="client_update" value="1" />
		<input type="hidden" name="id" value="<?php echo (int) $tpl['arr']['id']; ?>" />
		<div class="overflow clear_both">
			<div class="w350 float_left">
				<p>
					<label class="title"><?php __('lblTotalBids'); ?></label>
					<span class="inline_block t5">
						<?php
						if((int) $tpl['arr']['cnt_bids'] > 0)
						{
							?><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBids&amp;action=pjActionIndex&amp;client_id=<?php echo $tpl['arr']['id'];?>"><?php echo $tpl['arr']['cnt_bids'];?></a><?php
						}else{
							echo 0;
						} 
						?>
					</span>
				</p>
			</div>
			<div class="w350 float_right">
				<p>
					<label class="title"><?php __('lblIPAddress'); ?></label>
					<span class="inline_block t5">
						<?php echo pjSanitize::clean($tpl['arr']['ip']);?>
					</span>
				</p>
			</div>
		</div>
		<?php
		if(count($tpl['bid_arr']) == 1)
		{
			?>
			<p>
				<label class="title"><?php __('lblLastBid'); ?></label>
				<span class="inline_block t5">
					<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBids&amp;action=pjActionUpdate&amp;id=<?php echo $tpl['bid_arr'][0]['id'];?>"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['bid_arr'][0]['created']));?></a>
				</span>
			</p>
			<?php
		} 
		?>
		<p>
			<label class="title"><?php __('lblName'); ?></label>
			<span class="inline_block">
				<input type="text" name="name" id="name" value="<?php echo pjSanitize::html($tpl['arr']['name']); ?>" class="pj-form-field w250 required" data-msg-required="<?php __('pj_field_required');?>"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('email'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
				<input type="text" name="email" id="email" class="pj-form-field required email w200" value="<?php echo pjSanitize::html($tpl['arr']['email']); ?>" data-msg-required="<?php __('pj_field_required');?>" data-msg-email="<?php __('pj_email_invalid');?>" data-msg-remote="<?php __('pj_email_taken');?>"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('pass'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
				<input type="password" name="password" id="password" class="pj-form-field required w200" value="<?php echo pjSanitize::html($tpl['arr']['password']); ?>" data-msg-required="<?php __('pj_field_required');?>"/>
			</span>
		</p>
		
		<p>
			<label class="title"><?php __('lblPhone'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
				<input type="text" name="phone" id="phone" value="<?php echo pjSanitize::html($tpl['arr']['phone']); ?>" class="pj-form-field w200" placeholder="(123) 456-7890"/>
			</span>
		</p>
		
		<p>
			<label class="title"><?php __('lblStatus'); ?></label>
			<span class="inline_block">
				<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('pj_field_required');?>">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach (__('u_statarr', true) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
			<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminClients&action=pjActionIndex';" />
		</p>
	</form>
	<?php
}
?>