<?php
include_once dirname(__FILE__) . '/elements/header.php';
?>
<div class="pjAs-body">
	<div class="pjAs-items">
		<?php
		if(!empty($tpl['product_arr']))
		{
			foreach($tpl['product_arr'] as $k => $v)
			{
				$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/310x240.png';
				if(isset($v['image']) && !empty($v['image']) && file_exists(PJ_INSTALL_PATH . $v['image']))
				{
					$image = PJ_INSTALL_URL . $v['image'];
				}
				?>
				<div class="pjAs-item<?php echo isset($tpl['product_ids']) ? (array_key_exists($v['id'], $tpl['product_ids']) ? ' pjAs-item-bade' : NULL ) : NULL; ?>">
					<div class="pjAs-item-image">
						<a href="#" class="pjAsProductItem" data-id="<?php echo $v['id'];?>"><img src="<?php echo $image;?>" alt=""></a>
					</div><!-- /.pjAs-item-image -->
		
					<div class="pjAs-item-content">
						<div class="pjAs-item-name"><a href="#" class="pjAsProductItem" data-id="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['name']);?></a></div><!-- /.pjAs-item-name -->
		
						<div class="pjAs-item-desc"><?php echo pjSanitize::html($v['category']);?></div><!-- /.pjAs-item-desc -->
		
						<div class="pjAs-item-info"><?php echo nl2br(pjSanitize::clean($v['description']))?></div><!-- /.pjAs-item-info -->
		
						<div class="pjAs-item-actions">
							<?php
							$has_bid_won = false;
							if(isset($v['bid_won_price']) && (float) $v['bid_won_price'] > 0)
							{
								$has_bid_won = true;
							}
							if($has_bid_won == false)
							{
								if(isset($tpl['product_ids']) && array_key_exists($v['id'], $tpl['product_ids']))
								{ 
									?>
									<div class="pjAs-item-h-bid">
										<p><?php __('front_my_bid');?>: <strong><?php echo pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($tpl['product_ids'][$v['id']], $tpl['option_arr']), $tpl['option_arr']['o_currency']);?></strong></p>
				
										<p><?php __('front_highest_bid');?>: <strong><?php echo pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['highest_bid'], $tpl['option_arr']), $tpl['option_arr']['o_currency']);?></strong></p>
									</div><!-- /.pjAs-item-h-bid -->
									
									<a href="#" class="btn btn-primary pull-right pjAsProductItem" data-id="<?php echo $v['id'];?>"><?php __('front_btn_change_bid');?></a>
									<?php
								}else{
									if((float) $v['highest_bid'] > 0)
									{
										?>
										<div class="pjAs-item-h-bid">
											<p><?php __('front_highest_bid');?>: </p>
		
											<p><strong><?php echo pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['highest_bid'], $tpl['option_arr']), $tpl['option_arr']['o_currency']);?></strong></p>
										</div><!-- /.pjAs-item-h-bid -->
										<?php
									}
									if($controller->isFrontLogged())
									{
										?>
										<a href="#" class="btn btn-primary pull-right pjAsProductItem" data-id="<?php echo $v['id'];?>"><?php __('front_btn_submit_bid');?></a>
										<?php
									}
								}
								$closed_message = __('front_bidding_closed_in', true);
								$seconds = strtotime($v['closed']) - time(); 
								$hours = ($seconds / 3600) % 24 ;
								$days = floor($seconds / (24 * 3600));
								if($days == 1)
								{
									$closed_message = __('front_bidding_closed_in_day', true);
								}else if($days > 1){
									$closed_message = __('front_bidding_closed_in_days', true);
								}
								$closed_message = str_replace("{D}", $days, $closed_message);
								$closed_message = str_replace("{X}", $hours, $closed_message);
								?>
			
								<div class="pjAs-item-bids">
									<?php
									if((int) $v['cnt_bids'] > 0)
									{ 
										?><p><strong><?php echo pjSanitize::clean($v['cnt_bids']);?></strong> <?php __('front_bids_placed');?></p><?php
									} 
									?>
			
									<p class="pjAs-text-small"><span class="glyphicon glyphicon-time"></span> <?php echo $closed_message;?></p>
								</div><!-- /.pjAs-item-bids -->
								<?php
							}else{
								?>
								<div class="pjAs-item-h-bid">
									<p><?php __('front_bid_won');?>: </p>

									<p><strong><?php echo pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['bid_won_price'], $tpl['option_arr']), $tpl['option_arr']['o_currency']);?></strong></p>
								</div><!-- /.pjAs-item-h-bid -->
								<div class="pjAs-item-bids">
									<?php
									if((int) $v['cnt_bids'] > 0)
									{ 
										?><p><strong><?php echo pjSanitize::clean($v['cnt_bids']);?></strong> <?php __('front_bids_placed');?></p><?php
									} 
									?>
									<p class="pjAs-text-small"><?php __('front_bidding_closed');?></p>
								</div><!-- /.pjAs-item-bids -->
								<?php
							} 
							?>
						</div><!-- /.pjAs-item-actions -->
					</div><!-- /.pjAs-item-content -->
				</div><!-- /.pjAs-item -->
				<?php
			}
		} else {
			__('front_no_active_auctions');
		}
		?>
	</div><!-- /.pjAs-items -->

	<?php
	include_once dirname(__FILE__) . '/elements/pagination.php';
	?>
</div><!-- /.pjAs-body -->