var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var validator,
			$frmCreateBid = $("#frmCreateBid"),
			$frmUpdateBid = $("#frmUpdateBid"),
			$dialogConfirmation = $("#dialogConfirmation"),
			chosen = ($.fn.chosen !== undefined),
			dialog = ($.fn.dialog !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		if (chosen) {
			$("#filter_product_id").chosen();
			$("#product_id").chosen();
			$("#client_id").chosen();
		}
		if ($dialogConfirmation.length > 0 && dialog) {
			$dialogConfirmation.dialog({
				autoOpen: false,
				draggable: false,
				resizable: false,
				modal: true,
				width: 645,
				open: function () {
					$dialogConfirmation.html("");
					$.post("index.php?controller=pjAdminBids&action=pjActionConfirmation", $frmUpdateBid.serialize()).done(function (data) {
						$dialogConfirmation.html(data);
						validator = $dialogConfirmation.find("form").validate({
							
						});
						$dialogConfirmation.dialog("option", "position", "center");
						attachTinyMce.call(null);
					});
				},
				buttons: (function () {
					var buttons = {};
					buttons[pasApp.locale.button.send] = function () {
						if (validator.form()) {
							$.post("index.php?controller=pjAdminBids&action=pjActionConfirmation", $dialogConfirmation.find("form").serialize()).done(function (data) {
								$dialogConfirmation.dialog("close");
							})
						}
					};
					buttons[pasApp.locale.button.cancel] = function () {
						$dialogConfirmation.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
		function attachTinyMce(options) {
			if (window.tinymce !== undefined) {
				tinymce.EditorManager.editors = [];
				var defaults = {
					selector: "textarea.mceEditor",
					theme: "modern",
					width: 610,
					height: 330,
					plugins: [
				         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
				         "searchreplace visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
				         "save table contextmenu directionality emoticons template paste textcolor"
				    ],
				    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons"
				};
				
				var settings = $.extend({}, defaults, options);
				
				tinymce.init(settings);
			}
		}
		if ($frmCreateBid.length > 0 || $frmUpdateBid.length > 0) {
			jQuery.validator.addMethod("pjNumber", function(value, element) {
				
				var currency_format = parseInt($(element).attr('data-currency_format'), 10);
				var regex = /^((\d+)|(\d{1,3})(\,\d{3}|)*)(\.\d{1,2}|)$/;
				if(currency_format == 1)
				{
					regex = /^((\d+)|(\d{1,3})(\,\d{3}|)*)(\.\d{1,2}|)$/;
				}else if(currency_format == 2){
					regex = /^((\d+)|(\d{1,3})(\ \d{3}|)*)(\.\d{1,2}|)$/;
				}else if(currency_format == 3){
					regex = /^((\d+)|(\d{1,3})(\.\d{3}|)*)(\,\d{1,2}|)$/;
				}else if(currency_format == 4){
					regex = /^((\d+)|(\d{1,3})(\ \d{3}|)*)(\,\d{1,2}|)$/;
				}
				if(regex.test(value))
				{
					return true;
				}else{
					if(currency_format == 3 || currency_format == 4)
					{
						regex = /^((\d+)|(\d{1,3})(\\d{3}|)*)(\.\d{1,2}|)$/;
						if(regex.test(value))
						{
							return true;
						}else{
							return false;
						}
					}else{
						return false;
					}
				}
			});
		}
		if ($frmCreateBid.length > 0 && validate) {
			$frmCreateBid.validate({
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'product_id' || element.attr('name') == 'client_id')
					{
						error.insertAfter(element.parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
			
		}
		if ($frmUpdateBid.length > 0 && validate) {
			$frmUpdateBid.validate({
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'product_id' || element.attr('name') == 'client_id')
					{
						error.insertAfter(element.parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		function formatProduct(str, obj) 
		{
			return '<a href="index.php?controller=pjAdminProducts&action=pjActionUpdate&id='+obj.product_id+'">'+str+'</a>';
		}
		function formatClient(str, obj) 
		{
			return '<a href="index.php?controller=pjAdminClients&action=pjActionUpdate&id='+obj.client_id+'">'+str+'</a>';
		}
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminBids&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminBids&action=pjActionDeleteBid&id={:id}"}
				          ],
				columns: [{text: myLabel.product, type: "text", sortable: true, editable: false, width: 150, renderer: formatProduct},
				          {text: myLabel.client, type: "text", sortable: true, editable: false, width: 130, renderer: formatClient},
				          {text: myLabel.created, type: "text", sortable: true, editable: false, width: 130},
				          {text: myLabel.bid_price, type: "text", sortable: true, editable: false, width: 80},
				          {text: myLabel.status, type: "select", sortable: false, editable: true, width: 90, options: [
     						                                                                                     {label: myLabel.won, value: "won"}, 
     						                                                                                     {label: myLabel.received, value: "received"},
     						                                                                                     {label: myLabel.rejected, value: "rejected"}
     						                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminBids&action=pjActionGetBid" + pjGrid.queryString,
				dataType: "json",
				fields: ['product', 'name', 'created', 'bid_price', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminBids&action=pjActionDeleteBidBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminBids&action=pjActionSaveBid&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: "",
				product_id: "",
				name: "",
				email: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBids&action=pjActionGetBid", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBids&action=pjActionGetBid", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val(),
				product_id: "",
				name: "",
				email: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBids&action=pjActionGetBid", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
			e.stopPropagation();
			$(".pj-form-filter-advanced").toggle();
		}).on("submit", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var obj = {},
				$this = $(this),
				arr = $this.serializeArray(),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
				obj[arr[i].name] = arr[i].value;
			}
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBids&action=pjActionGetBid", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("reset", ".frm-filter-advanced", function (e) {
			$(".pj-button-detailed").trigger("click");
			$("#name").val('');
			$("#email").val('');
			$("#filter_product_id").val('');
		}).on("change", "#product_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if($(this).val() != '')
			{
				$('#pjFdEditProduct').css('display', 'block');
				var href = $('#pjFdEditProduct').attr('data-href');
				href = href.replace("{ID}", $(this).val());
				$('#pjFdEditProduct').attr('href', href);
			}else{
				$('#pjFdEditProduct').css('display', 'none');
			}
		}).on("change", "#client_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if($(this).val() != '')
			{
				$('#pjFdEditClient').css('display', 'block');
				var href = $('#pjFdEditClient').attr('data-href');
				href = href.replace("{ID}", $(this).val());
				$('#pjFdEditClient').attr('href', href);
			}else{
				$('#pjFdEditClient').css('display', 'none');
			}
		}).on("change", "#status", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if($(this).val() == 'won')
			{
				$('.pjPasSendConfirmation').css('display', 'inline-block');
			}else{
				$('.pjPasSendConfirmation').css('display', 'none');
			}
		}).on("click", ".pjPasSendConfirmation", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$dialogConfirmation.dialog('open');
		});
	});
})(jQuery_1_8_2);