(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined),
		fancybox = (pjQ.$.fn.fancybox !== undefined),
		routes = [
		          	{pattern: /^#!\/loadProducts$/, eventName: "loadProducts"},
		          	{pattern: /^#!\/loadProducts\/category_id:(\d+)\/page:(\d+)$/, eventName: "loadProducts"},
		          	{pattern: /^#!\/loadProducts\/page:(\d+)$/, eventName: "loadProducts"},
		          	{pattern: /^#!\/loadRegister$/, eventName: "loadRegister"},
		          	{pattern: /^#!\/loadLogin$/, eventName: "loadLogin"},
		          	{pattern: /^#!\/loadForgot$/, eventName: "loadForgot"},
		          	{pattern: /^#!\/loadProfile$/, eventName: "loadProfile"},
		          	{pattern: /^#!\/loadMyBids$/, eventName: "loadMyBids"},
		          	{pattern: /^#!\/loadMyBids\/status:(\S+)\/page:(\d+)$/, eventName: "loadMyBids"},
		          	{pattern: /^#!\/loadMyBids\/page:(\d+)$/, eventName: "loadMyBids"},
		          	{pattern: /^#!\/loadProduct\/id:(\d+)$/, eventName: "loadProduct"},
		         ];
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadProducts");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function PHPAuction(opts) {
		if (!(this instanceof PHPAuction)) {
			return new PHPAuction(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	PHPAuction.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	PHPAuction.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	PHPAuction.prototype = {
		reset: function () {
			this.$container = null;			
			this.container = null;
			this.opts = {};
			this.category_id = null;
			this.product_id = null;
			this.page = null;
			this.bid_page = null;
			this.status = null;
			return this;
		},
		
		disableButtons: function () {
			this.$container.find(".btn").each(function (i, el) {
				pjQ.$(el).attr("disabled", "disabled");
			});
		},
		enableButtons: function () {
			this.$container.find(".btn").removeAttr("disabled");
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjPasContainer_" + self.opts.index);
						
			self.$container = pjQ.$(self.container);
			
			pjQ.$('#pjAsBtnConfirm_' + self.opts.index).click(function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.disableButtons.call(self);
				var ajax_url = [self.opts.folder, "index.php?controller=pjFrontEnd&action=pjActionSaveBid", "&confirm=1"].join("");
				if(self.opts.session_id != '')
				{
					ajax_url = [self.opts.folder, "index.php?controller=pjFrontEnd&action=pjActionSaveBid", "&confirm=1", "&session_id=", self.opts.session_id].join("");
				}
				pjQ.$.get(ajax_url).done(function (data) {
					pjQ.$('#pjAsConfirmBid_' + self.opts.index).modal('hide');
					pjQ.$('#pjAsMessageBid_' + self.opts.index).html(data.msg);
					if(data.code == '200')
					{
						if (!hashBang("#!/loadProduct/id:" + data.product_id)) 
						{
							self.product_id = data.product_id;
							self.loadProduct.call(self);
						}
					}
					pjQ.$('#pjAsMessageModal_' + self.opts.index).modal('show');
					self.enableButtons.call(self);
				}).fail(function () {
					self.enableButtons.call(self);
				});
				return false;
			});
			
			this.$container.on("click.pas", ".pjAsLocale", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.opts.locale = pjQ.$(this).data("id");
				var params = {};
				if(self.opts.session_id != '')
				{
					params.session_id = self.opts.session_id;
				}
				params.locale_id = self.opts.locale;
				params.index = self.opts.index;
				
				self.disableButtons.call(self);
				pjQ.$.get([self.opts.folder, "index.php?controller=pjFront&action=pjActionLocale"].join(""), params).done(function (data) {
					if (!hashBang("#!/loadProducts")) {
						pjQ.$(window).trigger("loadProducts");
					}
				}).fail(function () {
					self.enableButtons.call(self);
				});
				return false;
			}).on("click.pas", ".pjAsMenuItem", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var load = pjQ.$(this).attr("data-load");
				if (!hashBang("#!/" + load)) 
				{
					pjQ.$(window).trigger(load);
				}
				return false;
			}).on("click.pas", ".pjAsMenuLogout", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var params = {};
				if(self.opts.session_id != '')
				{
					params.session_id = self.opts.session_id;
				}
				params.locale_id = self.opts.locale;
				params.index = self.opts.index;
				self.disableButtons.call(self);
				pjQ.$.get([self.opts.folder, "index.php?controller=pjFrontEnd&action=pjActionLogout"].join(""), params).done(function (data) {
					if (!hashBang("#!/loadProducts")) {
						pjQ.$(window).trigger("loadProducts");
					}
				}).fail(function () {
					self.enableButtons.call(self);
				});
				return false;
			}).on("change.pas", '.pjAsCategorySelector', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var category_id = pjQ.$(this).val();
				self.disableButtons.call(self);
				if(parseInt(category_id, 10) > 0)
				{
					if (!hashBang("#!/loadProducts/category_id:" + category_id + "/page:1")) 
					{
						self.page = 1;
						self.loadProducts.call(self);
					}
				}else{
					self.category_id = null;
					self.page = null;
					if (!hashBang("#!/loadProducts")) 
					{
						self.loadProducts.call(self);
					}
				}
				return false;
			}).on("click.pas", '.pjAsCategoryItem', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var category_id = pjQ.$(this).attr("data-id");
				self.disableButtons.call(self);
				if(parseInt(category_id, 10) > 0)
				{
					if (!hashBang("#!/loadProducts/category_id:" + category_id + "/page:1")) 
					{
						self.page = 1;
						self.loadProducts.call(self);
					}
				}else{
					self.category_id = null;
					self.page = null;
					if (!hashBang("#!/loadProducts")) 
					{
						self.loadProducts.call(self);
					}
				}
				return false;
			}).on("click.pas", '.pjAsPageNode', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var page = pjQ.$(this).attr('data-page');
				self.disableButtons.call(self);
				if(self.category_id != null)
				{
					if (!hashBang("#!/loadProducts/category_id:"+self.category_id+"/page:" + page)) 
					{
						self.page = page;
						self.loadProducts.call(self);
					}
				}else{
					if (!hashBang("#!/loadProducts/page:" + page)) 
					{
						self.page = page;
						self.loadProducts.call(self);
					}
				}
				
				return false;
			}).on("click.pas", ".pjAsBidsFilter", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var status = pjQ.$(this).attr("data-status");
				if(status != 'A')
				{
					if (!hashBang("#!/loadMyBids/status:" + status + "/page:1")) 
					{
						self.status = status;
						self.bid_page = 1;
						self.loadMyBids.call(self);
					}
				}else{
					if (!hashBang("#!/loadMyBids")) 
					{
						self.status = null;
						self.bid_page = null;
						self.loadMyBids.call(self);
					}
				}
				return false;
			}).on("click.pas", '.pjAsPageNodeBid', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var page = pjQ.$(this).attr('data-page');
				self.disableButtons.call(self);
				if(self.status != null)
				{
					if (!hashBang("#!/loadMyBids/status:"+self.status+"/page:" + page)) 
					{
						self.status = status;
						self.bid_page = page;
						self.loadMyBids.call(self);
					}
				}else{
					if (!hashBang("#!/loadMyBids/page:" + page)) 
					{
						self.bid_page = page;
						self.loadMyBids.call(self);
					}
				}
				
				return false;
			}).on("click.pas", '.pjAsProductItem', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var id = pjQ.$(this).attr('data-id');
				self.disableButtons.call(self);
				if (!hashBang("#!/loadProduct/id:" + id)) 
				{
					self.product_id = id;
					self.loadProduct.call(self);
				}
				return false;
			}).on("click.pas", '.pjAsSeePast3Bids', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var bid_list = pjQ.$('#pjAsBidListClone_' + self.opts.index).html();
				pjQ.$('#pjAsPastBidsList_' + self.opts.index).html(bid_list);
				pjQ.$('#pjAsPast3Bids_' + self.opts.index).modal('show');
				return false;
			}).on("click.pas", '#pjAsSubmitBid_' + self.opts.index, function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				pjQ.$('#pjAsSubmitForm_' + self.opts.index).submit();
				return false;
			});
			
			pjQ.$(window).on("loadProducts", this.$container, function (e) {
				switch (arguments.length) {
					case 1:
						self.category_id = null;
						self.page = null;
						break;
					case 2:
						self.page = arguments[1];
						break;
					case 3:
						self.category_id = arguments[1];
						self.page = arguments[2];
						break;
				}
				self.loadProducts.call(self);
			}).on("loadRegister", this.$container, function (e) {
				self.loadRegister.call(self);
			}).on("loadLogin", this.$container, function (e) {
				self.loadLogin.call(self);
			}).on("loadForgot", this.$container, function (e) {
				self.loadForgot.call(self);
			}).on("loadProfile", this.$container, function (e) {
				self.loadProfile.call(self);
			}).on("loadMyBids", this.$container, function (e) {
				switch (arguments.length) {
					case 1:
						self.status = null;
						self.bid_page = null;
						break;
					case 2:
						self.bid_page = arguments[1];
						break;
					case 3:
						self.status = arguments[1];
						self.bid_page = arguments[2];
						break;
				}
				self.loadMyBids.call(self);
			}).on("loadProduct", this.$container, function (e) {
				switch (arguments.length) {
					case 2:
						self.product_id = arguments[1];
						break;
				}
				self.loadProduct.call(self);
			});
			
			if (window.location.hash.length === 0) {
				this.loadProducts.call(this);
			} else {
				onHashChange.call(null);
			}
		},
		
		bindLogin: function(){
			var self = this;
			var $frmLogin = pjQ.$('#pjAsLoginForm_' + self.opts.index);
			
			if($frmLogin.length > 0 && validate)
			{
				$frmLogin.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.parent().next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						var ajax_url = [self.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionLogin"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionLogin", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.post(ajax_url, $form.serialize()).done(function (data) {
							if(data.code == '200')
							{
								if (!hashBang("#!/loadProducts")) 
								{
									self.loadProducts.call(self);
								}
							}else{
								var $loginMessage = pjQ.$('#pjAsLoginMessage_'+ self.opts.index);
								$loginMessage.html(data.text);
								$loginMessage.show();
								self.enableButtons.call(self);
							}
						}).fail(function () {
							self.enableButtons.call(self);
						});
						return false;
					}
				});
			}
		},
		bindForgot: function(){
			var self = this,
				$frmForgot = pjQ.$('#pjAsForgotForm_' + self.opts.index);
			if($frmForgot.length > 0 && validate)
			{
				$frmForgot.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.parent().next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $forgotMessage = pjQ.$('#pjAsForgotMessage_'+ self.opts.index);
						var $form = pjQ.$(form);
						var ajax_url = [self.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionForgot"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionForgot", "&session_id=", self.opts.session_id].join("");
						}
						$forgotMessage.html("").hide();
						pjQ.$.post(ajax_url, $form.serialize()).done(function (data) {
							
							if(data.code == '200')
							{
								$forgotMessage.removeClass('alert-danger').addClass('alert-success').html(data.text);
							}else{
								$forgotMessage.removeClass('alert-success').addClass('alert-danger').html(data.text);
							}
							$forgotMessage.show();
							self.enableButtons.call(self);
						}).fail(function () {
							self.enableButtons.call(self);
						});
						return false;
					}
				});
			}
		},
		bindRegister: function(){
			var self = this;
			var $frmRegister = pjQ.$('#pjAsRegisterForm_' + self.opts.index);
			
			if($frmRegister.length > 0 && validate)
			{
				$frmRegister.validate({
					rules : {
						"repeat_password" : {
							equalTo : "#password_" + self.opts.index
						}
					},
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.parent().next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $registerMessage = pjQ.$('#pjAsRegisterMessage_'+ self.opts.index);
						var $form = pjQ.$(form);
						var ajax_url = [self.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionRegister"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionRegister", "&session_id=", self.opts.session_id].join("");
						}
						$registerMessage.html("").hide();
						pjQ.$.post(ajax_url, $form.serialize()).done(function (data) {
							if(data.code == '200')
							{
								$registerMessage.removeClass('alert-danger').addClass('alert-success').html(data.text);
								$form.find("input[name='name']").val("");
								$form.find("input[name='email']").val("");
								$form.find("input[name='password']").val("");
								$form.find("input[name='repeat_password']").val("");
								$form.find("input[name='phone']").val("");
							}else{
								$registerMessage.removeClass('alert-success').addClass('alert-danger').html(data.text);
							}
							$registerMessage.show();
							self.enableButtons.call(self);
						}).fail(function () {
							self.enableButtons.call(self);
						});
						return false;
					}
				});
			}
		},
		bindProfile: function(){
			var self = this;
			var $frmProfile = pjQ.$('#pjAsProfileForm_' + self.opts.index);
			
			if($frmProfile.length > 0 && validate)
			{
				$frmProfile.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.parent().next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $profileMessage = pjQ.$('#pjAsProfileMessage_'+ self.opts.index);
						var $form = pjQ.$(form);
						var ajax_url = [self.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionProfile"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionProfile", "&session_id=", self.opts.session_id].join("");
						}
						$profileMessage.html("").hide();
						pjQ.$.post(ajax_url, $form.serialize()).done(function (data) {
							if(data.code == '200')
							{
								$profileMessage.removeClass('alert-danger').addClass('alert-success').html(data.text);
							}else{
								$profileMessage.removeClass('alert-success').addClass('alert-danger').html(data.text);
							}
							$profileMessage.show();
							self.enableButtons.call(self);
						}).fail(function () {
							self.enableButtons.call(self);
						});
						return false;
					}
				});
			}
		},
		loadProducts: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			if(self.category_id != null)
			{
				params.category_id = self.category_id;
			}
			if(self.page != null)
			{
				params.page = self.page;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionProducts"].join(""), params).done(function (data) {
				self.$container.html(data);
			}).fail(function () {
				
			});
		},
		bindProduct: function(){
			var self = this;
			var $frm = pjQ.$('#pjAsSubmitForm_' + self.opts.index);
			pjQ.$(".pjPasSelectorThumb").fancybox({
				openEffect	: 'none',
				closeEffect	: 'none'
			});
			pjQ.$('.modal-dialog').css("z-index", "9999");
			if($frm.length > 0 && validate)
			{
				pjQ.$.validator.addMethod("pjNumber", function(value, element) {
					
					var currency_format = parseInt(pjQ.$(element).attr('data-currency_format'), 10);
					var regex = /^((\d+)|(\d{1,3})(\,\d{3}|)*)(\.\d{1,2}|)$/;
					if(currency_format == 1)
					{
						regex = /^((\d+)|(\d{1,3})(\,\d{3}|)*)(\.\d{1,2}|)$/;
					}else if(currency_format == 2){
						regex = /^((\d+)|(\d{1,3})(\ \d{3}|)*)(\.\d{1,2}|)$/;
					}else if(currency_format == 3){
						regex = /^((\d+)|(\d{1,3})(\.\d{3}|)*)(\,\d{1,2}|)$/;
					}else if(currency_format == 4){
						regex = /^((\d+)|(\d{1,3})(\ \d{3}|)*)(\,\d{1,2}|)$/;
					}
					if(regex.test(value))
					{
						return true;
					}else{
						if(currency_format == 3 || currency_format == 4)
						{
							regex = /^((\d+)|(\d{1,3})(\\d{3}|)*)(\.\d{1,2}|)$/;
							if(regex.test(value))
							{
								return true;
							}else{
								return false;
							}
						}else{
							return false;
						}
					}
				});
				$frm.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.parent().next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
		            	self.disableButtons.call(self);
						var $form = pjQ.$(form);
						var ajax_url = [self.opts.folder, "index.php?controller=pjFrontEnd&action=pjActionSetBid"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFrontEnd&action=pjActionSetBid", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.post(ajax_url, $form.serialize()).done(function (data) {
							if(data.code == '200')
							{
								pjQ.$('#pjAsBidConfirmMessage_' + self.opts.index).html(data.text);
								pjQ.$('#pjAsConfirmBid_' + self.opts.index).modal('show');
							}
							self.enableButtons.call(self);
						}).fail(function () {
							self.enableButtons.call(self);
						});
						return false;
					}
				});
			}
		},
		loadLogin: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionLogin"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindLogin.call(self);
			}).fail(function () {
				
			});
		},
		loadForgot: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionForgot"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindForgot.call(self);
			}).fail(function () {
				
			});
		},
		loadRegister: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionRegister"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindRegister.call(self);
			}).fail(function () {
				
			});
		},
		loadProfile: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionProfile"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindProfile.call(self);
			}).fail(function () {
				
			});
		},
		loadMyBids: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			if(self.status != null)
			{
				params.status = self.status;
			}
			if(self.bid_page != null)
			{
				params.page = self.bid_page;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionMyBids"].join(""), params).done(function (data) {
				if (data.code != undefined && data.status == 'ERR') {
					if (!hashBang("#!/loadProducts")) 
					{
						self.loadProducts.call(self);
					}
				}else{
					self.$container.html(data);
				}
			}).fail(function () {
				
			});
		},
		loadProduct: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			if(self.product_id != null)
			{
				params.product_id = self.product_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontPublic&action=pjActionProduct"].join(""), params).done(function (data) {
				if (data.code != undefined && data.status == 'ERR') {
					if (!hashBang("#!/loadProducts")) 
					{
						self.loadProducts.call(self);
					}
				}else{
					self.$container.html(data);
					self.bindProduct.call(self);
				}
			}).fail(function () {
				
			});
		}
	};
	
	window.PHPAuction = PHPAuction;	
})(window);