DROP TABLE IF EXISTS `storelocator_stores`;
CREATE TABLE IF NOT EXISTS `storelocator_stores` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `country_id` int(11) unsigned DEFAULT NULL,
  `address_state` varchar(100) DEFAULT NULL,
  `address_city` varchar(255) DEFAULT NULL,
  `address_content` varchar(255) DEFAULT NULL,
  `address_zip` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `opening_times` text DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `image_name` varchar(255) DEFAULT NULL,
  `lat` varchar(50) DEFAULT NULL,
  `lng` varchar(50) DEFAULT NULL,
  `latlng` tinyint(1) unsigned DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'F',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `storelocator_categories`;
CREATE TABLE IF NOT EXISTS `storelocator_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_title` varchar(255) DEFAULT NULL,
  `marker` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `storelocator_stores_categories`;
CREATE TABLE IF NOT EXISTS `storelocator_stores_categories` (
  `store_id` int(11) unsigned NOT NULL,
  `category_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`store_id`, `category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `storelocator_fields`;
CREATE TABLE IF NOT EXISTS `storelocator_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `storelocator_multi_lang`;
CREATE TABLE IF NOT EXISTS `storelocator_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(100) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `storelocator_options`;
CREATE TABLE IF NOT EXISTS `storelocator_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `storelocator_roles`;
CREATE TABLE IF NOT EXISTS `storelocator_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `storelocator_users`;
CREATE TABLE IF NOT EXISTS `storelocator_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `storelocator_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 2, 1, NULL),
(1, 'o_default_address', 1, 'London, UK', NULL, 'string', 3, 1, NULL),
(1, 'o_map_language', 1, 'ar|eu|bg|bn|ca|cs|da|de|el|en|en-AU|en-GB|es|eu|fa|fi|fil|fr|gl|gu|hi|hr|hu|id|it|iw|ja|kn|ko|lt|lv|ml|mr|nl|nn|no|or|pl|pt|pt-BR|pt-PT|rm|ro|ru|sk|sl|sr|sv|tl|ta|te|th|tr|uk|vi|zh-CN|zh-TW::en-AU', 'ARABIC|BASQUE|BULGARIAN|BENGALI|CATALAN|CZECH|DANISH|GERMAN|GREEK|ENGLISH|ENGLISH (AUSTRALIAN)|ENGLISH (GREAT BRITAIN)|SPANISH|BASQUE|FARSI|FINNISH|FILIPINO|FRENCH|GALICIAN|GUJARATI|HINDI|CROATIAN|HUNGARIAN|INDONESIAN|ITALIAN|HEBREW|JAPANESE|KANNADA|KOREAN|LITHUANIAN|LATVIAN|MALAYALAM|MARATHI|DUTCH|NORWEGIAN NYNORSK|NORWEGIAN|ORIYA|POLISH|PORTUGUESE|PORTUGUESE (BRAZIL)|PORTUGUESE (PORTUGAL)|ROMANSCH|ROMANIAN|RUSSIAN|SLOVAK|SLOVENIAN|SERBIAN|SWEDISH|TAGALOG|TAMIL|TELUGU|THAI|TURKISH|UKRAINIAN|VIETNAMESE|CHINESE (SIMPLIFIED)|CHINESE (TRADITIONAL)', 'enum', 4, 1, NULL),
(1, 'o_zoom_level', 1, '1|2|3|4|5|6|7|8|9|10|11|12|13|14|15::10', '1|2|3|4|5|6|7|8|9|10|11|12|13|14|15', 'enum', 5, 1, NULL),
(1, 'o_distance', 1, 'km|miles::miles', 'km|miles', 'enum', 6, 1, NULL),
(1, 'o_use_categories', 1, 'Yes|No::Yes', 'Yes|No', 'enum', 7, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 12, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 11, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `storelocator_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

INSERT INTO `storelocator_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(126, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(127, 'url', 'backend', 'URL', 'script', NULL),
(128, 'user', 'backend', 'Username', 'script', NULL),
(129, 'vr_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(130, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(131, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(132, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(133, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(134, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(135, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(136, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(137, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(138, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(139, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(140, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(141, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(142, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(143, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(144, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(145, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(146, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(147, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(148, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(149, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(150, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(151, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(152, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(153, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(155, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(156, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(157, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(160, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(161, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(162, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(163, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(164, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(165, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(166, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(167, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(168, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(169, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(170, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(171, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(172, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(175, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(176, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(177, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(178, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(179, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(180, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(181, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(182, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(183, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(184, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(185, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(186, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(187, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(188, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(189, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(190, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(191, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(192, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(193, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(194, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(195, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(196, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(197, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(198, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(199, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(200, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(201, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(202, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(203, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(204, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(205, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(206, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(207, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(208, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(209, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(210, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(211, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(212, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(213, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(214, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(215, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(216, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(217, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(218, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(219, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(220, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(221, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(222, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(223, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(224, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(225, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(226, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(227, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(228, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(229, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(230, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(231, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(232, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(233, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(234, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(235, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(236, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(237, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(238, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(239, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(240, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(241, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(242, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(243, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(244, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(245, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(246, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(247, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(248, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(249, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(250, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(251, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(252, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(253, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(280, 'opt_o_default_address', 'backend', 'Options / Default address', 'script', NULL),
(281, 'opt_o_zoom_level', 'backend', 'Options / Map zoom level', 'script', NULL),
(282, 'opt_o_distance', 'backend', 'Options / Distance', 'script', NULL),
(283, 'menuStores', 'backend', 'Menu / Stores', 'script', NULL),
(284, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(285, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(286, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(287, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(288, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(289, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(290, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(291, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(292, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(293, 'lblAddCategory', 'backend', 'Label / Add category', 'script', NULL),
(294, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(295, 'lblStores', 'backend', 'Label / Stores', 'script', NULL),
(296, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(297, 'lblInactive', 'backend', 'Label / Inactive', 'script', NULL),
(298, 'lblDeleteSelected', 'backend', 'Label / Delete selected', 'script', NULL),
(299, 'lblDeleteConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(301, 'infoAddCategoryTitle', 'backend', 'Infobox / Add category title', 'script', NULL),
(302, 'infoAddCategoryBody', 'backend', 'Infobox / Add category body', 'script', NULL),
(303, 'lblUpdateCategory', 'backend', 'Label / Update category', 'script', NULL),
(330, 'error_titles_ARRAY_AS01', 'arrays', 'error_titles_ARRAY_AS01', 'script', NULL),
(331, 'error_titles_ARRAY_AS03', 'arrays', 'error_titles_ARRAY_AS03', 'script', NULL),
(332, 'error_titles_ARRAY_AS04', 'arrays', 'error_titles_ARRAY_AS04', 'script', NULL),
(333, 'error_titles_ARRAY_AS08', 'arrays', 'error_titles_ARRAY_AS08', 'script', NULL),
(334, 'error_bodies_ARRAY_AS01', 'arrays', 'error_bodies_ARRAY_AS01', 'script', NULL),
(335, 'error_bodies_ARRAY_AS03', 'arrays', 'error_bodies_ARRAY_AS03', 'script', NULL),
(336, 'error_bodies_ARRAY_AS04', 'arrays', 'error_bodies_ARRAY_AS04', 'script', NULL),
(337, 'error_bodies_ARRAY_AS08', 'arrays', 'error_bodies_ARRAY_AS08', 'script', NULL),
(338, 'lblAddStore', 'backend', 'Label / Add store', 'script', NULL),
(339, 'lblStore', 'backend', 'Label / Store', 'script', NULL),
(340, 'lblStoreName', 'backend', 'Label / Store name', 'script', NULL),
(341, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(342, 'lblOpeningTimes', 'backend', 'Label / Opening times', 'script', NULL),
(343, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(344, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(345, 'lblState', 'backend', 'Label / State', 'script', NULL),
(346, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(347, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(348, 'lblZip', 'backend', 'Label / Zip', 'script', NULL),
(349, 'lblGMapNote', 'backend', 'Label / GMap note', 'script', NULL),
(350, 'btnGoogleMapsApi', 'backend', 'Button / Google Maps API', 'script', NULL),
(351, 'lblLatitude', 'backend', 'Label / Latitude', 'script', NULL),
(352, 'lblLongitude', 'backend', 'Label / Longitude', 'script', NULL),
(353, 'lblAddressNotFound', 'backend', 'Label / Address not found', 'script', NULL),
(354, 'lblUpdateStore', 'backend', 'Label / Update store', 'script', NULL),
(356, 'lblDeleteImageTitle', 'backend', 'Label / Delete image', 'script', NULL),
(357, 'lblDeleteImageConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(359, 'lblRevertStatus', 'backend', 'Label / Revert Status', 'script', NULL),
(386, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(387, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(388, 'front_label_category', 'frontend', 'Label / Category', 'script', NULL),
(389, 'front_label_address', 'frontend', 'Label / Address', 'script', NULL),
(390, 'front_label_within', 'frontend', 'Label / Within', 'script', NULL),
(391, 'front_button_search', 'frontend', 'Button / Search', 'script', NULL),
(392, 'distances_ARRAY_1', 'arrays', 'distances_ARRAY_1', 'script', NULL),
(393, 'distances_ARRAY_5', 'arrays', 'distances_ARRAY_5', 'script', NULL),
(394, 'distances_ARRAY_10', 'arrays', 'distances_ARRAY_10', 'script', NULL),
(395, 'distances_ARRAY_25', 'arrays', 'distances_ARRAY_25', 'script', NULL),
(396, 'distances_ARRAY_50', 'arrays', 'distances_ARRAY_50', 'script', NULL),
(397, 'distances_ARRAY_100', 'arrays', 'distances_ARRAY_100', 'script', NULL),
(424, 'front_label_choose', 'frontend', 'Label / Choose', 'script', NULL),
(425, 'front_label_opening_times', 'frontend', 'Label / Opening times', 'script', NULL),
(426, 'opt_o_use_categories', 'backend', 'Options / Use categories', 'script', NULL),
(427, 'lblImportStore', 'backend', 'Label / Import', 'script', NULL),
(428, 'infoImportTitle', 'backend', 'Infobox / Import title', 'script', NULL),
(429, 'infoImportBody', 'backend', 'Infobox / Import body', 'script', NULL),
(430, 'lblCSVFile', 'backend', 'Label / CSV file', 'script', NULL),
(431, 'btnImport', 'backend', 'Button / Import', 'script', NULL),
(432, 'error_titles_ARRAY_AS11', 'arrays', 'error_titles_ARRAY_AS11', 'script', NULL),
(433, 'error_bodies_ARRAY_AS11', 'arrays', 'error_bodies_ARRAY_AS11', 'script', NULL),
(434, 'error_titles_ARRAY_AS10', 'arrays', 'error_titles_ARRAY_AS10', 'script', NULL),
(435, 'error_bodies_ARRAY_AS10', 'arrays', 'error_bodies_ARRAY_AS10', 'script', NULL),
(436, 'error_titles_ARRAY_AS09', 'arrays', 'error_titles_ARRAY_AS09', 'script', NULL),
(437, 'error_bodies_ARRAY_AS09', 'arrays', 'error_bodies_ARRAY_AS09', 'script', NULL),
(438, 'lblInstallPhp1Title', 'backend', 'Install / Install notice', 'script', NULL),
(439, 'lblInstall_1', 'backend', 'Install / Step 1', 'script', NULL),
(440, 'lblInstall', 'backend', 'Label / Install', 'script', NULL),
(441, 'lblEmail', 'backend', 'Label / Email', 'script', NULL),
(442, 'lblWebsite', 'backend', 'Label / Website', 'script', NULL),
(443, 'lblGoogleMarker', 'backend', 'Label / Google marker', 'script', NULL),
(444, 'lblDeleteMarkerTitle', 'backend', 'Label / Delete marker', 'script', NULL),
(445, 'lblDeleteMarkerConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(446, 'front_label_full_address', 'frontend', 'Label / full address', 'script', NULL),
(447, 'front_label_directions', 'frontend', 'Label / directions', 'script', NULL),
(448, 'front_label_close', 'frontend', 'Label / close', 'script', NULL),
(449, 'front_label_from', 'frontend', 'Label / From', 'script', NULL),
(451, 'front_label_go', 'frontend', 'Label / Go', 'script', NULL),
(452, 'lblSameCategory', 'backend', 'Label / Same category', 'script', NULL),
(453, 'login_err_ARRAY_4', 'arrays', 'login_err_ARRAY_4', 'script', NULL),
(454, 'lblAllowedExtension', 'backend', 'Label / Allowed ext', 'script', NULL),
(480, 'front_label_phone', 'frontend', 'Label / Phone', 'script', NULL),
(481, 'front_label_email', 'frontend', 'Label / Email', 'script', NULL),
(482, 'front_label_website', 'frontend', 'Label / Website', 'script', NULL),
(483, 'front_label_not_found', 'frontend', 'Label / No results found', 'script', NULL),
(484, 'front_label_sent', 'frontend', 'Label / Email sent', 'script', NULL),
(485, 'front_label_empty_email', 'frontend', 'Label / Email empty', 'script', NULL),
(486, 'front_label_invalid_email', 'frontend', 'Label / Invalid email', 'script', NULL),
(487, 'lblWithLatLng', 'backend', 'Label / With lat/lng', 'script', NULL),
(488, 'front_button_send', 'frontend', 'Button / Send', 'script', NULL),
(489, 'opt_o_map_language', 'backend', 'Options / Supported language on Map', 'script', NULL),
(557, 'infoStoresTitle', 'backend', 'Infobox / Stores title', 'script', NULL),
(558, 'infoStoresDesc', 'backend', 'Infobox / Stores desc', 'script', NULL),
(559, 'infoAddStoreTitle', 'backend', 'Infobox / Add Store title', 'script', NULL),
(560, 'infoAddStoreDesc', 'backend', 'Infobox / Add store desc', 'script', NULL),
(561, 'infoUpdateStoreTitle', 'backend', 'Infobox / Update Store title', 'script', NULL),
(562, 'infoUpdateStoreDesc', 'backend', 'Infobox / Update store desc', 'script', NULL),
(563, 'infoCategoriesTitle', 'backend', 'Infobox / Cateogries titles', 'script', NULL),
(564, 'infoCategoriesDesc', 'backend', 'Infobox / Cateogries desc', 'script', NULL),
(565, 'infoUpdateCategoryTitle', 'backend', 'Infobox / Update category title', 'script', NULL),
(566, 'infoUpdateCategoryDesc', 'backend', 'Infobox / Update category desc', 'script', NULL),
(567, 'infoUsersTitle', 'backend', 'Infobox / User lis title', 'script', NULL),
(568, 'infoUsersDesc', 'backend', 'Infobox / User lis desc', 'script', NULL),
(569, 'infoAddUserTitle', 'backend', 'Infobox / Add User title', 'script', NULL),
(570, 'infoAddUserDesc', 'backend', 'Infobox / Add User desc', 'script', NULL),
(571, 'infoUpdateUserTitle', 'backend', 'Infobox / Update User title', 'script', NULL),
(572, 'infoUpdateUserDesc', 'backend', 'Infobox / Update User desc', 'script', NULL),
(573, 'lblLatLng', 'backend', 'Label / Lat & Lng', 'script', NULL),
(574, 'lblGetCoord', 'backend', 'Label / Get Coordinates', 'script', NULL),
(575, 'lblLatLngTitle', 'backend', 'Label / Lat and Lng', 'script', NULL),
(576, 'lblCoordinatesFound', 'backend', 'Label / Coordinates found', 'script', NULL),
(577, 'lblWithLatLngTip', 'backend', 'Label / With Lat/Lng tip', 'script', NULL),
(578, 'front_current_location', 'frontend', 'Current location / address', 'script', NULL),
(579, 'front_geo_supported', 'frontend', 'Label / Geo not supported', 'script', NULL);

INSERT INTO `storelocator_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Listing Address Body', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'Listing Address Body', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'Listing Address Body', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Listing Address Title', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Listing Address Title', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Listing Address Title', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', 'Не', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', 'Да', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Email address is already in use', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Email address is already in use', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 157, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 157, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 172, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 172, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Default address', 'script'),
(NULL, 280, 'pjField', 2, 'title', 'Default address', 'script'),
(NULL, 280, 'pjField', 3, 'title', 'Default address', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Map zoom level', 'script'),
(NULL, 281, 'pjField', 2, 'title', 'Map zoom level', 'script'),
(NULL, 281, 'pjField', 3, 'title', 'Map zoom level', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Distance', 'script'),
(NULL, 282, 'pjField', 2, 'title', 'Distance', 'script'),
(NULL, 282, 'pjField', 3, 'title', 'Distance', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Stores', 'script'),
(NULL, 283, 'pjField', 2, 'title', 'Stores', 'script'),
(NULL, 283, 'pjField', 3, 'title', 'Stores', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 284, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 284, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Category updated', 'script'),
(NULL, 285, 'pjField', 2, 'title', 'Category updated', 'script'),
(NULL, 285, 'pjField', 3, 'title', 'Category updated', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Category added', 'script'),
(NULL, 286, 'pjField', 2, 'title', 'Category added', 'script'),
(NULL, 286, 'pjField', 3, 'title', 'Category added', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Failed to category', 'script'),
(NULL, 287, 'pjField', 2, 'title', 'Failed to category', 'script'),
(NULL, 287, 'pjField', 3, 'title', 'Failed to category', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Category not found', 'script'),
(NULL, 288, 'pjField', 2, 'title', 'Category not found', 'script'),
(NULL, 288, 'pjField', 3, 'title', 'Category not found', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 289, 'pjField', 2, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 289, 'pjField', 3, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'A new category has been added to the list.', 'script'),
(NULL, 290, 'pjField', 2, 'title', 'A new category has been added to the list.', 'script'),
(NULL, 290, 'pjField', 3, 'title', 'A new category has been added to the list.', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'We are sorry that the category could not be saved.', 'script'),
(NULL, 291, 'pjField', 2, 'title', 'We are sorry that the category could not be saved.', 'script'),
(NULL, 291, 'pjField', 3, 'title', 'We are sorry that the category could not be saved.', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'We sorry that the category you are looking for is missing.', 'script'),
(NULL, 292, 'pjField', 2, 'title', 'We sorry that the category you are looking for is missing.', 'script'),
(NULL, 292, 'pjField', 3, 'title', 'We sorry that the category you are looking for is missing.', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Add category', 'script'),
(NULL, 293, 'pjField', 2, 'title', 'Add category', 'script'),
(NULL, 293, 'pjField', 3, 'title', 'Add category', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 294, 'pjField', 2, 'title', 'Category', 'script');
INSERT INTO `storelocator_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 294, 'pjField', 3, 'title', 'Category', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Stores', 'script'),
(NULL, 295, 'pjField', 2, 'title', 'Stores', 'script'),
(NULL, 295, 'pjField', 3, 'title', 'Stores', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 296, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 296, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 297, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 297, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 298, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 298, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 299, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 299, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'New category', 'script'),
(NULL, 301, 'pjField', 2, 'title', 'New category', 'script'),
(NULL, 301, 'pjField', 3, 'title', 'New category', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Enter category name and click SAVE button. You can also upload custom image for the pins shown on the map. If no image uploaded the default Google map pins will be used.', 'script'),
(NULL, 302, 'pjField', 2, 'title', 'Enter category name and click SAVE button. You can also upload custom image for the pins shown on the map. If no image uploaded the default Google map pins will be used.', 'script'),
(NULL, 302, 'pjField', 3, 'title', 'Enter category name and click SAVE button. You can also upload custom image for the pins shown on the map. If no image uploaded the default Google map pins will be used.', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 303, 'pjField', 2, 'title', 'Update category', 'script'),
(NULL, 303, 'pjField', 3, 'title', 'Update category', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Store updated', 'script'),
(NULL, 330, 'pjField', 2, 'title', 'Store updated', 'script'),
(NULL, 330, 'pjField', 3, 'title', 'Store updated', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Store added', 'script'),
(NULL, 331, 'pjField', 2, 'title', 'Store added', 'script'),
(NULL, 331, 'pjField', 3, 'title', 'Store added', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Store failed to add', 'script'),
(NULL, 332, 'pjField', 2, 'title', 'Store failed to add', 'script'),
(NULL, 332, 'pjField', 3, 'title', 'Store failed to add', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Store not found', 'script'),
(NULL, 333, 'pjField', 2, 'title', 'Store not found', 'script'),
(NULL, 333, 'pjField', 3, 'title', 'Store not found', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'All changes made to the store have been saved.', 'script'),
(NULL, 334, 'pjField', 2, 'title', 'All changes made to the store have been saved.', 'script'),
(NULL, 334, 'pjField', 3, 'title', 'All changes made to the store have been saved.', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'A new store has been added to the list.', 'script'),
(NULL, 335, 'pjField', 2, 'title', 'A new store has been added to the list.', 'script'),
(NULL, 335, 'pjField', 3, 'title', 'A new store has been added to the list.', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'We are sorry that the store could not be added successfully.', 'script'),
(NULL, 336, 'pjField', 2, 'title', 'We are sorry that the store could not be added successfully.', 'script'),
(NULL, 336, 'pjField', 3, 'title', 'We are sorry that the store could not be added successfully.', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'We are sorry that the store you are looking for is missing.', 'script'),
(NULL, 337, 'pjField', 2, 'title', 'We are sorry that the store you are looking for is missing.', 'script'),
(NULL, 337, 'pjField', 3, 'title', 'We are sorry that the store you are looking for is missing.', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Add store', 'script'),
(NULL, 338, 'pjField', 2, 'title', 'Add store', 'script'),
(NULL, 338, 'pjField', 3, 'title', 'Add store', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Store', 'script'),
(NULL, 339, 'pjField', 2, 'title', 'Store', 'script'),
(NULL, 339, 'pjField', 3, 'title', 'Store', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Store name', 'script'),
(NULL, 340, 'pjField', 2, 'title', 'Store name', 'script'),
(NULL, 340, 'pjField', 3, 'title', 'Store name', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 341, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 341, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Opening times', 'script'),
(NULL, 342, 'pjField', 2, 'title', 'Opening times', 'script'),
(NULL, 342, 'pjField', 3, 'title', 'Opening times', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 343, 'pjField', 2, 'title', 'Image', 'script'),
(NULL, 343, 'pjField', 3, 'title', 'Image', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 344, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 344, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 345, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 345, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 346, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 346, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 347, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 347, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 348, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 348, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Click on the button to find address coordinates. You can also enter long/lat coordinates for the store. Once the map is shown you can click on the pin and move it on the map to precisely select store address.', 'script'),
(NULL, 349, 'pjField', 2, 'title', 'Click on the button to find address coordinates. You can also enter long/lat coordinates for the store. Once the map is shown you can click on the pin and move it on the map to precisely select store address.', 'script'),
(NULL, 349, 'pjField', 3, 'title', 'Click on the button to find address coordinates. You can also enter long/lat coordinates for the store. Once the map is shown you can click on the pin and move it on the map to precisely select store address.', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'FIND COORDINATES', 'script'),
(NULL, 350, 'pjField', 2, 'title', 'FIND COORDINATES', 'script'),
(NULL, 350, 'pjField', 3, 'title', 'FIND COORDINATES', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Latitude', 'script'),
(NULL, 351, 'pjField', 2, 'title', 'Latitude', 'script'),
(NULL, 351, 'pjField', 3, 'title', 'Latitude', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Longitude', 'script'),
(NULL, 352, 'pjField', 2, 'title', 'Longitude', 'script'),
(NULL, 352, 'pjField', 3, 'title', 'Longitude', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'We sorry that we could not find out the Latitude and Longitude of the given address.', 'script'),
(NULL, 353, 'pjField', 2, 'title', 'We sorry that we could not find out the Latitude and Longitude of the given address.', 'script'),
(NULL, 353, 'pjField', 3, 'title', 'We sorry that we could not find out the Latitude and Longitude of the given address.', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Update store', 'script'),
(NULL, 354, 'pjField', 2, 'title', 'Update store', 'script'),
(NULL, 354, 'pjField', 3, 'title', 'Update store', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 356, 'pjField', 2, 'title', 'Delete image', 'script'),
(NULL, 356, 'pjField', 3, 'title', 'Delete image', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 357, 'pjField', 2, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 357, 'pjField', 3, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Revert Status', 'script'),
(NULL, 359, 'pjField', 2, 'title', 'Revert Status', 'script'),
(NULL, 359, 'pjField', 3, 'title', 'Revert Status', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 386, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 386, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 387, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 387, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 388, 'pjField', 2, 'title', 'Category', 'script'),
(NULL, 388, 'pjField', 3, 'title', 'Category', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 389, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 389, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Within', 'script'),
(NULL, 390, 'pjField', 2, 'title', 'Within', 'script'),
(NULL, 390, 'pjField', 3, 'title', 'Within', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 391, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 391, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 392, 'pjField', 1, 'title', '1', 'script'),
(NULL, 392, 'pjField', 2, 'title', '1', 'script'),
(NULL, 392, 'pjField', 3, 'title', '1', 'script'),
(NULL, 393, 'pjField', 1, 'title', '5', 'script'),
(NULL, 393, 'pjField', 2, 'title', '5', 'script'),
(NULL, 393, 'pjField', 3, 'title', '5', 'script'),
(NULL, 394, 'pjField', 1, 'title', '10', 'script'),
(NULL, 394, 'pjField', 2, 'title', '10', 'script'),
(NULL, 394, 'pjField', 3, 'title', '10', 'script'),
(NULL, 395, 'pjField', 1, 'title', '25', 'script'),
(NULL, 395, 'pjField', 2, 'title', '25', 'script'),
(NULL, 395, 'pjField', 3, 'title', '25', 'script'),
(NULL, 396, 'pjField', 1, 'title', '50', 'script'),
(NULL, 396, 'pjField', 2, 'title', '50', 'script'),
(NULL, 396, 'pjField', 3, 'title', '50', 'script'),
(NULL, 397, 'pjField', 1, 'title', '100', 'script'),
(NULL, 397, 'pjField', 2, 'title', '100', 'script'),
(NULL, 397, 'pjField', 3, 'title', '100', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 424, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 424, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Opening times', 'script'),
(NULL, 425, 'pjField', 2, 'title', 'Opening times', 'script'),
(NULL, 425, 'pjField', 3, 'title', 'Opening times', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Use categories', 'script'),
(NULL, 426, 'pjField', 2, 'title', 'Use categories', 'script'),
(NULL, 426, 'pjField', 3, 'title', 'Use categories', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Import', 'script'),
(NULL, 427, 'pjField', 2, 'title', 'Import', 'script'),
(NULL, 427, 'pjField', 3, 'title', 'Import', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Import Stores', 'script'),
(NULL, 428, 'pjField', 2, 'title', 'Import Stores', 'script'),
(NULL, 428, 'pjField', 3, 'title', 'Import Stores', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'You can import a CSV file with stores data. Please, add a store manually using the Add Store form and then export it from the Store lists, bottom button "Choose action". This is the format of the required CSV file for import.', 'script'),
(NULL, 429, 'pjField', 2, 'title', 'You can import a CSV file with stores data. Please, add a store manually using the Add Store form and then export it from the Store lists, bottom button "Choose action". This is the format of the required CSV file for import.', 'script'),
(NULL, 429, 'pjField', 3, 'title', 'You can import a CSV file with stores data. Please, add a store manually using the Add Store form and then export it from the Store lists, bottom button "Choose action". This is the format of the required CSV file for import.', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'CSV file', 'script'),
(NULL, 430, 'pjField', 2, 'title', 'CSV file', 'script'),
(NULL, 430, 'pjField', 3, 'title', 'CSV file', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Import', 'script'),
(NULL, 431, 'pjField', 2, 'title', 'Import', 'script'),
(NULL, 431, 'pjField', 3, 'title', 'Import', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'CSV file missing', 'script'),
(NULL, 432, 'pjField', 2, 'title', 'CSV file missing', 'script'),
(NULL, 432, 'pjField', 3, 'title', 'CSV file missing', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Importing stores could not be process because of missing of csv file.', 'script'),
(NULL, 433, 'pjField', 2, 'title', 'Importing stores could not be process because of missing of csv file.', 'script'),
(NULL, 433, 'pjField', 3, 'title', 'Importing stores could not be process because of missing of csv file.', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'File type error', 'script'),
(NULL, 434, 'pjField', 2, 'title', 'File type error', 'script'),
(NULL, 434, 'pjField', 3, 'title', 'File type error', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 435, 'pjField', 2, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 435, 'pjField', 3, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Stores imported', 'script'),
(NULL, 436, 'pjField', 2, 'title', 'Stores imported', 'script'),
(NULL, 436, 'pjField', 3, 'title', 'Stores imported', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'The csv file has been imported successfully.', 'script'),
(NULL, 437, 'pjField', 2, 'title', 'The csv file has been imported successfully.', 'script'),
(NULL, 437, 'pjField', 3, 'title', 'The csv file has been imported successfully.', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Copy the HTML code below and put it on your web page where the store locator widget should be loaded. Please, note that you should put the code on a web page from the same domain where script is installed.', 'script'),
(NULL, 438, 'pjField', 2, 'title', 'Copy the HTML code below and put it on your web page where the store locator widget should be loaded. Please, note that you should put the code on a web page from the same domain where script is installed.', 'script'),
(NULL, 438, 'pjField', 3, 'title', 'Copy the HTML code below and put it on your web page where the store locator widget should be loaded. Please, note that you should put the code on a web page from the same domain where script is installed.', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Copy the code below and put it in your web page where you want store locator to appear.', 'script'),
(NULL, 439, 'pjField', 2, 'title', 'Copy the code below and put it in your web page where you want store locator to appear.', 'script'),
(NULL, 439, 'pjField', 3, 'title', 'Copy the code below and put it in your web page where you want store locator to appear.', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 440, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 440, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 441, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 441, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 442, 'pjField', 2, 'title', 'Website', 'script'),
(NULL, 442, 'pjField', 3, 'title', 'Website', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Google marker', 'script'),
(NULL, 443, 'pjField', 2, 'title', 'Google marker', 'script'),
(NULL, 443, 'pjField', 3, 'title', 'Google marker', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Delete google marker', 'script'),
(NULL, 444, 'pjField', 2, 'title', 'Delete google marker', 'script'),
(NULL, 444, 'pjField', 3, 'title', 'Delete google marker', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Are you sure that you want to delete this marker?', 'script'),
(NULL, 445, 'pjField', 2, 'title', 'Are you sure that you want to delete this marker?', 'script'),
(NULL, 445, 'pjField', 3, 'title', 'Are you sure that you want to delete this marker?', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'full address', 'script'),
(NULL, 446, 'pjField', 2, 'title', 'full address', 'script'),
(NULL, 446, 'pjField', 3, 'title', 'full address', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'directions', 'script'),
(NULL, 447, 'pjField', 2, 'title', 'directions', 'script'),
(NULL, 447, 'pjField', 3, 'title', 'directions', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'close', 'script'),
(NULL, 448, 'pjField', 2, 'title', 'close', 'script'),
(NULL, 448, 'pjField', 3, 'title', 'close', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 449, 'pjField', 2, 'title', 'From', 'script'),
(NULL, 449, 'pjField', 3, 'title', 'From', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Go', 'script'),
(NULL, 451, 'pjField', 2, 'title', 'Go', 'script'),
(NULL, 451, 'pjField', 3, 'title', 'Go', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Category cannot be the same.', 'script'),
(NULL, 452, 'pjField', 2, 'title', 'Category cannot be the same.', 'script'),
(NULL, 452, 'pjField', 3, 'title', 'Category cannot be the same.', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Invalid email.', 'script'),
(NULL, 453, 'pjField', 2, 'title', 'Invalid email.', 'script'),
(NULL, 453, 'pjField', 3, 'title', 'Invalid email.', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Only files with extenstion jpg|png|jpeg|gif are allowed.', 'script'),
(NULL, 454, 'pjField', 2, 'title', 'Only files with extenstion jpg|png|jpeg|gif are allowed.', 'script'),
(NULL, 454, 'pjField', 3, 'title', 'Only files with extenstion jpg|png|jpeg|gif are allowed.', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 480, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 480, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 481, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 481, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 482, 'pjField', 2, 'title', 'Website', 'script'),
(NULL, 482, 'pjField', 3, 'title', 'Website', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'No results found', 'script'),
(NULL, 483, 'pjField', 2, 'title', 'No results found', 'script'),
(NULL, 483, 'pjField', 3, 'title', 'No results found', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Directions have been sent successfully.', 'script'),
(NULL, 484, 'pjField', 2, 'title', 'Directions have been sent successfully.', 'script'),
(NULL, 484, 'pjField', 3, 'title', 'Directions have been sent successfully.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Email address cannot be empty.', 'script'),
(NULL, 485, 'pjField', 2, 'title', 'Email address cannot be empty.', 'script'),
(NULL, 485, 'pjField', 3, 'title', 'Email address cannot be empty.', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Email address is not valid.', 'script'),
(NULL, 486, 'pjField', 2, 'title', 'Email address is not valid.', 'script'),
(NULL, 486, 'pjField', 3, 'title', 'Email address is not valid.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'With latitude/longitude', 'script'),
(NULL, 487, 'pjField', 2, 'title', 'With latitude/longitude', 'script'),
(NULL, 487, 'pjField', 3, 'title', 'With latitude/longitude', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 488, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 488, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Supported language on Map', 'script'),
(NULL, 489, 'pjField', 2, 'title', 'Supported language on Map', 'script'),
(NULL, 489, 'pjField', 3, 'title', 'Supported language on Map', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Store list', 'script'),
(NULL, 557, 'pjField', 2, 'title', 'Store list', 'script'),
(NULL, 557, 'pjField', 3, 'title', 'Store list', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'You will find below the list of stores. If you want to add new store, let click on the Add store tab. In order to import multiple stores from CSV file, let click on the Import tab.', 'script'),
(NULL, 558, 'pjField', 2, 'title', 'You will find below the list of stores. If you want to add new store, let click on the Add store tab. In order to import multiple stores from CSV file, let click on the Import tab.', 'script'),
(NULL, 558, 'pjField', 3, 'title', 'You will find below the list of stores. If you want to add new store, let click on the Add store tab. In order to import multiple stores from CSV file, let click on the Import tab.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Add new store', 'script'),
(NULL, 559, 'pjField', 2, 'title', 'Add new store', 'script'),
(NULL, 559, 'pjField', 3, 'title', 'Add new store', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Please fill out the form below and click Save button to complete adding new store.', 'script'),
(NULL, 560, 'pjField', 2, 'title', 'Please fill out the form below and click Save button to complete adding new store.', 'script'),
(NULL, 560, 'pjField', 3, 'title', 'Please fill out the form below and click Save button to complete adding new store.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Update store', 'script'),
(NULL, 561, 'pjField', 2, 'title', 'Update store', 'script'),
(NULL, 561, 'pjField', 3, 'title', 'Update store', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'You can make any change on the form below and click Save button to update store information', 'script'),
(NULL, 562, 'pjField', 2, 'title', 'You can make any change on the form below and click Save button to update store information', 'script'),
(NULL, 562, 'pjField', 3, 'title', 'You can make any change on the form below and click Save button to update store information', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Category list', 'script'),
(NULL, 563, 'pjField', 2, 'title', 'Category list', 'script'),
(NULL, 563, 'pjField', 3, 'title', 'Category list', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Below is the list of categories. You can see how many stores assigned to each category.', 'script'),
(NULL, 564, 'pjField', 2, 'title', 'Below is the list of categories. You can see how many stores assigned to each category.', 'script'),
(NULL, 564, 'pjField', 3, 'title', 'Below is the list of categories. You can see how many stores assigned to each category.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 565, 'pjField', 2, 'title', 'Update category', 'script'),
(NULL, 565, 'pjField', 3, 'title', 'Update category', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'You can modify the category name or upload new new custom image for the pins shown on the map. If no image uploaded the default Google map pins will be used.', 'script'),
(NULL, 566, 'pjField', 2, 'title', 'You can modify the category name or upload new new custom image for the pins shown on the map. If no image uploaded the default Google map pins will be used.', 'script'),
(NULL, 566, 'pjField', 3, 'title', 'You can modify the category name or upload new new custom image for the pins shown on the map. If no image uploaded the default Google map pins will be used.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'User list', 'script'),
(NULL, 567, 'pjField', 2, 'title', 'User list', 'script'),
(NULL, 567, 'pjField', 3, 'title', 'User list', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Below is the list of users. It includes name, email, role, and status of each user. You can update, delete, or export users.', 'script'),
(NULL, 568, 'pjField', 2, 'title', 'Below is the list of users. It includes name, email, role, and status of each user. You can update, delete, or export users.', 'script'),
(NULL, 568, 'pjField', 3, 'title', 'Below is the list of users. It includes name, email, role, and status of each user. You can update, delete, or export users.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Add new user', 'script'),
(NULL, 569, 'pjField', 2, 'title', 'Add new user', 'script'),
(NULL, 569, 'pjField', 3, 'title', 'Add new user', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Please fill out the form below with mandatory fields and click SAVE button to add new user. ', 'script'),
(NULL, 570, 'pjField', 2, 'title', 'Please fill out the form below with mandatory fields and click SAVE button to add new user. ', 'script'),
(NULL, 570, 'pjField', 3, 'title', 'Please fill out the form below with mandatory fields and click SAVE button to add new user. ', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 571, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 571, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Let make any change on the form below and click SAVE button to update user information.', 'script'),
(NULL, 572, 'pjField', 2, 'title', 'Let make any change on the form below and click SAVE button to update user information.', 'script'),
(NULL, 572, 'pjField', 3, 'title', 'Let make any change on the form below and click SAVE button to update user information.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Lat & Lng', 'script'),
(NULL, 573, 'pjField', 2, 'title', 'Lat & Lng', 'script'),
(NULL, 573, 'pjField', 3, 'title', 'Lat & Lng', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Get Coordinates', 'script'),
(NULL, 574, 'pjField', 2, 'title', 'Get Coordinates', 'script'),
(NULL, 574, 'pjField', 3, 'title', 'Get Coordinates', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Latitudes and Longitudes', 'script'),
(NULL, 575, 'pjField', 2, 'title', 'Latitudes and Longitudes', 'script'),
(NULL, 575, 'pjField', 3, 'title', 'Latitudes and Longitudes', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Coordinates have been found for {STORES} store(s).', 'script'),
(NULL, 576, 'pjField', 2, 'title', 'Coordinates have been found for {STORES} store(s).', 'script'),
(NULL, 576, 'pjField', 3, 'title', 'Coordinates have been found for {STORES} store(s).', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'If you want tick on this check box, the system will automatically generate Latitude and Longitude for the stores imported that based on their zip codes and addresses.', 'script'),
(NULL, 577, 'pjField', 2, 'title', 'If you want tick on this check box, the system will automatically generate Latitude and Longitude for the stores imported that based on their zip codes and addresses.', 'script'),
(NULL, 577, 'pjField', 3, 'title', 'If you want tick on this check box, the system will automatically generate Latitude and Longitude for the stores imported that based on their zip codes and addresses.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Current Location / Address', 'script'),
(NULL, 578, 'pjField', 2, 'title', 'Current Location / Address', 'script'),
(NULL, 578, 'pjField', 3, 'title', 'Current Location / Address', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Geolocation is not supported by this browser.', 'script'),
(NULL, 579, 'pjField', 2, 'title', 'Geolocation is not supported by this browser.', 'script'),
(NULL, 579, 'pjField', 3, 'title', 'Geolocation is not supported by this browser.', 'script');