<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'pjStoreLocatorCaptcha';
	
	public $defaultLocale = 'front_locale_id';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		ob_start();
	}

	public function afterFilter()
	{		
		
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		$this->loadSetFields();
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionSetLocale()
	{
		$this->setLocaleId(@$_GET['locale']);
		pjUtil::redirect($_SERVER['HTTP_REFERER']);
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH . 'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH . 'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}
	
	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	
	public function pjActionLoadCss()
	{
		$theme = $this->option_arr['o_theme'];
		$fonts = $this->option_arr['o_theme'];
		if(isset($_GET['theme']) && in_array($_GET['theme'], array('theme1', 'theme2', 'theme3', 'theme4', 'theme5', 'theme6', 'theme7', 'theme8', 'theme9', 'theme10')))
		{
			$theme = $_GET['theme'];
			$fonts = $_GET['theme'];
		}
		$arr = array(
				array('file' => 'style.css', 'path' => PJ_CSS_PATH),
				array('file' => "$fonts.css", 'path' => PJ_CSS_PATH . "fonts/"),
				array('file' => "$theme.css", 'path' => PJ_CSS_PATH . "themes/"),
				array('file' => 'transitions.css', 'path' => PJ_CSS_PATH)
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
				
			if ($string !== FALSE)
			{
				echo str_replace(
						array('../fonts/glyphicons', "pjWrapper"),
						array(
								PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/fonts/glyphicons',
								"pjWrapperStoreLocator_" . $theme
						),
						$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoadJs()
	{
		header("Content-type: text/javascript");
		
		$api_key_str = isset($this->option_arr['o_google_map_api']) && !empty($this->option_arr['o_google_map_api']) ? 'key=' . $this->option_arr['o_google_map_api'] . '&' : '';
		
		$arr = array(
			array('file' => '', 'path' => 'https://json-sans-eval.googlecode.com/svn/trunk/src/json_sans_eval.js'),
			array('file' => '', 'path' => 'https://maps.google.com/maps/api/js?'.$api_key_str.'sensor=false&language=' . $this->option_arr['o_map_language'])
		);
		$pjHttp = new pjHttp();
		foreach ($arr as $item)
		{
			$pjHttp->fileRequest($item['path'] . $item['file']);
			$js_content = $pjHttp->getResponse();
			echo $js_content . "\n";
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		$category_arr = pjCategoryModel::factory()->where('status', 'T')->orderBy('category_title ASC')->findAll()->getData();
		$filter_arr = pjFilterModel::factory()->where('status', 'T')->orderBy('filter_title ASC')->findAll()->getData();
		$this->set('category_arr', $category_arr);
		$this->set('filter_arr', $filter_arr);
	}
	
	public function pjActionGenerateXml()
	{
		$pjStoreModel = pjStoreModel::factory();
		
		if(is_numeric($_GET["lat"]) && is_numeric($_GET["lng"]))
		{
			$center_lat = pjObject::escapeString($_GET["lat"]);
			$center_lng = pjObject::escapeString($_GET["lng"]);
		}else{
			$_address = $this->option_arr['o_default_address'];
			$_address = preg_replace('/\s+/', '+', $_address);
			
			$data = pjAppController::getLatLng($_address);
			
			$center_lat = $data['lat'];
			$center_lng = $data['lng'];
		}
		
		$radius = is_numeric($_GET["radius"]) ? pjObject::escapeString($_GET["radius"]) : 25;
		$distance = in_array($_GET['distance'], array('km', 'miles')) ? pjObject::escapeString($_GET["distance"]) : $this->option_arr['o_distance'];
		
		$filter_valid = true;
		$category_valid = true;
		if(isset($_GET['filter_id']) && !empty($_GET['filter_id']))
		{
			$temp_id_arr = explode(",", $_GET['filter_id']);
			foreach($temp_id_arr as $id)
			{
				if(!is_numeric($id))
				{
					$filter_valid = false;
				}
			}
		}else{
			$filter_valid = false;
		}
		if(isset($_GET['category_id']) && !empty($_GET['category_id']))
		{
			$temp_id_arr = explode(",", $_GET['category_id']);
			foreach($temp_id_arr as $id)
			{
				if(!is_numeric($id))
				{
					$category_valid = false;
				}
			}
		}else{
			$category_valid = false;
		}
		
		switch ($distance)
		{
			case 'km':
				$mean_radius = 6371;
				break;
			case 'miles':
			default:
				$mean_radius = 3959;
				break;
		}
		$pjStoreModel->where('t1.status', 'T');
		if($category_valid == true)
		{
			$pjStoreModel->where("t1.id IN(SELECT TSC.store_id FROM `".pjStoreCategoryModel::factory()->getTable()."` AS TSC WHERE TSC.category_id IN(".$_GET['category_id'].") )");
		}else{
			$pjStoreModel->where("t1.id NOT IN(SELECT TSC.store_id FROM `".pjStoreCategoryModel::factory()->getTable()."` AS TSC WHERE TSC.category_id IN(SELECT TC1.id FROM `".pjCategoryModel::factory()->getTable()."` AS TC1 WHERE TC1.status = 'F'))");
		}
		if($filter_valid == true)
		{
			$pjStoreModel->where("t1.id IN(SELECT TSF.store_id FROM `".pjStoreFilterModel::factory()->getTable()."` AS TSF WHERE TSF.filter_id IN(".$_GET['filter_id'].") )");
		}else{
			$pjStoreModel->where("t1.id NOT IN(SELECT TSF.store_id FROM `".pjStoreFilterModel::factory()->getTable()."` AS TSF WHERE TSF.filter_id IN(SELECT TF1.id FROM `".pjFilterModel::factory()->getTable()."` AS TF1 WHERE TF1.status = 'F'))");
		}
		
		$sub_query = "($mean_radius * acos(cos(radians('$center_lat')) * cos(radians(lat)) * cos(radians(lng) - radians('$center_lng')) + sin(radians('$center_lat')) * sin(radians(lat)))) AS distance ";
		
		$category_query = "(SELECT TC.marker FROM `".pjCategoryModel::factory()->getTable()."` AS TC LEFT JOIN `".pjStoreCategoryModel::factory()->getTable()."` AS TSC1 ON TC.id = TSC1.category_id WHERE TSC1.store_id = t1.id ORDER BY marker LIMIT 1) as marker";
		
		$arr = $pjStoreModel->select('t1.*, t2.content AS address_country, ' . $sub_query . ', ' . $category_query)
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.country_id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->having("distance < $radius")
					->orderBy("distance ASC")
					->findAll()
					->getData();
		$this->set('arr', $arr);
	}
	
	function pjActionGetLatLng()
	{
		$_address = $_GET['address'];
		$_address = preg_replace('/\s+/', '+', $_address);
		
		$data = pjAppController::getLatLng($_address);
		
		pjAppController::jsonResponse($data);
	}
	
	function pjActionSendEmail()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$data = array();
			$pjEmail = new pjEmail();
			
			if(empty($_POST['stl_email_text']))
			{
				$data['code'] = 100;
			}else{
				if(strtoupper($_POST['captcha']) == $_SESSION[$this->defaultCaptcha])
				{
					if (filter_var($_POST['stl_email_text'], FILTER_VALIDATE_EMAIL)) 
					{
						if ($this->option_arr['o_send_email'] == 'smtp')
						{
							$pjEmail
							->setTransport('smtp')
							->setSmtpHost($this->option_arr['o_smtp_host'])
							->setSmtpPort($this->option_arr['o_smtp_port'])
							->setSmtpUser($this->option_arr['o_smtp_user'])
							->setSmtpPass($this->option_arr['o_smtp_pass'])
							->setSender($this->option_arr['o_smtp_user'])
							;
						}
						$pjMultiLangModel = pjMultiLangModel::factory();
						$lang_message = $pjMultiLangModel->reset()->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_email_direction_message')
						->limit(0, 1)
						->findAll()->getData();
						$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_email_direction_subject')
						->limit(0, 1)
						->findAll()->getData();
					
						if (count($lang_message) === 1 && count($lang_subject) === 1)
						{
							$message = str_replace(array('{Direction}'), array($_POST['stl_directions_html']), $lang_message[0]['content']);
														
							$pjEmail
							->setContentType('text/html')
							->setFrom($this->getFromEmail())
							->setTo($_POST['stl_email_text'])
							->setSubject($lang_subject[0]['content'])
							->send($message);
						}
					
						$_SESSION[$this->defaultCaptcha] = NULL;
						unset($_SESSION[$this->defaultCaptcha]);
						
						$data['code'] = 200;
					}else{
						$data['code'] = 300;
					}
				}else{
					$data['code'] = 400;
				}
			}
			pjAppController::jsonResponse($data);
			exit;
		}
	}
}
?>