<?php
mt_srand();
$index = mt_rand(1, 9999);

$distances = __('distances', true);
ksort($distances);

$theme = isset($_GET['theme']) ? $_GET['theme'] : $tpl['option_arr']['o_theme'];
?>

<div id="pjWrapperStoreLocator_<?php echo $theme;?>">
	<div id="pjSlContainer_<?php echo $index;?>" class="container-fluid pjSlContainer">
		<div class="panel panel-default pjSlMain">
			<header class="panel-heading clearfix pjSlHeader">
				<div class="pjSlForm pjSlFormFilters">
					<form action="" method="post" name="stl_seach_form" class="form-inline" onsubmit="return false;">
						<div class="form-group pjSlFilterAddress">
							<div class="input-group">
								<input type="text" name="address" value="<?php echo $tpl['option_arr']['o_default_address'];?>" class="form-control" placeholder="<?php __('front_label_address'); ?>" />
								
								<a href="#" id="stl_current_location" class="input-group-addon" title="<?php __('front_current_location');?>">
									<span class="glyphicon glyphicon-screenshot" aria-hidden="aria-hidden"></span>
								</a>
								
								<a href="#" class="input-group-addon pjSlSearchIcon">
									<span class="glyphicon glyphicon-search" aria-hidden="aria-hidden"></span>
								</a>
							</div><!-- /.input-group -->
						</div><!-- /.form-group pjSlFilterAddress -->

						<div class="form-group pjSlFilterDistance">
							<select name="radius" class="form-control">
								<?php
								foreach ($distances as $k => $v)
								{
									?><option value="<?php echo $k; ?>" <?php echo $k == 25 ? 'selected="selected"' : null;?>><?php __('front_within');?> <?php echo $v; ?> <?php echo $tpl['option_arr']['o_distance'] == 'km' ? $tpl['option_arr']['o_distance'] : ($v == 1 ? __('front_mile', true) : $tpl['option_arr']['o_distance']) ;?></option><?php
								}
								?>
							</select>
						</div><!-- /.form-group pjSlFilterDistance -->
						<?php
						if(!empty($tpl['category_arr']) || !empty($tpl['filter_arr']))
						{ 
							?>
							<div class="form-group">
								<a href="#pjSlFormFiltersDropdown" role="button" data-toggle="collapse" class="btn btn-primary pjSlBtnFilterBy" aria-expanded="false" aria-controls="pjSlFormFiltersDropdown"><?php __('front_filter_by');?></a>
							</div><!-- /.form-group -->
						
							<div class="collapse pjSlFormFiltersDropdown" id="pjSlFormFiltersDropdown">
								<?php
								if($tpl['option_arr']['o_use_categories'] == 'Yes' && !empty($tpl['category_arr']))
								{ 
									?>
									<input type="hidden" name="category_id" valuue="1" />
									<p class="pjSlFormFiltersDropdownTitle"><?php __('front_label_category'); ?>: </p><!-- /.pjSlFormFiltersDropdownTitle -->
		
									<ul class="list-inline pjSlListFilters">
										<?php
										foreach ($tpl['category_arr'] as $k => $v)
										{ 
											?>
											<li>
												<div class="pjSlCheckbox pjSlCustomCheckbox">
													<input type="checkbox" id="pjSlCustomCheckbox-category-<?php echo $v['id'];?>" value="<?php echo $v['id'];?>" class="pjSlCategoryCheckbox" autocomplete="off" />
			
													<label for="pjSlCustomCheckbox-category-<?php echo $v['id'];?>">
														<span class="pjSlCustomCheckboxFake">
															<span class="glyphicon glyphicon-ok" aria-hidden="true"></span>
														</span>
			
														<?php echo $v['category_title']; ?>
													</label>
												</div><!-- /.pjSlCheckbox pjSlCustomCheckbox -->
											</li>
											<?php
										} 
										?>
									</ul><!-- /.list-inline pjSlListFilters -->
									<?php
								}
								if(!empty($tpl['filter_arr']))
								{ 
									?>
									<p class="pjSlFormFiltersDropdownTitle"><?php __('front_filters');?>: </p><!-- /.pjSlFormFiltersDropdownTitle -->
		
									<ul class="list-inline pjSlListFilters">
										<?php
										foreach($tpl['filter_arr'] as $k => $v)
										{ 
											?>
											<li>
												<div class="pjSlCheckbox pjSlCustomCheckbox">
													<input type="checkbox" id="pjSlCustomCheckbox-filter-<?php echo $v['id'];?>" value="<?php echo $v['id'];?>" class="pjSlFilterCheckbox" autocomplete="off" />
			
													<label for="pjSlCustomCheckbox-filter-<?php echo $v['id'];?>">
														<span class="pjSlCustomCheckboxFake">
															<span class="glyphicon glyphicon-ok" aria-hidden="true"></span>
														</span>
			
														<?php echo $v['filter_title']; ?>
													</label>
												</div><!-- /.pjSlCheckbox pjSlCustomCheckbox -->
											</li>
											<?php
										} 
										?>
									</ul><!-- /.list-inline pjSlListFilters -->
									<?php
								} 
								?>
	
								<div class="pjSlFormFiltersDropdownActions">
									<button type="submit" class="btn btn-primary pjSlSearchIcon"><?php __('front_btn_apply_filters');?></button>
									<a href="#" class="pjSlClearFilters"><?php __('front_clear_filters');?></a>
								</div><!-- /.pjSlFormFiltersDropdownActions -->
							</div><!-- /#pjSlFormFiltersDropdown.collapse pjSlFormFiltersDropdown -->
							<?php
						} 
						?>
					</form><!-- /.form-inline -->
				</div><!-- /.pjSlForm pjSlFormFilters -->
			</header><!-- /.panel-heading clearfix pjSlHeader -->
			
			<div class="panel-body pjSlBody">
				<div class="row">
					<?php
					if(isset($tpl['option_arr']['o_google_map_api']) && !empty($tpl['option_arr']['o_google_map_api']))
					{ 
						?>
						<div class="col-lg-5 col-md-5 col-sm-6 col-xs-12 pjSlResults">
							<div id="stl_search_result">
								<div id="stl_search_addresses" class="pre-scrollable pjSlResultsInner"></div>
							</div>
							<div id="stl_search_directions" style="display: none">
								<div class="pre-scrollable pjSlResultsInner">
									<div class="pjSlGoogleApi">
										<div class="pjSlAccordionActions">
											<a href="#" class="btnBack stl-directions-close"><?php __('front_label_close');?></a>
		
											<a role="button" data-toggle="collapse" href="#sendByEmail" aria-expanded="false" aria-controls="sendByEmail">
												<span class="pjSlAccordionSign pjSlAccordionOpen">+</span>
												<span class="pjSlAccordionSign pjSlAccordionClose">-</span>
												
												<span><?php __('front_label_email');?></span>
											</a>
										</div><!-- /.pjSlAccordionActions -->
		
										<div class="pjSlForm pjSlFormDirection pjSlFormEmail collapse" id="sendByEmail">
											<form action="" method="post" id="stl_send_email_form" name="stl_send_email_form" class="form-inline" onsubmit="return false;">
												<div class="row">
													<div class="col-sm-12">
														<input type="text" name="stl_email_text" placeholder="<?php __('front_label_email');?>" class="form-control pjSlEmailField" />
														
														<textarea id="stl_directions_html" name="stl_directions_html" class="stl-direction-html" style="display: none;"></textarea>
														
														<button type="button" id="stl_send_email" name="stl_send_email"  class="btn btn-primary"><?php __('front_label_go');?></button>
													</div>
												</div>
												<div class="row">
													
													<div class="col-sm-12">
														<input type="text" name="captcha" class="form-control pjSlCaptchaField" placeholder="<?php __('front_captcha');?>" maxlength="6" autocomplete="off">
														<img id="pjSlCapthaImg" src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&amp;action=pjActionCaptcha&amp;rand=<?php echo rand(1, 99999); ?>" alt="Captcha" style="vertical-align: middle" />
													</div><!-- /.col-sm-4 -->
													
												</div>
											</form><!-- /.form-inline -->
										</div><!-- /#sendByEmail.pjSlForm pjSlFormDirection collapse -->
		
										<div id="stl_search_directions_panel"></div>
									</div><!-- /.pjSlGoogleApi -->
								</div><!-- /.pre-scrollable pjSlResultsInner -->
							</div>
						</div><!-- /.col-lg-5 col-md-5 col-sm-6 col-xs-12 pjSlResults -->
						
						<div class="col-lg-7 col-md-7 col-sm-6 col-xs-12 pjSlMap" id="stl_store_canvas"></div><!-- /#pjSlMap.col-lg-7 col-md-7 col-sm-6 col-xs-12 pjSlMap -->
						<?php
					}else{
						?>
						<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 pjSlResults">
							<ul class="list-group">
								<li class="list-group-item pjSlResult">
									<div class="text-warning"><?php __('front_map_api_warning');?></div>
								</li>
							</ul>
						</div>
						<?php
					} 
					?>
					
				</div><!-- /.row -->
			</div><!-- /.panel-body pjSlBody -->
			
		</div><!-- /.panel panel-default pjSlMain -->
	</div><!-- /.container-fluid pjSlContainer -->
</div>

<script type="text/javascript">
var pjQ = pjQ || {},
	StoreLocator_<?php echo $index; ?>;
(function () {
	"use strict";
	
	var isSafari = /Safari/.test(navigator.userAgent) && /Apple Computer/.test(navigator.vendor),
		
	loadCssHack = function(url, callback){
		var link = document.createElement('link');
		link.type = 'text/css';
		link.rel = 'stylesheet';
		link.href = url;

		document.getElementsByTagName('head')[0].appendChild(link);

		var img = document.createElement('img');
		img.onerror = function(){
			if (callback && typeof callback === "function") {
				callback();
			}
		};
		img.src = url;
	},
	loadRemote = function(url, type, callback) {
		if (type === "css" && isSafari) {
			loadCssHack(url, callback);
			return;
		}
		var _element, _type, _attr, scr, s, element;
		
		switch (type) {
		case 'css':
			_element = "link";
			_type = "text/css";
			_attr = "href";
			break;
		case 'js':
			_element = "script";
			_type = "text/javascript";
			_attr = "src";
			break;
		}
		
		scr = document.getElementsByTagName(_element);
		s = scr[scr.length - 1];
		element = document.createElement(_element);
		element.type = _type;
		if (type == "css") {
			element.rel = "stylesheet";
		}
		if (element.readyState) {
			element.onreadystatechange = function () {
				if (element.readyState == "loaded" || element.readyState == "complete") {
					element.onreadystatechange = null;
					if (callback && typeof callback === "function") {
						callback();
					}
				}
			};
		} else {
			element.onload = function () {
				if (callback && typeof callback === "function") {
					callback();
				}
			};
		}
		element[_attr] = url;
		s.parentNode.insertBefore(element, s.nextSibling);
	},
	loadScript = function (url, callback) {
		loadRemote(url, "js", callback);
	},
	loadCss = function (url, callback) {
		loadRemote(url, "css", callback);
	},
	randomString = function (length, chars) {
		var result = "";
		for (var i = length; i > 0; --i) {
			result += chars[Math.round(Math.random() * (chars.length - 1))];
		}
		return result;
	},
	getSessionId = function () {
		return sessionStorage.getItem("session_id") == null ? "" : sessionStorage.getItem("session_id");
	},
	createSessionId = function () {
		if(getSessionId()=="") {
			sessionStorage.setItem("session_id",randomString(32, "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"));
		}
	},
	options = {
		server: "<?php echo PJ_INSTALL_URL; ?>",
		folder: "<?php echo PJ_INSTALL_URL; ?>",
		index: <?php echo $index; ?>,

		zoom_level: <?php echo $tpl['option_arr']['o_zoom_level']; ?>,
		default_address: "<?php echo $tpl['option_arr']['o_default_address']; ?>",
		distance: "<?php echo $tpl['option_arr']['o_distance']; ?>",
		use_categories: "<?php echo $tpl['option_arr']['o_use_categories']; ?>",
	
		search_form_name: "stl_seach_form",
		search_form_address_name: "stl_seach_form_add",
		search_form_search_name: "stl_search_form_search",
		search_form_address: "address",
		search_form_category: "category_id",
		search_form_radius: "radius",
	
		label_opening_time: "<?php echo pjSanitize::clean(__('front_label_opening_times', true, false));?>",
		label_full_address: "<?php echo pjSanitize::clean(__('front_label_full_address', true, false));?>",
		label_directions: "<?php echo pjSanitize::clean(__('front_label_directions', true, false));?>",
		label_close: "<?php echo pjSanitize::clean(__('front_label_close', true, false));?>",
		label_from: "<?php echo pjSanitize::clean(__('front_label_from', true, false));?>",
		label_address: "<?php echo pjSanitize::clean(__('front_label_address', true, false));?>",
		label_go: "<?php echo pjSanitize::clean(__('front_label_go', true, false));?>",
		label_phone: "<?php echo pjSanitize::clean(__('front_label_phone', true, false));?>",
		label_email: "<?php echo pjSanitize::clean(__('front_label_email', true, false));?>",
		label_website: "<?php echo pjSanitize::clean(__('front_label_website', true, false));?>",
		label_not_found: "<?php echo pjSanitize::clean(__('front_label_not_found', true, false));?>",
		label_address_not_found: "<?php echo pjSanitize::clean(__('front_label_address_not_found', true, false));?>",
		label_sent: "<?php echo pjSanitize::clean(__('front_label_sent', true, false));?>",
		label_empty_email: "<?php echo pjSanitize::clean(__('front_label_empty_email', true, false));?>",
		label_invalid_email: "<?php echo pjSanitize::clean(__('front_label_invalid_email', true, false));?>",
		label_captcha_incorrect: "<?php echo pjSanitize::clean(__('front_captcha_incorrect', true, false));?>",
		label_geo_not_supported: "<?php echo pjSanitize::clean(__('front_geo_supported', true, false));?>",
	
		install_url: "<?php echo PJ_INSTALL_URL; ?>",
		generate_xml_url: "<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionGenerateXml",
		get_latlng_url: "<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionGetLatLng",
		send_email_url: "<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionSendEmail"
	};
	if (isSafari) {
		createSessionId();
		options.session_id = getSessionId();
	}else{
		options.session_id = "";
	}
	<?php
	$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
	$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
	?>
	loadScript("<?php echo PJ_INSTALL_URL . $dm->getPath('pj_jquery'); ?>pjQuery.min.js", function () {
		loadScript("<?php echo PJ_INSTALL_URL . $dm->getPath('pj_bootstrap'); ?>pjQuery.bootstrap.min.js", function () {
			loadScript("<?php echo PJ_INSTALL_URL . PJ_JS_PATH ?>pjLoad.js", function () {
				StoreLocator = StoreLocator(options);
			});
		});
	});
})();
</script>