<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFrontJs extends pjAppController
{	
	public $defaultCaptcha = 'StivaSoftCaptcha';
	
	public $defaultLocale = 'pjFileSharing_LocaleId';
	
	public $defaultClient = 'pjFileSharing_Client';
	
	public function __construct()
	{
		$this->setLayout('pjActionFrontJs');
		self::allowCORS();
	}
	
	public function afterFilter()
	{		
		
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		$this->loadSetFields();
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	public function isFrontLogged()
	{
		if (isset($_SESSION[$this->defaultClient]) && count($_SESSION[$this->defaultClient]) > 0)
		{
			return true;
		}
		return false;
	}
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				
				pjAppController::setFields($this->getLocaleId());
				
				$day_names = __('day_names', true);
				ksort($day_names, SORT_NUMERIC);
				
				$months = __('months', true);
				ksort($months, SORT_NUMERIC);
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Locale have been changed.', 'opts' => array(
					'day_names' => array_values($day_names),
					'month_names' => array_values($months)
				)));
			}
		}
		exit;
	}
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH.'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}
	
	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
	
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	
	public function pjActionLoadCss()
	{
		$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
		
		$theme = isset($_GET['theme']) ? $_GET['theme'] : $this->option_arr['o_theme'];
		if((int) $theme > 0)
		{
			$theme = 'theme' . $theme;
		}
		$arr = array(
				array('file' => 'css?family=Open+Sans:400,600,700', 'path' => 'https://fonts.googleapis.com/'),
				array('file' => 'font-awesome.min.css', 'path' => $dm->getPath('font-awesome') . 'css/'),
				array('file' => 'style.css', 'path' => PJ_CSS_PATH),
				array('file' => "$theme.css", 'path' => PJ_CSS_PATH . "themes/"),
				array('file' => 'transitions.css', 'path' => PJ_CSS_PATH)
		);
		$thread_id = null;
		if(isset($_GET['thread_id']) && (int) $_GET['thread_id'] > 0)
		{
			$thread_id = (int) $_GET['thread_id'];
		}
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
			
			if ($string !== FALSE)
			{
				echo str_replace(
					array('../fonts/fontawesome', 'pjWrapperFileSharing'),
					array(
						PJ_INSTALL_URL . $dm->getPath('font-awesome') . 'fonts/fontawesome',
						"pjWrapperFileSharing_" . $theme),
					$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
	}
	
	public function pjActionIndex()
	{
		$this->setAjax(true);
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				$client = $_SESSION[$this->defaultClient];
				$pjFileModel = pjFileModel::factory();
			
				$pjFileModel->where('t1.status', 'T');
				$pjFileModel->where('t1.id IN (SELECT TCF.file_id FROM `'.pjClientFileModel::factory()->getTable().'` TCF WHERE TCF.client_id = '.$client['id'].')');
			
				$column = 'created';
				$direction = 'DESC';
				if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')) && in_array(strtolower($_GET['column']), array('file_name', 'file_size', 'created', 'last_comment', 'favorite')))
				{
					$column = $_GET['column'];
					$direction = strtoupper($_GET['direction']);
				}
			
				$total = $pjFileModel->findCount()->getData();
				$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $this->option_arr['o_files_per_page'];
				$pages = ceil($total / $rowCount);
				$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
				$offset = ((int) $page - 1) * $rowCount;
				if ($page > $pages)
				{
					$page = $pages;
				}
			
				$tbl_comment = pjCommentModel::factory()->getTable();
				$arr = $pjFileModel
					->select("t1.*, t2.name AS client,
										(IF(CHAR_LENGTH(t1.file_name) >= 12, CONCAT(SUBSTRING(t1.file_name, 1, 12), '...'), t1.file_name)) as short_file_name,
										(SELECT TCF.is_favorite FROM `".pjClientFileModel::factory()->getTable()."` AS TCF WHERE TCF.file_id=t1.id AND TCF.client_id='".$client['id']."') AS favorite,
										(SELECT COUNT(TC.id) FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id) AS cnt_comments,
										(SELECT TC.created FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY created DESC LIMIT 1) AS last_comment,
										(SELECT TC.id FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY created DESC LIMIT 1) AS last_id")
					->join('pjClient', 't1.client_id=t2.id', 'left')
					->orderBy("$column $direction")
					->limit($rowCount, $offset)
					->findAll()
					->getData();
			
				$this->set('arr', $arr);
				$this->set('paginator', array('pages' => $pages, 'total' => $total));
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 110));
			}
		}
	}
	
	public function pjActionLogin()
	{
		$this->setAjax(true);
		if($this->isXHR())
		{
			if(isset($_POST['login']))
			{
				$front_err = pjSanitize::clean(__('front_err', true));
				if (!isset($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG01', 'code' => 100, 'text' => $front_err['LOG01']));
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG02', 'code' => 101, 'text' => $front_err['LOG02']));
				}
				if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG03', 'code' => 103, 'text' => $front_err['LOG03']));
				}
				if (!isset($_POST['password']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG04', 'code' => 104, 'text' => $front_err['LOG04']));
				}
				if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG05', 'code' => 105, 'text' => $front_err['LOG05']));
				}
				
				$pjClientModel = pjClientModel::factory();
				$client = $pjClientModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
					->where('t1.email', $_POST['email'])
					->where(sprintf("t1.password = AES_ENCRYPT('%s', '%s')", pjObject::escapeString($_POST['password']), PJ_SALT))
					->limit(1)
					->findAll()
					->getData();
				if (count($client) != 1)
				{
					$temp_client = $pjClientModel
						->reset()
						->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
						->where('t1.email', $_POST['email'])
						->limit(1)
						->findAll()
						->getData();
					if (count($temp_client) != 1)
					{
						pjAppController::jsonResponse(array('status' => 'LOG06', 'code' => 106, 'text' => $front_err['LOG06']));
					}else{
						pjAppController::jsonResponse(array('status' => 'LOG08', 'code' => 108, 'text' => $front_err['LOG08']));
					}
				}else{
					$client = $client[0];
					if ($client['status'] == 'F')
					{
						pjAppController::jsonResponse(array('status' => 'LOG07', 'code' => 107, 'text' => $front_err['LOG07']));
					}
					$_SESSION[$this->defaultClient] = $client;
				
					$data = array();
					$data['last_login'] = date("Y-m-d H:i:s");
					$data['ip'] = pjUtil::getClientIp();
					$pjClientModel->reset()->setAttributes(array('id' => $client['id']))->modify($data);
						
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => ''));
				}
			}
		}
	}
	
	public function pjActionForgot()
	{
		$this->setAjax(true);
		if($this->isXHR())
		{
			if(isset($_POST['forgot_password']))
			{
				$front_err = pjSanitize::clean(__('front_err', true));
				$front_msg = pjSanitize::clean(__('front_msg', true));
				
				if (!isset($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'FOR01', 'code' => 101, 'text' => $front_err['FOR01']));
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'FOR02', 'code' => 102, 'text' => $front_err['FOR02']));
				}
				if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'FOR03', 'code' => 103, 'text' => $front_err['FOR03']));
				}
				
				$pjClientModel = pjClientModel::factory();
				$client_arr = $pjClientModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
					->where('t1.email', $_POST['email'])
					->limit(1)
					->findAll()
					->getData();
				if(count($client_arr) == 0)
				{
					pjAppController::jsonResponse(array('status' => 'FOR05', 'code' => 105, 'text' => $front_err['FOR05']));
				}
				$client = $client_arr[0];
				if($client['status'] == 'F')
				{
					pjAppController::jsonResponse(array('status' => 'FOR04', 'code' => 104, 'text' => $front_err['FOR04']));
				}else{
					if(!empty($this->option_arr['o_email_forgot_subject']) && !empty($this->option_arr['o_email_forgot_message']))
					{
						$pjEmail = new pjEmail();
				
						if ($this->option_arr['o_send_email'] == 'smtp')
						{
							$pjEmail
								->setTransport('smtp')
								->setSmtpHost($this->option_arr['o_smtp_host'])
								->setSmtpPort($this->option_arr['o_smtp_port'])
								->setSmtpUser($this->option_arr['o_smtp_user'])
								->setSmtpPass($this->option_arr['o_smtp_pass'])
								->setSender($this->option_arr['o_smtp_user']);
						}
				
						$to = $_POST['email'];
						$subject = $subject = $this->option_arr['o_email_forgot_subject'];
						$from = $this->getAdminEmail();
				
						$message = str_replace(
								array('{Name}', '{Password}'),
								array($client['name'], $client['password']),
								$this->option_arr['o_email_forgot_message']
						);
				
						$pjEmail->setContentType('text/html');
						$pjEmail->setTo($to);
						$pjEmail->setFrom($from);
						$pjEmail->setSubject($subject);
						$pjEmail->send($message);
				
						pjAppController::jsonResponse(array('status' => 'FOR01', 'code' => 200, 'text' => $front_msg['FOR01']));
					}
				}
			}
		}
	}
	
	public function pjActionView()
	{
		$this->setAjax(true);
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				$client = $_SESSION[$this->defaultClient];
				$id = pjObject::escapeString($_GET['id']);
				if(!empty($id) && (int) $id > 0)
				{
					$arr = pjFileModel::factory()
						->select("t1.*, t2.name AS client, t3.name AS user,
									  (SELECT TCF.is_favorite FROM `".pjClientFileModel::factory()->getTable()."` AS TCF WHERE TCF.file_id=t1.id AND TCF.client_id='".$client['id']."') AS favorite,")
					  	->join('pjClient', 't1.client_id=t2.id', 'left')
					  	->join('pjUser', 't1.user_id=t3.id', 'left')
					  	->find($id)
					  	->getData();
				
					$this->set('arr', $arr);
					
					$comment_result = $this->getCommentList($_GET);
					
					$this->set('comment_arr', $comment_result['comment_arr']);
					$this->set('paginator', $comment_result['paginator']);
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 110));
			}
		}
	}
	
	public function pjActionProfile()
	{
		$this->setAjax(true);
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				if(isset($_POST['profile']))
				{
					$pjClientModel = pjClientModel::factory();
					$pjClientModel->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
					$_SESSION[$this->defaultClient] = $pjClientModel->reset()->find($_POST['id'])->getData();
					
					$front_msg = pjSanitize::clean(__('front_msg', true));
					pjAppController::jsonResponse(array('status' => 'PRO01', 'code' => 200, 'text' => $front_msg['PRO01']));
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 110));
			}
		}
	}
	
	public function pjActionAddFile()
	{
		$this->setAjax(true);
		
		
		$post_max_size = pjUtil::getPostMaxSize();
		if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
		{
			$front_err = pjSanitize::clean(__('front_err', true));
			$err_message = $front_err['FF03'];
			$err_message = str_replace("{EXT}", $tpl['option_arr']['o_file_allowed'], $err_message);
			$err_message = str_replace("{SIZE}", ini_get('post_max_size'), $err_message);
			pjAppController::jsonResponse(array('status' => 'FF03', 'code' => 100, 'text' => $err_message));
		}
		
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				if(isset($_POST['add_file']))
				{
					$front_err = pjSanitize::clean(__('front_err', true));
					$front_msg = pjSanitize::clean(__('front_msg', true));
					
					$error_arr = array();
					$files = array();
					$allowed_ext = explode("|", $this->option_arr['o_file_allowed']);
						
					foreach ($_FILES['files'] as $k => $l) {
						foreach ($l as $i => $v) {
							if (!array_key_exists($i, $files))
							{
								$files[$i] = array();
							}
							$files[$i][$k] = $v;
						}
					}
					$id_arr = array();
					$client = $_SESSION[$this->defaultClient];
					$pjFileModel = pjFileModel::factory();
					$pjClientFileModel = pjClientFileModel::factory();
					foreach ($files as $k => $file)
					{
						$hash = md5(uniqid(rand(), true));
						$cnt = $pjFileModel->reset()->where('hash', $hash)->findCount()->getData();
						while($cnt > 0)
						{
							$hash = md5(uniqid(rand(), true));
							$cnt = $pjFileModel->reset()->where('hash', $hash)->findCount()->getData();
						}
						if(getimagesize($file["tmp_name"]) != false)
						{
							$Image = new pjImage();
							$Image->setAllowedExt($allowed_ext);
								
							if ($Image->load($file))
							{
								$resp = $Image->isConvertPossible();
								if ($resp['status'] === true)
								{
									$file_path = PJ_UPLOAD_PATH . 'files/' . $hash . '.' . $Image->getExtension();
									$thumb_path = PJ_UPLOAD_PATH . 'thumbs/' . $hash . '.' . $Image->getExtension();
									if ($Image->save(PJ_INSTALL_PATH . $file_path))
									{
										$Image->loadImage(PJ_INSTALL_PATH . $file_path);
										$Image->resizeSmart(180, 150);
										$Image->saveImage(PJ_INSTALL_PATH . $thumb_path);
									}
					
									$data = array();
									$data['mime_type'] = $file['type'];
									$data['file_path'] = $file_path;
									$data['thumb_path'] = $thumb_path;
									$data['file_name'] = $file['name'];
									$data['file_size'] = $file['size'];
									$data['hash'] = $hash;
									$data['user_id'] = ':NULL';
									$data['client_id'] = $client['id'];
					
									$id = $pjFileModel->reset()->setAttributes($data)->insert()->getInsertId();
									if ($id !== false && (int) $id > 0)
									{
										$cdata = array();
										$cdata['client_id'] = $client['id'];
										$cdata['file_id'] = $id;
										$pjClientFileModel->reset()->setAttributes($cdata)->insert();
					
										$id_arr[] = $id;
									}
								}
							}else{
								$error_arr[$k] = $Image->getErrorCode();
							}
								
						}else{
							$handle = new pjUpload();
							$handle->setAllowedExt($allowed_ext);
							if ($handle->load($file))
							{
								$data = array();
								$file_ext = $handle->getExtension();
								$file_path = PJ_UPLOAD_PATH . 'files/' . $hash . '.' . $file_ext;
								if($handle->save(PJ_INSTALL_PATH . $file_path))
								{
									$data['mime_type'] = $file['type'];
									$data['file_path'] = $file_path;
									$data['file_name'] = $file['name'];
									$data['file_size'] = $file['size'];
									$data['hash'] = $hash;
									$data['user_id'] = ':NULL';
									$data['client_id'] = $client['id'];
								}
									
								$id = $pjFileModel->reset()->setAttributes($data)->insert()->getInsertId();
								if ($id !== false && (int) $id > 0)
								{
									$cdata = array();
									$cdata['client_id'] = $client['id'];
									$cdata['file_id'] = $id;
									$pjClientFileModel->reset()->setAttributes($cdata)->insert();
										
									$id_arr[] = $id;
								}
							}else{
								$error_arr[$k] = $handle->getErrorCode();
							}
						}
					}
						
					if(count($error_arr) == 0)
					{
						$this->newFileEmail($client, $id_arr, $this->option_arr, 'admin');
						$this->sendSMS($client, $this->option_arr, 'file', 'admin');
							
						pjAppController::jsonResponse(array('status' => 'FF01', 'code' => 200, 'text' => $front_msg['FF01']));
					}else{
						if(count($error_arr) == count($files))
						{
							pjAppController::jsonResponse(array('status' => 'FF01', 'code' => 101, 'text' => $front_err['FF01']));
						}else if(count($error_arr) < count($files)){
							$this->newFileEmail($client, $id_arr, $this->option_arr, 'admin');
							$this->sendSMS($client, $this->option_arr, 'file', 'admin');

							$code_arr = pjSanitize::clean(__('file_error_code', true));
							$err_message = $front_err['FF04'];
							$err_arr = array();
							foreach($files as $k => $f)
							{
								$err_arr[] = $f['name'] . ': ' . (empty($error_arr[$k]) ? $code_arr['100'] : $code_arr[$error_arr[$k]]);
							}
							$err_message .= '<br/>' . join("<br/>", $err_arr);
							
							pjAppController::jsonResponse(array('status' => 'FF01', 'code' => 102, 'text' => $err_message));
						}
					}
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 110));
			}
		}
	}
	
	public function pjActionGetComments()
	{
		$this->setAjax(true);
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				$comment_result = $this->getCommentList($_GET);
					
				$this->set('comment_arr', $comment_result['comment_arr']);
				$this->set('paginator', $comment_result['paginator']);
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 110));
			}
		}
	}
	
	public function pjActionLogout()
	{
		$this->setAjax(true);
		
		if($this->isXHR())
		{
			if ($this->isFrontLogged())
			{
				unset($_SESSION[$this->defaultClient]);
			}
		}
		exit;
	}
	
	public function pjActionSaveComment()
	{
		$this->setAjax(true);
		
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				$client = $_SESSION[$this->defaultClient];
				if($_POST['post_comment'])
				{
					$front_err = pjSanitize::clean(__('front_err', true));
					$front_msg = pjSanitize::clean(__('front_msg', true));
					
					if (!isset($_POST['comment']))
					{
						pjAppController::jsonResponse(array('status' => 'COM01', 'code' => 101, 'text' => $front_err['COM01']));
					}
					if (isset($_POST['comment']) && !pjValidation::pjActionNotEmpty($_POST['comment']))
					{
						pjAppController::jsonResponse(array('status' => 'COM02', 'code' => 102, 'text' => $front_err['COM02']));
					}
					$data = array();
					$data['ip'] = pjUtil::getClientIp();
					$data['client_id'] = $client['id'];
				
					$id = pjCommentModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				
					if ($id !== false && (int) $id > 0)
					{
						$arr = pjCommentModel::factory()
							->select('t1.*, t2.file_name')
							->join('pjFile', 't1.file_id=t2.id', 'left')
							->find($id)
							->getData();
						
						$this->newCommentEmail($client, $arr, $this->option_arr, 'admin');
						$this->sendSMS($client, $this->option_arr, 'comment', 'admin');

						pjAppController::jsonResponse(array('status' => 'COM01', 'code' => 200, 'text' => $front_msg['COM01']));
					} else {
						pjAppController::jsonResponse(array('status' => 'COM03', 'code' => 103, 'text' => $front_err['COM03']));
					}
				}else{
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 110));
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 110));
			}
		}
	}
	
	public function pjActionSetFavorite()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$client = $_SESSION[$this->defaultClient];
			pjClientFileModel::factory()->where('file_id', $_GET['file_id'])->where('client_id', $client['id'])->limit(1)->modifyAll(array('is_favorite' => 'T'));
			$response['code'] = 200;
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionUnSetFavorite()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$client = $_SESSION[$this->defaultClient];
			pjClientFileModel::factory()->where('file_id', $_GET['file_id'])->where('client_id', $client['id'])->limit(1)->modifyAll(array('is_favorite' => 'F'));
			$response['code'] = 200;
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteFile()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$response['code'] = 100;
			if(isset($_SESSION[$this->defaultClient]))
			{
				$pjFileModel = pjFileModel::factory();
				$arr = $pjFileModel->find($_GET['id'])->getData();
				if($arr['client_id'] == $_SESSION[$this->defaultClient]['id'])
				{
					if ($pjFileModel->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
					{
						pjClientFileModel::factory()->where('file_id', $_GET['id'])->eraseAll();
	
						$file_path = $arr['file_path'];
						$thumb_path = $arr['thumb_path'];
						if (file_exists(PJ_INSTALL_PATH . $file_path)) {
							@unlink(PJ_INSTALL_PATH . $file_path);
						}
						if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
							@unlink(PJ_INSTALL_PATH . $thumb_path);
						}
						$response['code'] = 200;
					} else {
						$response['code'] = 100;
					}
				}else{
					$response['code'] = 101;
				}
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function getCommentList($get)
	{
	    $pjCommentModel = pjCommentModel::factory()->where('t1.file_id', $get['id'])->where('t1.status', 'T');
		$column = 'created';
		$direction = 'DESC';
		if (isset($get['direction']) && isset($get['column']) && in_array(strtoupper($get['direction']), array('ASC', 'DESC')))
		{
			$column = $_GET['column'];
			$direction = strtoupper($get['direction']);
		}
		
		$total = $pjCommentModel->findCount()->getData();
		$rowCount = isset($get['rowCount']) && (int) $get['rowCount'] > 0 ? (int) $get['rowCount'] : $this->option_arr['o_comments_per_page'];
		$pages = ceil($total / $rowCount);
		$page = isset($get['pjPage']) && (int) $get['pjPage'] > 0 ? intval($get['pjPage']) : 1;
		$offset = ((int) $page - 1) * $rowCount;
		if ($page > $pages)
		{
			$page = $pages;
		}
		
		$comment_arr = $pjCommentModel
			->select("t1.*, t2.name AS client, t3.name AS user")
			->join('pjClient', 't2.id=t1.client_id', 'left')
			->join('pjUser', 't3.id=t1.user_id', 'left')
			->orderBy("$column $direction")
			->limit($rowCount, $offset)
			->findAll()
			->getData();
		
		$paginator = array('pages' => $pages, 'total' => $total);
		
		return compact('comment_arr', 'paginator');
	}
	
	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
		header('P3P: CP="ALL DSP COR CUR ADM TAI OUR IND COM NAV INT"');
		header("Access-Control-Allow-Origin: $origin");
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
	}
}
?>