<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjLoad extends pjFront
{	
	public function pjActionIndex()
	{	
		$client = $_SESSION[$this->defaultClient];
		$pjFileModel = pjFileModel::factory();
		
		$pjFileModel->where('t1.status', 'T');
		$pjFileModel->where('t1.id IN (SELECT TCF.file_id FROM `'.pjClientFileModel::factory()->getTable().'` TCF WHERE TCF.client_id = '.$client['id'].')');
		
		$column = 'created';
		$direction = 'DESC';
		if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')) && in_array(strtolower($_GET['column']), array('file_name', 'file_size', 'created', 'last_comment', 'favorite')))
		{
			$column = $_GET['column'];
			$direction = strtoupper($_GET['direction']);
		}
		
		$total = $pjFileModel->findCount()->getData();
		$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $this->option_arr['o_files_per_page'];
		$pages = ceil($total / $rowCount);
		$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
		$offset = ((int) $page - 1) * $rowCount;
		if ($page > $pages)
		{
			$page = $pages;
		}
		
		$tbl_comment = pjCommentModel::factory()->getTable();
		$arr = $pjFileModel
			->select("t1.*, t2.name AS client,
								(IF(CHAR_LENGTH(t1.file_name) >= 12, CONCAT(SUBSTRING(t1.file_name, 1, 12), '...'), t1.file_name)) as short_file_name,
								(SELECT TCF.is_favorite FROM `".pjClientFileModel::factory()->getTable()."` AS TCF WHERE TCF.file_id=t1.id AND TCF.client_id='".$client['id']."') AS favorite, 
								(SELECT COUNT(TC.id) FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id) AS cnt_comments,
								(SELECT TC.created FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY created DESC LIMIT 1) AS last_comment,
								(SELECT TC.id FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY created DESC LIMIT 1) AS last_id")
			->join('pjClient', 't1.client_id=t2.id', 'left')
			->orderBy("$column $direction")
			->limit($rowCount, $offset)
			->findAll()
			->getData();
		
		$this->set('arr', $arr);
		$this->set('paginator', array('pages' => $pages, 'total' => $total));
	}
	
	public function pjActionView()
	{
		$client = $_SESSION[$this->defaultClient];
		if($_POST['post_comment'])
		{
			$err = null;
			if (!isset($_POST['comment']))
			{
				$err = 'COM01';
			}
			if (isset($_POST['comment']) && !pjValidation::pjActionNotEmpty($_POST['comment']))
			{
				$err = 'COM02';
			}
			if($err == null)
			{
				$data = array();
				$data['ip'] = pjUtil::getClientIp();
				$data['client_id'] = $client['id'];
				
				$id = pjCommentModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					$arr = pjCommentModel::factory()
						->select('t1.*, t2.file_name')
						->join('pjFile', 't1.file_id=t2.id', 'left')
						->find($id)
						->getData();
					$this->newCommentEmail($client, $arr, $this->option_arr, 'admin');
					$this->sendSMS($client, $this->option_arr, 'comment', 'admin');
					
					$_SESSION[$this->defaultMessage] = 'COM01';
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionView&id=' . $_POST['file_id'] . (isset($_POST['iframe']) ? '&iframe' : NULL) . '#pjFsCommentFormBox');
				} else {
					$_SESSION[$this->defaultError] = 'COM03';
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionView&id=' . $_POST['file_id'] . (isset($_POST['iframe']) ? '&iframe' : NULL) . '#pjFsCommentFormBox');
				}
			}else{
				$_SESSION[$this->defaultError] = $err;
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionView&id=' . $_POST['file_id'] . (isset($_POST['iframe']) ? '&iframe' : NULL) . '#pjFsCommentFormBox');
			}
		}else{
			$id = pjObject::escapeString($_GET['id']);
			if(!empty($id) && (int) $id > 0)
			{
				$arr = pjFileModel::factory()
					->select("t1.*, t2.name AS client, t3.name AS user,
							  (SELECT TCF.is_favorite FROM `".pjClientFileModel::factory()->getTable()."` AS TCF WHERE TCF.file_id=t1.id AND TCF.client_id='".$client['id']."') AS favorite,")
	  				->join('pjClient', 't1.client_id=t2.id', 'left')
	  				->join('pjUser', 't1.user_id=t3.id', 'left')
	  				->find($id)
	  				->getData();
				
  				$pjCommentModel = pjCommentModel::factory()->where('t1.file_id', $_GET['id'])->where('t1.status', 'T');
				$column = 'created';
				$direction = 'DESC';
				if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
				{
					$column = $_GET['column'];
					$direction = strtoupper($_GET['direction']);
				}
				
				$total = $pjCommentModel->findCount()->getData();
				$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $this->option_arr['o_comments_per_page'];
				$pages = ceil($total / $rowCount);
				$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
				$offset = ((int) $page - 1) * $rowCount;
				if ($page > $pages)
				{
					$page = $pages;
				}
				
				$comment_arr = $pjCommentModel
					->select("t1.*, t2.name AS client, t3.name AS user")
					->join('pjClient', 't2.id=t1.client_id', 'left')
					->join('pjUser', 't3.id=t1.user_id', 'left')
					->orderBy("$column $direction")
					->limit($rowCount, $offset)
					->findAll()
					->getData();
				
				$this->set('arr', $arr);
				$this->set('comment_arr', $comment_arr);
				$this->set('paginator', array('pages' => $pages, 'total' => $total));
				
				if(isset($_SESSION[$this->defaultError]))
				{
					$this->set('err', $_SESSION[$this->defaultError]);
					unset($_SESSION[$this->defaultError]);
				}
				if(isset($_SESSION[$this->defaultMessage]))
				{
					$this->set('msg', $_SESSION[$this->defaultMessage]);
					unset($_SESSION[$this->defaultMessage]);
				}
			}
		}
	}
	
	public function pjActionAddFile()
	{
		$post_max_size = pjUtil::getPostMaxSize();
		if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
		{
			$_SESSION[$this->defaultError] = 'FF03';
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionAddFile' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}
		if(isset($_POST['add_file']))
		{
			$error_arr = array();
			$files = array();
			$allowed_ext = explode("|", $this->option_arr['o_file_allowed']);
			
			foreach ($_FILES['files'] as $k => $l) {
				foreach ($l as $i => $v) {
					if (!array_key_exists($i, $files))
					{
						$files[$i] = array();
					}
					$files[$i][$k] = $v;
				}
			}
			$id_arr = array();
			$client = $_SESSION[$this->defaultClient];
			$pjFileModel = pjFileModel::factory();
			$pjClientFileModel = pjClientFileModel::factory();
			foreach ($files as $k => $file)
			{
				$hash = md5(uniqid(rand(), true));
				$cnt = $pjFileModel->reset()->where('hash', $hash)->findCount()->getData();
				while($cnt > 0)
				{
					$hash = md5(uniqid(rand(), true));
					$cnt = $pjFileModel->reset()->where('hash', $hash)->findCount()->getData();
				}
				if(getimagesize($file["tmp_name"]) != false)
				{
					$Image = new pjImage();
					$Image->setAllowedExt($allowed_ext);
					
					if ($Image->load($file))
					{
						$resp = $Image->isConvertPossible();
						if ($resp['status'] === true)
						{
							$file_path = PJ_UPLOAD_PATH . 'files/' . $hash . '.' . $Image->getExtension();
							$thumb_path = PJ_UPLOAD_PATH . 'thumbs/' . $hash . '.' . $Image->getExtension();
							if ($Image->save(PJ_INSTALL_PATH . $file_path))
							{
								$Image->loadImage(PJ_INSTALL_PATH . $file_path);
								$Image->resizeSmart(180, 150);
								$Image->saveImage(PJ_INSTALL_PATH . $thumb_path);
							}
				
							$data = array();
							$data['mime_type'] = $file['type'];
							$data['file_path'] = $file_path;
							$data['thumb_path'] = $thumb_path;
							$data['file_name'] = $file['name'];
							$data['file_size'] = $file['size'];
							$data['hash'] = $hash;
							$data['user_id'] = ':NULL';
							$data['client_id'] = $client['id'];
								
							$id = $pjFileModel->reset()->setAttributes($data)->insert()->getInsertId();
							if ($id !== false && (int) $id > 0)
							{
								$cdata = array();
								$cdata['client_id'] = $client['id'];
								$cdata['file_id'] = $id;
								$pjClientFileModel->reset()->setAttributes($cdata)->insert();
								
								$id_arr[] = $id;
							}
						}
					}else{
						$error_arr[$k] = $Image->getErrorCode();
					}
					
				}else{
					$handle = new pjUpload();
					$handle->setAllowedExt($allowed_ext);
					if ($handle->load($file))
					{
						$data = array();
						$file_ext = $handle->getExtension();
						$file_path = PJ_UPLOAD_PATH . 'files/' . $hash . '.' . $file_ext;
						if($handle->save(PJ_INSTALL_PATH . $file_path))
						{
							$data['mime_type'] = $file['type'];
							$data['file_path'] = $file_path;
							$data['file_name'] = $file['name'];
							$data['file_size'] = $file['size'];
							$data['hash'] = $hash;
							$data['user_id'] = ':NULL';
							$data['client_id'] = $client['id'];
						}
							
						$id = $pjFileModel->reset()->setAttributes($data)->insert()->getInsertId();
						if ($id !== false && (int) $id > 0)
						{
							$cdata = array();
							$cdata['client_id'] = $client['id'];
							$cdata['file_id'] = $id;
							$pjClientFileModel->reset()->setAttributes($cdata)->insert();
							
							$id_arr[] = $id;
						}
					}else{
						$error_arr[$k] = $handle->getErrorCode();
					}
				}
			}
			
			if(count($error_arr) == 0)
			{
				$this->newFileEmail($client, $id_arr, $this->option_arr, 'admin');
				$this->sendSMS($client, $this->option_arr, 'file', 'admin');
					
				$_SESSION[$this->defaultMessage] = 'FF01';
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionAddFile' . (isset($_POST['iframe']) ? '&iframe' : NULL));
			}else{
				if(count($error_arr) == count($files))
				{
					$_SESSION[$this->defaultError] = 'FF01';
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionAddFile' . (isset($_POST['iframe']) ? '&iframe' : NULL));
				}else if(count($error_arr) < count($files)){
					$this->newFileEmail($client, $id_arr, $this->option_arr, 'admin');
					$this->sendSMS($client, $this->option_arr, 'file', 'admin');
					
					$_SESSION[$this->defaultError] = compact('files', 'error_arr');
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionAddFile' . (isset($_POST['iframe']) ? '&iframe' : NULL));
				}
			}
		}else{
			
			if(isset($_SESSION[$this->defaultError]))
			{
				$this->set('err', $_SESSION[$this->defaultError]);
				unset($_SESSION[$this->defaultError]);
			}
			if(isset($_SESSION[$this->defaultMessage]))
			{
				$this->set('msg', $_SESSION[$this->defaultMessage]);
				unset($_SESSION[$this->defaultMessage]);
			}
		}
	}
	
	public function pjActionLogin()
	{
		if(isset($_POST['login']))
		{
			$err = null;
			if (!isset($_POST['email']))
			{
				$err = 'LOG01';
			}
			if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
			{
				$err = 'LOG02';
			}
			if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
			{
				$err = 'LOG03';
			}
			if (!isset($_POST['password']))
			{
				$err = 'LOG04';
			}
			if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']))
			{
				$err = 'LOG05';
			}
			if($err == null)
			{
				$pjClientModel = pjClientModel::factory();
				$client = $pjClientModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
					->where('t1.email', $_POST['email'])
					->where(sprintf("t1.password = AES_ENCRYPT('%s', '%s')", pjObject::escapeString($_POST['password']), PJ_SALT))
					->limit(1)
					->findAll()
					->getData();
				if (count($client) != 1)
				{
					$temp_client = $pjClientModel
						->reset()
						->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
						->where('t1.email', $_POST['email'])
						->limit(1)
						->findAll()
						->getData();
					if (count($temp_client) != 1)
					{
						$_SESSION[$this->defaultError] = 'LOG06';
					}else{
						$_SESSION[$this->defaultError] = 'LOG08';
						
					}
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionLogin' . (isset($_POST['iframe']) ? '&iframe' : NULL));
				}else{
					$client = $client[0];
					if ($client['status'] == 'F')
					{
						$_SESSION[$this->defaultError] = 'LOG07';
						pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionLogin' . (isset($_POST['iframe']) ? '&iframe' : NULL));
					}
					$_SESSION[$this->defaultClient] = $client;
					 
					$data = array();
					$data['last_login'] = date("Y-m-d H:i:s");
					$data['ip'] = pjUtil::getClientIp();
					$pjClientModel->reset()->setAttributes(array('id' => $client['id']))->modify($data);
					
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionIndex' . (isset($_POST['iframe']) ? '&iframe' : NULL));
				}
			}else{
				$_SESSION[$this->defaultError] = $err;
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionLogin' . (isset($_POST['iframe']) ? '&iframe' : NULL));
			}
		}else{
			if(isset($_SESSION[$this->defaultError]))
			{
				$this->set('err', $_SESSION[$this->defaultError]);
				unset($_SESSION[$this->defaultError]);
			}
		}
	}
	
	public function pjActionForgot()
	{
		if(isset($_POST['forgot_password']))
		{
			$err = null;
			if (!isset($_POST['email']))
			{
				$err = 'FOR01';
			}
			if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
			{
				$err = 'FOR02';
			}
			if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
			{
				$err = 'FOR03';
			}
			if($err == null)
			{
				$pjClientModel = pjClientModel::factory();
				$client_arr = $pjClientModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
					->where('t1.email', $_POST['email'])
					->limit(1)
					->findAll()
					->getData();
				if(count($client_arr) == 0)
				{
					$_SESSION[$this->defaultError] = 'FOR05';
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionForgot' . (isset($_POST['iframe']) ? '&iframe' : NULL));
				}
				$client = $client_arr[0];
				if($client['status'] == 'F')
				{
					$_SESSION[$this->defaultError] = 'FOR04';
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionForgot' . (isset($_POST['iframe']) ? '&iframe' : NULL));
				}else{
					if(!empty($this->option_arr['o_email_forgot_subject']) && !empty($this->option_arr['o_email_forgot_message']))
					{
						$pjEmail = new pjEmail();
						
						if ($this->option_arr['o_send_email'] == 'smtp')
						{
							$pjEmail
								->setTransport('smtp')
								->setSmtpHost($this->option_arr['o_smtp_host'])
								->setSmtpPort($this->option_arr['o_smtp_port'])
								->setSmtpUser($this->option_arr['o_smtp_user'])
								->setSmtpPass($this->option_arr['o_smtp_pass'])
								->setSender($this->option_arr['o_smtp_user']);
						}
						
						$to = $_POST['email'];
						$subject = $subject = $this->option_arr['o_email_forgot_subject'];
						$from = $this->getAdminEmail();
						
						$message = str_replace(
								array('{Name}', '{Password}'),
								array($client['name'], $client['password']),
								$this->option_arr['o_email_forgot_message']
						);
						
						$pjEmail->setContentType('text/html');
						$pjEmail->setTo($to);
						$pjEmail->setFrom($from);
						$pjEmail->setSubject($subject);
						$pjEmail->send($message);
						
						$_SESSION[$this->defaultMessage] = 'FOR01';
						pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionForgot' . (isset($_POST['iframe']) ? '&iframe' : NULL));
					}
				}
			}else{
				$_SESSION[$this->defaultError] = $err;
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionForgot' . (isset($_POST['iframe']) ? '&iframe' : NULL));
			}
		}else{
			if(isset($_SESSION[$this->defaultError]))
			{
				$this->set('err', $_SESSION[$this->defaultError]);
				unset($_SESSION[$this->defaultError]);
			}
			if(isset($_SESSION[$this->defaultMessage]))
			{
				$this->set('msg', $_SESSION[$this->defaultMessage]);
				unset($_SESSION[$this->defaultMessage]);
			}
		}
	}
	
	public function pjActionProfile()
	{
		if(isset($_POST['profile']))
		{
			$pjClientModel = pjClientModel::factory();
			$pjClientModel->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
			$_SESSION[$this->defaultClient] = $pjClientModel->reset()->find($_POST['id'])->getData();
			$_SESSION[$this->defaultMessage] = 'PRO01';
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionProfile' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}else{
			if(isset($_SESSION[$this->defaultMessage]))
			{
				$this->set('msg', $_SESSION[$this->defaultMessage]);
				unset($_SESSION[$this->defaultMessage]);
			}
		}
	}
	
	public function pjActionLogout()
	{
		if ($this->checkLogin())
		{
			unset($_SESSION[$this->defaultClient]);
		}
		pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionLogin' . (isset($_POST['iframe']) ? '&iframe' : NULL));
	}
	
	public function pjActionSetFavorite()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$response = array();
			$client = $_SESSION[$this->defaultClient];
			pjClientFileModel::factory()->where('file_id', $_GET['file_id'])->where('client_id', $client['id'])->limit(1)->modifyAll(array('is_favorite' => 'T'));
			$response['code'] = 200;
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionUnSetFavorite()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$client = $_SESSION[$this->defaultClient];
			pjClientFileModel::factory()->where('file_id', $_GET['file_id'])->where('client_id', $client['id'])->limit(1)->modifyAll(array('is_favorite' => 'F'));
			$response['code'] = 200;
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteFile()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$response['code'] = 100;
			if(isset($_SESSION[$this->defaultClient]))
			{
				$pjFileModel = pjFileModel::factory();
				$arr = $pjFileModel->find($_GET['id'])->getData();
				if($arr['client_id'] == $_SESSION[$this->defaultClient]['id'])
				{
					if ($pjFileModel->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
					{
						pjClientFileModel::factory()->where('file_id', $_GET['id'])->eraseAll();
						
						$file_path = $arr['file_path'];
						$thumb_path = $arr['thumb_path'];
						if (file_exists(PJ_INSTALL_PATH . $file_path)) {
							@unlink(PJ_INSTALL_PATH . $file_path);
						}
						if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
							@unlink(PJ_INSTALL_PATH . $thumb_path);
						}
						$response['code'] = 200;
					} else {
						$response['code'] = 100;
					}
				}else{
					$response['code'] = 101;
				}
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
}
?>