<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat files">
				<div class="info">
					<abbr><?php echo $tpl['cnt_files'];?></abbr>
					<?php echo $tpl['cnt_files'] != 1 ? __('lblFilesUploadedToday') : __('lblFileUploadedToday');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat comments">
				<div class="info">
					<abbr><?php echo $tpl['cnt_comments'];?></abbr>
					<?php echo $tpl['cnt_comments'] != 1 ? __('lblCommentsPostedToday') : __('lblCommentPostedToday');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat clients">
				<div class="info">
					<abbr><?php echo $tpl['cnt_clients'];?></abbr>
					<?php echo $tpl['cnt_clients'] != 1 ? __('lblClientsAddedToday') : __('lblClientAddedToday');?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblLastUploadedFiles');?></div>
			<div class="dashboard_column_top"><?php __('lblLatestComments');?></div>
			<div class="dashboard_column_top"><?php __('lblQuickLinks');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['file_arr']) > 0)
					{
						foreach($tpl['file_arr'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFiles&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['file_name']);?></a></label>
								<label><?php __('lblOn')?> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></label>
								<label><?php __('lblBy')?> <?php echo !empty($v['client']) ? pjSanitize::html($v['client']) : pjSanitize::html($v['user']);?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('lblNoFilesFound');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['comment_arr']) > 0)
					{
						foreach($tpl['comment_arr'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label><?php echo pjSanitize::html($v['file_name']);?></label>
								<label><?php __('lblOn')?> <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFiles&amp;action=pjActionComment&amp;id=<?php echo $v['file_id'];?>"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></a></label>
								<label><?php __('lblBy')?> <?php echo !empty($v['client']) ? pjSanitize::html($v['client']) : pjSanitize::html($v['user']);?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('lblNoCommentsFound');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<div class="dashboard_row quick_links">
						<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionCreate"><?php __('lblAddNewClient');?></a></label>
						<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFiles&amp;action=pjActionCreate"><?php __('lblUploadAFile');?></a></label>
						<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminComments&amp;action=pjActionCreate"><?php __('lblAddAComment');?></a></label>
						<br/><br/>
						<label><?php echo $tpl['total_clients'];?> <?php echo $tpl['total_clients'] == 1 ? mb_strtolower(__('lblClient', true), 'UTF-8') : mb_strtolower(__('menuClients', true), 'UTF-8');?></label>
						<label><?php echo $tpl['total_files'];?> <?php $tpl['total_files'] == 1 ? __('lblFileUploaded') : __('lblFilesUploaded');?></label>
						<label><?php __('lblSpaceTaken')?> <?php echo $tpl['total_size'];?></label>
						<label><?php echo $tpl['total_comments'];?> <?php $tpl['total_comments'] == 1 ? __('lblCommentPosted') : __('lblCommentsPosted');?></label>
					</div>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format']); ?></div>
		</div>
	</div>
	<?php
}
?>