var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateComment = $("#frmCreateComment"),
			$frmUpdateComment = $("#frmUpdateComment"),
			chosen = ($.fn.chosen !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		if (chosen) {
			$("#client_id").chosen();
			$("#file_id").chosen();
		}
		if ($frmCreateComment.length > 0 && validate) {
			$frmCreateComment.validate({
				rules:{
					"client_id": {
						required: function(){
							if($('#byClient').is(':checked'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"user_id": {
						required: function(){
							if($('#byUser').is(':checked'))
							{
								return true;
							}else{
								return false;
							}
						}
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ''
			});
			
			$('#pjPcEditClient').hide();
			$('#pjPcEditFile').hide();
			$('#pjPcPreviewFile').hide();
		}
		if ($frmUpdateComment.length > 0 && validate) {
			$frmUpdateComment.validate({
				rules:{
					"client_id": {
						required: function(){
							if($('#byClient').is(':checked'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"user_id": {
						required: function(){
							if($('#byUser').is(':checked'))
							{
								return true;
							}else{
								return false;
							}
						}
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ''
			});
			if($('#pjPcEditClient').attr('href') == '#')
			{
				$('#pjPcEditClient').hide();
			}
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			function formatFileName (str, obj) {
				return '<a href="file.php?id='+obj.file_id+'&hash='+obj.hash+'" target="_blank">'+str+'</a>';
			}
			function formatComment (str, obj) {
				return str + '<br/>' + obj.created;
			}
			function formatPostedBy(str, obj){
				if(obj.client == null)
				{
					return obj.user;
				}else{
					return '<a href="index.php?controller=pjAdminClients&action=pjActionUpdate&id=' + obj.client_id + '">' + str + '</a>';
				}
			}
			function showTopic(str, obj){
				return '<a href="index.php?controller=pjAdminTopics&action=pjActionUpdate&id=' + obj.topic_id + '">' + str + '</a>';
			}
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminComments&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminComments&action=pjActionDeleteComment&id={:id}"}
				          ],
				columns: [{text: myLabel.file_name, type: "text", sortable: false, editable: false, width: 160, renderer: formatFileName},
				          {text: myLabel.posted_by, type: "text", sortable: true, editable: false, width: 105, renderer: formatPostedBy},
				          {text: myLabel.comment, type: "text", sortable: true, editable: false, renderer: formatComment, width: 200},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 120, options: [
				                                                                                     {label: myLabel.approved, value: "T"}, 
				                                                                                     {label: myLabel.notapproved, value: "F"}
				                                                                                     ], applyClass: "pj-comment-status"}],
				dataUrl: "index.php?controller=pjAdminComments&action=pjActionGetComment" + pjGrid.queryString ,
				dataType: "json",
				fields: ['file_name', 'client', 'comment', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminComments&action=pjActionDeleteCommentBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminComments&action=pjActionExportComment", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminComments&action=pjActionSaveComment&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminComments&action=pjActionGetComment", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminComments&action=pjActionGetComment", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminComments&action=pjActionGetComment", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("change", "#file_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var id = $(this).val(),
				hash = $('option:selected', this).attr('data-hash');
			if(id == '')
			{
				$('#pjPcEditFile').hide();
				$('#pjPcPreviewFile').hide();
				if($('.pjFsReplyToComment').length > 0)
				{
					$('.pjFsReplyToComment').hide();
				}
			}else{
				var href = $('#pjPcEditFile').attr('data-href');
				href = href.replace(/\{ID\}/g, id);
				$('#pjPcEditFile').attr('href', href);
				$('#pjPcEditFile').show();
				
				$('#pjPcPreviewFile').attr('href', 'file.php?id=' + id + '&hash=' + hash);
				$('#pjPcPreviewFile').show();
				
				if($('.pjFsReplyToComment').length > 0)
				{
					var href = $('.pjFsReplyToComment').attr('data-href');
					href = href.replace(/\{ID\}/g, id);
					$('.pjFsReplyToComment').attr('href', href);
					$('.pjFsReplyToComment').show();
				}
			}
			
			return false;
		}).on("change", "#client_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var id = $(this).val();
			if(id == '')
			{
				$('#pjPcEditClient').hide();
				
			}else{
				var href = $('#pjPcEditClient').attr('data-href');
				href = href.replace(/\{ID\}/g, id);
				$('#pjPcEditClient').attr('href', href);
				$('#pjPcEditClient').show();
			}
			getFiles.call(null);
			return false;
		}).on("change", "input:radio", function (e) {
			if($(this).val() == 'client')
			{
				$('#pjFsClientBox').show();
				$('#pjFsUserBox').hide();
				$('#user_id').val('');
			}else{
				$('#pjFsClientBox').hide();
				$('#pjFsUserBox').show();
				$('#client_id').val('');
			}
			getFiles.call(null);
			return false;
		});
		
		function getFiles()
		{
			var client_id = $('#client_id').val();
			$.get("index.php?controller=pjAdminComments&action=pjActionGetFiles&client_id=" + client_id).done(function(data) {
				$('#pjFsFileBox').html(data);
				if (chosen) {
					$("#file_id").chosen();
				}
				$('#pjPcEditFile').hide();
				$('#pjPcPreviewFile').hide();
			});
		}
	});
})(jQuery_1_8_2);