var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmNotification = $('#frmNotification'),
			tabs = ($.fn.tabs !== undefined),
			spinner = ($.fn.spinner !== undefined),
			tipsy = ($.fn.tipsy !== undefined),
			$tabs = $("#tabs");
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		if (spinner) {
			$(".field-int").spinner({
				min: 0
			});
		}
		if (tipsy) {
			$(".option-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
		}
		if($frmNotification.length > 0)
		{
			tinymce.init({
				relative_urls : false,
				remove_script_host : false,
			    selector: "textarea.mceEditor",
			    theme: "modern",
			    width: 530,
			    height: 250,
			    plugins: [
			         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
			         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
			         "save table contextmenu directionality emoticons template paste textcolor"
			   ],
			   toolbar: "insertfile undo redo | styleselect fontselect fontsizeselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons"
			 });
		}
		$("#content").on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("click", ".pj-button-get-code", function (e) {
			reDrawCode.call(null, 1);
		}).on("click", ".pj-button-preview", function (e) {
			window.open("preview.php?&theme=" + $('#theme').val());
		}).on("change", "#thread_id", function (e) {
			reDrawCode.call(null, 0);
		}).on("change", "#theme", function (e) {
			reDrawCode.call(null, 1);
		});
		if($('#step_container').length > 0)
		{
			reDrawCode.call(null, 1);
		}
		function reDrawCode(open)
		{
			var theme = $('#theme').val();
			$('#step1').val('<?php\nob_start();\n$PJ_THEME = \''+theme+'\'; \n?>');
			if(open == 1)
			{
				$('#step_container').show();
			}
			
			var js_install_code = $('#install_code_clone').val();
			js_install_code = js_install_code.replace(/{THEME}/g, "&theme=" + theme);
			$('#install_code').val(js_install_code);
		}
	});
})(jQuery_1_8_2);