/*!
 * File Sharing Script v1.0
 * 
 * https://www.phpjabbers.com/file-sharing-script/
 * 
 * Copyright 2015, StivaSoft Ltd.
 * 
 */
(function (window, undefined){
	"use strict";
	

	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined);
    
	function loadDelayedCSS(opts) {
		pjQ.$(window).load(function() {
			  pjQ.$('body').append(pjQ.$('<link rel="stylesheet" type="text/css" />').attr('href', opts.server+'app/web/css/transitions.css'));
		});
	}
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnYacht(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function FileSharing(opts) {
		if (!(this instanceof FileSharing)) {
			return new FileSharing(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	FileSharing.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	FileSharing.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	FileSharing.prototype = {
		reset: function () {
			this.$container = null;
			this.container = null;			
			this.opts = {};
			
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjWrapperFileSharing");
			this.$container = pjQ.$(this.container);
			
			loadDelayedCSS(opts);
      
			self.bindLogin.call(self);
			self.bindForgot.call(self);
			self.bindProfile.call(self);
			self.bindAddFile.call(self);
			self.bindFileList.call(self);
			self.bindComments.call(self);
		},
		
		bindLogin: function(){
			var self = this,
				$frmLogin = pjQ.$('#pjFsLoginForm_' + self.opts.index);
			if($frmLogin.length > 0 && validate)
			{
				$frmLogin.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		},
		bindForgot: function(){
			var self = this,
				$frmForgot = pjQ.$('#pjFsForgotForm_' + self.opts.index);
			if($frmForgot.length > 0 && validate)
			{
				$frmForgot.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		},
		bindProfile: function(){
			var self = this,
				$frmProfile = pjQ.$('#pjFsProfileForm_' + self.opts.index);
			if($frmProfile.length > 0 && validate)
			{
				$frmProfile.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		},
		bindAddFile: function(){
			var self = this,
				$frmAddFile = pjQ.$('#pjFsAddFileForm_' + self.opts.index),
				$btnSubmit = pjQ.$('.pjFsBtnSubmitForm');
			
			if (pjQ.$('.pjFsAddFile').length) {
				var holderSelector = '.pjFsAddFile';
				var hasSelectedClass = 'pjFsAddFileAdded';
				var inputSelector = '.pjFsFileUploadField';
				var namesSelector = '.pjFsUploadedFiles';
				var messageSelector = '.pjFsExtensionMessage';
				var multipleNamesDivider = '; ';

				pjQ.$(inputSelector).on('change', function() {
					var input = this,
						files = input.files,
						allowed_ext = pjQ.$(input).attr('data-extension'),
						valid = false;

					pjQ.$.map(files, function(file) {
						var file_name = file.name,
							file_extension = file_name.substr( (file_name.lastIndexOf('.') + 1) );
						if(allowed_ext != '')
						{
							var allowed_arr = allowed_ext.split("|");
							if(pjQ.$.inArray(file_extension, allowed_arr) > -1)
							{
								valid = true;
							}
						}
					});
					pjQ.$(input).closest(holderSelector).toggleClass(hasSelectedClass, input.value !== '').find(namesSelector)
						.text(
							pjQ.$.map(files, function(file) {
								var file_name = file.name;
								return file.name;
							}).join(multipleNamesDivider)
						);
					if(valid == false)
					{
						pjQ.$(messageSelector).show();
						$btnSubmit.attr('disabled','disabled');
					}
				});

				pjQ.$('.pjFsBtnRemoveFile').on('click', function(e) {
					e.preventDefault();
					if (pjQ.$(this).attr('disabled') === undefined) 
					{
						pjQ.$(holderSelector).removeClass(hasSelectedClass);
						pjQ.$(inputSelector).val('');
						pjQ.$(namesSelector).text('');
						pjQ.$(messageSelector).hide();
						$btnSubmit.removeAttr('disabled');
					}
				});

				//drag and drop for add file
				pjQ.$(window).on('dragenter dragover drop', function(e) {
					if ((e.type === 'dragenter') && (pjQ.$(e.target).parents('.pjFsDroppableArea').length)) {
						console.log(1);
						pjQ.$(holderSelector).addClass('pjFsReadyForDrop');
					} else if ((e.type === 'dragenter') && (!pjQ.$(e.target).parents('.pjFsDroppableArea').length)) {
						pjQ.$(holderSelector).removeClass('pjFsReadyForDrop');
					} else if ((e.type === 'dragover') && (pjQ.$(e.target).parent().hasClass('pjFsBtnUpload'))) {
						pjQ.$('.pjFsBtnUpload').addClass('pjFsBtnReadyForDrop');
					} else if ((e.type === 'dragover') && (!pjQ.$(e.target).parent().hasClass('pjFsBtnUpload'))) {
						pjQ.$('.pjFsBtnUpload').removeClass('pjFsBtnReadyForDrop');
					} else if ((e.type === 'drop') && (pjQ.$(e.target).parent().hasClass('pjFsBtnUpload'))) {
						pjQ.$(holderSelector).removeClass('pjFsReadyForDrop');
						pjQ.$('.pjFsBtnUpload').removeClass('pjFsBtnReadyForDrop');
						console.log(5);
					};
				});
				
				$frmAddFile.on('submit', function(e){
					$btnSubmit.prepend( '<i class="fa fa-refresh fa-spin"></i>&nbsp;' ).attr('disabled','disabled');
					pjQ.$('.pjFsBtnRemoveFile').attr('disabled','disabled');
				});
			};
		},
		bindFileList: function(){
			var self = this,
				$frmFileList = pjQ.$('#pjFsFilesListForm_' + self.opts.index),
				$frmCommentList = pjQ.$('#pjFsCommentListForm_' + self.opts.index);
			if($frmFileList.length > 0)
			{
				pjQ.$('.pjFsPageNode').on('click.fs', function(e){
					e.preventDefault();
					var page = pjQ.$(this).attr('data-page');
					
					$frmFileList.find('input[name="pjPage"]').val(page);
					$frmFileList.submit();
				});
				pjQ.$('.pjFsViewAs').on('click.fs', function(e){
					e.preventDefault();
					var viewas = pjQ.$(this).attr('data-viewas');

					$frmFileList.append('<input type="hidden" name="viewas" value="'+viewas+'" />');
					$frmFileList.submit();
				});
				pjQ.$('.pjFsSortBy').on('click.fs', function(e){
					e.preventDefault();
					var column = pjQ.$(this).attr('data-column'),
						direction = pjQ.$(this).attr('data-direction');
					
					$frmFileList.find('input[name="column"]').val(column);
					$frmFileList.find('input[name="direction"]').val(direction);
					$frmFileList.submit();
				});
				
				pjQ.$('.modal-dialog').css("z-index", "9999");
			}
			if($frmCommentList.length > 0)
			{
				pjQ.$('.pjFsPageNode').on('click.fs', function(e){
					e.preventDefault();
					var page = pjQ.$(this).attr('data-page');
					
					$frmCommentList.find('input[name="pjPage"]').val(page);
					$frmCommentList.submit();
				});
			}
			pjQ.$('.pjFsRemoveFile').on('click.fs', function(e){
				e.preventDefault();
				var $this = pjQ.$(this),
					id = pjQ.$(this).attr('data-id');
				
				pjQ.$('#pjFsDeleteButton_' + self.opts.index).attr('data-id', id);
				pjQ.$('#pjFsDeleteFileModal').modal('show');
			});
			pjQ.$('#pjFsDeleteButton_' + self.opts.index).on('click.fs', function(e){
				e.preventDefault();
				var $this = pjQ.$(this),
					id = pjQ.$(this).attr('data-id');
				
				pjQ.$.get(self.opts.folder + "index.php?controller=pjLoad&action=pjActionDeleteFile&id=" + id).done(function (data) {
					if(data.code == '200')
					{
						$frmFileList.submit();
						pjQ.$('#pjFsDeleteFileModal').modal('hide');
					}else{
						pjQ.$('#pjFsDeleteFileModal').modal('hide');
						pjQ.$('#pjFsPermissionModal').modal('show');
					}
				});
			});
			pjQ.$('.pjFsFavorite').on('click.fs', function(e){
				e.preventDefault();
				var $this = pjQ.$(this),
					action = 'pjActionSetFavorite';
				if($this.hasClass('pjFsThumbStarChecked'))
				{
					action = 'pjActionUnSetFavorite';
				}
				pjQ.$.get(self.opts.folder + "index.php?controller=pjLoad&action="+action+"&file_id=" + $this.attr('data-id')).done(function(data) {
					if(data.code == '200')
					{
						if($this.hasClass('pjFsThumbStarChecked'))
						{
							$this.removeClass('pjFsThumbStarChecked');
						}else{
							$this.addClass('pjFsThumbStarChecked');
						}
					}
				});
			});
		},
		bindComments: function(){
			var self = this,
				$pjFsCommentForm_ = pjQ.$('#pjFsCommentForm_' + self.opts.index),
				$frmCommentList = pjQ.$('#pjFsCommentListForm_' + self.opts.index);
			if($pjFsCommentForm_.length > 0 && validate)
			{
				$pjFsCommentForm_.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
			if($frmCommentList.length > 0)
			{
				var page = parseInt($frmCommentList.find('input[name="pjPage"]').val(), 10);
				if(page > 1)
				{
					pjQ.$('html, body').animate({
			        	scrollTop: $frmCommentList.offset().top
			    	}, 500);
				}
			}
		}
	};
	
	window.FileSharing = FileSharing;	
})(window);