DROP TABLE IF EXISTS `igallery_hotspots`;
CREATE TABLE IF NOT EXISTS `igallery_hotspots` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `image_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `width` smallint(5) unsigned DEFAULT NULL,
  `height` smallint(5) unsigned DEFAULT NULL,
  `top` smallint(5) unsigned DEFAULT NULL,
  `left` smallint(5) unsigned DEFAULT NULL,
  `type` enum('icon','thumb','box') DEFAULT NULL,
  `effect` enum('1','2','3') DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `box_width` smallint(5) unsigned DEFAULT NULL,
  `box_height` smallint(5) unsigned DEFAULT NULL,
  `use_tooltip` enum('T','F') DEFAULT NULL,
  `data_type` enum('text','image','multi','video','link') DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `video_url` varchar(255) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `image_id` (`image_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `igallery_multiple_images`;
CREATE TABLE IF NOT EXISTS `igallery_multiple_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hotspot_id` int(10) unsigned DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `igallery_images`;
CREATE TABLE IF NOT EXISTS `igallery_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `thumb_path` varchar(255) DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `igallery_fields`;
CREATE TABLE IF NOT EXISTS `igallery_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `igallery_multi_lang`;
CREATE TABLE IF NOT EXISTS `igallery_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `igallery_options`;
CREATE TABLE IF NOT EXISTS `igallery_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `igallery_roles`;
CREATE TABLE IF NOT EXISTS `igallery_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `igallery_users`;
CREATE TABLE IF NOT EXISTS `igallery_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `igallery_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(5, 'btnAddImage', 'backend', 'Button / + Add image', 'script', NULL),
(6, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(7, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(8, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(9, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(10, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(11, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(12, 'btnDeleteImage', 'backend', 'Delete image', 'script', NULL),
(13, 'btnLogin', 'backend', 'Login', 'script', NULL),
(14, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(15, 'btnReset', 'backend', 'Reset', 'script', NULL),
(16, 'btnSave', 'backend', 'Save', 'script', NULL),
(17, 'btnSearch', 'backend', 'Search', 'script', NULL),
(18, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(19, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(20, 'created', 'backend', 'Created', 'script', NULL),
(21, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(22, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(23, 'email', 'backend', 'E-Mail', 'script', NULL),
(24, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(25, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(26, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(27, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(28, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(29, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(30, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(31, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(32, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(33, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(34, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(35, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(36, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(37, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(38, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(39, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(40, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(41, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(42, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(43, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(44, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(45, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(46, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(47, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(48, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(49, 'infoHotSpotsDesc', 'backend', 'Infobox / Hot spots', 'script', NULL),
(50, 'infoHotSpotsTitle', 'backend', 'Infobox / Hot spots', 'script', NULL),
(51, 'infoImagesDesc', 'backend', 'Infobox / List of images', 'script', NULL),
(52, 'infoImagesTitle', 'backend', 'Infobox / List of images', 'script', NULL),
(53, 'infoInstallDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(54, 'infoInstallTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(55, 'infoPreviewInstallDesc', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(56, 'infoPreviewInstallTitle', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(57, 'infoUpdateHotSpotDesc', 'backend', 'Infobox / Update hot spot', 'script', NULL),
(58, 'infoUpdateHotSpotTitle', 'backend', 'Infobox / Update hot spot', 'script', NULL),
(59, 'infoUpdateImageDesc', 'backend', 'Infobox / Update image', 'script', NULL),
(60, 'infoUpdateImageTitle', 'backend', 'Infobox / Update image', 'script', NULL),
(61, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(62, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(63, 'infoUploadImageDesc', 'backend', 'Infobox / Upload image', 'script', NULL),
(64, 'infoUploadImageTitle', 'backend', 'Infobox / Upload image', 'script', NULL),
(65, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(66, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(67, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(68, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(69, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(70, 'lblBoxHeight', 'backend', 'Label / Box height', 'script', NULL),
(71, 'lblBoxWidth', 'backend', 'Label / Box width', 'script', NULL),
(72, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(73, 'lblChooseImage', 'backend', 'Label / Choose image', 'script', NULL),
(74, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(75, 'lblDataType', 'backend', 'Label / Data type', 'script', NULL),
(76, 'lblDays', 'backend', 'Days', 'script', NULL),
(77, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(78, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(79, 'lblDeleteImageConfirm', 'backend', 'Label / Delete image', 'script', NULL),
(80, 'lblError', 'backend', 'Error', 'script', NULL),
(81, 'lblExport', 'backend', 'Export', 'script', NULL),
(82, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(83, 'lblHotSpotContentLenght', 'backend', 'Label / Post max size error.', 'script', NULL),
(84, 'lblHotSpotEffect', 'backend', 'Label / Effect', 'script', NULL),
(85, 'lblHotSpotInfoDesc', 'backend', 'Hot spot information', 'script', NULL),
(86, 'lblHotSpotInfoTitle', 'backend', 'Hot spot information', 'script', NULL),
(87, 'lblHotSpots', 'backend', 'Label / Hot spots', 'script', NULL),
(88, 'lblHotSpotType', 'backend', 'Label / Hot spot type', 'script', NULL),
(89, 'lblIcon', 'backend', 'Label / Icon', 'script', NULL),
(90, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(91, 'lblInactive', 'backend', 'Label / Inactive', 'script', NULL),
(92, 'lblInstallCode', 'backend', 'Label / Install code', 'script', NULL),
(93, 'lblIp', 'backend', 'IP address', 'script', NULL),
(94, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(95, 'lblLink', 'backend', 'Label / Link', 'script', NULL),
(96, 'lblMultipleImages', 'backend', 'Label / Multiple images', 'script', NULL),
(97, 'lblName', 'backend', 'Name', 'script', NULL),
(98, 'lblNo', 'backend', 'No', 'script', NULL),
(99, 'lblNoImageMessage', 'backend', 'Label / No images found.', 'script', NULL),
(100, 'lblOption', 'backend', 'Option', 'script', NULL),
(101, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(102, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(103, 'lblRole', 'backend', 'Role', 'script', NULL),
(104, 'lblStatus', 'backend', 'Status', 'script', NULL),
(105, 'lblText', 'backend', 'Label / Text', 'script', NULL),
(106, 'lblThumb', 'backend', 'Label / Thumb', 'script', NULL),
(107, 'lblThumbnail', 'backend', 'Label / Thumbnail', 'script', NULL),
(108, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(109, 'lblTooltipContent', 'backend', 'Label / Tooltip content', 'script', NULL),
(110, 'lblType', 'backend', 'Type', 'script', NULL),
(111, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(112, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(113, 'lblUseTooltip', 'backend', 'Label / Use tooltip', 'script', NULL),
(114, 'lblValue', 'backend', 'Value', 'script', NULL),
(115, 'lblVideoURL', 'backend', 'Label / Video URL', 'script', NULL),
(116, 'lblYes', 'backend', 'Yes', 'script', NULL),
(117, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(118, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(119, 'locales', 'backend', 'Languages', 'script', NULL),
(120, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(121, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(122, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(123, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(124, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(125, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(126, 'menuImages', 'backend', 'Menu / Images', 'script', NULL),
(127, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(128, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(129, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(130, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(131, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(132, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(133, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(134, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(135, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(136, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(137, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(138, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(139, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(140, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(141, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(142, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(143, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(144, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(145, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(146, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(147, 'pass', 'backend', 'Password', 'script', NULL),
(148, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(149, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(150, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(151, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(152, 'tabHotSpots', 'backend', 'Tab / Hot spots', 'script', NULL),
(153, 'tabImage', 'backend', 'Tab / Image', 'script', NULL),
(154, 'tabInstall', 'backend', 'Tab / Install', 'script', NULL),
(155, 'tabPreview', 'backend', 'Tab / Preview', 'script', NULL),
(156, 'url', 'backend', 'URL', 'script', NULL),
(157, 'user', 'backend', 'Username', 'script', NULL),
(158, 'front_no_main_image', 'frontend', 'Label / Main image is not found.', 'script', NULL),
(159, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(160, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(161, 'buttons_ARRAY_save', 'arrays', 'buttons_ARRAY_save', 'script', NULL),
(162, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(163, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(164, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(165, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(166, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(167, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(168, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(169, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(170, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(171, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(172, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(173, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(174, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(175, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(176, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(177, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(178, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(179, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(180, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(181, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(182, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(183, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(184, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(185, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(186, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(187, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(188, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(189, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(190, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(191, 'error_bodies_ARRAY_AHS01', 'arrays', 'error_bodies_ARRAY_AHS01', 'script', NULL),
(192, 'error_bodies_ARRAY_AHS06', 'arrays', 'error_bodies_ARRAY_AHS06', 'script', NULL),
(193, 'error_bodies_ARRAY_AHS08', 'arrays', 'error_bodies_ARRAY_AHS08', 'script', NULL),
(194, 'error_bodies_ARRAY_AI01', 'arrays', 'error_bodies_ARRAY_AI01', 'script', NULL),
(195, 'error_bodies_ARRAY_AI03', 'arrays', 'error_bodies_ARRAY_AI03', 'script', NULL),
(196, 'error_bodies_ARRAY_AI04', 'arrays', 'error_bodies_ARRAY_AI04', 'script', NULL),
(197, 'error_bodies_ARRAY_AI08', 'arrays', 'error_bodies_ARRAY_AI08', 'script', NULL),
(198, 'error_bodies_ARRAY_AI09', 'arrays', 'error_bodies_ARRAY_AI09', 'script', NULL),
(199, 'error_bodies_ARRAY_AI10', 'arrays', 'error_bodies_ARRAY_AI10', 'script', NULL),
(200, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(201, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(202, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(203, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(204, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(205, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(206, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(207, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(208, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(209, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(210, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(211, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(212, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(213, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(214, 'error_titles_ARRAY_AHS01', 'arrays', 'error_titles_ARRAY_AHS01', 'script', NULL),
(215, 'error_titles_ARRAY_AHS06', 'arrays', 'error_titles_ARRAY_AHS06', 'script', NULL),
(216, 'error_titles_ARRAY_AHS08', 'arrays', 'error_titles_ARRAY_AHS08', 'script', NULL),
(217, 'error_titles_ARRAY_AI01', 'arrays', 'error_titles_ARRAY_AI01', 'script', NULL),
(218, 'error_titles_ARRAY_AI03', 'arrays', 'error_titles_ARRAY_AI03', 'script', NULL),
(219, 'error_titles_ARRAY_AI04', 'arrays', 'error_titles_ARRAY_AI04', 'script', NULL),
(220, 'error_titles_ARRAY_AI08', 'arrays', 'error_titles_ARRAY_AI08', 'script', NULL),
(221, 'error_titles_ARRAY_AI09', 'arrays', 'error_titles_ARRAY_AI09', 'script', NULL),
(222, 'error_titles_ARRAY_AI10', 'arrays', 'error_titles_ARRAY_AI10', 'script', NULL),
(223, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(224, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(225, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(226, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(227, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(228, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(229, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(230, 'hotspot_effects_ARRAY_1', 'arrays', 'hotspot_effects_ARRAY_1', 'script', NULL),
(231, 'hotspot_effects_ARRAY_2', 'arrays', 'hotspot_effects_ARRAY_2', 'script', NULL),
(232, 'hotspot_effects_ARRAY_3', 'arrays', 'hotspot_effects_ARRAY_3', 'script', NULL),
(233, 'hotspot_errors_ARRAY_1', 'arrays', 'hotspot_errors_ARRAY_1', 'script', NULL),
(234, 'hotspot_errors_ARRAY_2', 'arrays', 'hotspot_errors_ARRAY_2', 'script', NULL),
(235, 'hotspot_errors_ARRAY_3', 'arrays', 'hotspot_errors_ARRAY_3', 'script', NULL),
(236, 'hotspot_errors_ARRAY_4', 'arrays', 'hotspot_errors_ARRAY_4', 'script', NULL),
(237, 'hotspot_errors_ARRAY_5', 'arrays', 'hotspot_errors_ARRAY_5', 'script', NULL),
(238, 'hotspot_errors_ARRAY_6', 'arrays', 'hotspot_errors_ARRAY_6', 'script', NULL),
(239, 'hotspot_types_ARRAY_image', 'arrays', 'hotspot_types_ARRAY_image', 'script', NULL),
(240, 'hotspot_types_ARRAY_link', 'arrays', 'hotspot_types_ARRAY_link', 'script', NULL),
(241, 'hotspot_types_ARRAY_multi', 'arrays', 'hotspot_types_ARRAY_multi', 'script', NULL),
(242, 'hotspot_types_ARRAY_text', 'arrays', 'hotspot_types_ARRAY_text', 'script', NULL),
(243, 'hotspot_types_ARRAY_video', 'arrays', 'hotspot_types_ARRAY_video', 'script', NULL),
(244, 'icon_list_ARRAY_1', 'arrays', 'icon_list_ARRAY_1', 'script', NULL),
(245, 'icon_list_ARRAY_10', 'arrays', 'icon_list_ARRAY_10', 'script', NULL),
(246, 'icon_list_ARRAY_2', 'arrays', 'icon_list_ARRAY_2', 'script', NULL),
(247, 'icon_list_ARRAY_3', 'arrays', 'icon_list_ARRAY_3', 'script', NULL),
(248, 'icon_list_ARRAY_4', 'arrays', 'icon_list_ARRAY_4', 'script', NULL),
(249, 'icon_list_ARRAY_5', 'arrays', 'icon_list_ARRAY_5', 'script', NULL),
(250, 'icon_list_ARRAY_6', 'arrays', 'icon_list_ARRAY_6', 'script', NULL),
(251, 'icon_list_ARRAY_7', 'arrays', 'icon_list_ARRAY_7', 'script', NULL),
(252, 'icon_list_ARRAY_8', 'arrays', 'icon_list_ARRAY_8', 'script', NULL),
(253, 'icon_list_ARRAY_9', 'arrays', 'icon_list_ARRAY_9', 'script', NULL),
(254, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(255, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(256, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(257, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(258, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(259, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(260, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(261, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(262, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(263, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(264, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(265, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(266, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(267, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(268, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(269, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(270, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(271, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(272, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(273, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(274, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(275, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(276, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(277, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(278, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(279, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(280, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(281, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(282, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(283, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(284, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(285, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(286, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(287, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(288, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(289, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(290, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(291, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(292, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(293, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(294, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(295, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(296, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(297, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(298, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(299, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(300, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(301, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(302, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(303, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(304, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(305, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(306, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(307, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(308, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(309, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(310, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(311, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(312, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(313, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(314, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(315, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(316, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(317, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(318, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(319, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(320, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(321, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(322, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(323, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(324, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(325, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(326, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(327, 'types_ARRAY_box', 'arrays', 'types_ARRAY_box', 'script', NULL),
(328, 'types_ARRAY_icon', 'arrays', 'types_ARRAY_icon', 'script', NULL),
(329, 'types_ARRAY_thumb', 'arrays', 'types_ARRAY_thumb', 'script', NULL),
(330, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(331, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(332, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(333, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `igallery_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', '+ Add days off', 'script'),
(NULL, 5, 'pjField', 1, 'title', '+ Add image', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 7, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 42, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Fill in the form below and save to add a new user.', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Configure the general options for your Interactive Image Gallery.', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'General settings', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'This is a list of all hotspots added to the selected image. You can edit each of them, if necessary. ', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Hotspots', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Review all images that have been added into your database. If you want to upload a new image, just click on the "+ Add image" button and choose the file.', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'List of images', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Copy the install code below and paste it on the web page.', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Please select the image that you want to install. Then scroll down and grab the Install code and put it on your web page.', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Preview front end and install on your website', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Make the necessary changes and click "Save" to update this hotspot.', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Update hotspot', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Click on the image to add hotspots. There are three hotspot types – icon, thumb, and box. You can add images, videos, links, and tooltips. Select the icon type and effect you would like to show on the frontend.', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Make your image interactive', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the user information.', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Upload the new image, add a title, and save. Please, note that the system accepts JPG files only. Once you upload an image, you can pin hotspots on it.', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Upload image', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Below is a list of all users. You can add new users, edit user details and change user status. ', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Box height', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Box width', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Choose image', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Data type', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'If you delete this image, all hotspots will be removed too. Are you sure that you want to delete it?', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Post content is too big. Please change again with your images and try to upload image(s) with smaller size.', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Effect', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Fill in the form below to create your hotspot.', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Customize hotspot', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Hotspots', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Hotspot type', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Icon', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Link', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Multiple images', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'No images found. Click {STAG}here{ETAG} to add.', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Text', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Thumb', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Thumbnail', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Tooltip content', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Use tooltip', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Video URL', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Images', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Hotspots', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Main image is not found.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'All changes made on the hot spot have been saved.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Post content is too big. Please check again with your images and try to upload image(s) with smaller size.', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'The hot spot you are looking is not found.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'All changes made to the image have been saved.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'New image has been added into the system.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'The image could not bee uploaded successfully. Please try again.', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'The image you are looking for is missing.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'The image could not be uploaded because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'The image could not be uploaded because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'All changes made to titles have been saved.', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Hot spot updated!', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Hot spot not updated!', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Hot spot not found!', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Image updated!', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Image added!', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Image failed to upload!', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Image not found', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Upload error!', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Effect 1', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Effect 2', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Effect 3', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'The thumbnail is not an image file.', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Some error occurred with the thumbnail image file.', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'The image for the data type is not the actual image.', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Some error occurred with the image for the data type of hot spot.', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'One of the multiple images has error. Please check again.', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'One of the multiple images is not an image file. Please check again.', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Link', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Multiple images', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Text', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Video', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Icon 1', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Icon 10', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Icon 2', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Icon 3', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Icon 4', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Icon 5', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Icon 6', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Icon 7', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Icon 8', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Icon 9', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'No property for the booking found', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'No booking found', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'No permisions to edit the booking', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Box', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Icon', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Thumb', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Yes', 'script');

INSERT INTO `igallery_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `igallery_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');