<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminHotSpots extends pjAdmin
{
	public function pjActionDeleteHotSpot()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$pjHotspotModel = pjHotspotModel::factory();
			$arr = $pjHotspotModel->find($_GET['id'])->getData();
			if ($pjHotspotModel->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				if (file_exists(PJ_INSTALL_PATH . $arr['thumbnail']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['thumbnail']);
				}
				if (file_exists(PJ_INSTALL_PATH . $arr['thumb_path']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['thumb_path']);
				}
				if (file_exists(PJ_INSTALL_PATH . $arr['image_path']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['image_path']);
				}
				pjMultipleImageModel::factory()->deleteImages($_GET['id']);
				pjMultiLangModel::factory()->where('model', 'pjHotSpot')->where('foreign_id', $_GET['id'])->eraseAll();
				
				
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteHotSpotBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjHotspotModel = pjHotspotModel::factory();
				$pjMultipleImageModel = pjMultipleImageModel::factory();
				$arr = $pjHotspotModel->whereIn('id', $_POST['record'])->findAll()->getData();
				foreach($arr as $v)
				{
					if (file_exists(PJ_INSTALL_PATH . $v['thumbnail']))
					{
						@unlink(PJ_INSTALL_PATH . $v['thumbnail']);
					}
					if (file_exists(PJ_INSTALL_PATH . $v['thumb_path'])) {
						@unlink(PJ_INSTALL_PATH . $v['thumb_path']);
					}
					if (file_exists(PJ_INSTALL_PATH . $v['image_path'])) {
						@unlink(PJ_INSTALL_PATH . $v['image_path']);
					}
					$pjMultipleImageModel->deleteImages($v['id']);
				}
				$pjHotspotModel->reset()->whereIn('id', $_POST['record'])->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjHotSpot')->whereIn('foreign_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetHotSpot()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjHotspotModel = pjHotspotModel::factory();
			
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjHotspotModel->where('image_id', (int) $_GET['id']);
			}
			
			$column = 'id';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjHotspotModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$hotspot_types = __('types', true);
			$yesno = __('_yesno', true);
			$data_types = __('hotspot_types', true);
			$data = $pjHotspotModel
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();

			foreach($data as $k => $v)
			{
				$v['type'] = $hotspot_types[$v['type']];
				$v['use_tooltip'] = $yesno[$v['use_tooltip']];
				$v['data_type'] = $data_types[$v['data_type']];
				$data[$k] = $v;
			}
			
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminHotSpots.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminHotSpots&action=pjActionIndex&err=AHS06");
			}
				
			if (isset($_POST['hotspot_update']))
			{
				$pjHotspotModel = pjHotspotModel::factory();
				
				$data = array();
				
				$err = 'AHS01';
				
				$hp = $pjHotspotModel->find($_POST['id'])->getData();
				
				$data['type'] = $_POST['dialog_hotspot_type'];
				$data['effect'] = $_POST['effect'];
				if($_POST['dialog_hotspot_type'] == 'icon')
				{
					$data['icon'] = $_POST['icon'];
					$data['width'] = 36;
					$data['height'] = 36;
					$top = $hp['top'] + (int)($hp['height'] / 2) - 18;
					$left = $hp['left'] + (int)($hp['width'] / 2) - 18;
					$data['top'] = $top;
					$data['left'] = $left;
					$data['box_width'] = ':NULL';
					$data['box_height'] = ':NULL';
					$data['thumbnail'] = ':NULL';
					$pjHotspotModel->deleteThumbnail($_POST['id']);
				}else if($_POST['dialog_hotspot_type'] == 'box'){
					
					$data['box_width'] = $_POST['box_width'];
					$data['box_height'] = $_POST['box_height'];
					$data['width'] = $_POST['box_width'];
					$data['height'] = $_POST['box_height'];
					
					$top = $hp['top'] + (int)($hp['height'] / 2) - (int)($_POST['box_height'] / 2);
					$left = $hp['left'] + (int)($hp['width'] / 2) - (int)($_POST['box_width'] / 2);
					$data['top'] = $top;
					$data['left'] = $left;
					
					$data['icon'] = ':NULL';
					$data['thumbnail'] = ':NULL';
					$pjHotspotModel->deleteThumbnail($_POST['id']);
				}else if($_POST['dialog_hotspot_type'] == 'thumb'){
					if (isset($_FILES['thumbnail']))
					{
						if($_FILES['thumbnail']['error'] == 0)
						{
							if(getimagesize($_FILES['thumbnail']["tmp_name"]) != false)
							{
								$Image = new pjImage();
								if ($Image->getErrorCode() !== 200)
								{
									$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
									if ($Image->load($_FILES['thumbnail']))
									{
										$resp = $Image->isConvertPossible();
										if ($resp['status'] === true)
										{
											$pjHotspotModel->deleteThumbnail($_POST['id']);
											
											$hash = md5(uniqid(rand(), true));
											$thumbnail_path = PJ_UPLOAD_PATH . 'hotspots/thumbs/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
												
											$Image->loadImage($_FILES['thumbnail']["tmp_name"]);
											$Image->resizeSmart(100, 100);
											$Image->saveImage($thumbnail_path);
											
											$top = $hp['top'] + (int)($hp['height'] / 2) - 50;
											$left = $hp['left'] + (int)($hp['width'] / 2) - 50;
											$data['top'] = $top;
											$data['left'] = $left;
											$data['width'] = 100;
											$data['height'] = 100;
											
											$data['thumbnail'] = $thumbnail_path;
											$data['box_width'] = ':NULL';
											$data['box_height'] = ':NULL';
											$data['icon'] = ':NULL';
										}
									}
								}
							}else{
								$err = 1;
							}
						}else if($_FILES['thumbnail']['error'] != 4){
							$err = 2;
						}
					}
				}
				$data['use_tooltip'] = $_POST['use_tooltip'];
				$data['data_type'] = $_POST['data_type'];
				
				$pjMultipleImageModel = pjMultipleImageModel::factory();
				
				if($_POST['data_type'] == 'text')
				{
					$data['link'] = ':NULL';
					$data['video_url'] = ':NULL';
					$data['image_path'] = ':NULL';
					$data['thumb_path'] = ':NULL';
					$pjHotspotModel->deleteImage($_POST['id']);
					$pjMultipleImageModel->deleteImages($_POST['id']);
				}else if($_POST['data_type'] == 'link'){
					$data['link'] = $_POST['link'];
					$data['video_url'] = ':NULL';
					$data['image_path'] = ':NULL';
					$data['thumb_path'] = ':NULL';
					$pjHotspotModel->deleteImage($_POST['id']);
					$pjMultipleImageModel->deleteImages($_POST['id']);
				}else if($_POST['data_type'] == 'video'){
					$data['video_url'] = $_POST['video_url'];
					$data['link'] = ':NULL';
					$data['image_path'] = ':NULL';
					$data['thumb_path'] = ':NULL';
					$pjHotspotModel->deleteImage($_POST['id']);
					$pjMultipleImageModel->deleteImages($_POST['id']);
				}else if($_POST['data_type'] == 'image'){
					if (isset($_FILES['image']))
					{
						if($_FILES['image']['error'] == 0)
						{
							if(getimagesize($_FILES['image']["tmp_name"]) != false)
							{
								$Image = new pjImage();
								if ($Image->getErrorCode() !== 200)
								{
									$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
									if ($Image->load($_FILES['image']))
									{
										$resp = $Image->isConvertPossible();
										if ($resp['status'] === true)
										{
											$pjHotspotModel->deleteImage($_POST['id']);
											
											$hash = md5(uniqid(rand(), true));
											$image_path = PJ_UPLOAD_PATH . 'hotspots/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
											$thumb_path = PJ_UPLOAD_PATH . 'hotspots/thumbs/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
					
											$Image->loadImage($_FILES['image']["tmp_name"]);
											$Image->saveImage($image_path);
											$Image->resizeSmart(100, 100);
											$Image->saveImage($thumb_path);
												
											$data['image_path'] = $image_path;
											$data['thumb_path'] = $thumb_path;
											$data['video_url'] = ':NULL';
											$data['link'] = ':NULL';
											$pjMultipleImageModel->deleteImages($_POST['id']);
										}
									}
								}
							}else{
								$err = 3;
							}
						}else if($_FILES['image']['error'] != 4){
							$err = 4;
						}
					}
				}else if($_POST['data_type'] == 'multi'){
					
					$files = array();
					foreach ($_FILES['images'] as $k => $l) {
						foreach ($l as $i => $v) {
							if (!array_key_exists($i, $files))
							{
								$files[$i] = array();
							}
							$files[$i][$k] = $v;
						}
					}
					$has_error = false;
					foreach ($files as $file)
					{
						if($file['error'] != 4 && $file['error'] != 0)
						{
							$has_error = true;
							$err = 5;
						}
						if(getimagesize($file["tmp_name"]) == false)
						{
							$has_error = true;
							$err = 6;
						}
					}
					
					if($has_error == false)
					{
						$data['video_url'] = ':NULL';
						$data['link'] = ':NULL';
						$data['image_path'] = ':NULL';
						$data['thumb_path'] = ':NULL';
						$pjHotspotModel->deleteImage($_POST['id']);
						foreach ($files as $file)
						{
							$hash = md5(uniqid(rand(), true));
							if(getimagesize($file["tmp_name"]) != false)
							{
								$Image = new pjImage();
								if ($Image->getErrorCode() !== 200)
								{
									if ($Image->load($file))
									{
										$resp = $Image->isConvertPossible();
										if ($resp['status'] === true)
										{
											$image_path = PJ_UPLOAD_PATH . 'images/' . $hash . '.' . $Image->getExtension();
											$thumb_path = PJ_UPLOAD_PATH . 'images/thumbs/' . $hash . '.' . $Image->getExtension();
											if ($Image->save($image_path))
											{
												$Image->loadImage($image_path);
												$Image->resizeSmart(100, 100);
												$Image->saveImage($thumb_path);
											}
								
											$image_data = array();
											$image_data['hotspot_id'] = $_POST['id'];
											$image_data['image_path'] = $image_path;
											$image_data['thumb_path'] = $thumb_path;
												
											$pjMultipleImageModel->reset()->setAttributes($image_data)->insert();
										}
									}
								}
							}
						}
					}
				}
				
				$pjHotspotModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll($data);
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjHotSpot', 'data');
				}
				
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminHotSpots&action=pjActionIndex&id=".$_POST['image_id']."&err=$err");
				
			} else {
				$arr = pjHotspotModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminHotSpots&action=pjActionIndex&err=AHS08");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjHotSpot');
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$image_arr = pjMultipleImageModel::factory()->where('hotspot_id', $arr['id'])->findAll()->getData();
				$this->set('image_arr', $image_arr);
				
				$this->appendJs('jquery.form.js', PJ_THIRD_PARTY_PATH . 'jform/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('pjAdminHotSpots.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>