<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjMultipleImageModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'multiple_images';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'hotspot_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'thumb_path', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'image_path', 'type' => 'varchar', 'default' => ':NULL')
	);
	
	public static function factory($attr=array())
	{
		return new pjMultipleImageModel($attr);
	}
	
	public function deleteImages($hotspot_id)
	{
		$arr = $this->reset()->where('hotspot_id', $hotspot_id)->findAll()->getData();
		foreach($arr as $k => $v)
		{
			$image_path = $v['image_path'];
			$thumb_path = $v['thumb_path'];
			if (file_exists(PJ_INSTALL_PATH . $image_path)) {
				@unlink(PJ_INSTALL_PATH . $image_path);
			}
			if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
				@unlink(PJ_INSTALL_PATH . $thumb_path);
			}
		}
		$this->reset()->where('hotspot_id', $hotspot_id)->eraseAll();
	}
}
?>