(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined),
		routes = [];
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadServices");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function IIGallery(opts) {
		if (!(this instanceof IIGallery)) {
			return new IIGallery(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	IIGallery.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	IIGallery.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	IIGallery.prototype = {
		reset: function () {
			this.$container = null;			
			this.container = null;
			this.opts = {};
			
			return this;
		},
		
		disableButtons: function () {
			this.$container.find(".btn").each(function (i, el) {
				pjQ.$(el).attr("disabled", "disabled");
			});
		},
		enableButtons: function () {
			this.$container.find(".btn").removeAttr("disabled");
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjIIGContainer_" + self.opts.index);
						
			self.$container = pjQ.$(self.container);
			
			/*self.$container.on('click.ig', '.pjIgHotSpot', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
			});*/
			
			if (window.location.hash.length === 0) {
				this.loadGallery.call(this);
			} else {
				onHashChange.call(null);
			}
		},
		loadGallery: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.locale = this.opts.locale;
			params.index = this.opts.index;
			params.id = this.opts.image_id;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionGallery"].join(""), params).done(function (data) {
				self.$container.html(data);
				
				if (pjQ.$('.pjIgPopupTrigger').length) {
					pjQ.$('.pjIgPopupTrigger').colorbox({
						className: 'pjIgCustomColorbox',
						maxWidth: '96%',
						maxHeight: '96%',
						rel: function() {
							return pjQ.$(this).attr('data-popupImageGroup');
						},
						inline: function() {
							if (!pjQ.$(this).hasClass('pjIgPopupInlineTrigger')) {
								return false;
							} else {
								return true;
							};
						}
					});
				};
				
				var $mainImage = pjQ.$('#pjIIgMainImage_' + self.opts.index);
				var main_width = parseInt($mainImage.attr('data-width'), 10);
				var main_height = parseInt($mainImage.attr('data-height'), 10);
				
				pjQ.$('.pjIgHotSpotTooltip').each(function(){
					var $hotspot = pjQ.$(this).parent();
					var hotspot_top = parseInt($hotspot.css("top"), 10);
					var hotspot_left = parseInt($hotspot.css("left"), 10);
					var hotspot_bottom = hotspot_top + parseInt($hotspot.css("height"), 10);
					var hotspot_right = hotspot_left + parseInt($hotspot.css("width"), 10);
					var tooltip_height = pjQ.$(this).height() + 40;
					var tooltip_width = pjQ.$(this).width() + 20;
					
					var tooltip_class = '';
					
					if(hotspot_top >= tooltip_height)
					{
						if(hotspot_left >= tooltip_width && hotspot_right + tooltip_width <= main_width){
							tooltip_class = 'pjIgHotSpotTooltipTop';
						}else{
							if(hotspot_left >= tooltip_width){
								tooltip_class = 'pjIgHotSpotTooltipLeft';
							}else if(hotspot_right + tooltip_width <= main_width){
								tooltip_class = 'pjIgHotSpotTooltipRight';
							}
						}
					}else{
						if(hotspot_left >= tooltip_width && hotspot_right + tooltip_width <= main_width){
							tooltip_class = 'pjIgHotSpotTooltipBottom';
						}else{
							if(hotspot_left >= tooltip_width){
								tooltip_class = 'pjIgHotSpotTooltipLeft';
							}else if(hotspot_right + tooltip_width <= main_width){
								tooltip_class = 'pjIgHotSpotTooltipRight';
							}
						}
					}
					pjQ.$(this).addClass(tooltip_class);
				});
				
			}).fail(function () {
				
			});
		},
	};
	
	window.IIGallery = IIGallery;	
})(window);