DROP TABLE IF EXISTS `memberlogin_fields`;
CREATE TABLE IF NOT EXISTS `memberlogin_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_multi_lang`;
CREATE TABLE IF NOT EXISTS `memberlogin_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(40) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(60) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_options`;
CREATE TABLE IF NOT EXISTS `memberlogin_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_roles`;
CREATE TABLE IF NOT EXISTS `memberlogin_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_users`;
CREATE TABLE IF NOT EXISTS `memberlogin_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_groups`;
CREATE TABLE IF NOT EXISTS `memberlogin_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_title` varchar(255) DEFAULT NULL,
  `home_url` varchar(255) DEFAULT NULL,
  `registration_fee` decimal(15,2) unsigned DEFAULT NULL,
  `subscription_fee` decimal(15,2) unsigned DEFAULT NULL,
  `subscription_period` enum('week','month','year') DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_members`;
CREATE TABLE IF NOT EXISTS `memberlogin_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `phone` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `gender` enum('F','M') DEFAULT NULL,
  `age` int(3) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `country_id` int(10) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,  
  `ip` varchar(255) DEFAULT NULL,
  `membership_expire` date DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_reg_fee_paid` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `country_id` (`country_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_files`;
CREATE TABLE IF NOT EXISTS `memberlogin_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_files_groups`;
CREATE TABLE IF NOT EXISTS `memberlogin_files_groups` (
  `file_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`file_id`, `group_id`),
  UNIQUE KEY `file_id` (`file_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_files_members`;
CREATE TABLE IF NOT EXISTS `memberlogin_files_members` (
  `file_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`file_id`, `member_id`),
  UNIQUE KEY `file_id` (`file_id`,`member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_notes`;
CREATE TABLE IF NOT EXISTS `memberlogin_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_notes_groups`;
CREATE TABLE IF NOT EXISTS `memberlogin_notes_groups` (
  `note_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`note_id`, `group_id`),
  UNIQUE KEY `file_id` (`note_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_notes_members`;
CREATE TABLE IF NOT EXISTS `memberlogin_notes_members` (
  `note_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`note_id`, `member_id`),
  UNIQUE KEY `note_id` (`note_id`,`member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `memberlogin_notifications`;
CREATE TABLE IF NOT EXISTS `memberlogin_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `memberlogin_notifications` (`id`, `key`, `subject`, `message`) VALUES
(1, 'notify', 'Administrator notification', 'Dear ,\r\n\r\nThere is a new member registered. Here is the detail information of the account.\r\n\r\nGroup: {Group}\r\nFirstname: {FirstName}\r\nLast name: {LastName}\r\nEmail: {Email}\r\nPassword: {Password}\r\nPhone: {Phone}\r\nWebsite: {Website}\r\nGender: {Gender}\r\nAge: {Age}\r\nBirthday: {Birthday}\r\nAddress: {Address}\r\nCity: {City}\r\nState: {State}\r\nCountry: {Country}\r\nZip: {Zip}\r\nCompany name: {CompanyName}\r\n{Fee}\r\n\r\nThanks!'),
(2, 'register', 'Registration confirmation', 'Dear {FirstName},\r\n\r\nYou have just registered for new member account. Here is the detail information of your account.\r\n\r\nGroup: {Group}\r\n\r\nFirstname: {FirstName}\r\nLast name: {LastName}\r\nEmail: {Email}\r\nPassword: {Password}\r\nPhone: {Phone}\r\nWebsite: {Website}\r\nGender: {Gender}\r\nAge: {Age}\r\nBirthday: {Birthday}\r\nAddress: {Address}\r\nCity: {City}\r\nState: {State}\r\nCountry: {Country}\r\nZip: {Zip}\r\nCompany name: {CompanyName}\r\n{Fee}\r\n\r\nPlease click on the link below to confirmation your registration and also activate your account.\r\n\r\n{ConfirmURL} \r\n\r\nThanks!'),
(3, 'payment', 'Payment confirmation', 'Dear {FirstName},\r\n\r\nYou have just paid for the member registration. Your account should be active now. \r\n\r\nHere is the detail information.\r\n\r\nGroup: {Group}\r\nFirstname: {FirstName}\r\nLast name: {LastName}\r\nEmail: {Email}\r\nPassword: {Password}\r\nPhone: {Phone}\r\nWebsite: {Website}\r\nGender: {Gender}\r\nAge: {Age}\r\nBirthday: {Birthday}\r\nAddress: {Address}\r\nCity: {City}\r\nState: {State}\r\nCountry: {Country}\r\nZip: {Zip}\r\nCompany name: {CompanyName}\r\n\r\nRegistration and subscription fee:\r\n{Fee} \r\n\r\nThanks!'),
(4, 'created', 'Registration created', 'Dear {FirstName},\r\n\r\nYou have just registered for new member account. Here is the detail information of the account.\r\n\r\nGroup: {Group}\r\nFirstname: {FirstName}\r\nLast name: {LastName}\r\nEmail: {Email}\r\nPassword: {Password}\r\nPhone: {Phone}\r\nWebsite: {Website}\r\nGender: {Gender}\r\nAge: {Age}\r\nBirthday: {Birthday}\r\nAddress: {Address}\r\nCity: {City}\r\nState: {State}\r\nCountry: {Country}\r\nZip: {Zip}\r\nCompany name: {CompanyName}\r\n{Fee}\r\n\r\nThanks!'),
(5, 'forgot', 'Password recovery', 'Dear {FirstName},\r\n\r\nWe have received a password recovery request by this email. Please, find below your password:\r\n\r\nPassword: {Password}\r\n\r\nThanks!');

INSERT INTO `memberlogin_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 1, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 2, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 3, 1, NULL),
(1, 'o_thankyou_page', 1, '', NULL, 'string', 5, 1, NULL),
(1, 'o_protected_page', 1, '', NULL, 'string', 6, 1, NULL),
(1, 'o_login_page', 1, '', NULL, 'string', 7, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_registration_confirmation', 2, 'manual|payment|confirm::confirm', 'Manual|Payment|Email Confirmation', 'enum', 1, 1, NULL),
(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 2, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 3, 1, NULL),
(1, 'o_registration_form', 99, 'first_name,email,password', NULL, 'string', NULL, 0, NULL),
(1, 'o_profile_form', 99, 'first_name,email,password', NULL, 'string', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `memberlogin_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T');


INSERT INTO `memberlogin_fields` VALUES
('1', 'addLocale', 'backend', 'Add language', 'script', NULL),
('2', 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
('3', 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
('4', 'backend', 'backend', 'Backend titles', 'script', NULL),
('5', 'btnAdd', 'backend', 'Button Add', 'script', NULL),
('6', 'btnBack', 'backend', 'Button Back', 'script', NULL),
('7', 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
('8', 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
('9', 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
('10', 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
('11', 'btnLogin', 'backend', 'Login', 'script', NULL),
('12', 'btnReset', 'backend', 'Reset', 'script', NULL),
('13', 'btnSave', 'backend', 'Save', 'script', NULL),
('14', 'btnSearch', 'backend', 'Search', 'script', NULL),
('15', 'btnSend', 'backend', 'Button Send', 'script', NULL),
('16', 'btnUpdate', 'backend', 'Update', 'script', NULL),
('17', 'created', 'backend', 'Created', 'script', NULL),
('18', 'email', 'backend', 'E-Mail', 'script', NULL),
('19', 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
('20', 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
('21', 'frontend', 'backend', 'Front-end titles', 'script', NULL),
('22', 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
('23', 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
('24', 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
('25', 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
('26', 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
('27', 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
('28', 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
('29', 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
('30', 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
('31', 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
('32', 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
('33', 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
('34', 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
('35', 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
('36', 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
('37', 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
('38', 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
('39', 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
('40', 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
('41', 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
('42', 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
('43', 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
('44', 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
('45', 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
('46', 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
('47', 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
('48', 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
('49', 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
('50', 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
('51', 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
('52', 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
('53', 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
('54', 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
('55', 'lblAddUser', 'backend', 'Add user', 'script', NULL),
('56', 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
('57', 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
('58', 'lblChoose', 'backend', 'Choose', 'script', NULL),
('59', 'lblDays', 'backend', 'Days', 'script', NULL),
('60', 'lblDelete', 'backend', 'Delete', 'script', NULL),
('61', 'lblError', 'backend', 'Error', 'script', NULL),
('62', 'lblExport', 'backend', 'Export', 'script', NULL),
('63', 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
('64', 'lblIp', 'backend', 'IP address', 'script', NULL),
('65', 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
('66', 'lblName', 'backend', 'Name', 'script', NULL),
('67', 'lblNo', 'backend', 'No', 'script', NULL),
('68', 'lblOption', 'backend', 'Option', 'script', NULL),
('69', 'lblOptionList', 'backend', 'Option list', 'script', NULL),
('70', 'lblRole', 'backend', 'Role', 'script', NULL),
('71', 'lblStatus', 'backend', 'Status', 'script', NULL),
('72', 'lblType', 'backend', 'Type', 'script', NULL),
('73', 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
('74', 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
('75', 'lblValue', 'backend', 'Value', 'script', NULL),
('76', 'lblYes', 'backend', 'Yes', 'script', NULL),
('77', 'lnkBack', 'backend', 'Link Back', 'script', NULL),
('78', 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
('79', 'locales', 'backend', 'Languages', 'script', NULL),
('80', 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
('81', 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
('82', 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
('83', 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
('84', 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
('85', 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
('86', 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
('87', 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
('88', 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
('89', 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
('90', 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
('91', 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
('92', 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
('93', 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
('94', 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
('95', 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
('96', 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
('97', 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
('98', 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
('99', 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
('100', 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
('101', 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
('102', 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
('103', 'pass', 'backend', 'Password', 'script', NULL),
('125', 'revert_status', 'backend', 'Revert status', 'script', NULL),
('126', 'url', 'backend', 'URL', 'script', NULL),
('127', 'user', 'backend', 'Username', 'script', NULL),
('128', 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
('129', 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
('130', 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
('131', 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
('132', 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
('133', 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
('134', 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
('135', 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
('136', 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
('137', 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
('138', 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
('139', 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
('140', 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
('141', 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
('142', 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
('143', 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
('144', 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
('145', 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
('146', 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
('147', 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
('148', 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
('149', 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
('150', 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
('151', 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
('152', 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
('153', 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
('154', 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
('155', 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
('156', 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
('159', 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
('160', 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
('161', 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
('162', 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
('163', 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
('164', 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
('165', 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
('166', 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
('167', 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
('168', 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
('169', 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
('170', 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
('171', 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
('174', 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
('175', 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
('176', 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
('177', 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
('178', 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
('179', 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
('180', 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
('181', 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
('182', 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
('183', 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
('184', 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
('185', 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
('186', 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
('187', 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
('188', 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
('189', 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
('190', 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
('191', 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
('192', 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
('193', 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
('194', 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
('195', 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
('196', 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
('197', 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
('198', 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
('199', 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
('200', 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
('201', 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
('202', 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
('203', 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
('204', 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
('205', 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
('206', 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
('207', 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
('208', 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
('209', 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
('210', 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
('211', 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
('212', 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
('213', 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
('214', 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
('215', 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
('216', 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
('217', 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
('218', 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
('219', 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
('220', 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
('221', 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
('222', 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
('223', 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
('224', 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
('225', 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
('226', 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
('227', 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
('228', 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
('229', 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
('230', 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
('231', 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
('232', 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
('233', 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
('234', 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
('235', 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
('236', 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
('237', 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
('238', 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
('239', 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
('240', 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
('241', 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
('242', 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
('243', 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
('244', 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
('245', 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
('246', 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
('247', 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
('248', 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
('249', 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
('250', 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
('251', '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
('252', '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
('253', 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
('254', 'pj_delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
('255', 'pj_delete_confirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
('256', 'menuGroups', 'backend', 'Menu / Groups', 'script', NULL),
('257', 'menuMembers', 'backend', 'Menu / Members', 'script', NULL),
('258', 'pj_same_group', 'backend', 'Label / Group in use', 'script', NULL),
('259', 'lblAddGroup', 'backend', 'Label / Add group', 'script', NULL),
('260', 'lblGroup', 'backend', 'Label / Group', 'script', NULL),
('261', 'lblMembers', 'backend', 'Label / Members', 'script', NULL),
('262', 'lblActive', 'backend', 'Label / Active', 'script', NULL),
('263', 'lblInactive', 'backend', 'Label / Inactive', 'script', NULL),
('264', 'error_titles_ARRAY_AG01', 'arrays', 'error_titles_ARRAY_AG01', 'script', NULL),
('265', 'error_bodies_ARRAY_AG01', 'arrays', 'error_bodies_ARRAY_AG01', 'script', NULL),
('266', 'error_titles_ARRAY_AG03', 'arrays', 'error_titles_ARRAY_AG03', 'script', NULL),
('267', 'error_bodies_ARRAY_AG03', 'arrays', 'error_bodies_ARRAY_AG03', 'script', NULL),
('268', 'error_titles_ARRAY_AG04', 'arrays', 'error_titles_ARRAY_AG04', 'script', NULL),
('269', 'error_bodies_ARRAY_AG04', 'arrays', 'error_bodies_ARRAY_AG04', 'script', NULL),
('270', 'error_titles_ARRAY_AG08', 'arrays', 'error_bodies_ARRAY_AG08', 'script', NULL),
('271', 'error_bodies_ARRAY_AG08', 'arrays', 'error_bodies_ARRAY_AG08', 'script', NULL),
('272', 'lblUpdateGroup', 'backend', 'Label / Update group', 'script', NULL),
('273', 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
('274', 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
('275', 'error_titles_ARRAY_AM03', 'arrays', 'error_titles_ARRAY_AM03', 'script', NULL),
('276', 'error_bodies_ARRAY_AM03', 'arrays', 'error_bodies_ARRAY_AM03', 'script', NULL),
('277', 'error_titles_ARRAY_AM04', 'arrays', 'error_titles_ARRAY_AM04', 'script', NULL),
('278', 'error_bodies_ARRAY_AM04', 'arrays', 'error_bodies_ARRAY_AM04', 'script', NULL),
('279', 'error_titles_ARRAY_AM08', 'arrays', 'error_titles_ARRAY_AM08', 'script', NULL),
('280', 'error_bodies_ARRAY_AM08', 'arrays', 'error_bodies_ARRAY_AM08', 'script', NULL),
('281', 'lblAddMember', 'backend', 'Label / Add member', 'script', NULL),
('282', 'lblFirstName', 'backend', 'Label / First name', 'script', NULL),
('283', 'lblLastName', 'backend', 'Label / Last name', 'script', NULL),
('284', 'lblEmail', 'backend', 'Label / Email', 'script', NULL),
('285', 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
('286', 'lblWebsite', 'backend', 'Label / Website', 'script', NULL),
('287', 'lblGender', 'backend', 'Label / Gender', 'script', NULL),
('288', 'lblAge', 'backend', 'Label / Age', 'script', NULL),
('289', 'lblBirthday', 'backend', 'Label / Birthday', 'script', NULL),
('290', 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
('291', 'lblCity', 'backend', 'Label / City', 'script', NULL),
('292', 'lblState', 'backend', 'Label / State', 'script', NULL),
('293', 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
('294', 'lblZip', 'backend', 'Label / Zip', 'script', NULL),
('295', 'lblCompanyName', 'backend', 'Label / Company name', 'script', NULL),
('296', 'lblUpdateMember', 'backend', 'Label / Update member', 'script', NULL),
('297', 'genderarr_ARRAY_F', 'arrays', 'genderarr_ARRAY_F', 'script', NULL),
('298', 'genderarr_ARRAY_M', 'arrays', 'genderarr_ARRAY_M', 'script', NULL),
('324', 'lblCreatedDateTime', 'backend', 'Label / Date time created', 'script', NULL),
('325', 'lblModifiedDateTime', 'backend', 'Label / Date time modified', 'script', NULL),
('326', 'lblNA', 'backend', 'Label / NA', 'script', NULL),
('327', 'lblSubscribed', 'backend', 'Label / Subscribed', 'script', NULL),
('328', 'lblBetween', 'backend', 'Label / between', 'script', NULL),
('329', 'lblAnd', 'backend', 'Label / and', 'script', NULL),
('330', 'lblDateSubscribed', 'backend', 'Label / Date subscribed', 'script', NULL),
('331', 'lblFrom', 'backend', 'Label / from', 'script', NULL),
('332', 'lblTo', 'backend', 'Label / to', 'script', NULL),
('333', 'subscribed_arr_ARRAY_T', 'arrays', 'subscribed_arr_ARRAY_T', 'script', NULL),
('334', 'subscribed_arr_ARRAY_F', 'arrays', 'subscribed_arr_ARRAY_F', 'script', NULL),
('360', 'lblImport', 'backend', 'Label / Import', 'script', NULL),
('361', 'lblCSVFile', 'backend', 'Label / CSV file', 'script', NULL),
('362', 'lblUpdateSubscribers', 'backend', 'Label / Update subscribers', 'script', NULL),
('363', 'infoImportTitle', 'backend', 'Infobox / Import title', 'script', NULL),
('364', 'infoImportBody', 'backend', 'Infobox / Import body', 'script', NULL),
('365', 'btnImport', 'backend', 'Button / Import', 'script', NULL),
('366', 'error_titles_ARRAY_AM09', 'arrays', 'error_titles_ARRAY_AM09', 'script', NULL),
('367', 'error_bodies_ARRAY_AM09', 'arrays', 'error_bodies_ARRAY_AM09', 'script', NULL),
('368', 'error_titles_ARRAY_AM13', 'arrays', 'error_titles_ARRAY_AM13', 'script', NULL),
('369', 'error_bodies_ARRAY_AM13', 'arrays', 'error_bodies_ARRAY_AM13', 'script', NULL),
('370', 'error_titles_ARRAY_AM12', 'arrays', 'error_titles_ARRAY_AM12', 'script', NULL),
('371', 'error_bodies_ARRAY_AM12', 'arrays', 'error_bodies_ARRAY_AM12', 'script', NULL),
('372', 'error_titles_ARRAY_AM10', 'arrays', 'error_titles_ARRAY_AM10', 'script', NULL),
('373', 'error_bodies_ARRAY_AM10', 'arrays', 'error_bodies_ARRAY_AM10', 'script', NULL),
('374', 'error_titles_ARRAY_AM11', 'arrays', 'error_titles_ARRAY_AM11', 'script', NULL),
('375', 'error_bodies_ARRAY_AM11', 'arrays', 'error_bodies_ARRAY_AS11', 'script', NULL),
('376', 'menuFiles', 'backend', 'Menu / Files', 'script', NULL),
('377', 'pj_same_title', 'backend', 'Label / same file title', 'script', NULL),
('378', 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
('379', 'lblFileName', 'backend', 'Label / File name', 'script', NULL),
('380', 'lblUploadedDateTime', 'backend', 'Label / Uploaded date time', 'script', NULL),
('381', 'lblUploadedFiles', 'backend', 'Label / Uploaded files', 'script', NULL),
('382', 'lblUpload', 'backend', 'Label / Upload', 'script', NULL),
('383', 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
('384', 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
('385', 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
('386', 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
('387', 'error_titles_ARRAY_AF04', 'arrays', 'error_titles_ARRAY_AF04', 'script', NULL),
('388', 'error_bodies_ARRAY_AF04', 'arrays', 'error_bodies_ARRAY_AF04', 'script', NULL),
('389', 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
('390', 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
('391', 'lblFile', 'backend', 'Label / File', 'script', NULL),
('392', 'lblGroupAccess', 'backend', 'Label / Group(s) access', 'script', NULL),
('393', 'lblMemberAccess', 'backend', 'Label / Individual members access', 'script', NULL),
('394', 'btnUpload', 'backend', 'Button / Upload', 'script', NULL),
('395', 'infoGroupTitle', 'backend', 'Infobox / Group title', 'script', NULL),
('396', 'infoGroupBody', 'backend', 'Infobox / Group body', 'script', NULL),
('397', 'lblHomePageUrl', 'backend', 'Label / Home page URL', 'script', NULL),
('398', 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
('399', 'lblAccount', 'backend', 'Label / Account', 'script', NULL),
('400', 'lblRegistrationForm', 'backend', 'Label / Registration form', 'script', NULL),
('401', 'lblInstallRegister', 'backend', 'Install / Register text', 'script', NULL),
('402', 'lblMemberSelectGroup', 'backend', 'Label / Member selects group', 'script', NULL),
('403', 'lblLoginForm', 'backend', 'Label / Login Form', 'script', NULL),
('404', 'lblInstallLogin', 'backend', 'Label / Install login text', 'script', NULL),
('405', 'lblProfileForm', 'backend', 'Label / Profile form', 'script', NULL),
('406', 'lblInstallProfile', 'backend', 'Label / Install profile text', 'script', NULL),
('407', 'lblLogoutLink', 'backend', 'Label / Logout link', 'script', NULL),
('408', 'lblInstallLogout', 'backend', 'Label / Install logout text', 'script', NULL),
('409', 'lblProtectedPages', 'backend', 'Label / Protected pages', 'script', NULL),
('410', 'lblInstallProtectedPages', 'backend', 'Label / Protected pages text', 'script', NULL),
('411', 'lblProtectedFiles', 'backend', 'Label / Protect files', 'script', NULL),
('412', 'lblInstallProtectedFiles', 'backend', 'Label / Protected file text', 'script', NULL),
('413', 'front_label_register', 'frontend', 'Label / Registration form', 'script', NULL),
('414', 'front_label_first_name', 'frontend', 'Label / First name', 'script', NULL),
('415', 'front_label_last_name', 'frontend', 'Label / Last name', 'script', NULL),
('416', 'front_label_email', 'frontend', 'Label / Email', 'script', NULL),
('417', 'front_label_password', 'frontend', 'Label / Password', 'script', NULL),
('418', 'front_required_ARRAY_first_name', 'arrays', 'front_required_ARRAY_first_name', 'script', NULL),
('419', 'front_required_ARRAY_email', 'arrays', 'front_required_ARRAY_email', 'script', NULL),
('420', 'front_required_ARRAY_password', 'arrays', 'front_required_ARRAY_password', 'script', NULL),
('421', 'front_required_ARRAY_captcha', 'arrays', 'front_required_ARRAY_captcha', 'script', NULL),
('422', 'front_label_group', 'frontend', 'Label / Group', 'script', NULL),
('423', 'front_label_phone', 'frontend', 'Label / Phone', 'script', NULL),
('424', 'front_label_website', 'frontend', 'Label / Website', 'script', NULL),
('425', 'front_label_gender', 'frontend', 'Label / Gender', 'script', NULL),
('426', 'front_label_age', 'frontend', 'Label / Age', 'script', NULL),
('427', 'front_label_birthday', 'frontend', 'Label / Birthday', 'script', NULL),
('428', 'front_label_address', 'frontend', 'Label / Address', 'script', NULL),
('429', 'front_label_city', 'frontend', 'Label / City', 'script', NULL),
('430', 'front_label_state', 'frontend', 'Label / State', 'script', NULL),
('431', 'front_label_country', 'frontend', 'Label / Country', 'script', NULL),
('432', 'front_label_zip', 'frontend', 'Label / Zip', 'script', NULL),
('433', 'front_label_company_name', 'frontend', 'Label / Company name', 'script', NULL),
('434', 'front_label_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
('435', 'front_label_choose', 'frontend', 'Label / Choose', 'script', NULL),
('436', 'front_button_register', 'frontend', 'Button / Register', 'script', NULL),
('437', 'front_validation_ARRAY_email_invalid', 'arrays', 'front_validation_ARRAY_email_invalid', 'script', NULL),
('438', 'front_validation_ARRAY_email_used', 'arrays', 'front_validation_ARRAY_email_used', 'script', NULL),
('439', 'front_validation_ARRAY_captcha_incorrect', 'arrays', 'front_validation_ARRAY_captcha_incorrect', 'script', NULL),
('440', 'front_validation_ARRAY_birthday_invalid', 'arrays', 'front_required_ARRAY_birthday_invalid', 'script', NULL),
('441', 'front_label_register_info', 'frontend', 'Label / Registration processing', 'script', NULL),
('442', 'front_label_register_success', 'frontend', 'Label / Registration success', 'script', NULL),
('443', 'front_label_register_error', 'frontend', 'Label / Registration error', 'script', NULL),
('444', 'front_required_ARRAY_group', 'arrays', 'front_required_ARRAY_group', 'script', NULL),
('445', 'lblThankYouPageTip', 'backend', 'Tips / Thank you page', 'script', NULL),
('446', 'lblProtectedPageTip', 'backend', 'Tips / Protected page', 'script', NULL),
('447', 'lblLegendRegister', 'backend', 'Label / registration confirmation', 'script', NULL),
('448', 'lblLegendForgot', 'backend', 'Label / Password recovery', 'script', NULL),
('449', 'tokens_ARRAY_register', 'arrays', 'tokens_ARRAY_register', 'script', NULL),
('450', 'tokens_ARRAY_forgot', 'arrays', 'tokens_ARRAY_forgot', 'script', NULL),
('476', 'opt_o_thankyou_page', 'backend', 'Options / Thank you page', 'script', NULL),
('477', 'opt_o_protected_page', 'backend', 'Options / Protected page', 'script', NULL),
('478', 'menuEmails', 'backend', 'Menu / Emails', 'script', NULL),
('479', 'lblEmailTipRegister', 'backend', 'Label / Registration email tip', 'script', NULL),
('480', 'lblEmailTipForgot', 'backend', 'Label / Password recovery tip', 'script', NULL),
('481', 'lblEmailSubject', 'backend', 'Label / Subject', 'script', NULL),
('482', 'lblEmailMessage', 'backend', 'Label / Email message', 'script', NULL),
('483', 'infoEmailTitle', 'backend', 'Infobox / Email title', 'script', NULL),
('484', 'infoEmailBody', 'backend', 'Infobox / Email body', 'script', NULL),
('485', 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
('486', 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
('487', 'front_activation_ARRAY_FA01', 'arrays', 'front_activation_ARRAY_FA01', 'script', NULL),
('488', 'front_activation_ARRAY_FA02', 'arrays', 'front_activation_ARRAY_FA02', 'script', NULL),
('489', 'front_activation_ARRAY_FA03', 'arrays', 'front_activation_ARRAY_FA03', 'script', NULL),
('490', 'front_label_login', 'frontend', 'Label / Login', 'script', NULL),
('491', 'front_button_login', 'frontend', 'Button / Login', 'script', NULL),
('492', 'front_label_login_success', 'frontend', 'Label / Login success', 'script', NULL),
('493', 'front_label_login_error_1', 'frontend', 'Label / Login error 1', 'script', NULL),
('494', 'front_label_login_error_2', 'frontend', 'Label / Login error 2', 'script', NULL),
('495', 'front_label_profile', 'frontend', 'Label / Member profile', 'script', NULL),
('496', 'profile_statuses_ARRAY_2', 'arrays', 'profile_statuses_ARRAY_2', 'script', NULL),
('497', 'profile_statuses_ARRAY_3', 'arrays', 'profile_statuses_ARRAY_3', 'script', NULL),
('498', 'front_button_save', 'frontend', 'Button / Save', 'script', NULL),
('499', 'front_required_ARRAY_retype_password', 'arrays', 'front_required_ARRAY_retype_password', 'script', NULL),
('500', 'front_validation_ARRAY_retype_password', 'arrays', 'front_validation_ARRAY_retype_password', 'script', NULL),
('501', 'front_label_retype_password', 'frontend', 'Label / Retype password', 'script', NULL),
('502', 'front_label_new_password', 'frontend', 'Label / New password', 'script', NULL),
('503', 'front_label_profile_info', 'frontend', 'Label / Profile is saving', 'script', NULL),
('504', 'front_label_profile_success', 'frontend', 'Label / Profile saved', 'script', NULL),
('505', 'front_label_profile_error', 'frontend', 'Label / Profile error', 'script', NULL),
('506', 'opt_o_login_page', 'backend', 'Options / Login page', 'script', NULL),
('507', 'lblLoginPageTip', 'backend', 'Tips / Login page', 'script', NULL),
('508', 'front_label_logout', 'frontend', 'Label / Logout', 'script', NULL),
('534', 'front_label_files', 'frontend', 'Label / Files', 'script', NULL),
('535', 'front_label_no_files', 'frontend', 'Label / No files found', 'script', NULL),
('561', 'lblUpdateFile', 'backend', 'Label / Update file', 'script', NULL),
('564', 'menuForms', 'backend', 'Menu / Forms', 'script', NULL),
('565', 'infoFormTitle', 'backend', 'Infobox / Form info title', 'script', NULL),
('566', 'infoFormBody', 'backend', 'Infobox / Form info body', 'script', NULL),
('567', 'lblPassword', 'backend', 'Label / Password', 'script', NULL),
('568', 'pj_valid_url', 'backend', 'Label / valid url', 'script', NULL),
('569', 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
('570', 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
('573', 'front_label_login_error_3', 'frontend', 'Label / Login error 3', 'script', NULL),
('574', 'opt_o_registration_confirmation', 'backend', 'Options / Registration confirmation', 'script', NULL),
('576', 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
('577', 'menuRegistrations', 'backend', 'Menu / Registrations', 'script', NULL),
('578', 'infoRegistrationTitle', 'backend', 'Infobox / Registration settings title', 'script', NULL),
('579', 'infoRegistrationBody', 'backend', 'Infobox / Registration settings body', 'script', NULL),
('580', 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
('581', 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
('582', 'subscription_period_ARRAY_week', 'arrays', 'subscription_period_ARRAY_week', 'script', NULL),
('583', 'subscription_period_ARRAY_month', 'arrays', 'subscription_period_ARRAY_month', 'script', NULL),
('584', 'subscription_period_ARRAY_year', 'arrays', 'subscription_period_ARRAY_year', 'script', NULL),
('585', 'lblRegistrationFee', 'backend', 'Label / Registration fee', 'script', NULL),
('586', 'lblSubscriptionFee', 'backend', 'Label / Subscription fee', 'script', NULL),
('587', 'lblPer', 'backend', 'Label / per', 'script', NULL),
('588', 'tokens_ARRAY_notify', 'arrays', 'tokens_ARRAY_notify', 'script', NULL),
('589', 'tokens_ARRAY_payment', 'arrays', 'tokens_ARRAY_payment', 'script', NULL),
('590', 'tokens_ARRAY_created', 'arrays', 'tokens_ARRAY_created', 'script', NULL),
('591', 'lblLegendNotify', 'backend', 'Label / Administrator notification', 'script', NULL),
('592', 'lblLegendPayment', 'backend', 'Label / Payment confirmation', 'script', NULL),
('593', 'lblLegendCreated', 'backend', 'Label / Registration created', 'script', NULL),
('594', 'lblEmailTipNotify', 'backend', 'Label / Notification email tip', 'script', NULL),
('595', 'lblEmailTipPayment', 'backend', 'Label / Payment confirmation email tip', 'script', NULL),
('596', 'lblEmailTipCreated', 'backend', 'Label / Registration created email tip', 'script', NULL),
('597', 'front_required_ARRAY_last_name', 'arrays', 'front_required_ARRAY_last_name', 'script', NULL),
('598', 'front_required_ARRAY_phone', 'arrays', 'front_required_ARRAY_phone', 'script', NULL),
('599', 'front_required_ARRAY_website', 'arrays', 'front_required_ARRAY_website', 'script', NULL),
('600', 'front_required_ARRAY_gender', 'arrays', 'front_required_ARRAY_gender', 'script', NULL),
('601', 'front_required_ARRAY_age', 'arrays', 'front_required_ARRAY_age', 'script', NULL),
('602', 'front_required_ARRAY_birthday', 'arrays', 'front_required_ARRAY_birthday', 'script', NULL),
('603', 'front_required_ARRAY_address', 'arrays', 'front_required_ARRAY_address', 'script', NULL),
('604', 'front_required_ARRAY_city', 'arrays', 'front_required_ARRAY_city', 'script', NULL),
('605', 'front_required_ARRAY_state', 'arrays', 'front_required_ARRAY_state', 'script', NULL),
('606', 'front_required_ARRAY_country', 'arrays', 'front_required_ARRAY_country', 'script', NULL),
('607', 'front_required_ARRAY_zip', 'arrays', 'front_required_ARRAY_zip', 'script', NULL),
('608', 'front_required_ARRAY_company_name', 'arrays', 'front_required_ARRAY_company_name', 'script', NULL),
('609', 'front_label_per', 'frontend', 'Label / per', 'script', NULL),
('610', 'front_label_registration_fee', 'frontend', 'Label / Registration fee', 'script', NULL),
('611', 'front_label_subscription_fee', 'frontend', 'Label / Subscription fee', 'script', NULL),
('637', 'lblPeriodRequired', 'backend', 'Label / Period required', 'script', NULL),
('638', 'lblCSVAllowed', 'backend', 'Label / CSV fiels allowed', 'script', NULL),
('639', 'front_label_register_load_payment', 'frontend', 'Label / Loading payment form', 'script', NULL),
('640', 'front_label_forgot_password', 'frontend', 'Label / Forgot password', 'script', NULL),
('641', 'front_button_send', 'frontend', 'Button / Send', 'script', NULL),
('642', 'front_label_back', 'frontend', 'label / Back', 'script', NULL),
('643', 'front_label_forgot_success', 'frontend', 'Label / Forgot success', 'script', NULL),
('644', 'front_label_forgot_error_1', 'frontend', 'Label / Forgot error 1', 'script', NULL),
('670', 'lblLastLogin', 'backend', 'Label / Date/time last login', 'script', NULL),
('671', 'infoGroupListTitle', 'backend', 'Infobox / Gropu list title', 'script', NULL),
('672', 'infoGroupListBody', 'backend', 'Infobox / Gropu list body', 'script', NULL),
('673', 'infoAddMemberTitle', 'backend', 'Infobox / Add member title', 'script', NULL),
('674', 'infoAddMemberBody', 'backend', 'Infobox / Add member body', 'script', NULL),
('675', 'infoFileListTitle', 'backend', 'Infobox/ Uploaded files title', 'script', NULL),
('676', 'infoFileListBody', 'backend', 'Infobox/ Uploaded files body', 'script', NULL),
('677', 'infoUploadFilesTitle', 'backend', 'Infobox / Upload title', 'script', NULL),
('678', 'infoUploadFilesBody', 'backend', 'Infobox / Upload body', 'script', NULL),
('679', 'infoUserListTitle', 'backend', 'Infobox / User list title', 'script', NULL),
('680', 'infoUserListBody', 'backend', 'Infobox / User list body', 'script', NULL),
('706', 'infoUpdateGroupTitle', 'backend', 'Infobox / Update group title', 'script', NULL),
('707', 'infoUpdateGroupBody', 'backend', 'Infobox / Update group body', 'script', NULL),
('708', 'last_login_ARRAY_today', 'arrays', 'last_login_ARRAY_today', 'script', NULL),
('709', 'last_login_ARRAY_7_days', 'arrays', 'last_login_ARRAY_7_days', 'script', NULL),
('710', 'last_login_ARRAY_30_days', 'arrays', 'last_login_ARRAY_30_days', 'script', NULL),
('711', 'last_login_ARRAY_3_months', 'arrays', 'last_login_ARRAY_3_months', 'script', NULL),
('712', 'lblFilterLastLogin', 'backend', 'Label / Last login', 'script', NULL),
('738', 'infoUpdateFilesTitle', 'backend', 'Infobox / Update protected files', 'script', NULL),
('739', 'infoUpdateFilesBody', 'backend', 'Infobox / Update filed body', 'script', NULL),
('741', 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
('742', 'lbllMembers', 'backend', 'Label / Members', 'script', NULL),
('743', 'lblMember', 'backend', 'Label / Member', 'script', NULL),
('744', 'lblActiveMembers', 'backend', 'Label / Active members', 'script', NULL),
('745', 'lblActiveMember', 'backend', 'Label / Active member', 'script', NULL),
('746', 'lblGroups', 'backend', 'Label / Groups', 'script', NULL),
('747', 'lblLastRegistered', 'backend', 'Label / Last registered', 'script', NULL),
('748', 'lblMostPopularGroups', 'backend', 'Label / Most popular groups', 'script', NULL),
('749', 'lblMemberNotFound', 'backend', 'Label / There is no member found', 'script', NULL),
('750', 'lblGroupNotFound', 'backend', 'Label / There is no group found', 'script', NULL),
('776', 'menuNotes', 'backend', 'Menu / Notes', 'script', NULL),
('777', 'lblAll', 'backend', 'Label / All', 'script', NULL),
('778', 'lblNote', 'backend', 'Label / Note', 'script', NULL),
('779', 'lblCreated', 'backend', 'Label / Created', 'script', NULL),
('780', 'infoNoteListTitle', 'backend', 'Infobox / Notes title', 'script', NULL),
('781', 'infoNoteListBody', 'backend', 'Infobox / Notes body', 'script', '2014-01-05 12:55:09'),
('782', 'error_titles_ARRAY_AN01', 'arrays', 'error_titles_ARRAY_AN01', 'script', NULL),
('783', 'error_bodies_ARRAY_AN01', 'arrays', 'error_bodies_ARRAY_AN01', 'script', NULL),
('784', 'error_titles_ARRAY_AN03', 'arrays', 'error_titles_ARRAY_AN03', 'script', NULL),
('785', 'error_bodies_ARRAY_AN03', 'arrays', 'error_bodies_ARRAY_AN03', 'script', NULL),
('786', 'error_titles_ARRAY_AN04', 'arrays', 'error_titles_ARRAY_AN04', 'script', NULL),
('787', 'error_bodies_ARRAY_AN04', 'arrays', 'error_bodies_ARRAY_AN04', 'script', NULL),
('788', 'error_titles_ARRAY_AN08', 'arrays', 'error_titles_ARRAY_AN08', 'script', NULL),
('789', 'error_bodies_ARRAY_AN08', 'arrays', 'error_bodies_ARRAY_AN08', 'script', NULL),
('790', 'lblAddNote', 'backend', 'Label / Add note', 'script', NULL),
('791', 'infoAddNoteTitle', 'backend', 'Infobox / Add note title', 'script', NULL),
('792', 'infoAddNoteBody', 'backend', 'Infobox / Add note body', 'script', NULL),
('793', 'lblUpdateNote', 'backend', 'Label / Update note', 'script', NULL),
('794', 'infoUpdateNoteTitle', 'backend', 'Infobox / Update note title', 'script', NULL),
('795', 'infoUpdateNoteBody', 'backend', 'Infobox / Update note body', 'script', NULL),
('796', 'lblProtectedNotes', 'backend', 'Label / Protected notes', 'script', NULL),
('797', 'lblInstallProtectedNotes', 'backend', 'Label / Install protected notes', 'script', NULL),
('798', 'front_label_notes', 'frontend', 'Label / Notes', 'script', NULL),
('799', 'front_label_no_notes', 'frontend', 'Label / No note', 'script', NULL),
('800', 'error_titles_ARRAY_AM14', 'arrays', 'error_titles_ARRAY_AM14', 'script', NULL),
('801', 'error_bodies_ARRAY_AM14', 'arrays', 'error_bodies_ARRAY_AM14', 'script', NULL),
('802', 'lblExpiration', 'backend', 'Expiration', 'script', NULL),
('803', 'front_label_login_error_4', 'frontend', 'Label / Login error 4', 'script', NULL);

INSERT INTO `memberlogin_multi_lang` VALUES
('1', '1', 'pjField', '1', 'title', 'Add language', 'script'),
('2', '2', 'pjField', '1', 'title', 'Password reminder', 'script'),
('3', '3', 'pjField', '1', 'title', 'Admin Login', 'script'),
('4', '4', 'pjField', '1', 'title', 'Back-end titles', 'script'),
('5', '5', 'pjField', '1', 'title', 'Add +', 'script'),
('6', '6', 'pjField', '1', 'title', '« Back', 'script'),
('7', '7', 'pjField', '1', 'title', 'Backup', 'script'),
('8', '8', 'pjField', '1', 'title', 'Cancel', 'script'),
('9', '9', 'pjField', '1', 'title', 'Continue', 'script'),
('10', '10', 'pjField', '1', 'title', 'Delete', 'script'),
('11', '11', 'pjField', '1', 'title', 'Login', 'script'),
('12', '12', 'pjField', '1', 'title', 'Reset', 'script'),
('13', '13', 'pjField', '1', 'title', 'Save', 'script'),
('14', '14', 'pjField', '1', 'title', 'Search', 'script'),
('15', '15', 'pjField', '1', 'title', 'Send', 'script'),
('16', '16', 'pjField', '1', 'title', 'Update', 'script'),
('17', '17', 'pjField', '1', 'title', 'DateTime', 'script'),
('18', '18', 'pjField', '1', 'title', 'Email', 'script'),
('19', '19', 'pjField', '1', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('20', '20', 'pjField', '1', 'title', 'Password reminder', 'script'),
('21', '21', 'pjField', '1', 'title', 'Front-end titles', 'script'),
('22', '22', 'pjField', '1', 'title', 'Action confirmation', 'script'),
('23', '23', 'pjField', '1', 'title', 'Cancel', 'script'),
('24', '24', 'pjField', '1', 'title', 'Delete', 'script'),
('25', '25', 'pjField', '1', 'title', 'OK', 'script'),
('26', '26', 'pjField', '1', 'title', 'Choose Action', 'script'),
('27', '27', 'pjField', '1', 'title', 'Are you sure you want to delete selected record?', 'script'),
('28', '28', 'pjField', '1', 'title', 'Delete confirmation', 'script'),
('29', '29', 'pjField', '1', 'title', 'No records found', 'script'),
('30', '30', 'pjField', '1', 'title', 'Go to page:', 'script'),
('31', '31', 'pjField', '1', 'title', 'Items per page', 'script'),
('32', '32', 'pjField', '1', 'title', 'Next »', 'script'),
('33', '33', 'pjField', '1', 'title', 'Next page', 'script'),
('34', '34', 'pjField', '1', 'title', '« Prev', 'script'),
('35', '35', 'pjField', '1', 'title', 'Prev page', 'script'),
('36', '36', 'pjField', '1', 'title', 'Total items:', 'script'),
('37', '37', 'pjField', '1', 'title', 'Listing Address Body', 'script'),
('38', '38', 'pjField', '1', 'title', 'Listing Address Title', 'script'),
('39', '39', 'pjField', '1', 'title', 'Listing Bookings Body', 'script'),
('40', '40', 'pjField', '1', 'title', 'Listing Bookings Title', 'script'),
('41', '41', 'pjField', '1', 'title', 'Listing Contact Body', 'script'),
('42', '42', 'pjField', '1', 'title', 'Listing Contact Title', 'script'),
('43', '43', 'pjField', '1', 'title', 'Extend exp.date Body', 'script'),
('44', '44', 'pjField', '1', 'title', 'Extend exp.date Title', 'script'),
('45', '45', 'pjField', '1', 'title', 'Listing Prices Body', 'script'),
('46', '46', 'pjField', '1', 'title', 'Listing Prices Title', 'script'),
('47', '47', 'pjField', '1', 'title', 'Languages Array Body', 'script'),
('48', '48', 'pjField', '1', 'title', 'Languages Arrays Title', 'script'),
('49', '49', 'pjField', '1', 'title', 'Languages Backend Body', 'script'),
('50', '50', 'pjField', '1', 'title', 'Languages Backend Title', 'script'),
('51', '51', 'pjField', '1', 'title', 'Languages Body', 'script'),
('52', '52', 'pjField', '1', 'title', 'Languages Frontend Body', 'script'),
('53', '53', 'pjField', '1', 'title', 'Languages Frontend Title', 'script'),
('54', '54', 'pjField', '1', 'title', 'Languages Title', 'script'),
('55', '55', 'pjField', '1', 'title', 'Add user', 'script'),
('56', '56', 'pjField', '1', 'title', 'Backup database', 'script'),
('57', '57', 'pjField', '1', 'title', 'Backup files', 'script'),
('58', '58', 'pjField', '1', 'title', 'Choose', 'script'),
('59', '59', 'pjField', '1', 'title', 'days', 'script'),
('60', '60', 'pjField', '1', 'title', 'Delete', 'script'),
('61', '61', 'pjField', '1', 'title', 'Error', 'script'),
('62', '62', 'pjField', '1', 'title', 'Export', 'script'),
('63', '63', 'pjField', '1', 'title', 'Forgot password', 'script'),
('64', '64', 'pjField', '1', 'title', 'IP address', 'script'),
('65', '65', 'pjField', '1', 'title', 'Is confirmed', 'script'),
('66', '66', 'pjField', '1', 'title', 'Name', 'script'),
('67', '67', 'pjField', '1', 'title', 'No', 'script'),
('68', '68', 'pjField', '1', 'title', 'Option', 'script'),
('69', '69', 'pjField', '1', 'title', 'Option list', 'script'),
('70', '70', 'pjField', '1', 'title', 'Role', 'script'),
('71', '71', 'pjField', '1', 'title', 'Status', 'script'),
('72', '72', 'pjField', '1', 'title', 'Type', 'script'),
('73', '73', 'pjField', '1', 'title', 'Update user', 'script'),
('74', '74', 'pjField', '1', 'title', 'Registration date/time', 'script'),
('75', '75', 'pjField', '1', 'title', 'Value', 'script'),
('76', '76', 'pjField', '1', 'title', 'Yes', 'script'),
('77', '77', 'pjField', '1', 'title', 'Back', 'script'),
('78', '78', 'pjField', '1', 'title', 'Arrays titles', 'script'),
('79', '79', 'pjField', '1', 'title', 'Languages', 'script'),
('80', '80', 'pjField', '1', 'title', 'Flag', 'script'),
('81', '81', 'pjField', '1', 'title', 'Is default', 'script'),
('82', '82', 'pjField', '1', 'title', 'Order', 'script'),
('83', '83', 'pjField', '1', 'title', 'Title', 'script'),
('84', '84', 'pjField', '1', 'title', 'Backup', 'script'),
('85', '85', 'pjField', '1', 'title', 'Dashboard', 'script'),
('86', '86', 'pjField', '1', 'title', 'Multi Lang', 'script'),
('87', '87', 'pjField', '1', 'title', 'Languages', 'script'),
('88', '88', 'pjField', '1', 'title', 'Logout', 'script'),
('89', '89', 'pjField', '1', 'title', 'Options', 'script'),
('90', '90', 'pjField', '1', 'title', 'Plugins', 'script'),
('91', '91', 'pjField', '1', 'title', 'Profile', 'script'),
('92', '92', 'pjField', '1', 'title', 'Users', 'script'),
('93', '93', 'pjField', '1', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
('94', '94', 'pjField', '1', 'title', 'Currency', 'script'),
('95', '95', 'pjField', '1', 'title', 'Date format', 'script'),
('96', '96', 'pjField', '1', 'title', 'Send email', 'script'),
('97', '97', 'pjField', '1', 'title', 'SMTP Host', 'script'),
('98', '98', 'pjField', '1', 'title', 'SMTP Password', 'script'),
('99', '99', 'pjField', '1', 'title', 'SMTP Port', 'script'),
('100', '100', 'pjField', '1', 'title', 'SMTP Username', 'script'),
('101', '101', 'pjField', '1', 'title', 'Timezone', 'script'),
('102', '102', 'pjField', '1', 'title', 'First day of the week', 'script'),
('103', '103', 'pjField', '1', 'title', 'Password', 'script'),
('104', '125', 'pjField', '1', 'title', 'Revert status', 'script'),
('105', '126', 'pjField', '1', 'title', 'URL', 'script'),
('106', '127', 'pjField', '1', 'title', 'Username', 'script'),
('107', '128', 'pjField', '1', 'title', 'Email address was already in use', 'script'),
('108', '129', 'pjField', '1', 'title', 'Sunday', 'script'),
('109', '130', 'pjField', '1', 'title', 'Monday', 'script'),
('110', '131', 'pjField', '1', 'title', 'Tuesday', 'script'),
('111', '132', 'pjField', '1', 'title', 'Wednesday', 'script'),
('112', '133', 'pjField', '1', 'title', 'Thursday', 'script'),
('113', '134', 'pjField', '1', 'title', 'Friday', 'script'),
('114', '135', 'pjField', '1', 'title', 'Saturday', 'script'),
('115', '136', 'pjField', '1', 'title', 'S', 'script'),
('116', '137', 'pjField', '1', 'title', 'M', 'script'),
('117', '138', 'pjField', '1', 'title', 'T', 'script'),
('118', '139', 'pjField', '1', 'title', 'W', 'script'),
('119', '140', 'pjField', '1', 'title', 'T', 'script'),
('120', '141', 'pjField', '1', 'title', 'F', 'script'),
('121', '142', 'pjField', '1', 'title', 'S', 'script'),
('122', '143', 'pjField', '1', 'title', 'Given email address is not associated with any account.', 'script'),
('123', '144', 'pjField', '1', 'title', 'For further instructions please check your mailbox.', 'script'),
('124', '145', 'pjField', '1', 'title', 'We are sorry, please try again later.', 'script'),
('125', '146', 'pjField', '1', 'title', 'All the changes made to your profile have been saved.', 'script'),
('126', '147', 'pjField', '1', 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
('127', '148', 'pjField', '1', 'title', 'All backup files have been saved.', 'script'),
('128', '149', 'pjField', '1', 'title', 'No option was selected.', 'script'),
('129', '150', 'pjField', '1', 'title', 'Backup not performed.', 'script'),
('130', '151', 'pjField', '1', 'title', 'All the changes made to titles have been saved.', 'script'),
('131', '152', 'pjField', '1', 'title', 'All the changes made to options have been saved.', 'script'),
('132', '153', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('133', '154', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('134', '155', 'pjField', '1', 'title', 'We are sorry, but the user has not been added.', 'script'),
('135', '156', 'pjField', '1', 'title', 'User your looking for is missing.', 'script'),
('136', '159', 'pjField', '1', 'title', 'Account not found!', 'script'),
('137', '160', 'pjField', '1', 'title', 'Password send!', 'script'),
('138', '161', 'pjField', '1', 'title', 'Password not send!', 'script'),
('139', '162', 'pjField', '1', 'title', 'Profile updated!', 'script'),
('140', '163', 'pjField', '1', 'title', 'Backup', 'script'),
('141', '164', 'pjField', '1', 'title', 'Backup complete!', 'script'),
('142', '165', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('143', '166', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('144', '167', 'pjField', '1', 'title', 'Options updated!', 'script'),
('145', '168', 'pjField', '1', 'title', 'User updated!', 'script'),
('146', '169', 'pjField', '1', 'title', 'User added!', 'script'),
('147', '170', 'pjField', '1', 'title', 'User failed to add.', 'script'),
('148', '171', 'pjField', '1', 'title', 'User not found.', 'script'),
('149', '174', 'pjField', '1', 'title', 'Active', 'script'),
('150', '175', 'pjField', '1', 'title', 'Inactive', 'script'),
('151', '176', 'pjField', '1', 'title', 'Wrong username or password', 'script'),
('152', '177', 'pjField', '1', 'title', 'Access denied', 'script'),
('153', '178', 'pjField', '1', 'title', 'Account is disabled', 'script'),
('154', '179', 'pjField', '1', 'title', 'January', 'script'),
('155', '180', 'pjField', '1', 'title', 'October', 'script'),
('156', '181', 'pjField', '1', 'title', 'November', 'script'),
('157', '182', 'pjField', '1', 'title', 'December', 'script'),
('158', '183', 'pjField', '1', 'title', 'February', 'script'),
('159', '184', 'pjField', '1', 'title', 'March', 'script'),
('160', '185', 'pjField', '1', 'title', 'April', 'script'),
('161', '186', 'pjField', '1', 'title', 'May', 'script'),
('162', '187', 'pjField', '1', 'title', 'June', 'script'),
('163', '188', 'pjField', '1', 'title', 'July', 'script'),
('164', '189', 'pjField', '1', 'title', 'August', 'script'),
('165', '190', 'pjField', '1', 'title', 'September', 'script'),
('166', '191', 'pjField', '1', 'title', 'Dr.', 'script'),
('167', '192', 'pjField', '1', 'title', 'Miss', 'script'),
('168', '193', 'pjField', '1', 'title', 'Mr.', 'script'),
('169', '194', 'pjField', '1', 'title', 'Mrs.', 'script'),
('170', '195', 'pjField', '1', 'title', 'Ms.', 'script'),
('171', '196', 'pjField', '1', 'title', 'Other', 'script'),
('172', '197', 'pjField', '1', 'title', 'Prof.', 'script'),
('173', '198', 'pjField', '1', 'title', 'Rev.', 'script'),
('174', '199', 'pjField', '1', 'title', 'Jan', 'script'),
('175', '200', 'pjField', '1', 'title', 'Oct', 'script'),
('176', '201', 'pjField', '1', 'title', 'Nov', 'script'),
('177', '202', 'pjField', '1', 'title', 'Dec', 'script'),
('178', '203', 'pjField', '1', 'title', 'Feb', 'script'),
('179', '204', 'pjField', '1', 'title', 'Mar', 'script'),
('180', '205', 'pjField', '1', 'title', 'Apr', 'script'),
('181', '206', 'pjField', '1', 'title', 'May', 'script'),
('182', '207', 'pjField', '1', 'title', 'Jun', 'script'),
('183', '208', 'pjField', '1', 'title', 'Jul', 'script'),
('184', '209', 'pjField', '1', 'title', 'Aug', 'script'),
('185', '210', 'pjField', '1', 'title', 'Sep', 'script'),
('186', '211', 'pjField', '1', 'title', 'You are not loged in.', 'script'),
('187', '212', 'pjField', '1', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('188', '213', 'pjField', '1', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('189', '214', 'pjField', '1', 'title', 'Empty resultset.', 'script'),
('190', '215', 'pjField', '1', 'title', 'The operation is not allowed in demo mode.', 'script'),
('191', '216', 'pjField', '1', 'title', 'No property for the reservation found', 'script'),
('192', '217', 'pjField', '1', 'title', 'No reservation found', 'script'),
('193', '218', 'pjField', '1', 'title', 'No permisions to edit the reservation', 'script'),
('194', '219', 'pjField', '1', 'title', 'No permisions to edit the property', 'script'),
('195', '220', 'pjField', '1', 'title', 'E-Mail address already exist', 'script'),
('196', '221', 'pjField', '1', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('197', '222', 'pjField', '1', 'title', 'Your registration was successfull.', 'script'),
('198', '223', 'pjField', '1', 'title', 'GMT-03:00', 'script'),
('199', '224', 'pjField', '1', 'title', 'GMT-04:00', 'script'),
('200', '225', 'pjField', '1', 'title', 'GMT-05:00', 'script'),
('201', '226', 'pjField', '1', 'title', 'GMT-06:00', 'script'),
('202', '227', 'pjField', '1', 'title', 'GMT-07:00', 'script'),
('203', '228', 'pjField', '1', 'title', 'GMT-08:00', 'script'),
('204', '229', 'pjField', '1', 'title', 'GMT-09:00', 'script'),
('205', '230', 'pjField', '1', 'title', 'GMT-01:00', 'script'),
('206', '231', 'pjField', '1', 'title', 'GMT-10:00', 'script'),
('207', '232', 'pjField', '1', 'title', 'GMT-11:00', 'script'),
('208', '233', 'pjField', '1', 'title', 'GMT-12:00', 'script'),
('209', '234', 'pjField', '1', 'title', 'GMT-02:00', 'script'),
('210', '235', 'pjField', '1', 'title', 'GMT', 'script'),
('211', '236', 'pjField', '1', 'title', 'GMT+03:00', 'script'),
('212', '237', 'pjField', '1', 'title', 'GMT+04:00', 'script'),
('213', '238', 'pjField', '1', 'title', 'GMT+05:00', 'script'),
('214', '239', 'pjField', '1', 'title', 'GMT+06:00', 'script'),
('215', '240', 'pjField', '1', 'title', 'GMT+07:00', 'script'),
('216', '241', 'pjField', '1', 'title', 'GMT+08:00', 'script'),
('217', '242', 'pjField', '1', 'title', 'GMT+09:00', 'script'),
('218', '243', 'pjField', '1', 'title', 'GMT+01:00', 'script'),
('219', '244', 'pjField', '1', 'title', 'GMT+10:00', 'script'),
('220', '245', 'pjField', '1', 'title', 'GMT+11:00', 'script'),
('221', '246', 'pjField', '1', 'title', 'GMT+12:00', 'script'),
('222', '247', 'pjField', '1', 'title', 'GMT+13:00', 'script'),
('223', '248', 'pjField', '1', 'title', 'GMT+02:00', 'script'),
('224', '249', 'pjField', '1', 'title', 'Inactive', 'script'),
('225', '250', 'pjField', '1', 'title', 'Active', 'script'),
('226', '251', 'pjField', '1', 'title', 'No', 'script'),
('227', '252', 'pjField', '1', 'title', 'Yes', 'script'),
('228', '253', 'pjField', '1', 'title', 'Time format', 'script'),
('229', '254', 'pjField', '1', 'title', 'Delete selected', 'script'),
('230', '255', 'pjField', '1', 'title', 'Are you sure that you want to delete the selected record(s)?', 'script'),
('231', '256', 'pjField', '1', 'title', 'Groups', 'script'),
('232', '257', 'pjField', '1', 'title', 'Members', 'script'),
('233', '258', 'pjField', '1', 'title', 'The group name was already in use.', 'script'),
('234', '259', 'pjField', '1', 'title', 'Add group', 'script'),
('235', '260', 'pjField', '1', 'title', 'Group', 'script'),
('236', '261', 'pjField', '1', 'title', 'Members', 'script'),
('237', '262', 'pjField', '1', 'title', 'Active', 'script'),
('238', '263', 'pjField', '1', 'title', 'Inactive', 'script'),
('239', '264', 'pjField', '1', 'title', 'Group updated!', 'script'),
('240', '265', 'pjField', '1', 'title', 'All changes made to the group have been saved.', 'script'),
('241', '266', 'pjField', '1', 'title', 'Group added!', 'script'),
('242', '267', 'pjField', '1', 'title', 'A new group has been added to the list.', 'script'),
('243', '268', 'pjField', '1', 'title', 'Group failed to add!', 'script'),
('244', '269', 'pjField', '1', 'title', 'We are sorry that group could not be added.', 'script'),
('245', '270', 'pjField', '1', 'title', 'Group not found!', 'script'),
('246', '271', 'pjField', '1', 'title', 'Group you are looking for is missing.', 'script'),
('247', '272', 'pjField', '1', 'title', 'Update group', 'script'),
('248', '273', 'pjField', '1', 'title', 'Member updated', 'script'),
('249', '274', 'pjField', '1', 'title', 'All changes made to the member have been saved.', 'script'),
('250', '275', 'pjField', '1', 'title', 'Member added', 'script'),
('251', '276', 'pjField', '1', 'title', 'A new member has been added to the list.', 'script'),
('252', '277', 'pjField', '1', 'title', 'Member failed to add', 'script'),
('253', '278', 'pjField', '1', 'title', 'We are sorry that member could not bee added.', 'script'),
('254', '279', 'pjField', '1', 'title', 'Member not found', 'script'),
('255', '280', 'pjField', '1', 'title', 'Member you are looking for is missing.', 'script'),
('256', '281', 'pjField', '1', 'title', 'Add member', 'script'),
('257', '282', 'pjField', '1', 'title', 'First name', 'script'),
('258', '283', 'pjField', '1', 'title', 'Last name', 'script'),
('259', '284', 'pjField', '1', 'title', 'Email', 'script'),
('260', '285', 'pjField', '1', 'title', 'Phone', 'script'),
('261', '286', 'pjField', '1', 'title', 'Website', 'script'),
('262', '287', 'pjField', '1', 'title', 'Gender', 'script'),
('263', '288', 'pjField', '1', 'title', 'Age', 'script'),
('264', '289', 'pjField', '1', 'title', 'Birthday', 'script'),
('265', '290', 'pjField', '1', 'title', 'Address', 'script'),
('266', '291', 'pjField', '1', 'title', 'City', 'script'),
('267', '292', 'pjField', '1', 'title', 'State', 'script'),
('268', '293', 'pjField', '1', 'title', 'Country', 'script'),
('269', '294', 'pjField', '1', 'title', 'Zip', 'script'),
('270', '295', 'pjField', '1', 'title', 'Company name', 'script'),
('271', '296', 'pjField', '1', 'title', 'Update member', 'script'),
('272', '297', 'pjField', '1', 'title', 'Female', 'script'),
('273', '298', 'pjField', '1', 'title', 'Male', 'script'),
('274', '324', 'pjField', '1', 'title', 'Date/time created', 'script'),
('275', '325', 'pjField', '1', 'title', 'Date/time modified', 'script'),
('276', '326', 'pjField', '1', 'title', 'n/a', 'script'),
('277', '327', 'pjField', '1', 'title', 'Subscribed', 'script'),
('278', '328', 'pjField', '1', 'title', 'between', 'script'),
('279', '329', 'pjField', '1', 'title', 'and', 'script'),
('280', '330', 'pjField', '1', 'title', 'Date subscribed', 'script'),
('281', '331', 'pjField', '1', 'title', 'from', 'script'),
('282', '332', 'pjField', '1', 'title', 'to', 'script'),
('283', '333', 'pjField', '1', 'title', 'Subscribed', 'script'),
('284', '334', 'pjField', '1', 'title', 'Unsubscribed', 'script'),
('285', '360', 'pjField', '1', 'title', 'Import', 'script'),
('286', '361', 'pjField', '1', 'title', 'CSV file', 'script'),
('287', '362', 'pjField', '1', 'title', 'Update subscribers', 'script'),
('288', '363', 'pjField', '1', 'title', 'Import members', 'script'),
('289', '364', 'pjField', '1', 'title', 'You can import a CSV file with your members'' data. Please check <a href="import-sample.csv">this file</a> for an example of the required CSV file format. Your file should be exactly the same.', 'script'),
('290', '365', 'pjField', '1', 'title', 'Import', 'script'),
('291', '366', 'pjField', '1', 'title', 'Member imported', 'script'),
('292', '367', 'pjField', '1', 'title', 'Member list has been imported successfully.', 'script'),
('293', '368', 'pjField', '1', 'title', 'Member imported', 'script'),
('294', '369', 'pjField', '1', 'title', 'Member list has been imported, but there are some duplicated emails.', 'script'),
('295', '370', 'pjField', '1', 'title', 'Members updated', 'script'),
('296', '371', 'pjField', '1', 'title', 'Members in CSV file have been updated.', 'script'),
('297', '372', 'pjField', '1', 'title', 'File type error', 'script'),
('298', '373', 'pjField', '1', 'title', 'Only csv files are allowed.', 'script'),
('299', '374', 'pjField', '1', 'title', 'CSV file missing', 'script'),
('300', '375', 'pjField', '1', 'title', 'Importing members could not be process because of missing of CSV file.', 'script'),
('301', '376', 'pjField', '1', 'title', 'Files', 'script'),
('302', '377', 'pjField', '1', 'title', 'The file title was already in use.', 'script'),
('303', '378', 'pjField', '1', 'title', 'Title', 'script'),
('304', '379', 'pjField', '1', 'title', 'File name', 'script'),
('305', '380', 'pjField', '1', 'title', 'Uploaded date time', 'script'),
('306', '381', 'pjField', '1', 'title', 'Uploaded files', 'script'),
('307', '382', 'pjField', '1', 'title', 'Upload', 'script'),
('308', '383', 'pjField', '1', 'title', 'File updated', 'script'),
('309', '384', 'pjField', '1', 'title', 'All changes made to the file have been saved.', 'script'),
('310', '385', 'pjField', '1', 'title', 'File uploaded', 'script'),
('311', '386', 'pjField', '1', 'title', 'A new file has been uploaded successfully.', 'script'),
('312', '387', 'pjField', '1', 'title', 'File failed to upload', 'script'),
('313', '388', 'pjField', '1', 'title', 'We are sorry that the file could not be uploaded.', 'script'),
('314', '389', 'pjField', '1', 'title', 'File not found', 'script'),
('315', '390', 'pjField', '1', 'title', 'The file you are looking for is missing.', 'script'),
('316', '391', 'pjField', '1', 'title', 'File', 'script'),
('317', '392', 'pjField', '1', 'title', 'Group(s) access', 'script'),
('318', '393', 'pjField', '1', 'title', 'Individual members access', 'script'),
('319', '394', 'pjField', '1', 'title', 'Upload', 'script'),
('320', '395', 'pjField', '1', 'title', 'Add Group', 'script'),
('321', '396', 'pjField', '1', 'title', 'Add a new group by entering name and page URL where members will be taken once they login their account. Please, make sure that this page is protected. You can also set a one time registration fee and a recurring fee. Under Options page, Registrations tab, you can set registration options.', 'script'),
('322', '397', 'pjField', '1', 'title', 'Home page URL', 'script'),
('323', '398', 'pjField', '1', 'title', 'Install', 'script'),
('324', '399', 'pjField', '1', 'title', 'Account', 'script'),
('325', '400', 'pjField', '1', 'title', 'Registration form', 'script'),
('326', '401', 'pjField', '1', 'title', 'Use the code below to put a registration form on your web page(s). You can configure the registration form so it registers the members to a specific group only OR you can have the members select the group they want to register to.', 'script'),
('327', '402', 'pjField', '1', 'title', 'Member selects group', 'script'),
('328', '403', 'pjField', '1', 'title', 'Login Form', 'script'),
('329', '404', 'pjField', '1', 'title', 'Use the code below to put a login form on your web page(s). Depending on the group members belong to they will be redirected to the corresponding group home page. Group home page can be set under Edit Group page.', 'script'),
('330', '405', 'pjField', '1', 'title', 'Profile form', 'script'),
('331', '406', 'pjField', '1', 'title', 'Use the code below to put a edit profile form on your web page(s). This code will show a profile form so each member can edit own profile details. Make sure that the profile form code is put on a protected page.', 'script'),
('332', '407', 'pjField', '1', 'title', 'Logout link', 'script'),
('333', '408', 'pjField', '1', 'title', 'Use the code below to create a Logout link. You can put logout links on any of the protected web pages that you have.', 'script'),
('334', '409', 'pjField', '1', 'title', 'Protected pages', 'script'),
('335', '410', 'pjField', '1', 'title', 'Use the code below to protect your .php pages. If you have .html page all you have to do is to change its extension to .php and you can use this code to protect it. Paste the code at the very top of the page that you want to protect. You can also select group(s) that can access the protected pages.', 'script'),
('336', '411', 'pjField', '1', 'title', 'Protected files', 'script'),
('337', '412', 'pjField', '1', 'title', 'Use the code below to show a list with protected files. You can put this code on any of the protected .php pages that you have. Although the code is the same for all members, each member will only see the files he/she has access to.', 'script'),
('338', '413', 'pjField', '1', 'title', 'Registration form', 'script'),
('339', '414', 'pjField', '1', 'title', 'First name', 'script'),
('340', '415', 'pjField', '1', 'title', 'Last name', 'script'),
('341', '416', 'pjField', '1', 'title', 'Email', 'script'),
('342', '417', 'pjField', '1', 'title', 'Password', 'script'),
('343', '418', 'pjField', '1', 'title', 'First name is required.', 'script'),
('344', '419', 'pjField', '1', 'title', 'Email is required.', 'script'),
('345', '420', 'pjField', '1', 'title', 'Password is required.', 'script'),
('346', '421', 'pjField', '1', 'title', 'Captcha is required.', 'script'),
('347', '422', 'pjField', '1', 'title', 'Group', 'script'),
('348', '423', 'pjField', '1', 'title', 'Phone', 'script'),
('349', '424', 'pjField', '1', 'title', 'Website', 'script'),
('350', '425', 'pjField', '1', 'title', 'Gender', 'script'),
('351', '426', 'pjField', '1', 'title', 'Age', 'script'),
('352', '427', 'pjField', '1', 'title', 'Birthday', 'script'),
('353', '428', 'pjField', '1', 'title', 'Address', 'script'),
('354', '429', 'pjField', '1', 'title', 'City', 'script'),
('355', '430', 'pjField', '1', 'title', 'State', 'script'),
('356', '431', 'pjField', '1', 'title', 'Country', 'script'),
('357', '432', 'pjField', '1', 'title', 'Zip', 'script'),
('358', '433', 'pjField', '1', 'title', 'Company name', 'script'),
('359', '434', 'pjField', '1', 'title', 'Captcha', 'script'),
('360', '435', 'pjField', '1', 'title', 'Choose', 'script'),
('361', '436', 'pjField', '1', 'title', 'Register', 'script'),
('362', '437', 'pjField', '1', 'title', 'Email is invalid.', 'script'),
('363', '438', 'pjField', '1', 'title', 'The email address was used by other member.', 'script'),
('364', '439', 'pjField', '1', 'title', 'Captcha is incorrect.', 'script'),
('365', '440', 'pjField', '1', 'title', 'Birthday is invalid.', 'script'),
('366', '441', 'pjField', '1', 'title', 'Registration is processing, please wait...', 'script'),
('367', '442', 'pjField', '1', 'title', 'Congratulations! Registration is successful.', 'script'),
('368', '443', 'pjField', '1', 'title', 'There is some error occurred. Registration is failed.', 'script'),
('369', '444', 'pjField', '1', 'title', 'Group is required.', 'script'),
('370', '445', 'pjField', '1', 'title', 'This is the page that will be redirected to after users registered successfully for a new account.', 'script'),
('371', '446', 'pjField', '1', 'title', 'This is the page where users will be redirected to if they try to access protected page and are not logged in or do not have permissions to access it.', 'script'),
('372', '447', 'pjField', '1', 'title', 'Registration confirmation', 'script'),
('373', '448', 'pjField', '1', 'title', 'Password recovery', 'script'),
('374', '449', 'pjField', '1', 'title', 'Available tokens:\r\n\r\n{Group}\r\n{FirstName}\r\n{LastName}\r\n{Email}\r\n{Password}\r\n{Phone}\r\n{Website}\r\n{Gender}\r\n{Age}\r\n{Birthday}\r\n{Address}\r\n{City}\r\n{State}\r\n{Country}\r\n{Zip}\r\n{CompanyName}\r\n{Fee}\r\n{ConfirmURL}', 'script'),
('375', '450', 'pjField', '1', 'title', 'Available tokens:\r\n\r\n{FirstName}\r\n{Password}', 'script'),
('376', '476', 'pjField', '1', 'title', 'Thank you page', 'script'),
('377', '477', 'pjField', '1', 'title', 'Protected page', 'script'),
('378', '478', 'pjField', '1', 'title', 'Emails', 'script'),
('379', '479', 'pjField', '1', 'title', 'This email will be sent to user when confirmation set to ''Email Confirmation'' in the Tab ''Registrations'' of the menu ''Options''. There are some available tokens below.', 'script'),
('380', '480', 'pjField', '1', 'title', 'This email will be sent to member who has just requested for his/her password. There are some available tokens below.', 'script'),
('381', '481', 'pjField', '1', 'title', 'Subject', 'script'),
('382', '482', 'pjField', '1', 'title', 'Message', 'script'),
('383', '483', 'pjField', '1', 'title', 'Email notifications', 'script'),
('384', '484', 'pjField', '1', 'title', 'Below you can customize the different email notification messages that are being sent out. Mouse over the ? next to each message title for more details about when it is sent.', 'script'),
('385', '485', 'pjField', '1', 'title', 'Email settings updated', 'script'),
('386', '486', 'pjField', '1', 'title', 'All changes made to email settings have been saved.', 'script'),
('387', '487', 'pjField', '1', 'title', 'You account has been activated. You can login now.', 'script'),
('388', '488', 'pjField', '1', 'title', 'Sorry! we could not find out your account on our system.', 'script'),
('389', '489', 'pjField', '1', 'title', 'You account was already activated.', 'script'),
('390', '490', 'pjField', '1', 'title', 'Login', 'script'),
('391', '491', 'pjField', '1', 'title', 'Login', 'script'),
('392', '492', 'pjField', '1', 'title', 'Login successfully!', 'script'),
('393', '493', 'pjField', '1', 'title', 'Email address is not found.', 'script'),
('394', '494', 'pjField', '1', 'title', 'Password is incorrect.', 'script'),
('395', '495', 'pjField', '1', 'title', 'Member profile', 'script'),
('396', '496', 'pjField', '1', 'title', 'Sorry! your account does not exist on the system.', 'script'),
('397', '497', 'pjField', '1', 'title', 'Your account was disabled by the administrator.', 'script'),
('398', '498', 'pjField', '1', 'title', 'Save', 'script'),
('399', '499', 'pjField', '1', 'title', 'Retype password is required.', 'script'),
('400', '500', 'pjField', '1', 'title', 'Retype password does not match.', 'script'),
('401', '501', 'pjField', '1', 'title', 'Retype password', 'script'),
('402', '502', 'pjField', '1', 'title', 'New password', 'script'),
('403', '503', 'pjField', '1', 'title', 'Your profile is saving...', 'script'),
('404', '504', 'pjField', '1', 'title', 'Your profile has been saved successfully.', 'script'),
('405', '505', 'pjField', '1', 'title', 'Your profile has not been saved.', 'script'),
('406', '506', 'pjField', '1', 'title', 'Login page', 'script'),
('407', '507', 'pjField', '1', 'title', 'This is page that will be redirected to after users logout from the system.', 'script'),
('408', '508', 'pjField', '1', 'title', 'Logout', 'script'),
('409', '534', 'pjField', '1', 'title', 'Files', 'script'),
('410', '535', 'pjField', '1', 'title', 'No files found', 'script'),
('411', '561', 'pjField', '1', 'title', 'Update file', 'script'),
('412', '564', 'pjField', '1', 'title', 'Forms', 'script'),
('413', '565', 'pjField', '1', 'title', 'Member details', 'script'),
('414', '566', 'pjField', '1', 'title', 'Using the two tabs below you can set the fields which members should fill in on both the registration and the profile pages.', 'script'),
('415', '567', 'pjField', '1', 'title', 'Password', 'script'),
('416', '568', 'pjField', '1', 'title', 'Please enter a valid URL.', 'script'),
('417', '569', 'pjField', '1', 'title', 'Form settings updated', 'script'),
('418', '570', 'pjField', '1', 'title', 'All changes made to form settings has been saved.', 'script'),
('419', '573', 'pjField', '1', 'title', 'Account is not active.', 'script'),
('420', '574', 'pjField', '1', 'title', 'Registration confirmation', 'script'),
('421', '576', 'pjField', '1', 'title', 'Paypal address', 'script'),
('422', '577', 'pjField', '1', 'title', 'Registrations', 'script'),
('423', '578', 'pjField', '1', 'title', 'Registration settings', 'script'),
('424', '579', 'pjField', '1', 'title', 'Below you can set different configure registration process. If you''ve set registration and/or subscription fee for any of the groups here you can set currency and paypal address where members will pay you. Under the "Registration confirmation" drop down you can set how the registrations will be confirmed: Manual - administrator will have to approve each member manually; Payment - members will be approved after paying the registration fee; Email confirmation - an email will be sent to each member and after clicking on the confirmation link the member account will be confirmed.', 'script'),
('425', '580', 'pjField', '1', 'title', 'Registration settings updated', 'script'),
('426', '581', 'pjField', '1', 'title', 'All changes made to registration settings have been saved.', 'script'),
('427', '582', 'pjField', '1', 'title', 'Week', 'script'),
('428', '583', 'pjField', '1', 'title', 'Month', 'script'),
('429', '584', 'pjField', '1', 'title', 'Year', 'script'),
('430', '585', 'pjField', '1', 'title', 'Registration fee', 'script'),
('431', '586', 'pjField', '1', 'title', 'Subscription fee', 'script'),
('432', '587', 'pjField', '1', 'title', 'per', 'script'),
('433', '588', 'pjField', '1', 'title', 'Available tokens:\r\n\r\n{Group}\r\n{FirstName}\r\n{LastName}\r\n{Email}\r\n{Password}\r\n{Phone}\r\n{Website}\r\n{Gender}\r\n{Age}\r\n{Birthday}\r\n{Address}\r\n{City}\r\n{State}\r\n{Country}\r\n{Zip}\r\n{CompanyName}\r\n{Fee}', 'script'),
('434', '589', 'pjField', '1', 'title', 'Available tokens:\r\n\r\n{Group}\r\n{FirstName}\r\n{LastName}\r\n{Email}\r\n{Password}\r\n{Phone}\r\n{Website}\r\n{Gender}\r\n{Age}\r\n{Birthday}\r\n{Address}\r\n{City}\r\n{State}\r\n{Country}\r\n{Zip}\r\n{CompanyName}\r\n{Fee}', 'script'),
('435', '590', 'pjField', '1', 'title', 'Available tokens:\r\n\r\n{Group}\r\n{FirstName}\r\n{LastName}\r\n{Email}\r\n{Password}\r\n{Phone}\r\n{Website}\r\n{Gender}\r\n{Age}\r\n{Birthday}\r\n{Address}\r\n{City}\r\n{State}\r\n{Country}\r\n{Zip}\r\n{CompanyName}\r\n{Fee}', 'script'),
('436', '591', 'pjField', '1', 'title', 'Administrator notification', 'script'),
('437', '592', 'pjField', '1', 'title', 'Payment confirmation', 'script'),
('438', '593', 'pjField', '1', 'title', 'Registration created', 'script'),
('439', '594', 'pjField', '1', 'title', 'This email will be sent to administrators when new registration is made. There are some available tokens below.', 'script'),
('440', '595', 'pjField', '1', 'title', 'This email will be sent to user when payment is made. There are some available tokens below.', 'script'),
('441', '596', 'pjField', '1', 'title', 'This email will be sent to user when confirmation set to ''Manual'' in the Tab ''Registrations'' of the menu ''Options''. There are some available tokens below.', 'script'),
('442', '597', 'pjField', '1', 'title', 'Last name is required.', 'script'),
('443', '598', 'pjField', '1', 'title', 'Phone is required.', 'script'),
('444', '599', 'pjField', '1', 'title', 'Website is required.', 'script'),
('445', '600', 'pjField', '1', 'title', 'Gender is required.', 'script'),
('446', '601', 'pjField', '1', 'title', 'Age is required.', 'script'),
('447', '602', 'pjField', '1', 'title', 'Birthday is required.', 'script'),
('448', '603', 'pjField', '1', 'title', 'Address is required.', 'script'),
('449', '604', 'pjField', '1', 'title', 'City is required.', 'script'),
('450', '605', 'pjField', '1', 'title', 'State is required.', 'script'),
('451', '606', 'pjField', '1', 'title', 'Country is required.', 'script'),
('452', '607', 'pjField', '1', 'title', 'Zip is required.', 'script'),
('453', '608', 'pjField', '1', 'title', 'Company name is required.', 'script'),
('454', '609', 'pjField', '1', 'title', 'per', 'script'),
('455', '610', 'pjField', '1', 'title', 'Registration fee', 'script'),
('456', '611', 'pjField', '1', 'title', 'Subscription fee', 'script'),
('457', '637', 'pjField', '1', 'title', 'Subscription period is required.', 'script'),
('458', '638', 'pjField', '1', 'title', 'Only CSV files are allowed.', 'script'),
('459', '639', 'pjField', '1', 'title', 'Loading payment form...', 'script'),
('460', '640', 'pjField', '1', 'title', 'Forgot password', 'script'),
('461', '641', 'pjField', '1', 'title', 'Send', 'script'),
('462', '642', 'pjField', '1', 'title', 'Back', 'script'),
('463', '643', 'pjField', '1', 'title', 'Your password has been sent to your email address.', 'script'),
('464', '644', 'pjField', '1', 'title', 'Email address does not exist.', 'script'),
('465', '670', 'pjField', '1', 'title', 'Date/time last login', 'script'),
('466', '671', 'pjField', '1', 'title', 'Groups', 'script'),
('467', '672', 'pjField', '1', 'title', 'Below you can see all members groups. You can create one or multiple groups and organize your members. You can also set up a subscription and recurring fee for your members.', 'script'),
('468', '673', 'pjField', '1', 'title', 'Add new member', 'script'),
('469', '674', 'pjField', '1', 'title', 'Fill in the form below to add a new member.', 'script'),
('470', '675', 'pjField', '1', 'title', 'Protected files', 'script'),
('471', '676', 'pjField', '1', 'title', 'Below you can see all the files that you''ve uploaded and protected. You can upload a new file under the Upload tab or edit any of the files below by clicking on the Edit icon next to it.', 'script'),
('472', '677', 'pjField', '1', 'title', 'Upload new file', 'script'),
('473', '678', 'pjField', '1', 'title', 'The title you enter for your file will be seen by people who have access to it. You can specify the Member Groups or individual members who can view and download this file.', 'script'),
('474', '679', 'pjField', '1', 'title', 'Users', 'script'),
('475', '680', 'pjField', '1', 'title', 'Below is a list of users who have access to Member Login administration panel. You can create new users or remove current.', 'script'),
('476', '706', 'pjField', '1', 'title', 'Update group', 'script'),
('477', '707', 'pjField', '1', 'title', 'Update group by entering name and page URL where members will be taken once they login their account. Please, make sure that this page is protected. You can also set a one time registration fee and a recurring fee. Under Options page, Registrations tab, you can set registration options.', 'script'),
('478', '708', 'pjField', '1', 'title', 'Today', 'script'),
('479', '709', 'pjField', '1', 'title', 'Last 7 days', 'script'),
('480', '710', 'pjField', '1', 'title', 'Last 30 days', 'script'),
('481', '711', 'pjField', '1', 'title', 'Last 3 months', 'script'),
('482', '712', 'pjField', '1', 'title', 'Last login', 'script'),
('508', '738', 'pjField', '1', 'title', 'Update protected files', 'script'),
('509', '739', 'pjField', '1', 'title', 'The title you enter for your file will be seen by people who have access to it. You can specify the Member Groups or individual members who can view and download this file.', 'script'),
('510', '741', 'pjField', '1', 'title', 'Last login', 'script'),
('511', '742', 'pjField', '1', 'title', 'Members', 'script'),
('512', '743', 'pjField', '1', 'title', 'Member', 'script'),
('513', '744', 'pjField', '1', 'title', 'Active members', 'script'),
('514', '745', 'pjField', '1', 'title', 'Active member', 'script'),
('515', '746', 'pjField', '1', 'title', 'Groups', 'script'),
('516', '747', 'pjField', '1', 'title', 'Last registered', 'script'),
('517', '748', 'pjField', '1', 'title', 'Most popular groups', 'script'),
('518', '749', 'pjField', '1', 'title', 'There is no member found', 'script'),
('519', '750', 'pjField', '1', 'title', 'There is no group found.', 'script'),
('520', '776', 'pjField', '1', 'title', 'Notes', 'script'),
('521', '777', 'pjField', '1', 'title', 'All', 'script'),
('522', '778', 'pjField', '1', 'title', 'Note', 'script'),
('523', '779', 'pjField', '1', 'title', 'Created', 'script'),
('524', '780', 'pjField', '1', 'title', 'Notes', 'script'),
('525', '781', 'pjField', '1', 'title', 'Below you can see all the notes that you''ve created and protected. You can create a new note under the Add Note tab or edit any of the notes below by clicking on the Edit icon next to it.', 'script'),
('526', '782', 'pjField', '1', 'title', 'Note updated', 'script'),
('527', '783', 'pjField', '1', 'title', 'All changes made to the note have been saved.', 'script'),
('528', '784', 'pjField', '1', 'title', 'Note added', 'script'),
('529', '785', 'pjField', '1', 'title', 'A new note has been added to the list.', 'script'),
('530', '786', 'pjField', '1', 'title', 'Failed to add', 'script'),
('531', '787', 'pjField', '1', 'title', 'We are sorry that the note could not be added to the list.', 'script'),
('532', '788', 'pjField', '1', 'title', 'Note not found', 'script'),
('533', '789', 'pjField', '1', 'title', 'We are sorry that the note you are looking for is missing.', 'script'),
('534', '790', 'pjField', '1', 'title', 'Add note', 'script'),
('535', '791', 'pjField', '1', 'title', 'Add new note', 'script'),
('536', '792', 'pjField', '1', 'title', 'The note you enter below will be seen by people who have access to it. You can specify the Member Groups or individual members who can view the note.', 'script'),
('537', '793', 'pjField', '1', 'title', 'Update note', 'script'),
('538', '794', 'pjField', '1', 'title', 'Update note', 'script'),
('539', '795', 'pjField', '1', 'title', 'The note you enter below will be seen by people who have access to it. You can specify the Member Groups or individual members who can view the note.', 'script'),
('540', '796', 'pjField', '1', 'title', 'Protected notes', 'script'),
('541', '797', 'pjField', '1', 'title', 'Use the code below to show a list with protected notes. You can put this code on any of the protected .php pages that you have. Although the code is the same for all members, each member will only see the notes he/she has access to.', 'script'),
('542', '798', 'pjField', '1', 'title', 'Notes', 'script'),
('543', '799', 'pjField', '1', 'title', 'There is no note available.', 'script'),
('544', '800', 'pjField', '1', 'title', 'CSV file in wrong format', 'script'),
('545', '801', 'pjField', '1', 'title', 'CSV file should include First Name and Email column.', 'script'),
('546', '802', 'pjField', '1', 'title', 'Expiration', 'script'),
('547', '803', 'pjField', '1', 'title', 'Account expired.', 'script');