<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{
	static public function uuid()
	{
		return chr(rand(65,90)) . chr(rand(65,90)) . time();
	}
	static public function getReferer()
	{
		if (isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SERVER['REDIRECT_URL']))
			{
				return $_SERVER['REDIRECT_URL'];
			}
		}
	
		if (isset($_SERVER['HTTP_REFERER']))
		{
			$pos = strpos($_SERVER['HTTP_REFERER'], "#");
			if ($pos !== FALSE)
			{
				return substr($_SERVER['HTTP_REFERER'], 0, $pos);
			}
			return $_SERVER['HTTP_REFERER'];
		}
	}
	static public function add3W($url)
	{
		$bits = parse_url($url);
		$newHost = substr($bits["host"],0,4) !== "www."?"www.".$bits["host"]:$bits["host"];
		$return_url = $bits["scheme"]."://".$newHost.(isset($bits["port"])?":".$bits["port"]:"").$bits["path"].(!empty($bits["query"])?"?".$bits["query"]:"");
		return $return_url;
	}
	public static function printInstallNotice($title, $body, $convert = true, $close = true)
	{
		?>
		<div class="install-notice-box">
			<div class="notice-top"></div>
			<div class="notice-middle">
				<span class="notice-info">&nbsp;</span>
				<?php
				if (!empty($title))
				{
					printf('<span class="block bold">%s</span>', $convert ? htmlspecialchars(stripslashes($title)) : stripslashes($title));
				}
				if (!empty($body))
				{
					printf('<span class="block">%s</span>', $convert ? htmlspecialchars(stripslashes($body)) : stripslashes($body));
				}
				if ($close)
				{
					?><a href="#" class="notice-close"></a><?php
				}
				?>
			</div>
			<div class="notice-bottom"></div>
		</div>
		<?php
	}
	
	static public function html2txt($document){
		$search = array('@<script[^>]*?>.*?</script>@si', 
		               '@<[\/\!]*?[^<>]*?>@si',           
		               '@<style[^>]*?>.*?</style>@siU',   
		               '@<![\s\S]*?--[ \t\n\r]*>@'    
		);
		$text = preg_replace($search, '', $document);
		return $text;
	}
	
	static public function truncateDescription($string, $limit, $break=".", $pad="..."){
		if(strlen($string) <= $limit) 
			return $string;  
		if(false !== ($breakpoint = strpos($string, $break, $limit))) 
		{ 
			if($breakpoint < strlen($string) - 1) 
			{ 
				$string = substr($string, 0, $breakpoint) . $pad; 
			} 
		} 
		return $string;
	}
	
	static private function dayDropDown($date_format, $day){
		
		$select_ele = '<select name="day" class="ml-select ml-w60 ml-birthday">';
		$select_ele .= '<option value="">----</option>';
		foreach (range(1, 31) as $v)
		{
			$v_pad = str_pad($v, 2, '0', STR_PAD_LEFT); 
			if(strpos($date_format, "j") > -1){
				if($day == $v_pad){
					$select_ele .= '<option value="'.$v_pad.'" selected="selected">'.$v.'</option>';
				}else{
					$select_ele .= '<option value="'.$v_pad.'">'.$v.'</option>';
				}	
			}else{
				if($day == $v_pad){
					$select_ele .= '<option value="'.$v_pad.'" selected="selected">'.$v_pad.'</option>';
				}else{
					$select_ele .= '<option value="'.$v_pad.'">'.$v_pad.'</option>';
				}
			}
		}
		$select_ele .= '</select>';
		return $select_ele;
	}
	
	static private function monthDropDown($date_format, $month){
		$select_ele = '<select name="month" class="ml-select ml-w60 ml-birthday">';
		$select_ele .= '<option value="">----</option>';
		foreach (range(1, 12) as $v)
		{
			$v_pad = str_pad($v, 2, '0', STR_PAD_LEFT); 
			if(strpos($date_format, "n") > -1){
				if($month == $v_pad){
					$select_ele .= '<option value="'.$v_pad.'" selected="selected">'.$v.'</option>';
				}else{
					$select_ele .= '<option value="'.$v_pad.'">'.$v.'</option>';
				}	
			}else{
				if($month == $v_pad){
					$select_ele .= '<option value="'.$v_pad.'" selected="selected">'.$v_pad.'</option>';
				}else{
					$select_ele .= '<option value="'.$v_pad.'">'.$v_pad.'</option>';
				}
			}
		}
		$select_ele .= '</select>';
		return $select_ele;
	}
	static private function yearDropDown($date_format, $year){
		$select_ele = '<select name="year" class="ml-select ml-w80 ml-birthday">';
		$select_ele .= '<option value="">----</option>';
		foreach (range(1900, date('Y')) as $v)
		{
			if($year == $v){
				$select_ele .= '<option value="'.$v.'" selected="selected">'.$v.'</option>';
			}else{
				$select_ele .= '<option value="'.$v.'">'.$v.'</option>';
			}
		}
		$select_ele .= '</select>';
		return $select_ele;
	}
	
	static public function dateSuite($date_format, $d, $m, $y){
		$day = pjUtil::dayDropDown($date_format, $d);
		$month = pjUtil::monthDropDown($date_format, $m);
		$year = pjUtil::yearDropDown($date_format, $y);
		
		$date_format = str_replace("d", '{d}', $date_format);
		$date_format = str_replace("j", '{j}', $date_format);
		$date_format = str_replace("n", '{n}', $date_format);
		$date_format = str_replace("m", '{m}', $date_format);
		$date_format = str_replace("Y", '{Y}', $date_format);
		
		$date_format = str_replace("{d}", $day, $date_format);
		$date_format = str_replace("{j}", $day, $date_format);
		
		$date_format = str_replace("{n}", $month, $date_format);
		$date_format = str_replace("{m}", $month, $date_format);
		
		$date_format = str_replace("{Y}", $year, $date_format);
		
		return $date_format;
	}
	static public function getPostMaxSize()
	{
		$post_max_size = ini_get('post_max_size');
		switch (substr($post_max_size, -1))
		{
			case 'G':
				$post_max_size = (int) $post_max_size * 1024 * 1024 * 1024;
				break;
			case 'M':
				$post_max_size = (int) $post_max_size * 1024 * 1024;
				break;
			case 'K':
				$post_max_size = (int) $post_max_size * 1024;
				break;
		}
		return $post_max_size;
	}
}
?>